/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.ClassBuilder;
import io.github.dmlloyd.classfile.ClassFile;
import io.github.dmlloyd.classfile.ClassFileElement;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.MethodModel;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.github.dmlloyd.classfile.attribute.InnerClassInfo;
import io.github.dmlloyd.classfile.attribute.InnerClassesAttribute;
import io.github.dmlloyd.classfile.attribute.NestHostAttribute;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.InvokeKind;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.creator.AnonymousClassCreator;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ConstructorCreator;
import io.quarkus.gizmo2.creator.LambdaCreator;
import io.quarkus.gizmo2.creator.StaticMethodCreator;
import io.quarkus.gizmo2.creator.SwitchCreator;
import io.quarkus.gizmo2.creator.TryCreator;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.AnonymousClassCreatorImpl;
import io.quarkus.gizmo2.impl.ArrayStore;
import io.quarkus.gizmo2.impl.AssignableImpl;
import io.quarkus.gizmo2.impl.BinOp;
import io.quarkus.gizmo2.impl.BlockExpr;
import io.quarkus.gizmo2.impl.BlockHeader;
import io.quarkus.gizmo2.impl.Box;
import io.quarkus.gizmo2.impl.Break;
import io.quarkus.gizmo2.impl.CheckCast;
import io.quarkus.gizmo2.impl.ClassSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.Cmp;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Dup;
import io.quarkus.gizmo2.impl.EnumSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.GotoCase;
import io.quarkus.gizmo2.impl.GotoDefault;
import io.quarkus.gizmo2.impl.GotoStart;
import io.quarkus.gizmo2.impl.If;
import io.quarkus.gizmo2.impl.IfRel;
import io.quarkus.gizmo2.impl.IfZero;
import io.quarkus.gizmo2.impl.InstanceMethodCreatorImpl;
import io.quarkus.gizmo2.impl.InstanceOf;
import io.quarkus.gizmo2.impl.IntSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.Invoke;
import io.quarkus.gizmo2.impl.InvokeDynamic;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.LambdaAsAnonClassCreatorImpl;
import io.quarkus.gizmo2.impl.LambdaAsMethodCreatorImpl;
import io.quarkus.gizmo2.impl.LineNumber;
import io.quarkus.gizmo2.impl.LocalVarImpl;
import io.quarkus.gizmo2.impl.LongSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.MethodCreatorImpl;
import io.quarkus.gizmo2.impl.MonitorEnter;
import io.quarkus.gizmo2.impl.MonitorExit;
import io.quarkus.gizmo2.impl.Neg;
import io.quarkus.gizmo2.impl.New;
import io.quarkus.gizmo2.impl.NewArrayResult;
import io.quarkus.gizmo2.impl.NewEmptyArray;
import io.quarkus.gizmo2.impl.NewResult;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.Preconditions;
import io.quarkus.gizmo2.impl.PrimitiveCast;
import io.quarkus.gizmo2.impl.Rel;
import io.quarkus.gizmo2.impl.RelZero;
import io.quarkus.gizmo2.impl.Return;
import io.quarkus.gizmo2.impl.StringSwitchCreatorImpl;
import io.quarkus.gizmo2.impl.SwitchCreatorImpl;
import io.quarkus.gizmo2.impl.ThisExpr;
import io.quarkus.gizmo2.impl.Throw;
import io.quarkus.gizmo2.impl.TryCreatorImpl;
import io.quarkus.gizmo2.impl.TryFinally;
import io.quarkus.gizmo2.impl.TypeCreatorImpl;
import io.quarkus.gizmo2.impl.Unbox;
import io.quarkus.gizmo2.impl.UncheckedCast;
import io.quarkus.gizmo2.impl.Util;
import io.quarkus.gizmo2.impl.Yield;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.quarkus.gizmo2.impl.constant.IntConst;
import io.quarkus.gizmo2.impl.constant.NullConst;
import io.quarkus.gizmo2.impl.constant.VoidConst;
import io.smallrye.common.constraint.Assert;
import java.io.PrintStream;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class BlockCreatorImpl
extends Item
implements BlockCreator {
    private static final int ST_ACTIVE = 0;
    private static final int ST_NESTED = 1;
    private static final int ST_DONE = 2;
    private final TypeCreatorImpl owner;
    private final CodeBuilder outerCodeBuilder;
    private final BlockCreatorImpl parent;
    private final int depth;
    private final String methodNameForLambdas;
    private final Node head;
    private final Node tail;
    private boolean breakTarget;
    TryFinally tryFinally;
    private int state;
    private final Label startLabel;
    private final Label endLabel;
    private final Item input;
    private final ClassDesc outputType;
    private final ClassDesc returnType;
    private Consumer<BlockCreator> loopAction;
    private String nestSite;
    private String finishSite;
    private List<Consumer<BlockCreator>> postInits;

    BlockCreatorImpl(TypeCreatorImpl owner, CodeBuilder outerCodeBuilder, ClassDesc returnType, String methodNameForLambdas) {
        this(owner, outerCodeBuilder, null, ConstantDescs.CD_void, ConstImpl.ofVoid(), ConstantDescs.CD_void, returnType, methodNameForLambdas);
    }

    BlockCreatorImpl(BlockCreatorImpl parent) {
        this(parent, ConstImpl.ofVoid(), ConstantDescs.CD_void);
    }

    BlockCreatorImpl(BlockCreatorImpl parent, ClassDesc inputType) {
        this(parent.owner, parent.outerCodeBuilder, parent, inputType, ConstImpl.ofVoid(), ConstantDescs.CD_void, parent.returnType, parent.methodNameForLambdas);
    }

    BlockCreatorImpl(BlockCreatorImpl parent, Item input, ClassDesc outputType) {
        this(parent.owner, parent.outerCodeBuilder, parent, input.type(), input, outputType, parent.returnType, parent.methodNameForLambdas);
    }

    BlockCreatorImpl(BlockCreatorImpl parent, ClassDesc inputType, ClassDesc outputType) {
        this(parent.owner, parent.outerCodeBuilder, parent, inputType, ConstImpl.ofVoid(), outputType, parent.returnType, parent.methodNameForLambdas);
    }

    private BlockCreatorImpl(TypeCreatorImpl owner, CodeBuilder outerCodeBuilder, BlockCreatorImpl parent, ClassDesc inputType, Item input, ClassDesc outputType, ClassDesc returnType, String methodNameForLambdas) {
        this.outerCodeBuilder = outerCodeBuilder;
        this.parent = parent;
        this.owner = owner;
        this.depth = parent == null ? 0 : parent.depth + 1;
        this.methodNameForLambdas = methodNameForLambdas;
        this.tryFinally = parent == null ? null : parent.tryFinally;
        this.postInits = parent == null ? List.of() : parent.postInits;
        this.startLabel = this.newLabel();
        this.endLabel = this.newLabel();
        this.input = input;
        this.head = Node.newList(BlockHeader.INSTANCE, Yield.YIELD_VOID);
        this.tail = this.head.next();
        if (!inputType.equals(ConstantDescs.CD_void)) {
            this.head.insertNext(new BlockExpr(inputType));
        }
        this.outputType = outputType;
        this.returnType = returnType;
    }

    Node head() {
        return this.head;
    }

    Node tail() {
        return this.tail;
    }

    BlockCreatorImpl parent() {
        return this.parent;
    }

    Label newLabel() {
        return this.outerCodeBuilder.newLabel();
    }

    ClassDesc returnType() {
        return this.returnType;
    }

    @Override
    public ClassDesc type() {
        return this.outputType;
    }

    @Override
    public boolean active() {
        return this.state == 0;
    }

    @Override
    public boolean done() {
        return this.state == 2;
    }

    @Override
    public boolean mayFallThrough() {
        if (this.active()) {
            // empty if block
        }
        return this.breakTarget || this.tail.item().mayFallThrough();
    }

    @Override
    public Node pop(Node node) {
        Yield yield;
        assert (this == node.item());
        if (this.isVoid()) {
            return super.pop(node);
        }
        assert (this.mayFallThrough());
        if (this.breakTarget) {
            return super.pop(node);
        }
        Item tailItem = this.tail.item();
        if (tailItem instanceof Yield && !(yield = (Yield)tailItem).value().isVoid()) {
            this.tail.set(Yield.YIELD_VOID);
            BlockCreatorImpl.cleanStack(this.tail);
            return node.prev();
        }
        return super.pop(node);
    }

    private void markDone() {
        this.state = 2;
        this.finishSite = Util.trackCaller();
    }

    @Override
    public boolean isContainedBy(BlockCreator other) {
        return this == other || this.parent != null && this.parent.isContainedBy(other);
    }

    @Override
    public LocalVar localVar(String name, GenericType type, Expr value) {
        LocalVarImpl lv = new LocalVarImpl(this, name, type);
        this.addItem(lv.allocator());
        this.set((Assignable)lv, value);
        return lv;
    }

    @Override
    public Expr get(Assignable var, MemoryOrder mode) {
        return this.addItem(((AssignableImpl)var).emitGet(this, mode));
    }

    @Override
    public void set(Assignable var, Expr value, MemoryOrder mode) {
        Item newValue = Conversions.convert(value, var.type());
        this.addItem(((AssignableImpl)var).emitSet(this, newValue, mode));
    }

    @Override
    public void andAssign(Assignable var, Expr arg) {
        this.set(var, this.and((Expr)var, arg));
    }

    @Override
    public void orAssign(Assignable var, Expr arg) {
        this.set(var, this.or((Expr)var, arg));
    }

    @Override
    public void xorAssign(Assignable var, Expr arg) {
        this.set(var, this.xor((Expr)var, arg));
    }

    @Override
    public void shlAssign(Assignable var, Expr arg) {
        this.set(var, this.shl((Expr)var, arg));
    }

    @Override
    public void shrAssign(Assignable var, Expr arg) {
        this.set(var, this.shr((Expr)var, arg));
    }

    @Override
    public void ushrAssign(Assignable var, Expr arg) {
        this.set(var, this.ushr((Expr)var, arg));
    }

    @Override
    public void addAssign(Assignable var, Expr arg) {
        if (arg instanceof Const) {
            Const c = (Const)arg;
            this.inc(var, c);
        } else {
            this.set(var, this.add((Expr)var, arg));
        }
    }

    @Override
    public void subAssign(Assignable var, Expr arg) {
        if (arg instanceof Const) {
            Const c = (Const)arg;
            this.dec(var, c);
        } else {
            this.set(var, this.sub((Expr)var, arg));
        }
    }

    @Override
    public void mulAssign(Assignable var, Expr arg) {
        this.set(var, this.mul((Expr)var, arg));
    }

    @Override
    public void divAssign(Assignable var, Expr arg) {
        this.set(var, this.div((Expr)var, arg));
    }

    @Override
    public void remAssign(Assignable var, Expr arg) {
        this.set(var, this.rem((Expr)var, arg));
    }

    @Override
    public Expr box(Expr a) {
        if (Conversions.isPrimitiveWrapper(a.type())) {
            return a;
        }
        return this.addItem(new Box(a));
    }

    @Override
    public Expr unbox(Expr a) {
        if (Conversions.isPrimitive(a.type())) {
            return a;
        }
        return this.addItem(new Unbox(a));
    }

    @Override
    public Expr switchEnum(ClassDesc outputType, Expr enumExpr, Consumer<SwitchCreator> builder) {
        EnumSwitchCreatorImpl sci = new EnumSwitchCreatorImpl(this, enumExpr, outputType);
        sci.accept(builder);
        this.addItem(sci);
        return sci;
    }

    @Override
    public Expr switch_(ClassDesc outputType, Expr expr, Consumer<SwitchCreator> builder) {
        SwitchCreatorImpl sci = switch (expr.typeKind().asLoadable()) {
            case TypeKind.INT -> new IntSwitchCreatorImpl(this, expr, outputType);
            case TypeKind.LONG -> new LongSwitchCreatorImpl(this, expr, outputType);
            case TypeKind.REFERENCE -> {
                if (expr.type().equals(ConstantDescs.CD_String)) {
                    yield new StringSwitchCreatorImpl(this, expr, outputType);
                }
                if (expr.type().equals(ConstantDescs.CD_Class)) {
                    yield new ClassSwitchCreatorImpl(this, expr, outputType);
                }
                throw new UnsupportedOperationException("Switch type " + String.valueOf(expr.type()) + " not supported");
            }
            default -> throw new UnsupportedOperationException("Switch type " + String.valueOf(expr.type()) + " not supported");
        };
        sci.accept(builder);
        this.addItem(sci);
        return sci;
    }

    @Override
    public void gotoCase(SwitchCreator switch_, Const case_) {
        SwitchCreatorImpl sci = (SwitchCreatorImpl)switch_;
        if (!sci.contains(this)) {
            throw new IllegalArgumentException("The given switch statement does not enclose this block");
        }
        this.addItem(new GotoCase(switch_, case_));
    }

    @Override
    public void gotoDefault(SwitchCreator switch_) {
        this.addItem(new GotoDefault(switch_));
    }

    @Override
    public Expr iterate(Expr items) {
        return this.invokeInterface(MethodDesc.of(Iterable.class, "iterator", Iterator.class, new Class[0]), items, new Expr[0]);
    }

    @Override
    public Expr currentThread() {
        return this.invokeStatic(MethodDesc.of(Thread.class, "currentThread", Thread.class, new Class[0]), new Expr[0]);
    }

    @Override
    public void close(Expr closeable) {
        this.invokeInterface(MethodDesc.of(AutoCloseable.class, "close", Void.TYPE, new Class[0]), closeable, new Expr[0]);
    }

    @Override
    public void inc(Assignable var, Const amount) {
        ((AssignableImpl)var).emitInc(this, amount);
    }

    @Override
    public void dec(Assignable var, Const amount) {
        ((AssignableImpl)var).emitDec(this, amount);
    }

    @Override
    public Expr newEmptyArray(ClassDesc componentType, Expr size) {
        return this.addItem(new NewEmptyArray(componentType, (Item)size));
    }

    private void insertNewArrayStore(NewEmptyArray nea, List<ArrayStore> stores, Node node, List<Item> values, int idx) {
        if (idx == 0) {
            nea.forEachDependency(nea.insert(node), Item::insertIfUnbound);
        } else {
            ArrayStore store = stores.get(idx - 1);
            Node storeNode = store.insert(node);
            Node beforeValNode = storeNode.prev();
            Item value = values.get(idx - 1);
            if (value.bound()) {
                beforeValNode = value.verify(beforeValNode);
            }
            Dup dup = (Dup)stores.get(idx - 1).arrayExpr();
            Node prev = dup.insert(beforeValNode.next());
            this.insertNewArrayStore(nea, stores, prev, values, idx - 1);
            store.forEachDependency(storeNode, Item::insertIfUnbound);
        }
    }

    @Override
    public <T> Expr newArray(ClassDesc componentType, List<T> values, Function<T, ? extends Expr> mapper) {
        this.checkActive();
        int size = values.size();
        ArrayList<ArrayStore> stores = new ArrayList<ArrayStore>(size);
        NewEmptyArray nea = new NewEmptyArray(componentType, ConstImpl.of(size));
        for (int i = 0; i < size; ++i) {
            stores.add(new ArrayStore(new Dup(nea), ConstImpl.of(i), (Item)mapper.apply(values.get(i)), componentType));
        }
        this.insertNewArrayStore(nea, stores, this.tail, Util.reinterpretCast(values), values.size());
        Item result = nea;
        if (size > 0) {
            result = this.addItem(new NewArrayResult(nea, Util.reinterpretCast(stores)));
        }
        return result;
    }

    private Expr relZero(Expr a, If.Kind kind) {
        switch (a.typeKind().asLoadable()) {
            case INT: 
            case REFERENCE: {
                return this.addItem(new RelZero(a, kind));
            }
            case LONG: {
                return this.relZero(this.cmp(a, Const.of(0, a.typeKind())), kind);
            }
            case FLOAT: 
            case DOUBLE: {
                return this.relZero(this.cmpg(a, Const.of(0, a.typeKind())), kind);
            }
        }
        throw new IllegalStateException();
    }

    private Expr rel(Expr a, Expr b, If.Kind kind) {
        Optional promotedType;
        ClassDesc operandType = a.type();
        Optional<Object> optional = promotedType = Conversions.numericPromotionRequired(kind, a.type(), b.type()) ? Conversions.numericPromotion(a.type(), b.type()) : Optional.empty();
        if (promotedType.isPresent()) {
            operandType = (ClassDesc)promotedType.get();
            a = Conversions.convert(a, operandType);
            b = Conversions.convert(b, operandType);
        }
        TypeKind typeKind = TypeKind.from(operandType).asLoadable();
        switch (typeKind) {
            case INT: {
                IntConst bc;
                IntConst ac;
                if (a instanceof IntConst && (ac = (IntConst)a).intValue() == 0) {
                    return this.relZero(b, kind.invert());
                }
                if (b instanceof IntConst && (bc = (IntConst)b).intValue() == 0) {
                    return this.relZero(a, kind);
                }
                return this.addItem(new Rel(a, b, kind));
            }
            case LONG: {
                return this.relZero(this.cmp(a, b), kind);
            }
            case FLOAT: 
            case DOUBLE: {
                return this.relZero(this.cmpg(a, b), kind);
            }
            case REFERENCE: {
                if (a instanceof NullConst) {
                    return this.relZero(b, kind);
                }
                if (b instanceof NullConst) {
                    return this.relZero(a, kind);
                }
                return this.addItem(new Rel(a, b, kind));
            }
        }
        throw Assert.impossibleSwitchCase((Object)((Object)typeKind));
    }

    @Override
    public Expr eq(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.EQ);
    }

    @Override
    public Expr ne(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.NE);
    }

    @Override
    public Expr lt(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.LT);
    }

    @Override
    public Expr gt(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.GT);
    }

    @Override
    public Expr le(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.LE);
    }

    @Override
    public Expr ge(Expr a, Expr b) {
        return this.rel(a, b, If.Kind.GE);
    }

    @Override
    public Expr cmp(Expr a, Expr b) {
        return this.addItem(new Cmp(a, b, Cmp.Kind.CMP));
    }

    @Override
    public Expr cmpl(Expr a, Expr b) {
        return this.addItem(new Cmp(a, b, Cmp.Kind.CMPL));
    }

    @Override
    public Expr cmpg(Expr a, Expr b) {
        return this.addItem(new Cmp(a, b, Cmp.Kind.CMPG));
    }

    @Override
    public Expr and(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.AND));
    }

    @Override
    public Expr or(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.OR));
    }

    @Override
    public Expr xor(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.XOR));
    }

    @Override
    public Expr complement(Expr a) {
        return this.xor(a, Const.of(-1, a.typeKind()));
    }

    @Override
    public Expr shl(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.SHL));
    }

    @Override
    public Expr shr(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.SHR));
    }

    @Override
    public Expr ushr(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.USHR));
    }

    @Override
    public Expr add(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.ADD));
    }

    @Override
    public Expr sub(Expr a, Expr b) {
        ConstImpl c;
        if (a instanceof ConstImpl && (c = (ConstImpl)a).isZero()) {
            return this.neg(b);
        }
        return this.addItem(new BinOp(a, b, BinOp.Kind.SUB));
    }

    @Override
    public Expr mul(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.MUL));
    }

    @Override
    public Expr div(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.DIV));
    }

    @Override
    public Expr rem(Expr a, Expr b) {
        return this.addItem(new BinOp(a, b, BinOp.Kind.REM));
    }

    @Override
    public Expr neg(Expr a) {
        return this.addItem(new Neg(a));
    }

    @Override
    public Expr lambda(MethodDesc sam, ClassDesc samOwner, Consumer<LambdaCreator> builder) {
        if (Util.debug) {
            return this.lambdaDebug(sam, samOwner, builder);
        }
        ClassDesc ownerDesc = this.owner.type();
        String ds = ownerDesc.descriptorString();
        ClassDesc desc = ClassDesc.ofDescriptor(ds.substring(0, ds.length() - 1) + "$lambda;");
        ClassFile cf = ClassFile.of((ClassFile.Option[])new ClassFile.Option[]{ClassFile.StackMapsOption.GENERATE_STACK_MAPS});
        ArrayList captureExprs = new ArrayList();
        byte[] bytes = cf.build(desc, zb -> {
            zb.withVersion(this.owner.version().major(), 0);
            AnonymousClassCreatorImpl tc = new AnonymousClassCreatorImpl(this.owner.gizmo, desc, this.owner.output(), (ClassBuilder)zb, ConstructorDesc.of(Object.class, new Class[0]), captureExprs);
            if (sam instanceof InterfaceMethodDesc) {
                tc.implements_(sam.owner());
            }
            tc.method(sam, imc -> {
                imc.public_();
                LambdaAsAnonClassCreatorImpl lc = new LambdaAsAnonClassCreatorImpl(tc, (InstanceMethodCreatorImpl)imc);
                tc.preAccept();
                builder.accept(lc);
                tc.freezeCaptures();
                tc.constructor(cc -> tc.ctorSetups().forEach((Consumer<Consumer<ConstructorCreator>>)((Consumer<Consumer>)action -> action.accept(cc))));
                tc.postAccept();
            });
        });
        this.owner.buildLambdaBootstrap();
        String encoded = Base64.getUrlEncoder().encodeToString(bytes);
        MethodTypeDesc ctorType = MethodTypeDesc.of(samOwner, (ClassDesc[])captureExprs.stream().map(Expr::type).toArray(ClassDesc[]::new));
        return this.invokeDynamic(DynamicCallSiteDesc.of(MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, ownerDesc, "defineLambdaCallSite", MethodTypeDesc.of(ConstantDescs.CD_CallSite, ConstantDescs.CD_MethodHandles_Lookup, ConstantDescs.CD_String, ConstantDescs.CD_MethodType)), encoded, ctorType), captureExprs);
    }

    private Expr lambdaDebug(MethodDesc sam, ClassDesc samOwner, Consumer<LambdaCreator> builder) {
        ConstantDesc samType = sam.type();
        String name = "lambda$" + this.methodNameForLambdas + "$" + this.owner.lambdaAndAnonClassCounter++;
        ArrayList captures = new ArrayList();
        MethodDesc lambdaMethod = this.owner.staticMethod(name, arg_0 -> BlockCreatorImpl.lambda$lambdaDebug$5((MethodTypeDesc)samType, builder, samOwner, captures, arg_0));
        return this.invokeDynamic(DynamicCallSiteDesc.of(ConstantDescs.ofCallsiteBootstrap(Util.classDesc(LambdaMetafactory.class), "metafactory", ConstantDescs.CD_CallSite, ConstantDescs.CD_MethodType, ConstantDescs.CD_MethodHandle, ConstantDescs.CD_MethodType), sam.name(), MethodTypeDesc.of(samOwner, (ClassDesc[])captures.stream().map(Expr::type).toArray(ClassDesc[]::new)), samType, MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.STATIC, lambdaMethod.owner(), lambdaMethod.name(), (MethodTypeDesc)lambdaMethod.type()), samType), captures);
    }

    @Override
    public Expr newAnonymousClass(ConstructorDesc superCtor, List<? extends Expr> args, Consumer<AnonymousClassCreator> builder) {
        ClassDesc ownerDesc = this.owner.type();
        int idx = this.owner.lambdaAndAnonClassCounter++;
        String ds = ownerDesc.descriptorString();
        ClassDesc desc = ClassDesc.ofDescriptor(ds.substring(0, ds.length() - 1) + "$" + idx + ";");
        ClassFile cf = ClassFile.of((ClassFile.Option[])new ClassFile.Option[]{ClassFile.StackMapsOption.GENERATE_STACK_MAPS});
        ArrayList captureExprs = new ArrayList();
        byte[] bytes = cf.build(desc, zb -> {
            zb.withVersion(this.owner.version().major(), 0);
            zb.with((ClassFileElement)NestHostAttribute.of((ClassDesc)ownerDesc));
            zb.with((ClassFileElement)InnerClassesAttribute.of((InnerClassInfo[])new InnerClassInfo[]{InnerClassInfo.of((ClassDesc)desc, Optional.of(ownerDesc), Optional.empty(), (int)0)}));
            AnonymousClassCreatorImpl tc = new AnonymousClassCreatorImpl(this.owner.gizmo, desc, this.owner.output(), (ClassBuilder)zb, superCtor, captureExprs);
            tc.preAccept();
            builder.accept(tc);
            tc.freezeCaptures();
            tc.constructor(cc -> tc.ctorSetups().forEach((Consumer<Consumer<ConstructorCreator>>)((Consumer<Consumer>)action -> action.accept(cc))));
            tc.postAccept();
        });
        ClassModel cm = cf.parse(bytes);
        List methods = cm.methods();
        MethodModel ourCtor = (MethodModel)methods.get(methods.size() - 1);
        this.owner.output().write(desc, bytes);
        return this.new_(ConstructorDesc.of(desc, ourCtor.methodTypeSymbol()), Stream.concat(args.stream(), captureExprs.stream()).toList());
    }

    @Override
    public Expr cast(Expr a, GenericType toGenType) {
        ClassDesc toType = toGenType.desc();
        if (a.type().isPrimitive()) {
            if (toType.isPrimitive()) {
                return this.addItem(new PrimitiveCast(a, toGenType));
            }
            if (toType.equals(Conversions.boxingConversion(a.type()).orElse(null))) {
                return this.box(a);
            }
            throw new IllegalArgumentException("Cannot cast primitive value of type '" + a.type().displayName() + "' to object type '" + toType.displayName() + "'");
        }
        if (toType.equals(Conversions.unboxingConversion(a.type()).orElse(null))) {
            return this.unbox(a);
        }
        if (toType.isPrimitive()) {
            throw new IllegalArgumentException("Cannot cast object value of type '" + a.type().displayName() + "' to primitive type '" + toType.displayName() + "'");
        }
        return this.addItem(new CheckCast(a, toGenType));
    }

    @Override
    public Expr uncheckedCast(Expr a, GenericType toType) {
        if (a.type().isPrimitive()) {
            throw new IllegalArgumentException("Cannot apply unchecked cast to primitive value: " + a.type().displayName());
        }
        if (toType.desc().isPrimitive()) {
            throw new IllegalArgumentException("Cannot apply unchecked cast to primitive type: " + toType.desc().displayName());
        }
        return this.addItem(new UncheckedCast(a, toType));
    }

    @Override
    public Expr instanceOf(Expr obj, GenericType type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        return this.addItem(new InstanceOf(obj, type));
    }

    @Override
    public Expr new_(GenericType genericType, ConstructorDesc ctor, List<? extends Expr> args) {
        this.checkActive();
        if (!ctor.owner().equals(genericType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match constructor type %s".formatted(genericType, ctor.owner()));
        }
        New new_ = new New(genericType);
        Dup dup_ = new Dup(new_);
        Node node = this.tail.prev();
        for (int i = args.size() - 1; i >= 0; --i) {
            Item arg = (Item)args.get(i);
            if (!arg.bound()) continue;
            node = arg.verify(node);
        }
        Node dupNode = dup_.insert(node.next());
        new_.insert(dupNode);
        Invoke invoke = new Invoke(ctor, dup_, args, genericType);
        this.addItem(invoke);
        return this.addItem(new NewResult(new_, invoke));
    }

    @Override
    public Expr invokeStatic(GenericType genericReturnType, MethodDesc method, List<? extends Expr> args) {
        if (!method.returnType().equals(genericReturnType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match method return type %s".formatted(genericReturnType, method.returnType()));
        }
        return this.addItem(new Invoke(Opcode.INVOKESTATIC, method, null, args, genericReturnType));
    }

    @Override
    public Expr invokeVirtual(GenericType genericReturnType, MethodDesc method, Expr instance, List<? extends Expr> args) {
        if (!method.returnType().equals(genericReturnType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match method return type %s".formatted(genericReturnType, method.returnType()));
        }
        return this.addItem(new Invoke(Opcode.INVOKEVIRTUAL, method, instance, args, genericReturnType));
    }

    @Override
    public Expr invokeSpecial(GenericType genericReturnType, MethodDesc method, Expr instance, List<? extends Expr> args) {
        if (!method.returnType().equals(genericReturnType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match method return type %s".formatted(genericReturnType, method.returnType()));
        }
        return this.addItem(new Invoke(Opcode.INVOKESPECIAL, method, instance, args, genericReturnType));
    }

    @Override
    public Expr invokeSpecial(ConstructorDesc ctor, Expr instance, List<? extends Expr> args) {
        Invoke invoke = new Invoke(ctor, instance, args, GenericType.of(Void.TYPE));
        this.addItem(invoke);
        if (instance instanceof ThisExpr) {
            for (Consumer<BlockCreator> postInit : this.postInits) {
                postInit.accept(this);
            }
        }
        return invoke;
    }

    @Override
    public Expr invokeInterface(GenericType genericReturnType, MethodDesc method, Expr instance, List<? extends Expr> args) {
        if (!(method instanceof InterfaceMethodDesc)) {
            throw new IllegalArgumentException("Cannot emit `invokeinterface` for " + String.valueOf(method) + "; must be InterfaceMethodDesc");
        }
        if (!method.returnType().equals(genericReturnType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match method return type %s".formatted(genericReturnType, method.returnType()));
        }
        return this.addItem(new Invoke(Opcode.INVOKEINTERFACE, method, instance, args, genericReturnType));
    }

    @Override
    public Expr invokeDynamic(DynamicCallSiteDesc callSiteDesc, List<? extends Expr> args) {
        return this.addItem(new InvokeDynamic(args, callSiteDesc));
    }

    @Override
    public void forEach(Expr fn, BiConsumer<BlockCreator, ? super LocalVar> builder) {
        this.block(fn, (b0, fn0) -> {
            LocalVar items = b0.localVar("$$items" + this.depth, (Expr)fn0);
            if (items.type().isArray()) {
                Expr lv = items.length();
                Expr length = lv instanceof Const ? lv : b0.localVar("$$length" + this.depth, lv);
                LocalVar idx = b0.localVar("$$idx" + this.depth, Const.of(0));
                b0.block(b1 -> b1.if_(b1.lt((Expr)idx, length), b2 -> {
                    LocalVar val = b2.localVar("$$val" + this.depth, items.elem(idx));
                    builder.accept((BlockCreator)b2, val);
                    if (b2.active()) {
                        b2.inc(idx);
                        b2.gotoStart();
                    }
                }));
            } else {
                LocalVar itr = b0.localVar("$$itr" + this.depth, b0.iterate(items));
                b0.block(b1 -> b1.if_(b1.withIterator(itr).hasNext(), b2 -> {
                    LocalVar val = b2.localVar("$$val" + this.depth, b2.withIterator(itr).next());
                    ((BlockCreatorImpl)b2).loopAction = bb -> bb.goto_((BlockCreator)b1);
                    builder.accept((BlockCreator)b2, val);
                    if (b2.active()) {
                        b2.goto_((BlockCreator)b1);
                    }
                }));
            }
        });
    }

    void block(Expr arg, BiConsumer<BlockCreator, Expr> nested) {
        BlockCreatorImpl block = new BlockCreatorImpl(this, (Item)arg, ConstantDescs.CD_void);
        block.accept(nested);
        this.addItem(block);
    }

    @Override
    public void block(Consumer<BlockCreator> nested) {
        this.checkActive();
        BlockCreatorImpl block = new BlockCreatorImpl(this);
        this.state = 1;
        this.nestSite = Util.trackCaller();
        block.accept(nested);
        this.state = 0;
        this.nestSite = null;
        this.addItem(block);
    }

    @Override
    public Expr blockExpr(ClassDesc type, Consumer<BlockCreator> nested) {
        Yield yield;
        this.checkActive();
        BlockCreatorImpl block = new BlockCreatorImpl(this, ConstImpl.ofVoid(), type);
        this.state = 1;
        this.nestSite = Util.trackCaller();
        block.accept(nested);
        this.state = 0;
        this.nestSite = null;
        Item item = block.tail.item();
        if (item instanceof Yield && (yield = (Yield)item).value().isVoid()) {
            Node node = block.head.next();
            while (node.item() != yield) {
                this.tail.insertPrev(node.item());
                node = node.next();
            }
            return this.tail.prev().item();
        }
        this.addItem(block);
        return block;
    }

    public void accept(BiConsumer<? super BlockCreatorImpl, Expr> handler) {
        Item input;
        this.checkActive();
        Item item = this.head.next().item();
        if (item instanceof BlockExpr) {
            BlockExpr be = (BlockExpr)item;
            input = be;
        } else {
            input = VoidConst.INSTANCE;
        }
        handler.accept(this, input);
        BlockCreatorImpl.cleanStack(this.tail.item().process(this.tail, Item::verify));
        this.markDone();
    }

    public void accept(Consumer<? super BlockCreatorImpl> handler) {
        Yield yield;
        Expr val;
        this.checkActive();
        handler.accept(this);
        Item item = this.tail.item();
        if (item instanceof Yield && (val = (yield = (Yield)item).value()).typeKind() != this.typeKind()) {
            if (val.typeKind() == TypeKind.VOID) {
                throw new IllegalStateException("Block did not yield a value of type " + String.valueOf((Object)this.typeKind()) + " (did you forget to call `yield(val)`?)");
            }
            throw new IllegalStateException("Block yielded value of wrong type (expected a " + String.valueOf((Object)this.typeKind()) + " but got " + String.valueOf(val.type()) + ")");
        }
        BlockCreatorImpl.cleanStack(this.tail.item().process(this.tail, Item::verify));
        this.markDone();
    }

    @Override
    public void ifInstanceOf(Expr obj, ClassDesc type, BiConsumer<BlockCreator, ? super LocalVar> ifTrue) {
        this.doIf(this.instanceOf(obj, type), bc -> ifTrue.accept((BlockCreator)bc, bc.localVar("$$instance" + this.depth, bc.cast(obj, type))), null);
    }

    @Override
    public void ifNotInstanceOf(Expr obj, ClassDesc type, Consumer<BlockCreator> ifFalse) {
        this.doIf(this.instanceOf(obj, type), null, ifFalse);
    }

    @Override
    public void ifInstanceOfElse(Expr obj, ClassDesc type, BiConsumer<BlockCreator, ? super LocalVar> ifTrue, Consumer<BlockCreator> ifFalse) {
        this.doIf(this.instanceOf(obj, type), bc -> ifTrue.accept((BlockCreator)bc, bc.localVar("$$instance" + this.depth, bc.cast(obj, type))), ifFalse);
    }

    private If doIfInsn(ClassDesc type, Expr cond, BlockCreatorImpl wt, BlockCreatorImpl wf) {
        if (((Item)cond).bound()) {
            Item prevItem = this.tail.prev().item();
            if (prevItem == cond) {
                if (cond instanceof Rel) {
                    Rel rel = (Rel)cond;
                    IfRel ifRel = new IfRel(type, rel.kind(), wt, wf, rel.left(), rel.right());
                    if (ifRel.mayFallThrough()) {
                        rel.replace(this.tail.prev(), ifRel);
                    } else {
                        rel.remove(this.tail.prev());
                        this.replaceLastItem(ifRel);
                    }
                    return ifRel;
                }
                if (cond instanceof RelZero) {
                    RelZero rz = (RelZero)cond;
                    IfZero ifZero = new IfZero(type, rz.kind(), wt, wf, rz.input(), false);
                    if (ifZero.mayFallThrough()) {
                        rz.replace(this.tail.prev(), ifZero);
                    } else {
                        rz.remove(this.tail.prev());
                        this.replaceLastItem(ifZero);
                    }
                    return ifZero;
                }
            }
        } else {
            if (cond instanceof Rel) {
                Rel rel = (Rel)cond;
                return this.addItem(new IfRel(type, rel.kind(), wt, wf, rel.left(), rel.right()));
            }
            if (cond instanceof RelZero) {
                RelZero rz = (RelZero)cond;
                return this.addItem(new IfZero(type, rz.kind(), wt, wf, rz.input(), false));
            }
        }
        return this.addItem(new IfZero(type, If.Kind.NE, wt, wf, (Item)cond, true));
    }

    private void doIf(Expr cond, Consumer<BlockCreator> whenTrue, Consumer<BlockCreator> whenFalse) {
        BlockCreatorImpl wf;
        BlockCreatorImpl wt = whenTrue == null ? null : new BlockCreatorImpl(this);
        BlockCreatorImpl blockCreatorImpl = wf = whenFalse == null ? null : new BlockCreatorImpl(this);
        if (wt != null) {
            wt.accept(whenTrue);
        }
        if (wf != null) {
            wf.accept(whenFalse);
        }
        this.doIfInsn(ConstantDescs.CD_void, cond, wt, wf);
    }

    @Override
    public Expr cond(ClassDesc type, Expr cond, Consumer<BlockCreator> whenTrue, Consumer<BlockCreator> whenFalse) {
        BlockCreatorImpl wt = new BlockCreatorImpl(this, ConstImpl.ofVoid(), type);
        BlockCreatorImpl wf = new BlockCreatorImpl(this, ConstImpl.ofVoid(), type);
        wt.accept(whenTrue);
        wf.accept(whenFalse);
        return this.doIfInsn(type, cond, wt, wf);
    }

    @Override
    public void if_(Expr cond, Consumer<BlockCreator> whenTrue) {
        this.doIf(cond, whenTrue, null);
    }

    @Override
    public void ifNot(Expr cond, Consumer<BlockCreator> whenFalse) {
        this.doIf(cond, null, whenFalse);
    }

    @Override
    public void ifElse(Expr cond, Consumer<BlockCreator> whenTrue, Consumer<BlockCreator> whenFalse) {
        this.doIf(cond, whenTrue, whenFalse);
    }

    @Override
    public void break_(BlockCreator outer) {
        ((BlockCreatorImpl)outer).breakTarget = true;
        if (outer != this) {
            this.addItem(new Break(outer));
        }
        this.markDone();
    }

    @Override
    public void continue_(BlockCreator loop) {
        BlockCreatorImpl bci = (BlockCreatorImpl)loop;
        Consumer<BlockCreator> action = bci.loopAction;
        if (action == null) {
            throw new IllegalArgumentException("Can only continue a loop");
        }
        action.accept(this);
    }

    @Override
    public void goto_(BlockCreator outer) {
        if (!outer.contains(this)) {
            throw new IllegalStateException("Invalid block nesting");
        }
        this.addItem(new GotoStart(outer));
        this.markDone();
    }

    @Override
    public void loop(Consumer<BlockCreator> body) {
        this.block(b0 -> {
            ((BlockCreatorImpl)b0).loopAction = bb -> bb.goto_((BlockCreator)b0);
            body.accept((BlockCreator)b0);
            if (b0.active()) {
                b0.gotoStart();
            }
        });
    }

    @Override
    public void while_(Consumer<BlockCreator> cond, Consumer<BlockCreator> body) {
        this.block(b0 -> b0.if_(b0.blockExpr(ConstantDescs.CD_boolean, cond), b1 -> {
            ((BlockCreatorImpl)b1).loopAction = bb -> bb.goto_((BlockCreator)b0);
            body.accept((BlockCreator)b1);
            if (b1.active()) {
                b1.goto_((BlockCreator)b0);
            }
        }));
    }

    @Override
    public void doWhile(Consumer<BlockCreator> body, Consumer<BlockCreator> cond) {
        this.block(b0 -> {
            b0.block(b1 -> {
                ((BlockCreatorImpl)b1).loopAction = bb -> bb.break_((BlockCreator)b1);
                body.accept((BlockCreator)b1);
            });
            if (b0.active()) {
                b0.if_(b0.blockExpr(ConstantDescs.CD_boolean, cond), b1 -> b1.goto_((BlockCreator)b0));
            }
        });
    }

    @Override
    public void try_(Consumer<TryCreator> body) {
        TryCreatorImpl tci = new TryCreatorImpl(this);
        tci.accept(body);
        tci.addTo(this);
    }

    @Override
    public void autoClose(Expr resource, BiConsumer<BlockCreator, ? super LocalVar> body) {
        if (resource instanceof LocalVar) {
            LocalVar lv = (LocalVar)resource;
            this.autoClose(lv, (BlockCreator b0) -> body.accept((BlockCreator)b0, lv));
        } else {
            this.block(resource, (b0, opened) -> {
                LocalVar rsrc = b0.localVar("$$resource" + this.depth, (Expr)opened);
                this.autoClose(rsrc, (BlockCreator b1) -> body.accept((BlockCreator)b1, rsrc));
            });
        }
    }

    @Override
    public void autoClose(LocalVar resource, Consumer<BlockCreator> body) {
        this.try_(t1 -> {
            t1.body(body);
            t1.catch_(ConstantDescs.CD_Throwable, "e2", (b2, e2) -> {
                b2.try_(t3 -> {
                    t3.body(b4 -> b4.close(resource));
                    t3.catch_(ConstantDescs.CD_Throwable, "e4", (b4, e4) -> b4.withThrowable((Expr)e2).addSuppressed((Expr)e4));
                });
                b2.throw_((Expr)e2);
            });
        });
        if (this.active()) {
            this.close(resource);
        }
    }

    void monitorEnter(Item monitor) {
        this.addItem(new MonitorEnter(monitor));
    }

    void monitorExit(Item monitor) {
        this.addItem(new MonitorExit(monitor));
    }

    @Override
    public void synchronized_(Expr monitor, Consumer<BlockCreator> body) {
        this.block(monitor, (b0, mon) -> {
            LocalVar mv = b0.localVar("$$monitor" + this.depth, (Expr)mon);
            ((BlockCreatorImpl)b0).monitorEnter((Item)((Object)mv));
            b0.try_(t1 -> {
                t1.body(body);
                t1.finally_(b2 -> ((BlockCreatorImpl)b2).monitorExit((Item)((Object)mv)));
            });
        });
    }

    @Override
    public void locked(Expr jucLock, Consumer<BlockCreator> body) {
        this.block(jucLock, (b0, lock) -> {
            LocalVar lv = b0.localVar("$$lock" + this.depth, (Expr)lock);
            b0.invokeInterface(MethodDesc.of(Lock.class, "lock", Void.TYPE, new Class[0]), (Expr)lv, new Expr[0]);
            b0.try_(t1 -> {
                t1.body(body);
                t1.finally_(b2 -> b2.invokeInterface(MethodDesc.of(Lock.class, "unlock", Void.TYPE, new Class[0]), (Expr)lv, new Expr[0]));
            });
        });
    }

    @Override
    public void returnNull() {
        this.return_(ConstImpl.ofNull(this.returnType));
    }

    @Override
    public void return_() {
        this.replaceLastItem(Return.RETURN_VOID);
    }

    @Override
    public void return_(Expr val) {
        this.replaceLastItem((val = Conversions.convert(val, this.returnType)).equals(Const.ofVoid()) ? Return.RETURN_VOID : new Return(val));
    }

    @Override
    public void throw_(Expr val) {
        this.replaceLastItem(new Throw(val));
    }

    @Override
    public void yield(Expr val) {
        this.replaceLastItem((val = Conversions.convert(val, this.outputType)).equals(Const.ofVoid()) ? Yield.YIELD_VOID : new Yield(val));
    }

    @Override
    public Expr objHashCode(Expr expr) {
        return switch (expr.typeKind()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.BOOLEAN -> this.invokeStatic(MethodDesc.of(Boolean.class, "hashCode", Integer.TYPE, Boolean.TYPE), expr);
            case TypeKind.BYTE -> this.invokeStatic(MethodDesc.of(Byte.class, "hashCode", Integer.TYPE, Byte.TYPE), expr);
            case TypeKind.SHORT -> this.invokeStatic(MethodDesc.of(Short.class, "hashCode", Integer.TYPE, Short.TYPE), expr);
            case TypeKind.CHAR -> this.invokeStatic(MethodDesc.of(Character.class, "hashCode", Integer.TYPE, Character.TYPE), expr);
            case TypeKind.INT -> this.invokeStatic(MethodDesc.of(Integer.class, "hashCode", Integer.TYPE, Integer.TYPE), expr);
            case TypeKind.LONG -> this.invokeStatic(MethodDesc.of(Long.class, "hashCode", Integer.TYPE, Long.TYPE), expr);
            case TypeKind.FLOAT -> this.invokeStatic(MethodDesc.of(Float.class, "hashCode", Integer.TYPE, Float.TYPE), expr);
            case TypeKind.DOUBLE -> this.invokeStatic(MethodDesc.of(Double.class, "hashCode", Integer.TYPE, Double.TYPE), expr);
            case TypeKind.REFERENCE -> this.invokeStatic(MethodDesc.of(Objects.class, "hashCode", Integer.TYPE, Object.class), expr);
            case TypeKind.VOID -> Const.of(0);
        };
    }

    @Override
    public Expr objEquals(Expr a, Expr b) {
        return switch (a.typeKind()) {
            case TypeKind.REFERENCE -> {
                switch (b.typeKind()) {
                    case REFERENCE: {
                        yield this.invokeStatic(MethodDesc.of(Objects.class, "equals", Boolean.TYPE, Object.class, Object.class), a, b);
                    }
                }
                yield this.objEquals(a, this.box(b));
            }
            default -> {
                switch (b.typeKind()) {
                    case REFERENCE: {
                        yield this.objEquals(this.box(a), b);
                    }
                }
                yield this.eq(a, b);
            }
        };
    }

    @Override
    public Expr objToString(Expr expr) {
        Class[] classArray = new Class[1];
        classArray[0] = switch (expr.typeKind()) {
            case TypeKind.BOOLEAN -> Boolean.TYPE;
            case TypeKind.INT, TypeKind.BYTE, TypeKind.SHORT -> Integer.TYPE;
            case TypeKind.CHAR -> Character.TYPE;
            case TypeKind.LONG -> Long.TYPE;
            case TypeKind.FLOAT -> Float.TYPE;
            case TypeKind.DOUBLE -> Double.TYPE;
            case TypeKind.REFERENCE -> {
                if (expr.type().equals(ConstantDescs.CD_char.arrayType())) {
                    yield char[].class;
                }
                yield Object.class;
            }
            default -> throw new IllegalArgumentException("Invalid type for `toString`: " + String.valueOf(expr));
        };
        return this.invokeStatic(MethodDesc.of(String.class, "valueOf", String.class, classArray), expr);
    }

    @Override
    public Expr arrayHashCode(Expr expr) {
        Preconditions.requireArray(expr);
        ClassDesc componentType = expr.type().componentType();
        if (componentType.isArray()) {
            return this.invokeStatic(MethodDesc.of(Arrays.class, "deepHashCode", Integer.TYPE, Object[].class), expr);
        }
        ClassDesc type = TypeKind.from(componentType) == TypeKind.REFERENCE ? ConstantDescs.CD_Object.arrayType() : expr.type();
        return this.invokeStatic(MethodDesc.of(Arrays.class, "hashCode", MethodTypeDesc.of(ConstantDescs.CD_int, type)), expr);
    }

    @Override
    public Expr arrayEquals(Expr a, Expr b) {
        Preconditions.requireArray(a);
        Preconditions.requireArray(b);
        Preconditions.requireSameTypeKind(a.type().componentType(), b.type().componentType());
        ClassDesc componentType = a.type().componentType();
        if (componentType.isArray()) {
            return this.invokeStatic(MethodDesc.of(Arrays.class, "deepEquals", Boolean.TYPE, Object[].class, Object[].class), a, b);
        }
        ClassDesc type = TypeKind.from(componentType) == TypeKind.REFERENCE ? ConstantDescs.CD_Object.arrayType() : a.type();
        return this.invokeStatic(MethodDesc.of(Arrays.class, "equals", MethodTypeDesc.of(ConstantDescs.CD_boolean, type, type)), a, b);
    }

    @Override
    public Expr arrayToString(Expr expr) {
        Preconditions.requireArray(expr);
        ClassDesc componentType = expr.type().componentType();
        if (componentType.isArray()) {
            return this.invokeStatic(MethodDesc.of(Arrays.class, "deepToString", String.class, Object[].class), expr);
        }
        ClassDesc type = TypeKind.from(componentType) == TypeKind.REFERENCE ? ConstantDescs.CD_Object.arrayType() : expr.type();
        return this.invokeStatic(MethodDesc.of(Arrays.class, "toString", MethodTypeDesc.of(ConstantDescs.CD_String, type)), expr);
    }

    @Override
    public Expr classForName(Expr className) {
        return this.invokeStatic(MethodDesc.of(Class.class, "forName", Class.class, String.class), className);
    }

    @Override
    public <T> Expr listOf(List<T> items, Function<T, ? extends Expr> mapper) {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (T item : items) {
            exprs.add(mapper.apply(item));
        }
        int size = exprs.size();
        if (size <= 10) {
            return this.invokeStatic(MethodDesc.of(List.class, "of", List.class, Collections.nCopies(size, Object.class)), exprs);
        }
        return this.invokeStatic(MethodDesc.of(List.class, "of", List.class, Object[].class), this.newArray(Object.class, exprs));
    }

    @Override
    public <T> Expr setOf(List<T> items, Function<T, ? extends Expr> mapper) {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (T item : items) {
            exprs.add(mapper.apply(item));
        }
        int size = exprs.size();
        if (size <= 10) {
            return this.invokeStatic(MethodDesc.of(Set.class, "of", Set.class, Collections.nCopies(size, Object.class)), exprs);
        }
        return this.invokeStatic(MethodDesc.of(Set.class, "of", Set.class, Object[].class), this.newArray(Object.class, exprs));
    }

    @Override
    public Expr mapOf(List<? extends Expr> items) {
        int size = (items = List.copyOf(items)).size();
        if (size % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of items: " + String.valueOf(items));
        }
        if (size <= 20) {
            return this.invokeStatic(MethodDesc.of(Map.class, "of", Map.class, Collections.nCopies(items.size(), Object.class)), items);
        }
        throw new UnsupportedOperationException("Maps with more than 10 entries are not supported");
    }

    @Override
    public Expr mapEntry(Expr key, Expr value) {
        return this.invokeStatic(MethodDesc.of(Map.class, "entry", Map.Entry.class, Object.class, Object.class), key, value);
    }

    @Override
    public Expr optionalOf(Expr value) {
        return this.invokeStatic(MethodDesc.of(Optional.class, "of", Optional.class, Object.class), value);
    }

    @Override
    public Expr optionalOfNullable(Expr value) {
        return this.invokeStatic(MethodDesc.of(Optional.class, "ofNullable", Optional.class, Object.class), value);
    }

    @Override
    public void line(int lineNumber) {
        this.addItem(new LineNumber(lineNumber));
    }

    @Override
    public void printf(String format, List<? extends Expr> values) {
        this.invokeVirtual(MethodDesc.of(PrintStream.class, "printf", PrintStream.class, String.class, Object[].class), (Expr)Expr.staticField(FieldDesc.of(System.class, "out")), Const.of(format), this.newArray(ConstantDescs.CD_Object, values));
    }

    @Override
    public void assert_(Consumer<BlockCreator> assertion, String message) {
        this.if_(this.logicalAnd(Const.ofInvoke(Const.ofMethodHandle(InvokeKind.VIRTUAL, MethodDesc.of(Class.class, "desiredAssertionStatus", Boolean.TYPE, new Class[0])), new Const[0]), assertion), __ -> this.throw_(AssertionError.class, message));
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.input.process(node.prev(), op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.block(bcb -> {
            bcb.labelBinding(this.startLabel);
            for (Node node = this.head; node != null; node = node.next()) {
                node.item().writeCode((CodeBuilder)bcb, this);
            }
            bcb.labelBinding(this.endLabel);
        });
    }

    @Override
    public void writeAnnotations(RetentionPolicy retention, ArrayList<TypeAnnotation> annotations) {
        for (Node node = this.head; node != null; node = node.next()) {
            node.item().writeAnnotations(retention, annotations);
        }
    }

    void postInit(List<Consumer<BlockCreator>> postInits) {
        this.postInits = postInits;
    }

    <I extends Item> I addItem(I item) {
        this.checkActive();
        Node node = item.insert(this.tail);
        item.bind();
        item.forEachDependency(node, Item::insertIfUnbound);
        if (!item.mayFallThrough()) {
            assert (this.tail.item() instanceof Yield);
            this.tail.set(item);
            node.remove();
            this.markDone();
        }
        return item;
    }

    <I extends Item> I replaceLastItem(I item) {
        this.checkActive();
        assert (this.tail.item() instanceof Yield);
        this.tail.set(item);
        item.forEachDependency(this.tail, Item::insertIfUnbound);
        this.markDone();
        return item;
    }

    private void checkActive() {
        if (this.state == 2) {
            if (this.finishSite == null) {
                throw new IllegalStateException("This block has already been finished\nTo track callers and get an improved exception message, add the system property `gizmo.debug`");
            }
            throw new IllegalStateException("This block has already been finished at " + this.finishSite);
        }
        if (this.state == 1) {
            if (this.nestSite == null) {
                throw new IllegalStateException("This block is currently not active, because a nested block is being created\nTo track callers and get an improved exception message, add the system property `gizmo.debug`");
            }
            throw new IllegalStateException("This block is currently not active, because a nested block is being created, starting at " + this.nestSite);
        }
        if (!this.active()) {
            throw new IllegalStateException("This block is not active");
        }
    }

    Label startLabel() {
        return this.startLabel;
    }

    Label endLabel() {
        return this.endLabel;
    }

    static Node cleanStack(Node node) {
        if (node == null) {
            throw new IllegalStateException();
        }
        while (node.hasPrev()) {
            if ((node = node.item().pop(node)) != null) continue;
            throw new IllegalStateException();
        }
        return node;
    }

    private static /* synthetic */ void lambda$lambdaDebug$5(MethodTypeDesc samType, Consumer builder, ClassDesc samOwner, List captures, StaticMethodCreator mc) {
        mc.private_();
        mc.synthetic();
        mc.returning(samType.returnType());
        builder.accept(new LambdaAsMethodCreatorImpl(samOwner, samType, (MethodCreatorImpl)((Object)mc), captures));
    }
}

