/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.ClassFileElement;
import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.MethodBuilder;
import io.github.dmlloyd.classfile.MethodSignature;
import io.github.dmlloyd.classfile.Signature;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.github.dmlloyd.classfile.TypeKind;
import io.github.dmlloyd.classfile.attribute.ExceptionsAttribute;
import io.github.dmlloyd.classfile.attribute.MethodParameterInfo;
import io.github.dmlloyd.classfile.attribute.MethodParametersAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.SignatureAttribute;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.TypeParameter;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ConstructorCreator;
import io.quarkus.gizmo2.creator.ExecutableCreator;
import io.quarkus.gizmo2.creator.ParamCreator;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.ModifiableCreatorImpl;
import io.quarkus.gizmo2.impl.ParamCreatorImpl;
import io.quarkus.gizmo2.impl.ParamVarImpl;
import io.quarkus.gizmo2.impl.TypeCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ExecutableCreatorImpl
extends ModifiableCreatorImpl
implements ExecutableCreator {
    private static final MethodParameterInfo EMPTY_PI = MethodParameterInfo.of(Optional.empty(), (int)0);
    static final int ST_INITIAL = 0;
    static final int ST_BODY = 1;
    static final int ST_POST_BODY = 2;
    static final int ST_DONE = 3;
    final BitSet locals = new BitSet();
    final TypeCreatorImpl typeCreator;
    private List<TypeParameter> typeParameters = List.of();
    GenericType genericReturnType;
    boolean typeEstablished;
    MethodTypeDesc type = null;
    List<ParamVarImpl> params = List.of();
    int state = 0;
    List<GenericType.OfThrows> throws_ = List.of();

    ExecutableCreatorImpl(TypeCreatorImpl typeCreator) {
        super(typeCreator.gizmo);
        this.typeCreator = typeCreator;
    }

    @Override
    public MethodTypeDesc type() {
        MethodTypeDesc type = this.type;
        if (type == null) {
            type = this.type = this.computeType();
        }
        return type;
    }

    @Override
    public void setType(MethodTypeDesc desc) {
        if (this.state >= 1) {
            throw new IllegalStateException("Type may no longer be changed");
        }
        if (this.typeEstablished) {
            MethodTypeDesc type = this.type();
            if (!desc.equals(type)) {
                throw new IllegalArgumentException("Type " + String.valueOf(desc) + " does not match established type " + String.valueOf(type));
            }
        } else {
            int descParamCnt;
            MethodTypeDesc existing = this.type;
            if (desc.equals(existing)) {
                return;
            }
            GenericType returnType = this.genericReturnType;
            if (returnType != null && !desc.returnType().equals(returnType.desc())) {
                throw new IllegalArgumentException("Type " + String.valueOf(desc) + " has a return type that does not match established return type " + String.valueOf(returnType));
            }
            int paramCnt = this.params.size();
            if (paramCnt > (descParamCnt = desc.parameterCount())) {
                throw new IllegalArgumentException("Existing parameter count (" + paramCnt + ") is greater than the number of parameters in " + String.valueOf(desc));
            }
            List<ParamVarImpl> params = this.params;
            for (int i = 0; i < paramCnt; ++i) {
                ParamVarImpl param = params.get(i);
                if (param == null || param.type().equals(desc.parameterType(i))) continue;
                throw new IllegalArgumentException("Defined parameter " + i + " has a type of " + String.valueOf(param.type()) + " which conflicts with " + String.valueOf(desc));
            }
            this.clearType();
            this.type = desc;
            this.genericReturnType = GenericType.of(desc.returnType());
            if (params.size() != descParamCnt) {
                if (params instanceof ArrayList) {
                    ArrayList al = (ArrayList)params;
                    al.ensureCapacity(descParamCnt);
                } else {
                    this.params = new ArrayList<ParamVarImpl>(descParamCnt);
                    this.params.addAll(params);
                }
            }
            this.typeEstablished = true;
        }
    }

    MethodTypeDesc computeType() {
        assert (this.type == null);
        return MethodTypeDesc.of(this.returnType(), (ClassDesc[])this.params.stream().map(ParamVarImpl::type).toArray(ClassDesc[]::new));
    }

    @Override
    public GenericType genericReturnType() {
        GenericType returnType = this.genericReturnType;
        if (returnType == null) {
            return GenericType.of(ConstantDescs.CD_void);
        }
        return returnType;
    }

    @Override
    public ClassDesc returnType() {
        return this.genericReturnType().desc();
    }

    void returning(GenericType type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        if (this.state >= 1) {
            throw new IllegalStateException("Return type may no longer be changed");
        }
        GenericType returnType = this.genericReturnType;
        if (returnType == null) {
            assert (!this.typeEstablished);
            this.genericReturnType = type;
        } else if (!returnType.equals(type)) {
            throw new IllegalArgumentException("Return type " + String.valueOf(type) + " does not match established return type " + String.valueOf(returnType));
        }
    }

    void returning(ClassDesc type) {
        this.returning(GenericType.of(type));
    }

    void doBody(Consumer<BlockCreator> builder, MethodBuilder mb) {
        int i;
        List<MethodParameterInfo> mpi;
        ArrayList<TypeAnnotation> visible = new ArrayList<TypeAnnotation>();
        ArrayList<TypeAnnotation> invisible = new ArrayList<TypeAnnotation>();
        mb.with((ClassFileElement)SignatureAttribute.of((MethodSignature)this.computeSignature()));
        mb.withFlags(this.modifiers);
        this.addVisible((Consumer<? super RuntimeVisibleAnnotationsAttribute>)mb);
        this.addInvisible((Consumer<? super RuntimeInvisibleAnnotationsAttribute>)mb);
        List<GenericType.OfThrows> throws_ = this.throws_;
        if (!throws_.isEmpty()) {
            mb.with((ClassFileElement)ExceptionsAttribute.of(throws_.stream().map(GenericType::desc).map(cd -> this.typeCreator.zb.constantPool().classEntry(cd)).toList()));
            for (int i2 = 0; i2 < throws_.size(); ++i2) {
                GenericType.OfThrows genericType = throws_.get(i2);
                Util.computeAnnotations(genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofThrows((int)i2), visible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
                Util.computeAnnotations(genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofThrows((int)i2), invisible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
            }
        }
        if (!(mpi = this.params.stream().map(pv -> pv == null ? EMPTY_PI : MethodParameterInfo.ofParameter(Optional.of(pv.name()), (int)pv.flags())).toList()).isEmpty()) {
            mb.with((ClassFileElement)MethodParametersAttribute.of(mpi));
        }
        if (this.params.stream().anyMatch(pvi -> !pvi.visible.isEmpty())) {
            mb.with((ClassFileElement)RuntimeVisibleParameterAnnotationsAttribute.of(this.params.stream().map(pvi -> pvi != null ? pvi.visible : List.of()).toList()));
        }
        if (this.params.stream().anyMatch(pvi -> !pvi.invisible.isEmpty())) {
            mb.with((ClassFileElement)RuntimeInvisibleParameterAnnotationsAttribute.of(this.params.stream().map(pvi -> pvi != null ? pvi.invisible : List.of()).toList()));
        }
        for (i = 0; i < this.params.size(); ++i) {
            GenericType genericType = this.params.get(i).genericType();
            Util.computeAnnotations(genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodFormalParameter((int)i), visible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
            Util.computeAnnotations(genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodFormalParameter((int)i), invisible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        }
        Util.computeAnnotations(this.genericReturnType(), RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodReturn(), visible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        Util.computeAnnotations(this.genericReturnType(), RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodReturn(), invisible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        for (i = 0; i < this.typeParameters.size(); ++i) {
            TypeParameter tv = this.typeParameters.get(i);
            Util.computeAnnotations(tv, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofTypeParameter((TypeAnnotation.TargetType)TypeAnnotation.TargetType.METHOD_TYPE_PARAMETER, (int)i), visible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
            Util.computeAnnotations(tv, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofTypeParameter((TypeAnnotation.TargetType)TypeAnnotation.TargetType.METHOD_TYPE_PARAMETER, (int)i), invisible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        }
        if (builder != null) {
            mb.withCode(cb -> this.doCode(builder, (CodeBuilder)cb));
        }
        if (!visible.isEmpty()) {
            mb.with((ClassFileElement)RuntimeVisibleTypeAnnotationsAttribute.of(visible));
        }
        if (!invisible.isEmpty()) {
            mb.with((ClassFileElement)RuntimeInvisibleTypeAnnotationsAttribute.of(invisible));
        }
    }

    MethodSignature computeSignature() {
        return MethodSignature.of(this.typeParameters.stream().map(Util::typeParamOf).toList(), this.throws_.stream().map(Util::signatureOf).map(Signature.ThrowableSig.class::cast).toList(), (Signature)Util.signatureOf(this.genericReturnType()), (Signature[])((Signature[])this.params.stream().map(ParamVarImpl::genericType).map(Util::signatureOf).toArray(Signature[]::new)));
    }

    void doCode(Consumer<BlockCreator> builder, CodeBuilder cb) {
        ArrayList<TypeAnnotation> visible = new ArrayList<TypeAnnotation>();
        ArrayList<TypeAnnotation> invisible = new ArrayList<TypeAnnotation>();
        BlockCreatorImpl bc = new BlockCreatorImpl(this.typeCreator, cb, this.returnType(), this instanceof ConstructorCreator ? "new" : this.name());
        if ((this.modifiers & 8) == 0) {
            cb.localVariable(0, "this", this.typeCreator.type(), bc.startLabel(), bc.endLabel());
            GenericType.OfClass genericType = this.typeCreator.genericType();
            if (!genericType.isRaw()) {
                cb.localVariableType(0, "this", (Signature)Util.signatureOf(genericType), bc.startLabel(), bc.endLabel());
            }
            if (genericType.hasVisibleAnnotations()) {
                Util.computeAnnotations(genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofLocalVariable(List.of(TypeAnnotation.LocalVarTargetInfo.of((Label)bc.startLabel(), (Label)bc.endLabel(), (int)0))), visible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
                Util.computeAnnotations(genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodReceiver(), visible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
            }
            if (genericType.hasInvisibleAnnotations()) {
                Util.computeAnnotations(genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofLocalVariable(List.of(TypeAnnotation.LocalVarTargetInfo.of((Label)bc.startLabel(), (Label)bc.endLabel(), (int)0))), invisible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
                Util.computeAnnotations(genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofMethodReceiver(), invisible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
            }
        }
        for (ParamVarImpl param : this.params) {
            if (param == null) continue;
            cb.localVariable(param.slot(), param.name(), param.type(), bc.startLabel(), bc.endLabel());
            GenericType genericType = param.genericType();
            if (!genericType.isRaw()) {
                cb.localVariableType(param.slot(), param.name(), Util.signatureOf(genericType), bc.startLabel(), bc.endLabel());
            }
            if (genericType.hasVisibleAnnotations()) {
                Util.computeAnnotations(genericType, RetentionPolicy.RUNTIME, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofLocalVariable(List.of(TypeAnnotation.LocalVarTargetInfo.of((Label)bc.startLabel(), (Label)bc.endLabel(), (int)param.slot()))), visible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
            }
            if (!genericType.hasInvisibleAnnotations()) continue;
            Util.computeAnnotations(genericType, RetentionPolicy.CLASS, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofLocalVariable(List.of(TypeAnnotation.LocalVarTargetInfo.of((Label)bc.startLabel(), (Label)bc.endLabel(), (int)param.slot()))), invisible, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        }
        bc.accept(builder);
        bc.writeCode(cb, bc);
        if (bc.mayFallThrough()) {
            if (this.creationSite == null) {
                throw new IllegalStateException("Outermost block of an executable member must not fall out (return or throw instead)\nTo track callers and get an improved exception message, add the system property `gizmo.debug`");
            }
            throw new IllegalStateException("Outermost block of an executable member created at " + this.creationSite + " must not fall out (return or throw instead)");
        }
        bc.writeAnnotations(RetentionPolicy.RUNTIME, visible);
        bc.writeAnnotations(RetentionPolicy.CLASS, invisible);
        if (!visible.isEmpty()) {
            cb.with((ClassFileElement)RuntimeVisibleTypeAnnotationsAttribute.of(visible));
        }
        if (!invisible.isEmpty()) {
            cb.with((ClassFileElement)RuntimeInvisibleTypeAnnotationsAttribute.of(invisible));
        }
    }

    abstract String name();

    void body(Consumer<BlockCreator> builder) {
        if (this.state >= 1) {
            throw new IllegalStateException("Body established twice");
        }
        this.state = 1;
        try {
            this.typeCreator.zb.withMethod(this.name(), this.type(), this.modifiers, mb -> this.doBody(builder, (MethodBuilder)mb));
        }
        finally {
            this.state = 2;
        }
    }

    @Override
    public ParamVar parameter(String name, Consumer<ParamCreator> builder) {
        return this.parameter(name, this.params.size(), builder);
    }

    @Override
    public ParamVar parameter(String name, int position, Consumer<ParamCreator> builder) {
        ParamCreatorImpl pc;
        int slot;
        if (this.state >= 1) {
            throw new IllegalStateException("Parameters may no longer be established");
        }
        MethodTypeDesc type = this.type;
        if (type != null && !this.typeEstablished) {
            this.clearType();
            type = null;
        }
        if (type == null) {
            int size = this.params.size();
            if (position != size) {
                throw new IllegalStateException("The method type was not established upfront and so parameters must be declared in order: expected parameter " + size + ", but got " + position);
            }
            if (size == 0) {
                slot = this.firstSlot();
            } else {
                ParamVarImpl last = this.params.get(size - 1);
                slot = last.slot() + last.slotSize();
            }
            pc = new ParamCreatorImpl(this.typeCreator.gizmo);
        } else {
            if (position < 0 || position >= type.parameterCount()) {
                throw new IndexOutOfBoundsException("Parameter position " + position + " is out of bounds for type " + String.valueOf(type));
            }
            if (position < this.params.size()) {
                throw new IllegalStateException("Parameter already defined at position " + position);
            }
            pc = new ParamCreatorImpl(this.typeCreator.gizmo, GenericType.of(type.parameterType(position)));
            slot = this.firstSlot() + IntStream.range(0, position).mapToObj(type::parameterType).map(TypeKind::from).mapToInt(TypeKind::slotSize).sum();
        }
        ParamVarImpl pv = pc.apply(builder, name, position, slot);
        List<ParamVarImpl> list = this.params;
        if (list instanceof ArrayList) {
            ArrayList al = (ArrayList)list;
            al.add(pv);
        } else {
            this.params = Util.listWith(this.params, pv);
        }
        this.locals.set(slot);
        if (TypeKind.from((TypeDescriptor.OfField)pv.type()).slotSize() == 2) {
            this.locals.set(slot + 1);
        }
        return pv;
    }

    @Override
    public void throws_(GenericType.OfThrows throwableType) {
        Assert.checkNotNullParam((String)"throwableType", (Object)throwableType);
        if (this.state >= 1) {
            throw new IllegalStateException("Exception throws may no longer be established");
        }
        List<GenericType.OfThrows> list = this.throws_;
        if (list instanceof ArrayList) {
            ArrayList al = (ArrayList)list;
            al.add(throwableType);
        } else {
            this.throws_ = Util.listWith(this.throws_, throwableType);
        }
    }

    void clearType() {
        this.type = null;
    }

    int firstSlot() {
        return 1;
    }

    public ClassDesc owner() {
        return this.typeCreator.type();
    }

    <T extends TypeParameter> T addTypeParameter(T var) {
        List<TypeParameter> list = this.typeParameters;
        if (list instanceof ArrayList) {
            ArrayList al = (ArrayList)list;
            al.add(var);
        } else {
            this.typeParameters = Util.listWith(this.typeParameters, var);
        }
        return var;
    }
}

