/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.TypeKind;
import io.github.dmlloyd.classfile.instruction.SwitchCase;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.SwitchCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ClassDesc;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class HashSwitchCreatorImpl<C extends ConstImpl>
extends SwitchCreatorImpl<C> {
    HashSwitchCreatorImpl(BlockCreatorImpl enclosing, Expr switchVal, ClassDesc type, Class<C> constantType) {
        super(enclosing, switchVal, type, constantType);
    }

    abstract boolean staticEquals(C var1, C var2);

    abstract void equaller(CodeBuilder var1, C var2, Label var3);

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        Label fallOut;
        Label nonMatching;
        if (this.default_ == null) {
            fallOut = nonMatching = block.newLabel();
        } else {
            fallOut = this.default_.endLabel();
            nonMatching = this.default_.startLabel();
        }
        List<Map.Entry> sortedCases = this.casesByConstant.entrySet().stream().sorted(Comparator.comparingInt(e -> this.staticHash((ConstImpl)e.getKey()))).toList();
        int[] hashes = this.casesByConstant.keySet().stream().mapToInt(this::staticHash).sorted().distinct().toArray();
        Label[] caseLabels = (Label[])IntStream.of(hashes).mapToObj(val -> cb.newLabel()).toArray(Label[]::new);
        List<SwitchCase> switchCases = IntStream.range(0, hashes.length).mapToObj(i -> SwitchCase.of((int)hashes[i], (Label)caseLabels[i])).toList();
        TypeKind tk = Util.actualKindOf(this.switchVal.typeKind());
        int idx = cb.allocateLocal(tk);
        this.doDup(cb);
        cb.storeLocal(tk, idx);
        this.hash(cb);
        if ((double)this.casesByConstant.size() / (double)(this.max - this.min) >= 0.9) {
            cb.tableswitch(this.min, this.max, nonMatching, switchCases);
        } else {
            cb.lookupswitch(nonMatching, switchCases);
        }
        if (!this.casesByConstant.isEmpty()) {
            Iterator<Map.Entry> iterator = sortedCases.iterator();
            assert (iterator.hasNext());
            Map.Entry entry = iterator.next();
            int hashIdx = 0;
            int hash = this.staticHash((ConstImpl)entry.getKey());
            assert (hash == hashes[hashIdx]);
            cb.labelBinding(caseLabels[hashIdx++]);
            cb.loadLocal(tk, idx);
            this.equaller(cb, (ConstImpl)entry.getKey(), ((SwitchCreatorImpl.CaseCreatorImpl)entry.getValue()).body.startLabel());
            while (iterator.hasNext()) {
                entry = iterator.next();
                int nextHash = this.staticHash((ConstImpl)entry.getKey());
                if (hash != nextHash) {
                    cb.goto_(nonMatching);
                    cb.labelBinding(caseLabels[hashIdx++]);
                    hash = nextHash;
                }
                cb.loadLocal(tk, idx);
                this.equaller(cb, (ConstImpl)entry.getKey(), ((SwitchCreatorImpl.CaseCreatorImpl)entry.getValue()).body.startLabel());
            }
            cb.goto_(nonMatching);
            for (SwitchCreatorImpl.CaseCreatorImpl case_ : this.cases) {
                case_.body.writeCode(cb, block);
                if (!case_.body.mayFallThrough()) continue;
                cb.goto_(fallOut);
            }
        }
        if (this.default_ == null) {
            cb.labelBinding(fallOut);
            cb.labelBinding(nonMatching);
        } else {
            this.default_.writeCode(cb, block);
        }
    }

    private void doDup(CodeBuilder cb) {
        if (this.switchVal.typeKind().slotSize() == 2) {
            cb.dup2();
        } else {
            cb.dup();
        }
    }

    private void doPop(CodeBuilder cb) {
        if (this.switchVal.typeKind().slotSize() == 2) {
            cb.pop2();
        } else {
            cb.pop();
        }
    }
}

