/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.BlockHeader;
import io.quarkus.gizmo2.impl.Goto;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import java.lang.constant.ClassDesc;
import java.util.List;

abstract class If
extends Item {
    private final ClassDesc type;
    final Kind kind;
    final BlockCreatorImpl whenTrue;
    final BlockCreatorImpl whenFalse;

    If(ClassDesc type, Kind kind, BlockCreatorImpl whenTrue, BlockCreatorImpl whenFalse) {
        this.type = type;
        this.kind = kind;
        this.whenTrue = whenTrue;
        this.whenFalse = whenFalse;
    }

    @Override
    public ClassDesc type() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        if (this.whenTrue != null) {
            Node trueTail = this.whenTrue.tail();
            if (this.whenFalse != null) {
                Node falseTail = this.whenFalse.tail();
                Item item = trueTail.item();
                if (item instanceof Goto) {
                    Goto goto_ = (Goto)item;
                    if (trueTail.prev().item() instanceof BlockHeader) {
                        this.op(this.kind).accept(cb, goto_.target(block));
                        this.whenFalse.writeCode(cb, block);
                        return;
                    }
                }
                if ((item = falseTail.item()) instanceof Goto) {
                    Goto goto_ = (Goto)item;
                    if (falseTail.prev().item() instanceof BlockHeader) {
                        this.op(this.kind.invert()).accept(cb, goto_.target(block));
                        this.whenTrue.writeCode(cb, block);
                        return;
                    }
                }
                this.op(this.kind).accept(cb, this.whenTrue.startLabel());
                this.whenFalse.writeCode(cb, block);
                if (this.whenFalse.mayFallThrough()) {
                    cb.goto_(this.whenTrue.endLabel());
                }
                this.whenTrue.writeCode(cb, block);
                return;
            }
            Item item = trueTail.item();
            if (item instanceof Goto) {
                Goto goto_ = (Goto)item;
                if (trueTail.prev().item() instanceof BlockHeader) {
                    this.op(this.kind).accept(cb, goto_.target(block));
                    return;
                }
            }
            this.op(this.kind.invert()).accept(cb, this.whenTrue.endLabel());
            this.whenTrue.writeCode(cb, block);
            return;
        }
        if (this.whenFalse == null) throw new IllegalStateException();
        Node falseTail = this.whenFalse.tail();
        Item item = falseTail.item();
        if (item instanceof Goto) {
            Goto goto_ = (Goto)item;
            if (falseTail.prev().item() instanceof BlockHeader) {
                this.op(this.kind.invert()).accept(cb, goto_.target(block));
                return;
            }
        }
        this.op(this.kind).accept(cb, this.whenFalse.endLabel());
        this.whenFalse.writeCode(cb, block);
    }

    @Override
    public boolean mayFallThrough() {
        return this.whenTrue == null || this.whenTrue.mayFallThrough() || this.whenFalse == null || this.whenFalse.mayFallThrough();
    }

    abstract IfOp op(Kind var1);

    static enum Kind {
        EQ(CodeBuilder::ifeq, CodeBuilder::if_icmpeq, CodeBuilder::ifnull, CodeBuilder::if_acmpeq),
        NE(CodeBuilder::ifne, CodeBuilder::if_icmpne, CodeBuilder::ifnonnull, CodeBuilder::if_acmpne),
        LT(CodeBuilder::iflt, CodeBuilder::if_icmplt),
        GE(CodeBuilder::ifge, CodeBuilder::if_icmpge),
        LE(CodeBuilder::ifle, CodeBuilder::if_icmple),
        GT(CodeBuilder::ifgt, CodeBuilder::if_icmpgt);

        static final List<Kind> values;
        final IfOp if_;
        final IfOp if_icmp;
        final IfOp if_acmpnull;
        final IfOp if_acmp;

        private Kind(IfOp if_, IfOp if_icmp, IfOp if_acmpnull, IfOp if_acmp) {
            this.if_ = if_;
            this.if_icmp = if_icmp;
            this.if_acmpnull = if_acmpnull;
            this.if_acmp = if_acmp;
        }

        private Kind(IfOp if_, IfOp if_icmp) {
            this(if_, if_icmp, null, null);
        }

        Kind invert() {
            return values.get(this.ordinal() ^ 1);
        }

        static {
            values = List.of(Kind.values());
        }
    }

    static interface IfOp {
        public void accept(CodeBuilder var1, Label var2);
    }
}

