/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.creator.AccessLevel;
import io.quarkus.gizmo2.creator.ModifiableCreator;
import io.quarkus.gizmo2.creator.Modifier;
import io.quarkus.gizmo2.creator.ModifierFlag;
import io.quarkus.gizmo2.impl.AnnotatableCreatorImpl;
import io.quarkus.gizmo2.impl.GizmoImpl;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ModifiableCreatorImpl
extends AnnotatableCreatorImpl
implements ModifiableCreator {
    int modifiers;

    ModifiableCreatorImpl(GizmoImpl gizmo) {
        this.modifiers = gizmo.getDefaultModifiers(this.modifierLocation());
    }

    @Override
    public void addFlag(ModifierFlag flag) {
        if (this.requires(flag)) {
            return;
        }
        if (this.supports(flag)) {
            flag.forEachExclusive(this::removeFlag);
            this.modifiers |= flag.mask();
        } else {
            throw ModifiableCreatorImpl.cannotAdd(flag);
        }
    }

    @Override
    public void removeFlag(ModifierFlag flag) {
        if (this.requires(flag)) {
            throw ModifiableCreatorImpl.cannotRemove(flag);
        }
        if (!this.supports(flag)) {
            return;
        }
        this.modifiers &= ~flag.mask();
    }

    private boolean requires(ModifierFlag flag) {
        return this.modifierLocation().requires(flag);
    }

    @Override
    public void setAccess(AccessLevel access) {
        if (!this.supports(access)) {
            throw ModifiableCreatorImpl.unsupported(access);
        }
        this.modifiers = this.modifiers & ~AccessLevel.fullMask() | access.mask();
    }

    private static IllegalArgumentException unsupported(AccessLevel modifier) {
        return new IllegalArgumentException("Access level \"%s\" cannot be used here".formatted(modifier));
    }

    private static IllegalArgumentException cannotAdd(Modifier modifier) {
        return new IllegalArgumentException("Modifier \"%s\" cannot be added here".formatted(modifier));
    }

    private static IllegalArgumentException cannotRemove(Modifier modifier) {
        return new IllegalArgumentException("Modifier \"%s\" cannot be removed here".formatted(modifier));
    }
}

