/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.instruction.SwitchCase;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.SwitchCreatorImpl;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ClassDesc;
import java.util.Comparator;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class PerfectHashSwitchCreatorImpl<C extends ConstImpl>
extends SwitchCreatorImpl<C> {
    PerfectHashSwitchCreatorImpl(BlockCreatorImpl enclosing, Expr switchVal, ClassDesc type, Class<C> constantType) {
        super(enclosing, switchVal, type, constantType);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        Label fallOut;
        Label nonMatching;
        if (this.default_ == null) {
            fallOut = nonMatching = block.newLabel();
        } else {
            fallOut = this.default_.endLabel();
            nonMatching = this.default_.startLabel();
        }
        List<SwitchCase> switchCases = this.casesByConstant.entrySet().stream().map(c -> SwitchCase.of((int)this.staticHash((ConstImpl)c.getKey()), (Label)((SwitchCreatorImpl.CaseCreatorImpl)c.getValue()).body.startLabel())).sorted(Comparator.comparingInt(SwitchCase::caseValue)).toList();
        this.hash(cb);
        if ((double)this.casesByConstant.size() / (double)(this.max - this.min) >= 0.9) {
            cb.tableswitch(this.min, this.max, nonMatching, switchCases);
        } else {
            cb.lookupswitch(nonMatching, switchCases);
        }
        for (SwitchCreatorImpl.CaseCreatorImpl case_ : this.casesByConstant.values()) {
            case_.body.writeCode(cb, block);
            if (!case_.body.mayFallThrough()) continue;
            cb.goto_(fallOut);
        }
        if (this.default_ == null) {
            cb.labelBinding(fallOut);
            cb.labelBinding(nonMatching);
        } else {
            this.default_.writeCode(cb, block);
        }
    }
}

