package io.quarkus.gizmo2.impl;

import static io.smallrye.common.constraint.Assert.impossibleSwitchCase;
import static java.lang.constant.ConstantDescs.*;

import java.lang.constant.MethodTypeDesc;
import java.util.function.BiFunction;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.constant.ConstImpl;

final class FieldGetViaHandle extends Item {
    private final FieldDeref fieldDeref;
    private final MemoryOrder mode;

    FieldGetViaHandle(final FieldDeref fieldDeref, final MemoryOrder mode) {
        this.fieldDeref = fieldDeref;
        this.mode = mode;
    }

    protected void computeType() {
        initType(fieldDeref.type());
        if (fieldDeref.hasGenericType()) {
            initGenericType(fieldDeref.genericType());
        }
    }

    protected Node forEachDependency(final Node node, final BiFunction<Item, Node, Node> op) {
        return ConstImpl.ofFieldVarHandle(fieldDeref.desc()).process(fieldDeref.instance().process(node.prev(), op), op);
    }

    public void writeCode(final CodeBuilder cb, final BlockCreatorImpl block) {
        cb.invokevirtual(CD_VarHandle, switch (mode) {
            case Plain -> "get";
            case Opaque -> "getOpaque";
            case Acquire -> "getAcquire";
            case Volatile -> "getVolatile";
            default -> throw impossibleSwitchCase(mode);
        }, MethodTypeDesc.of(type(), fieldDeref.instance().type()));
    }
}
