/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.vertx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.EventExecutor;
import io.undertow.httpcore.BufferAllocator;
import io.undertow.httpcore.ConnectionSSLSessionInfo;
import io.undertow.httpcore.HttpExchange;
import io.undertow.httpcore.HttpExchangeBase;
import io.undertow.httpcore.InputChannel;
import io.undertow.httpcore.IoCallback;
import io.undertow.httpcore.OutputChannel;
import io.undertow.httpcore.SSLSessionInfo;
import io.undertow.httpcore.UndertowOptionMap;
import io.undertow.vertx.VertxBufferImpl;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.net.impl.ConnectionBase;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.net.ssl.SSLSession;
import org.jboss.logging.Logger;

public class VertxHttpExchange
extends HttpExchangeBase
implements HttpExchange,
InputChannel,
OutputChannel,
Handler<Buffer> {
    private static final Logger log = Logger.getLogger(VertxHttpExchange.class);
    private final HttpServerRequest request;
    private final HttpServerResponse response;
    private final ConnectionBase connectionBase;
    private final BufferAllocator allocator;
    private final Executor worker;
    private Buffer input1;
    private Deque<Buffer> inputOverflow;
    private boolean waitingForRead = false;
    private BiConsumer<InputChannel, Object> readHandler;
    private Object readHandlerContext;
    private boolean eof = false;
    private boolean eofRead = false;
    private boolean responseDone = false;
    private boolean waitingForWrite;
    private boolean drainHandlerRegistered;
    private volatile boolean writeQueued = false;
    private IOException readError;

    public VertxHttpExchange(final HttpServerRequest request, BufferAllocator allocator, Executor worker) {
        this.request = request;
        this.response = request.response();
        this.connectionBase = (ConnectionBase)request.connection();
        this.allocator = allocator;
        this.worker = worker;
        if (this.isRequestEntityBodyAllowed() && !request.isEnded()) {
            request.handler((Handler)this);
            request.exceptionHandler((Handler)new Handler<Throwable>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(Throwable event) {
                    HttpConnection httpConnection = request.connection();
                    synchronized (httpConnection) {
                        if (event instanceof IOException) {
                            VertxHttpExchange.this.readError = (IOException)event;
                        } else {
                            VertxHttpExchange.this.readError = new IOException(event);
                        }
                    }
                }
            });
            request.endHandler((Handler)new Handler<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(Void event) {
                    BiConsumer readCallback = null;
                    Object readContext = null;
                    HttpConnection httpConnection = request.connection();
                    synchronized (httpConnection) {
                        VertxHttpExchange.this.eof = true;
                        if (VertxHttpExchange.this.waitingForRead) {
                            request.connection().notify();
                        }
                        if (VertxHttpExchange.this.readHandler != null) {
                            readCallback = VertxHttpExchange.this.readHandler;
                            VertxHttpExchange.this.readHandler = null;
                            readContext = VertxHttpExchange.this.readHandlerContext;
                            VertxHttpExchange.this.readHandlerContext = null;
                        }
                    }
                    if (readCallback != null) {
                        readCallback.accept(VertxHttpExchange.this, readContext);
                    }
                    if (VertxHttpExchange.this.input1 == null) {
                        VertxHttpExchange.this.terminateRequest();
                    }
                }
            });
            request.fetch(1L);
        } else {
            this.terminateRequest();
        }
        request.response().exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable event) {
                log.debugf(event, "IO Exception ", new Object[0]);
                VertxHttpExchange.this.eof = true;
                VertxHttpExchange.this.terminateRequest();
                VertxHttpExchange.this.terminateResponse();
                request.connection().close();
            }
        });
        request.response().endHandler((Handler)new Handler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Void event) {
                HttpConnection httpConnection = request.connection();
                synchronized (httpConnection) {
                    if (VertxHttpExchange.this.waitingForWrite || VertxHttpExchange.this.waitingForRead) {
                        request.connection().notify();
                    }
                }
                VertxHttpExchange.this.terminateResponse();
            }
        });
    }

    public BufferAllocator getBufferAllocator() {
        return this.allocator;
    }

    public HttpExchange setStatusCode(int code) {
        this.response.setStatusCode(code);
        return this;
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getRequestHeader(String name) {
        return this.request.getHeader(name);
    }

    public List<String> getRequestHeaders(String name) {
        return this.request.headers().getAll(name);
    }

    public boolean containsRequestHeader(String name) {
        return this.request.headers().contains(name);
    }

    public void removeRequestHeader(String name) {
        this.request.headers().remove(name);
    }

    public void setRequestHeader(String name, String value) {
        this.request.headers().set(name, value);
    }

    public Collection<String> getRequestHeaderNames() {
        return this.request.headers().names();
    }

    public void addRequestHeader(String name, String value) {
        this.request.headers().add(name, value);
    }

    public void clearRequestHeaders() {
        this.request.headers().clear();
    }

    public List<String> getResponseHeaders(String name) {
        return this.response.headers().getAll(name);
    }

    public boolean containsResponseHeader(String name) {
        return this.response.headers().contains(name);
    }

    public void removeResponseHeader(String name) {
        if (this.isResponseStarted()) {
            return;
        }
        this.response.headers().remove(name);
    }

    public void setResponseHeader(String name, String value) {
        if (this.isResponseStarted()) {
            return;
        }
        this.response.headers().set(name, value);
    }

    public Collection<String> getResponseHeaderNames() {
        return this.response.headers().names();
    }

    public void addResponseHeader(String name, String value) {
        if (this.isResponseStarted()) {
            return;
        }
        this.response.headers().add(name, value);
    }

    public void clearResponseHeaders() {
        if (this.isResponseStarted()) {
            return;
        }
        this.response.headers().clear();
    }

    public String getResponseHeader(String name) {
        return this.response.headers().get(name);
    }

    public String getRequestMethod() {
        return this.request.method().name();
    }

    public String getRequestScheme() {
        return this.request.scheme();
    }

    public String getRequestURI() {
        return this.request.uri();
    }

    public String getProtocol() {
        switch (this.request.version()) {
            case HTTP_1_0: {
                return "HTTP/1.0";
            }
            case HTTP_1_1: {
                return "HTTP/1.1";
            }
            case HTTP_2: {
                return "HTTP/2.0";
            }
        }
        return this.request.version().toString();
    }

    public boolean isInIoThread() {
        return this.connectionBase.channel().eventLoop().inEventLoop();
    }

    public InputChannel getInputChannel() {
        return this;
    }

    public InetSocketAddress getDestinationAddress() {
        return (InetSocketAddress)this.connectionBase.channel().localAddress();
    }

    public InetSocketAddress getSourceAddress() {
        return (InetSocketAddress)this.connectionBase.channel().remoteAddress();
    }

    public ByteBuf readAsync() throws IOException {
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            if (this.readError != null) {
                throw new IOException(this.readError);
            }
            if (this.input1 != null) {
                ByteBuf ret = this.input1.getByteBuf();
                if (this.inputOverflow != null) {
                    this.input1 = this.inputOverflow.poll();
                    if (this.input1 == null) {
                        this.request.fetch(1L);
                    }
                } else {
                    this.input1 = null;
                    this.request.fetch(1L);
                }
                return ret;
            }
            if (this.eof) {
                this.eofRead = true;
                return null;
            }
            throw new IllegalStateException("readAsync called when isReadable is false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadable() {
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            if (this.eofRead) {
                return false;
            }
            return this.input1 != null || this.eof || this.readError != null;
        }
    }

    public <T> void setReadHandler(BiConsumer<InputChannel, T> handler, T context) {
        this.readHandler = handler;
        this.readHandlerContext = context;
    }

    public int readBytesAvailable() {
        if (this.input1 != null) {
            return this.input1.getByteBuf().readableBytes();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf readBlocking() throws IOException {
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            while (this.input1 == null && !this.eof) {
                try {
                    this.waitingForRead = true;
                    this.request.connection().wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
                finally {
                    this.waitingForRead = false;
                }
            }
            Buffer ret = this.input1;
            this.input1 = null;
            if (this.inputOverflow != null) {
                this.input1 = this.inputOverflow.poll();
                if (this.input1 == null) {
                    this.request.fetch(1L);
                }
            } else {
                this.request.fetch(1L);
            }
            if (ret == null) {
                this.terminateRequest();
            }
            return ret == null ? null : ret.getByteBuf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            this.request.connection().close();
        }
    }

    public EventExecutor getIoThread() {
        return this.connectionBase.channel().eventLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlocking0(ByteBuf data, boolean last) throws IOException {
        if (this.responseDone) {
            if (last && data == null) {
                return;
            }
            throw new IOException("Response already complete");
        }
        if (last && data == null) {
            this.responseDone = true;
            this.request.response().end();
            return;
        }
        try {
            HttpConnection httpConnection = this.request.connection();
            synchronized (httpConnection) {
                this.awaitWriteable();
                if (last) {
                    this.responseDone = true;
                    this.request.response().end(this.createBuffer(data));
                } else {
                    this.request.response().write(this.createBuffer(data));
                }
            }
        }
        finally {
            if (last) {
                this.terminateResponse();
            }
        }
    }

    private void awaitWriteable() throws InterruptedIOException {
        assert (Thread.holdsLock(this.request.connection()));
        while (this.request.response().writeQueueFull()) {
            if (!this.drainHandlerRegistered) {
                this.drainHandlerRegistered = true;
                this.request.response().drainHandler((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        if (VertxHttpExchange.this.waitingForWrite) {
                            VertxHttpExchange.this.request.connection().notifyAll();
                        }
                    }
                });
            }
            try {
                this.waitingForWrite = true;
                this.request.connection().wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            finally {
                this.waitingForWrite = false;
            }
        }
    }

    public <T> void writeAsync0(final ByteBuf data, final boolean last, final IoCallback<T> callback, final T context) {
        if (this.responseDone) {
            if (last && data == null) {
                callback.onComplete((HttpExchange)this, context);
            } else {
                callback.onException((HttpExchange)this, context, new IOException("Response already complete"));
            }
            return;
        }
        this.writeQueued = true;
        if (last && data == null) {
            this.responseDone = true;
            this.request.response().end();
            this.queueWriteListener(callback, context, last);
            return;
        }
        if (this.request.response().writeQueueFull()) {
            this.request.response().drainHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    if (last) {
                        VertxHttpExchange.this.responseDone = true;
                        VertxHttpExchange.this.request.response().end(VertxHttpExchange.this.createBuffer(data));
                    } else {
                        VertxHttpExchange.this.request.response().write(VertxHttpExchange.this.createBuffer(data));
                    }
                    VertxHttpExchange.this.queueWriteListener(callback, context, last);
                    VertxHttpExchange.this.request.response().drainHandler(null);
                }
            });
        } else {
            if (last) {
                this.responseDone = true;
                this.request.response().end(this.createBuffer(data));
            } else {
                this.request.response().write(this.createBuffer(data));
            }
            this.queueWriteListener(callback, context, last);
        }
    }

    private <T> void queueWriteListener(final IoCallback<T> callback, final T context, final boolean last) {
        this.connectionBase.channel().eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                if (last) {
                    VertxHttpExchange.this.terminateResponse();
                }
                callback.onComplete((HttpExchange)VertxHttpExchange.this, context);
                VertxHttpExchange.this.writeQueued = false;
            }
        });
    }

    private Buffer createBuffer(ByteBuf data) {
        return new VertxBufferImpl(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Buffer event) {
        BiConsumer<InputChannel, Object> readCallback = null;
        Object context = null;
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            if (this.input1 == null) {
                this.input1 = event;
            } else {
                if (this.inputOverflow == null) {
                    this.inputOverflow = new ArrayDeque<Buffer>();
                }
                this.inputOverflow.add(event);
            }
            if (this.waitingForRead) {
                this.request.connection().notifyAll();
            }
            if (this.readHandler != null) {
                readCallback = this.readHandler;
                this.readHandler = null;
                context = this.readHandlerContext;
                this.readHandlerContext = null;
            }
        }
        if (readCallback != null) {
            final BiConsumer<InputChannel, Object> f = readCallback;
            final Object c = context;
            this.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    f.accept(VertxHttpExchange.this, c);
                }
            });
        }
    }

    public Executor getWorker() {
        return this.worker;
    }

    public UndertowOptionMap getUndertowOptions() {
        return UndertowOptionMap.EMPTY;
    }

    public void sendContinue() {
        this.request.response().writeContinue();
    }

    public void discardRequest() {
        if (!this.eof) {
            this.request.connection().close();
        }
    }

    public boolean isUpgradeSupported() {
        return true;
    }

    public SSLSessionInfo getSslSessionInfo() {
        SSLSession session = this.request.sslSession();
        if (session != null) {
            return new ConnectionSSLSessionInfo(session);
        }
        return null;
    }

    public boolean isIoOperationQueued() {
        return this.readHandler != null || this.writeQueued;
    }

    public void setMaxEntitySize(long maxEntitySize) {
    }

    public long getMaxEntitySize() {
        return 0L;
    }

    public void setUpgradeListener(final Consumer<Object> listener) {
        Http1xServerConnection connection = (Http1xServerConnection)this.request.connection();
        final ChannelHandlerContext context = connection.channelHandlerContext();
        this.request.response().endHandler((Handler)new Handler<Void>(){

            public void handle(Void event) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        VertxHttpExchange.this.terminateResponse();
                        context.pipeline().remove("httpDecoder");
                        context.pipeline().remove("httpEncoder");
                        context.pipeline().remove("websocketExtensionHandler");
                        context.pipeline().remove("handler");
                        listener.accept(context);
                    }
                };
                if (VertxHttpExchange.this.isInIoThread()) {
                    runnable.run();
                } else {
                    VertxHttpExchange.this.getIoThread().execute(runnable);
                }
            }
        });
    }
}

