/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.vertx;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.undertow.websockets.ConfiguredServerEndpoint;
import io.undertow.websockets.EndpointSessionHandler;
import io.undertow.websockets.ServerWebSocketContainer;
import io.undertow.websockets.UndertowSession;
import io.undertow.websockets.WebSocketDeploymentInfo;
import io.undertow.websockets.handshake.Handshake;
import io.undertow.websockets.handshake.HandshakeUtil;
import io.undertow.websockets.handshake.WebSocketHttpExchange;
import io.undertow.websockets.util.WebsocketPathMatcher;
import io.undertow.websockets.vertx.VertxWebSocketHttpExchange;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class VertxWebSocketHandler
implements Handler<RoutingContext> {
    protected final EndpointSessionHandler callback;
    protected final WebsocketPathMatcher<ServerWebSocketContainer.WebSocketHandshakeHolder> pathTemplateMatcher;
    protected final ServerWebSocketContainer container;
    protected final Executor executor;
    protected static final String SESSION_ATTRIBUTE = "io.undertow.websocket.current-connections";

    public VertxWebSocketHandler(ServerWebSocketContainer container, WebSocketDeploymentInfo info) {
        this.container = container;
        this.executor = (Executor)info.getExecutor().get();
        container.deploymentComplete();
        this.pathTemplateMatcher = new WebsocketPathMatcher();
        for (ConfiguredServerEndpoint endpoint : container.getConfiguredServerEndpoints()) {
            if (info == null || info.getServerExtensions().isEmpty()) {
                this.pathTemplateMatcher.add(endpoint.getPathTemplate(), (Object)container.handshakes(endpoint));
                continue;
            }
            this.pathTemplateMatcher.add(endpoint.getPathTemplate(), (Object)container.handshakes(endpoint, info.getServerExtensions()));
        }
        this.callback = new EndpointSessionHandler(container);
    }

    public void handle(RoutingContext event) {
        HttpServerRequest req = event.request();
        final HttpServerResponse resp = event.response();
        if (req.getHeader((CharSequence)HttpHeaderNames.UPGRADE) != null) {
            WebsocketPathMatcher.PathMatchResult matchResult;
            ChannelPipeline pipeline = ((ConnectionBase)event.request().connection()).channel().pipeline();
            ChannelHandler websocketChannelHandler = pipeline.get("webSocketExtensionHandler");
            if (websocketChannelHandler != null) {
                pipeline.remove(websocketChannelHandler);
            }
            final VertxWebSocketHttpExchange facade = this.createHttpExchange(event);
            String path = event.normalizedPath();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if ((matchResult = this.pathTemplateMatcher.match(path)) != null) {
                Handshake handshaker = null;
                for (Handshake method : ((ServerWebSocketContainer.WebSocketHandshakeHolder)matchResult.getValue()).handshakes) {
                    if (!method.matches((WebSocketHttpExchange)facade)) continue;
                    handshaker = method;
                    break;
                }
                if (handshaker != null) {
                    if (this.container.isClosed()) {
                        resp.setStatusCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).end();
                        return;
                    }
                    facade.putAttachment(HandshakeUtil.PATH_PARAMS, matchResult.getParameters());
                    final Handshake selected = handshaker;
                    handshaker.handshake((WebSocketHttpExchange)facade, (Consumer)new Consumer<ChannelHandlerContext>(){

                        @Override
                        public void accept(ChannelHandlerContext context) {
                            UndertowSession channel = VertxWebSocketHandler.this.callback.connected(context, selected.getConfig(), (WebSocketHttpExchange)facade, resp.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL));
                        }
                    });
                    return;
                }
            }
        }
        event.next();
    }

    protected VertxWebSocketHttpExchange createHttpExchange(RoutingContext event) {
        return new VertxWebSocketHttpExchange(this.executor, event);
    }
}

