/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.vertx;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.undertow.websockets.handshake.WebSocketHttpExchange;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class VertxWebSocketHttpExchange
implements WebSocketHttpExchange {
    private final Executor executor;
    private final HttpServerRequest request;
    private final HttpServerResponse response;
    private final RoutingContext exchange;
    final Map<String, Object> attributes = new HashMap<String, Object>();

    public VertxWebSocketHttpExchange(Executor executor, RoutingContext context) {
        this.executor = executor;
        this.request = context.request();
        this.response = context.response();
        this.exchange = context;
    }

    public <T> void putAttachment(String key, T value) {
        this.attributes.put(key, value);
    }

    public <T> T getAttachment(String key) {
        return (T)this.attributes.get(key);
    }

    public String getRequestHeader(CharSequence headerName) {
        return this.request.getHeader(headerName.toString());
    }

    public Map<String, List<String>> getRequestHeaders() {
        TreeMap<String, List> headers = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
        Set headerNames = this.request.headers().names();
        for (String header : headerNames) {
            List vals = this.request.headers().getAll(header);
            headers.put(header, vals);
        }
        return Collections.unmodifiableMap(headers);
    }

    public String getResponseHeader(CharSequence headerName) {
        return this.response.headers().get(headerName);
    }

    public Map<String, List<String>> getResponseHeaders() {
        HashMap headers = new HashMap();
        Set headerNames = this.response.headers().names();
        for (String header : headerNames) {
            headers.put(header, new ArrayList(this.response.headers().getAll(header)));
        }
        return Collections.unmodifiableMap(headers);
    }

    public void setResponseHeaders(Map<String, List<String>> headers) {
        this.response.headers().clear();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            this.response.headers().set(entry.getKey(), (Iterable)entry.getValue());
        }
    }

    public void setResponseHeader(CharSequence headerName, String headerValue) {
        this.response.headers().set(headerName.toString(), headerValue);
    }

    public void upgradeChannel(final Consumer<Object> listener) {
        this.response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)"upgrade");
        Http1xServerConnection connection = (Http1xServerConnection)this.request.connection();
        ChannelHandlerContext context = connection.channelHandlerContext();
        ChannelHandler websocketChannelHandler = context.pipeline().get("webSocketExtensionHandler");
        if (websocketChannelHandler != null) {
            context.pipeline().remove(websocketChannelHandler);
        }
        this.response.setStatusCode(101).end((Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> event) {
                Http1xServerConnection connection = (Http1xServerConnection)VertxWebSocketHttpExchange.this.request.connection();
                ChannelHandlerContext context = connection.channelHandlerContext();
                context.pipeline().remove("httpDecoder");
                context.pipeline().remove("httpEncoder");
                context.pipeline().remove("handler");
                listener.accept(context);
            }
        });
    }

    public void endExchange() {
    }

    public void close() {
        this.response.end();
    }

    public String getRequestScheme() {
        return this.request.scheme();
    }

    public String getRequestURI() {
        return this.request.uri() + (this.request.query() == null ? "" : "?" + this.request.query());
    }

    public String getQueryString() {
        return this.request.query();
    }

    public Object getSession() {
        return null;
    }

    public Map<String, List<String>> getRequestParameters() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        for (Map.Entry param : this.request.params()) {
            params.put((String)param.getKey(), new ArrayList(this.request.params().getAll((String)param.getKey())));
        }
        return params;
    }

    public Principal getUserPrincipal() {
        final User user = this.exchange.user();
        if (user != null) {
            return new Principal(){

                @Override
                public String getName() {
                    return user.principal().getString("username");
                }
            };
        }
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Executor getExecutor() {
        return this.executor;
    }
}

