/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.undertow.httpcore.UndertowOptionMap;
import io.undertow.websockets.jsr.WebSocketClientNegotiation;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

class WebsocketConnectionBuilder {
    private final URI uri;
    private final EventLoopGroup eventLoopGroup;
    private SSLContext ssl;
    private UndertowOptionMap optionMap = UndertowOptionMap.EMPTY;
    private InetSocketAddress bindAddress;
    private WebSocketVersion version = WebSocketVersion.V13;
    private WebSocketClientNegotiation clientNegotiation;
    private URI proxyUri;
    private SslContext proxySsl;

    public WebsocketConnectionBuilder(URI uri, EventLoopGroup eventLoopGroup) {
        this.uri = uri;
        this.eventLoopGroup = eventLoopGroup;
    }

    public URI getUri() {
        return this.uri;
    }

    public SSLContext getSsl() {
        return this.ssl;
    }

    public WebsocketConnectionBuilder setSsl(SSLContext ssl) {
        this.ssl = ssl;
        return this;
    }

    public UndertowOptionMap getOptionMap() {
        return this.optionMap;
    }

    public WebsocketConnectionBuilder setOptionMap(UndertowOptionMap optionMap) {
        this.optionMap = optionMap;
        return this;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public WebsocketConnectionBuilder setBindAddress(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public WebSocketVersion getVersion() {
        return this.version;
    }

    public WebsocketConnectionBuilder setVersion(WebSocketVersion version) {
        this.version = version;
        return this;
    }

    public WebSocketClientNegotiation getClientNegotiation() {
        return this.clientNegotiation;
    }

    public WebsocketConnectionBuilder setClientNegotiation(WebSocketClientNegotiation clientNegotiation) {
        this.clientNegotiation = clientNegotiation;
        return this;
    }

    public URI getProxyUri() {
        return this.proxyUri;
    }

    public WebsocketConnectionBuilder setProxyUri(URI proxyUri) {
        this.proxyUri = proxyUri;
        return this;
    }

    public SslContext getProxySsl() {
        return this.proxySsl;
    }

    public WebsocketConnectionBuilder setProxySsl(SslContext proxySsl) {
        this.proxySsl = proxySsl;
        return this;
    }

    public ChannelFuture connect() {
        Bootstrap b = new Bootstrap();
        String protocol = this.uri.getScheme();
        final WebSocketClientHandler handler = new WebSocketClientHandler((WebSocketClientHandshaker)new WebSocketClientHandshaker13(this.uri, WebSocketVersion.V13, null, false, HttpHeaders.EMPTY_HEADERS, 1280000){

            protected FullHttpRequest newHandshakeRequest() {
                FullHttpRequest request = super.newHandshakeRequest();
                if (WebsocketConnectionBuilder.this.clientNegotiation.getSupportedSubProtocols() != null) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < WebsocketConnectionBuilder.this.clientNegotiation.getSupportedSubProtocols().size(); ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(WebsocketConnectionBuilder.this.clientNegotiation.getSupportedSubProtocols().get(i));
                    }
                    request.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)sb.toString());
                }
                WebsocketConnectionBuilder.this.clientNegotiation.beforeRequest(request.headers());
                return request;
            }

            protected void verify(FullHttpResponse response) {
                super.verify(response);
                WebsocketConnectionBuilder.this.clientNegotiation.afterRequest(response.headers());
            }
        });
        ((Bootstrap)((Bootstrap)b.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (WebsocketConnectionBuilder.this.ssl != null) {
                    SSLEngine sslEngine = WebsocketConnectionBuilder.this.ssl.createSSLEngine();
                    sslEngine.setUseClientMode(true);
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                }
                pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("ws-handler", (ChannelHandler)handler);
            }
        });
        ChannelFuture future = null;
        try {
            future = b.connect(this.uri.getHost(), this.uri.getPort()).sync();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ChannelPromise promise = future.channel().newPromise();
        handler.setExternalPromise(promise);
        return promise;
    }

    private class WebSocketClientHandler
    extends SimpleChannelInboundHandler<Object> {
        private final WebSocketClientHandshaker handshaker;
        private volatile ChannelPromise handshakeFuture;
        private ChannelPromise promise;

        public WebSocketClientHandler(WebSocketClientHandshaker handshaker) {
            this.handshaker = handshaker;
        }

        public ChannelFuture handshakeFuture() {
            return this.handshakeFuture;
        }

        public synchronized void handlerAdded(ChannelHandlerContext ctx) {
            if (this.handshakeFuture != null) {
                this.handshakeFuture = ctx.newPromise();
            }
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.handshaker.handshake(ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.handshakeFuture.setFailure((Throwable)new ClosedChannelException());
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                try {
                    this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                    this.handshakeFuture.setSuccess();
                    ch.pipeline().remove((ChannelHandler)this);
                }
                catch (WebSocketHandshakeException e) {
                    this.handshakeFuture.setFailure((Throwable)e);
                }
                return;
            }
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (!this.handshakeFuture.isDone()) {
                this.handshakeFuture.setFailure(cause);
            }
            ctx.close();
        }

        public synchronized void setExternalPromise(final ChannelPromise promise) {
            if (this.handshakeFuture == null) {
                this.handshakeFuture = promise;
            } else {
                this.handshakeFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                    public void operationComplete(Future<? super Void> future) throws Exception {
                        if (future.isSuccess()) {
                            promise.setSuccess();
                        } else {
                            promise.setFailure(future.cause());
                        }
                    }
                });
            }
        }
    }
}

