/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.DefaultContainerConfigurator;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpoint;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.jsr.handshake.WebSocketHttpExchange;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;

public final class EndpointSessionHandler {
    private final ServerWebSocketContainer container;

    public EndpointSessionHandler(ServerWebSocketContainer container) {
        this.container = container;
    }

    ServerWebSocketContainer getContainer() {
        return this.container;
    }

    public UndertowSession connected(ChannelHandlerContext context, ConfiguredServerEndpoint config, WebSocketHttpExchange exchange, String subprotocol) {
        try {
            Object endpointInstance;
            if (this.container.isClosed()) {
                context.write((Object)new CloseWebSocketFrame());
                return null;
            }
            InstanceFactory<?> endpointFactory = config.getEndpointFactory();
            ServerEndpointConfig.Configurator configurator = config.getEndpointConfiguration().getConfigurator();
            DefaultContainerConfigurator.setCurrentInstanceFactory(endpointFactory);
            final Object instanceFromConfigurator = configurator.getEndpointInstance(config.getEndpointConfiguration().getEndpointClass());
            final InstanceHandle<Object> factoryInstance = DefaultContainerConfigurator.clearCurrentInstanceFactory();
            InstanceHandle<Object> instance = factoryInstance == null ? new ImmediateInstanceHandle(instanceFromConfigurator) : (factoryInstance.getInstance() == instanceFromConfigurator ? factoryInstance : new InstanceHandle<Object>(){

                public Object getInstance() {
                    return instanceFromConfigurator;
                }

                public void release() {
                    factoryInstance.release();
                }
            });
            ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            Principal principal = exchange.getAttachment(HandshakeUtil.PRINCIPAL);
            if (principal == null) {
                principal = src.getServletRequest() instanceof HttpServletRequest ? ((HttpServletRequest)src.getServletRequest()).getUserPrincipal() : src.getOriginalRequest().getUserPrincipal();
            }
            if (config.getAnnotatedEndpointFactory() != null) {
                final AnnotatedEndpoint annotated = config.getAnnotatedEndpointFactory().createInstance(instance);
                endpointInstance = new InstanceHandle<Endpoint>((InstanceHandle)instance){
                    final /* synthetic */ InstanceHandle val$instance;
                    {
                        this.val$instance = instanceHandle;
                    }

                    public Endpoint getInstance() {
                        return annotated;
                    }

                    public void release() {
                        this.val$instance.release();
                    }
                };
            } else {
                endpointInstance = instance;
            }
            UndertowSession session = new UndertowSession(context.channel(), URI.create(exchange.getRequestURI()), exchange.getAttachment(HandshakeUtil.PATH_PARAMS), exchange.getRequestParameters(), this, principal, (InstanceHandle<Endpoint>)endpointInstance, (EndpointConfig)config.getEndpointConfiguration(), exchange.getQueryString(), config.getEncodingFactory().createEncoding((EndpointConfig)config.getEndpointConfiguration()), config, subprotocol, Collections.emptyList(), null, exchange.getExecutor());
            config.addOpenSession(session);
            session.setMaxBinaryMessageBufferSize(this.getContainer().getDefaultMaxBinaryMessageBufferSize());
            session.setMaxTextMessageBufferSize(this.getContainer().getDefaultMaxTextMessageBufferSize());
            session.setMaxIdleTimeout(this.getContainer().getDefaultMaxSessionIdleTimeout());
            session.getAsyncRemote().setSendTimeout(this.getContainer().getDefaultAsyncSendTimeout());
            try {
                ((Endpoint)endpointInstance.getInstance()).onOpen((Session)session, (EndpointConfig)config.getEndpointConfiguration());
            }
            catch (Exception e) {
                ((Endpoint)endpointInstance.getInstance()).onError((Session)session, (Throwable)e);
                session.close();
            }
            return session;
        }
        catch (Exception e) {
            JsrWebSocketLogger.REQUEST_LOGGER.endpointCreationFailed(e);
            context.close();
            return null;
        }
    }
}

