/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.FrameHandler;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.SessionContainer;
import io.undertow.websockets.jsr.WebSocketSessionRemoteEndpoint;
import io.undertow.websockets.jsr.WebsocketConnectionBuilder;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;

public final class UndertowSession
implements Session {
    private final String sessionId;
    private Channel channel;
    private FrameHandler frameHandler;
    private final ServerWebSocketContainer container;
    private final Principal user;
    private final WebSocketSessionRemoteEndpoint remote;
    private final Map<String, Object> attrs;
    private final Map<String, List<String>> requestParameterMap;
    private final URI requestUri;
    private final String queryString;
    private final Map<String, String> pathParameters;
    private final InstanceHandle<Endpoint> endpoint;
    private final Encoding encoding;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final SessionContainer openSessions;
    private final String subProtocol;
    private final List<Extension> extensions;
    private final EndpointConfig config;
    private final Executor executor;
    private volatile int maximumBinaryBufferSize = 0;
    private volatile int maximumTextBufferSize = 0;
    private volatile boolean localClose;
    private int disconnectCount = 0;
    private int failedCount = 0;
    private ConfiguredServerEndpoint configuredServerEndpoint;
    private final WebsocketConnectionBuilder clientConnectionBuilder;

    public UndertowSession(Channel channel, URI requestUri, Map<String, String> pathParameters, Map<String, List<String>> requestParameterMap, EndpointSessionHandler handler, Principal user, InstanceHandle<Endpoint> endpoint, EndpointConfig config, String queryString, Encoding encoding, SessionContainer openSessions, String subProtocol, List<Extension> extensions, WebsocketConnectionBuilder clientConnectionBuilder, Executor executor) {
        this.clientConnectionBuilder = clientConnectionBuilder;
        assert (openSessions != null);
        this.channel = channel;
        this.queryString = queryString;
        this.encoding = encoding;
        this.openSessions = openSessions;
        this.container = handler.getContainer();
        this.user = user;
        this.requestUri = requestUri;
        this.requestParameterMap = Collections.unmodifiableMap(requestParameterMap);
        this.pathParameters = Collections.unmodifiableMap(pathParameters);
        this.config = config;
        this.remote = new WebSocketSessionRemoteEndpoint(this, encoding);
        this.endpoint = endpoint;
        this.sessionId = new SecureRandomSessionIdGenerator().createSessionId();
        this.attrs = Collections.synchronizedMap(new HashMap(config.getUserProperties()));
        this.extensions = extensions;
        this.subProtocol = subProtocol;
        this.executor = executor;
        this.setupWebSocketChannel(channel);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ServerWebSocketContainer getContainer() {
        return this.container;
    }

    public synchronized void addMessageHandler(MessageHandler messageHandler) throws IllegalStateException {
        this.frameHandler.addHandler(messageHandler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) {
        this.frameHandler.addHandler(clazz, (MessageHandler)handler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) {
        this.frameHandler.addHandler(clazz, (MessageHandler)handler);
    }

    public synchronized Set<MessageHandler> getMessageHandlers() {
        return this.frameHandler.getHandlers();
    }

    public synchronized void removeMessageHandler(MessageHandler messageHandler) {
        this.frameHandler.removeHandler(messageHandler);
    }

    public String getProtocolVersion() {
        return "13";
    }

    public String getNegotiatedSubprotocol() {
        return this.subProtocol == null ? "" : this.subProtocol;
    }

    public boolean isSecure() {
        return this.channel.pipeline().get(SslHandler.class) != null;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public long getMaxIdleTimeout() {
        return -1L;
    }

    public void setMaxIdleTimeout(long milliseconds) {
    }

    public String getId() {
        return this.sessionId;
    }

    public void close() throws IOException {
        this.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, null));
    }

    public void close(CloseReason closeReason) throws IOException {
        this.localClose = true;
        this.closeInternal(closeReason);
    }

    public void closeInternal() throws IOException {
        this.closeInternal(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, null));
    }

    public void closeInternal(final CloseReason closeReason) throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.channel.writeAndFlush((Object)new CloseWebSocketFrame(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase())).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                    UndertowSession.this.channel.close();
                }
            });
            this.getContainer().invokeEndpointMethod(this.getExecutor(), new Runnable(){

                @Override
                public void run() {
                    ((Endpoint)UndertowSession.this.endpoint.getInstance()).onClose((Session)UndertowSession.this, closeReason);
                }
            });
        }
    }

    private void handleReconnect(long reconnect) {
        JsrWebSocketLogger.REQUEST_LOGGER.debugf("Attempting reconnect in %s ms for session %s", reconnect, this);
        this.channel.eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
                CompletableFuture<Void> channelFuture = UndertowSession.this.clientConnectionBuilder.connect(new Function<Channel, Void>(){

                    @Override
                    public Void apply(Channel channel) {
                        UndertowSession.this.closed.set(false);
                        UndertowSession.this.setupWebSocketChannel(channel);
                        UndertowSession.this.localClose = false;
                        ((Endpoint)UndertowSession.this.endpoint.getInstance()).onOpen((Session)UndertowSession.this, UndertowSession.this.config);
                        return null;
                    }
                });
                channelFuture.exceptionally((Function)new Function<Throwable, Void>(){

                    @Override
                    public Void apply(Throwable throwable) {
                        long timeout = UndertowSession.this.container.getWebSocketReconnectHandler().reconnectFailed(new IOException(throwable), UndertowSession.this.getRequestURI(), UndertowSession.this, ++UndertowSession.this.failedCount);
                        if (timeout >= 0L) {
                            UndertowSession.this.handleReconnect(timeout);
                        }
                        return null;
                    }
                });
            }
        }, reconnect, TimeUnit.MILLISECONDS);
    }

    public void forceClose() {
        try {
            this.channel.close().sync();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getRequestURI() {
        return this.requestUri;
    }

    public Map<String, List<String>> getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public Map<String, Object> getUserProperties() {
        return this.attrs;
    }

    public Principal getUserPrincipal() {
        return this.user;
    }

    public void setMaxBinaryMessageBufferSize(int i) {
        this.maximumBinaryBufferSize = i;
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.maximumBinaryBufferSize;
    }

    public void setMaxTextMessageBufferSize(int i) {
        this.maximumTextBufferSize = i;
    }

    public int getMaxTextMessageBufferSize() {
        return this.maximumTextBufferSize;
    }

    public RemoteEndpoint.Async getAsyncRemote() {
        return this.remote.getAsync();
    }

    public RemoteEndpoint.Basic getBasicRemote() {
        return this.remote.getBasic();
    }

    public Set<Session> getOpenSessions() {
        return new HashSet<Session>(this.openSessions.getOpenSessions());
    }

    public List<Extension> getNegotiatedExtensions() {
        return this.extensions;
    }

    public ConfiguredServerEndpoint getConfiguredServerEndpoint() {
        return this.configuredServerEndpoint;
    }

    public UndertowSession setConfiguredServerEndpoint(ConfiguredServerEndpoint configuredServerEndpoint) {
        this.configuredServerEndpoint = configuredServerEndpoint;
        return this;
    }

    void close0() {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    UndertowSession.this.endpoint.release();
                }
                finally {
                    try {
                        UndertowSession.this.encoding.close();
                    }
                    finally {
                        UndertowSession.this.openSessions.removeOpenSession(UndertowSession.this);
                    }
                }
            }
        });
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    private void setupWebSocketChannel(Channel webSocketChannel) {
        this.frameHandler = new FrameHandler(this, (Endpoint)this.endpoint.getInstance());
        webSocketChannel.pipeline().addLast(new ChannelHandler[]{this.frameHandler});
    }

    public Executor getExecutor() {
        return this.executor;
    }

    boolean isSessionClosed() {
        return this.closed.get();
    }
}

