/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.netty.channel.EventLoopGroup;
import io.undertow.websockets.jsr.WebsocketClientSslProvider;
import java.net.URI;
import javax.net.ssl.SSLContext;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Endpoint;

public class DefaultWebSocketClientSslProvider
implements WebsocketClientSslProvider {
    public static final String SSL_CONTEXT = "io.undertow.websocket.SSL_CONTEXT";
    private static final ThreadLocal<SSLContext> LOCAL_SSL_CONTEXT = new ThreadLocal();

    @Override
    public SSLContext getSsl(EventLoopGroup worker, Class<?> annotatedEndpoint, URI uri) {
        return this.getThreadLocalSsl(worker);
    }

    @Override
    public SSLContext getSsl(EventLoopGroup worker, Object annotatedEndpointInstance, URI uri) {
        return this.getThreadLocalSsl(worker);
    }

    @Override
    public SSLContext getSsl(EventLoopGroup worker, Endpoint endpoint, ClientEndpointConfig cec, URI uri) {
        SSLContext ssl = this.getThreadLocalSsl(worker);
        if (ssl != null) {
            return ssl;
        }
        SSLContext sslContext = (SSLContext)cec.getUserProperties().get(SSL_CONTEXT);
        if (sslContext != null) {
            return sslContext;
        }
        return null;
    }

    public static void setSslContext(SSLContext context) {
        LOCAL_SSL_CONTEXT.set(context);
    }

    private SSLContext getThreadLocalSsl(EventLoopGroup worker) {
        return LOCAL_SSL_CONTEXT.get();
    }
}

