/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit5.virtual.internal;

import io.quarkus.test.junit5.virtual.internal.EventStreamFacade;
import io.quarkus.test.junit5.virtual.internal.InternalEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jfr.consumer.RecordedEvent;

public class Collector
implements Consumer<RecordedEvent> {
    public static final String CARRIER_PINNED_EVENT_NAME = "jdk.VirtualThreadPinned";
    private static final Logger LOGGER = Logger.getLogger(Collector.class.getName());
    private final List<Function<RecordedEvent, Boolean>> observers = new CopyOnWriteArrayList<Function<RecordedEvent, Boolean>>();
    private final List<RecordedEvent> events = new CopyOnWriteArrayList<RecordedEvent>();
    private final EventStreamFacade facade;
    volatile State state = State.INIT;

    public Collector() {
        if (EventStreamFacade.available) {
            this.facade = new EventStreamFacade();
            this.facade.enable(CARRIER_PINNED_EVENT_NAME).withStackTrace();
            this.facade.enable("io.quarkus.test.junit5.virtual.internal.InternalEvents.ShutdownEvent").withoutStackTrace();
            this.facade.enable("io.quarkus.test.junit5.virtual.internal.InternalEvents.CapturingStartedEvent").withoutStackTrace();
            this.facade.enable("io.quarkus.test.junit5.virtual.internal.InternalEvents.CapturingStoppedEvent").withoutStackTrace();
            this.facade.enable("io.quarkus.test.junit5.virtual.internal.InternalEvents.InitializationEvent").withoutStackTrace();
            this.facade.setOrdered(true);
            this.facade.setMaxSize(100);
            this.facade.onEvent(this);
        } else {
            this.facade = null;
        }
    }

    public void init() {
        if (this.facade != null) {
            long begin = System.nanoTime();
            CountDownLatch latch = new CountDownLatch(1);
            this.observers.add(re -> {
                if (re.getEventType().getName().equals("io.quarkus.test.junit5.virtual.internal.InternalEvents.InitializationEvent")) {
                    latch.countDown();
                    return true;
                }
                return false;
            });
            this.facade.startAsync();
            new InternalEvents.InitializationEvent().commit();
            try {
                if (!latch.await(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Unable to start JFR collection, RecordingStartedEvent event not received after 10s");
                }
                long end = System.nanoTime();
                this.state = State.STARTED;
                LOGGER.log(Level.FINE, "Event collection started in {0}s", (end - begin) / 1000000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public void start() {
        if (this.facade != null) {
            CountDownLatch latch = new CountDownLatch(1);
            String id = UUID.randomUUID().toString();
            long begin = System.nanoTime();
            this.observers.add(re -> {
                if (re.getEventType().getName().equals("io.quarkus.test.junit5.virtual.internal.InternalEvents.CapturingStartedEvent") && id.equals(re.getString("id"))) {
                    this.events.clear();
                    this.state = State.COLLECTING;
                    latch.countDown();
                    return true;
                }
                return false;
            });
            new InternalEvents.CapturingStartedEvent(id).commit();
            try {
                if (!latch.await(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Unable to start JFR collection, START_EVENT event not received after 10s");
                }
                long end = System.nanoTime();
                LOGGER.log(Level.FINE, "Event capturing started in {0}s", (end - begin) / 1000000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public List<RecordedEvent> stop() {
        if (this.facade != null) {
            CountDownLatch latch = new CountDownLatch(1);
            String id = UUID.randomUUID().toString();
            long begin = System.nanoTime();
            this.observers.add(re -> {
                if (re.getEventType().getName().equals("io.quarkus.test.junit5.virtual.internal.InternalEvents.CapturingStoppedEvent")) {
                    this.state = State.STARTED;
                    latch.countDown();
                    return true;
                }
                return false;
            });
            new InternalEvents.CapturingStoppedEvent(id).commit();
            try {
                if (!latch.await(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Unable to start JFR collection, STOP_EVENT event not received after 10s");
                }
                long end = System.nanoTime();
                LOGGER.log(Level.FINE, "Event collection stopped in {0}s", (end - begin) / 1000000L);
                return new ArrayList<RecordedEvent>(this.events);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        return Collections.emptyList();
    }

    public void shutdown() {
        if (this.facade != null) {
            CountDownLatch latch = new CountDownLatch(1);
            long begin = System.nanoTime();
            this.observers.add(re -> {
                if (re.getEventType().getName().equals("io.quarkus.test.junit5.virtual.internal.InternalEvents.ShutdownEvent")) {
                    latch.countDown();
                    return true;
                }
                return false;
            });
            InternalEvents.ShutdownEvent event = new InternalEvents.ShutdownEvent();
            event.commit();
            try {
                if (!latch.await(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Unable to stop JFR collection, RecordingStoppedEvent event not received at 10s");
                }
                this.state = State.INIT;
                long end = System.nanoTime();
                LOGGER.log(Level.FINE, "Event collector shutdown in {0}s", (end - begin) / 1000000L);
                this.facade.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void accept(RecordedEvent re) {
        if (this.state == State.COLLECTING) {
            this.events.add(re);
        }
        ArrayList toBeRemoved = new ArrayList();
        this.observers.forEach(c -> {
            if (((Boolean)c.apply(re)).booleanValue()) {
                toBeRemoved.add(c);
            }
        });
        this.observers.removeAll(toBeRemoved);
    }

    public List<RecordedEvent> getEvents() {
        return new ArrayList<RecordedEvent>(this.events);
    }

    static enum State {
        INIT,
        STARTED,
        COLLECTING;

    }
}

