/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.deployment.util.DeploymentUtil;
import io.quarkus.maven.BuildMojo;
import io.quarkus.maven.dependency.ArtifactDependency;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.runtime.LaunchMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public class AbstractDeploymentMojo
extends BuildMojo {
    Deployer deployer = Deployer.kubernetes;
    @Parameter(property="quarkus.deployment.dry-run")
    boolean dryRun;
    @Parameter(property="quarkus.container-image.build", defaultValue="false")
    boolean imageBuild;
    @Parameter(property="quarkus.container-image.builder")
    String imageBuilder;

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"Deployment configuration:");
            this.systemProperties.entrySet().stream().filter(e -> ((String)e.getKey()).contains("quarkus.deployment")).forEach(e -> this.getLog().info((CharSequence)(" - " + (String)e.getKey() + ": " + (String)e.getValue())));
        } else {
            super.doExecute();
        }
    }

    public Optional<String> getImageBuilder() {
        return Optional.ofNullable(this.imageBuilder);
    }

    public Deployer getDeployer() {
        return DeploymentUtil.getEnabledDeployer().map(d -> Deployer.valueOf(d)).orElse(Deployer.kubernetes);
    }

    @Override
    protected List<Dependency> forcedDependencies(LaunchMode mode) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Deployer deployer = this.getDeployer();
        String containerImageBuilderArtifactId = AbstractDeploymentMojo.containerImageBuilderArtifactId(this.imageBuilder);
        this.getDeploymentExtension(deployer).ifPresent(d -> dependencies.add((Dependency)d));
        this.getContainerImageExtension(containerImageBuilderArtifactId).or(() -> this.getFirstContainerImageExtension(deployer)).ifPresent(d -> dependencies.add((Dependency)d));
        return dependencies;
    }

    protected Optional<ArtifactDependency> getDeploymentExtension(Deployer deployer) {
        return this.mavenProject().getDependencyManagement().getDependencies().stream().filter(d -> "io.quarkus".equals(d.getGroupId()) && deployer.getExtension().equals(d.getArtifactId())).map(d -> new ArtifactDependency(d.getGroupId(), d.getArtifactId(), null, "jar", d.getVersion())).findFirst();
    }

    protected Optional<ArtifactDependency> getFirstContainerImageExtension(Deployer deployer) {
        return this.getContainerImageExtension(Arrays.stream(deployer.requiresOneOf).findFirst());
    }

    protected Optional<ArtifactDependency> getContainerImageExtension(String artifactId) {
        return this.getContainerImageExtension(Optional.ofNullable(artifactId));
    }

    protected Optional<ArtifactDependency> getContainerImageExtension(Optional<String> artifactId) {
        return artifactId.flatMap(a -> this.mavenProject().getDependencyManagement().getDependencies().stream().filter(d -> "io.quarkus".equals(d.getGroupId()) && a.equals(d.getArtifactId())).map(d -> new ArtifactDependency(d.getGroupId(), d.getArtifactId(), null, "jar", d.getVersion())).findFirst());
    }

    protected static String containerImageBuilderArtifactId(String builder) {
        if (builder == null || builder.isEmpty()) {
            return null;
        }
        return "quarkus-container-image-" + builder;
    }

    public static enum Deployer {
        kubernetes("quarkus-kubernetes", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        minikube("quarkus-minikube", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        kind("quarkus-kind", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        knative("quarkus-kubernetes", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        openshift("quarkus-openshift", new String[0]);

        private final String extension;
        private final String[] requiresOneOf;

        private Deployer(String extension, String ... requiresOneOf) {
            this.extension = extension;
            this.requiresOneOf = requiresOneOf;
        }

        public String getExtension() {
            return this.extension;
        }

        public String[] getRequiresOneOf() {
            return this.requiresOneOf;
        }
    }
}

