/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.maven.components.QuarkusWorkspaceProvider;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="go-offline", threadSafe=true)
public class GoOfflineMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Component
    RepositorySystem repoSystem;
    @Component
    RemoteRepositoryManager remoteRepositoryManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repos;
    @Component
    QuarkusWorkspaceProvider workspaceProvider;
    @Parameter(property="mode", required=false, defaultValue="test")
    String mode;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DependencyNode root;
        Set<Object> excludedScopes;
        DefaultArtifact pom = new DefaultArtifact(this.project.getArtifact().getGroupId(), this.project.getArtifactId(), "pom", this.project.getVersion());
        MavenArtifactResolver resolver = this.getResolver();
        BootstrapAppModelResolver appModelResolver = new BootstrapAppModelResolver(resolver);
        if (this.mode.equalsIgnoreCase("test")) {
            appModelResolver.setTest(true);
            excludedScopes = Set.of();
        } else if (this.mode.equalsIgnoreCase("dev") || this.mode.equalsIgnoreCase("development")) {
            appModelResolver.setDevMode(true);
            excludedScopes = Set.of("test");
        } else if (this.mode.equalsIgnoreCase("prod") || this.mode.isEmpty()) {
            excludedScopes = Set.of("test", "provided");
        } else {
            throw new IllegalArgumentException("Unrecognized mode '" + this.mode + "', supported values are test, dev, development, prod");
        }
        try {
            root = resolver.getSystem().collectDependencies(resolver.getSession(), resolver.newCollectManagedRequest((Artifact)pom, List.of(), List.of(), List.of(), List.of(), excludedScopes)).getRoot();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to collect dependencies of " + (Artifact)pom, e);
        }
        LocalWorkspace workspace = resolver.getMavenContext().getWorkspace();
        ArrayList<Path> createdDirs = new ArrayList<Path>(workspace.getProjects().size());
        try {
            GoOfflineMojo.ensureResolvableModule(root, workspace, createdDirs);
            appModelResolver.resolveModel(ArtifactCoords.of((String)pom.getGroupId(), (String)pom.getArtifactId(), (String)pom.getClassifier(), (String)pom.getExtension(), (String)pom.getVersion()));
        }
        catch (AppModelResolverException e) {
            throw new MojoExecutionException("Failed to resolve Quarkus application model for " + this.project.getArtifact(), (Exception)((Object)e));
        }
        finally {
            for (Path d : createdDirs) {
                IoUtils.recursiveDelete((Path)d);
            }
        }
    }

    private MavenArtifactResolver getResolver() throws MojoExecutionException {
        return this.workspaceProvider.createArtifactResolver(BootstrapMavenContext.config().setUserSettings(this.session.getRequest().getUserSettingsFile()).setCurrentProject(this.project.getBasedir().toString()).setRemoteRepositoryManager(this.remoteRepositoryManager).setRemoteRepositories(this.repos).setPreferPomsFromWorkspace(true));
    }

    private static void ensureResolvableModule(DependencyNode node, LocalWorkspace workspace, List<Path> createdDirs) throws MojoExecutionException {
        Path classesDir;
        LocalProject module;
        Artifact artifact = node.getArtifact();
        if (artifact != null && (module = workspace.getProject(artifact.getGroupId(), artifact.getArtifactId())) != null && !module.getRawModel().getPackaging().equals("pom") && !Files.exists(classesDir = artifact.getClassifier().equals("tests") ? module.getTestClassesDir() : module.getClassesDir(), new LinkOption[0])) {
            Path topDirToCreate = classesDir;
            while (!Files.exists(topDirToCreate.getParent(), new LinkOption[0])) {
                topDirToCreate = topDirToCreate.getParent();
            }
            try {
                Files.createDirectories(classesDir, new FileAttribute[0]);
                createdDirs.add(topDirToCreate);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create " + classesDir, (Exception)e);
            }
        }
        for (DependencyNode c : node.getChildren()) {
            GoOfflineMojo.ensureResolvableModule(c, workspace, createdDirs);
        }
    }
}

