/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qe.reporter.flakyrun.commentator;

import io.quarkus.qe.reporter.flakyrun.FlakyReporterUtils;
import io.quarkus.qe.reporter.flakyrun.reporter.FlakyRunReporter;
import io.quarkus.qe.reporter.flakyrun.reporter.FlakyTest;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class CreateGhPrComment {
    public static final String TEST_BASE_DIR = CreateGhPrComment.class.getSimpleName() + ".test-base-dir";
    public static final String OVERVIEW_FILE_KEY = "overview-file";
    public static final String FLAKY_REPORTS_FILE_PREFIX_KEY = "flaky-reports-file-prefix";
    public static final String GH_REPO_ENV_VAR_NAME = "GH_REPO";
    public static final String WORKFLOW_ID_ENV_VAR_NAME = "WORKFLOW_ID";
    private static final Path CURRENT_DIR = Path.of(".", new String[0]);
    private final String comment;
    private final Path baseDir = System.getProperty(TEST_BASE_DIR) != null ? Path.of(System.getProperty(TEST_BASE_DIR), new String[0]) : CURRENT_DIR;

    public CreateGhPrComment(String[] args) {
        this(args, CreateGhPrComment.getRequiredEnv(GH_REPO_ENV_VAR_NAME), CreateGhPrComment.getRequiredEnv(WORKFLOW_ID_ENV_VAR_NAME));
    }

    public CreateGhPrComment(String[] args, String ghRepo, String workflowId) {
        Set<String> jobs = this.getJobs(args);
        String failureOverview = CreateGhPrComment.getFailureOverview(jobs);
        String flakyTestsReports = this.getFlakyTestReports(args, jobs);
        String prNumber = this.getPrNumber();
        this.comment = "Following jobs contain at least one flaky test:\n%s\n\nRun summary: https://github.com/%s/actions/runs/%s?pr=%s\n\n**Flaky tests:**\n\n---\n%s\n".formatted(failureOverview, ghRepo, workflowId, prNumber, flakyTestsReports);
    }

    private Set<String> getJobs(String[] args) {
        Path overviewPath = this.baseDir.resolve(FlakyReporterUtils.getRequiredArgument(OVERVIEW_FILE_KEY, args));
        if (Files.exists(overviewPath, new LinkOption[0])) {
            String overview = FlakyReporterUtils.readFile(overviewPath);
            return Arrays.stream(overview.split(",")).map(String::trim).map(job -> {
                if (job.startsWith("'")) {
                    return job.substring(1);
                }
                return job;
            }).map(job -> {
                if (job.endsWith("'")) {
                    return job.substring(0, job.length() - 1);
                }
                return job;
            }).collect(Collectors.toSet());
        }
        throw new IllegalStateException("File '" + overviewPath + "' not found");
    }

    private String getPrNumber() {
        String prNumber = FlakyReporterUtils.readFile(this.baseDir.resolve("pr-number"));
        if (prNumber == null || prNumber.isBlank()) {
            throw new IllegalStateException("File 'pr-number' not found, cannot proceed without the PR number");
        }
        return prNumber.trim();
    }

    public String getComment() {
        return this.comment;
    }

    public void printToStdOut() {
        System.out.println(this.comment);
    }

    private String getFlakyTestReports(String[] args, Set<String> jobs) {
        String reportFilePrefix = FlakyReporterUtils.getRequiredArgument(FLAKY_REPORTS_FILE_PREFIX_KEY, args);
        File[] listOfDirFiles = this.baseDir.toFile().listFiles();
        if (listOfDirFiles == null || listOfDirFiles.length == 0) {
            return "No flaky test reports found";
        }
        HashMap testNameToDetail = new HashMap();
        StringBuilder result = new StringBuilder();
        for (File file : listOfDirFiles) {
            if (!file.getName().startsWith(reportFilePrefix)) continue;
            FlakyRunReporter.parseFlakyTestsReport(file.toPath()).forEach(flakyTest -> testNameToDetail.computeIfAbsent(flakyTest.fullTestName(), tn -> new FlakyTestWithFiles((Set<String>)new HashSet<String>(), (FlakyTest)flakyTest)).fileNames().add(file.getName()));
        }
        testNameToDetail.values().forEach(flakyTest -> result.append("**`%s`**\n - Failure message: `%s`\n - Failed in jobs:\n%s\n<details>\n<summary>Failure stacktrace</summary>\n\n```\n%s\n```\n\n</details>\n\n---\n".formatted(flakyTest.detail.fullTestName(), flakyTest.detail.failureMessage(), CreateGhPrComment.toFailedInJobs(flakyTest.fileNames, jobs), flakyTest.detail.failureStackTrace())));
        return result.toString();
    }

    private static String toFailedInJobs(Set<String> fileNames, Set<String> jobs) {
        return fileNames.stream().map(fileName -> CreateGhPrComment.toJobName(fileName, jobs)).map(jobName -> "   - " + jobName).collect(Collectors.joining(System.lineSeparator()));
    }

    private static String toJobName(String fileName, Set<String> jobs) {
        String[] words = fileName.transform(fn -> {
            if (fn.endsWith(".json")) {
                return fn.substring(0, fn.length() - 5);
            }
            return fn;
        }).split("-");
        if (words.length > 3) {
            Set last3Words = Arrays.stream(words).skip(words.length - 3).map(String::toLowerCase).collect(Collectors.toSet());
            String jobName = jobs.stream().filter(job -> last3Words.stream().allMatch(w -> job.toLowerCase().contains((CharSequence)w))).findFirst().orElse(null);
            if (jobName != null) {
                return jobName.trim();
            }
        }
        System.out.println("Unknown format for flaky report filename: " + fileName);
        return fileName;
    }

    private static String getFailureOverview(Set<String> jobs) {
        return jobs.stream().map(job -> " * " + job).collect(Collectors.joining(System.lineSeparator()));
    }

    private static String getRequiredEnv(String environmentVariableName) {
        String envVar = System.getenv(environmentVariableName);
        if (envVar == null) {
            throw new IllegalArgumentException("Missing environment variable: " + environmentVariableName);
        }
        return envVar;
    }

    private record FlakyTestWithFiles(Set<String> fileNames, FlakyTest detail) {
    }
}

