/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qe.reporter.flakyrun.mavenextension;

import io.quarkus.qe.reporter.flakyrun.reporter.FlakyRunReporter;
import io.quarkus.qe.reporter.flakyrun.reporter.Project;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="quarkus-qe-flaky-run-reporter")
public class FlakyRunReportingMavenExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;

    public void afterSessionEnd(MavenSession session) {
        this.logger.debug("Flaky run reporter started");
        List<Project> projects = FlakyRunReportingMavenExtension.getProjectsFromMvnSession(session);
        if (!projects.isEmpty()) {
            new FlakyRunReporter(this.logger).createReport(projects);
        } else {
            this.logger.info("No projects found in this Maven session, won't generate Flaky Run report");
        }
    }

    private static List<Project> getProjectsFromMvnSession(MavenSession session) {
        Path rootPath = Path.of("", new String[0]).toAbsolutePath();
        boolean isNotMultiModuleProject = session.getResult().getTopologicallySortedProjects().size() == 1;
        return session.getResult().getTopologicallySortedProjects().stream().map(p -> new Project(p.getName(), rootPath.relativize(p.getBasedir().toPath()))).filter(p -> {
            boolean rootProject = !p.baseDir().toString().isEmpty();
            return isNotMultiModuleProject || rootProject;
        }).toList();
    }
}

