/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qe.reporter.flakyrun.summary;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.quarkus.qe.reporter.flakyrun.FlakyReporterUtils;
import io.quarkus.qe.reporter.flakyrun.reporter.FlakyRunReporter;
import io.quarkus.qe.reporter.flakyrun.reporter.FlakyTest;
import io.quarkus.qe.reporter.flakyrun.summary.FlakyRunSummary;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class FlakyRunSummaryReporter {
    public static final String TEST_BASE_DIR = FlakyRunSummaryReporter.class.getSimpleName() + ".test-base-dir";
    public static final String FLAKY_SUMMARY_REPORT = "flaky-summary-report.json";
    public static final String CI_BUILD_NUMBER = "flaky-report-ci-build-number";
    public static final String DAY_RETENTION = "day-retention";
    private static final Path CURRENT_DIR = Path.of(".", new String[0]);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final String MAX_FLAKES_PER_TEST = "max-flakes-per-test";
    private static final String PREVIOUS_SUMMARY_REPORT_PATH = "previous-summary-report-path";
    private static final String NEW_SUMMARY_REPORT_PATH = "new-summary-report-path";
    private static final String NEW_FLAKY_REPORT_PATH = "new-flaky-report-path";
    private static final String CI_JOB_NAME = "flaky-report-ci-job-name";
    private final int dayRetention;
    private final int maxFlakesPerTest;
    private final Path newBuildReportPath;
    private final Path previousSummaryReportPath;
    private final String ciJobName;
    private final int ciJobBuildNumber;
    private final Path newSummaryReportPath;

    public FlakyRunSummaryReporter(String[] args) {
        int dayRetention = 30;
        int maxFlakesPerTest = 50;
        Path baseDir = System.getProperty(TEST_BASE_DIR) != null ? Path.of(System.getProperty(TEST_BASE_DIR), new String[0]) : CURRENT_DIR;
        Path newBuildReportPath = baseDir.resolve("flaky-run-report.json");
        Path previousSummaryReportPath = baseDir.resolve(FLAKY_SUMMARY_REPORT);
        Path newSummaryReportPath = baseDir.resolve(FLAKY_SUMMARY_REPORT);
        String ciJobName = "";
        int ciJobBuildNumber = -1;
        for (String arg : args) {
            if (FlakyReporterUtils.isArgument(DAY_RETENTION, arg)) {
                dayRetention = FlakyReporterUtils.parseIntArgument(DAY_RETENTION, arg);
            }
            if (FlakyReporterUtils.isArgument(MAX_FLAKES_PER_TEST, arg)) {
                maxFlakesPerTest = FlakyReporterUtils.parseIntArgument(MAX_FLAKES_PER_TEST, arg);
            }
            if (FlakyReporterUtils.isArgument(NEW_FLAKY_REPORT_PATH, arg)) {
                newBuildReportPath = Path.of(FlakyReporterUtils.parseStringArgument(NEW_FLAKY_REPORT_PATH, arg), new String[0]);
            }
            if (FlakyReporterUtils.isArgument(PREVIOUS_SUMMARY_REPORT_PATH, arg)) {
                previousSummaryReportPath = Path.of(FlakyReporterUtils.parseStringArgument(PREVIOUS_SUMMARY_REPORT_PATH, arg), new String[0]);
            }
            if (FlakyReporterUtils.isArgument(CI_BUILD_NUMBER, arg)) {
                ciJobBuildNumber = FlakyReporterUtils.parseIntArgument(CI_BUILD_NUMBER, arg);
            }
            if (FlakyReporterUtils.isArgument(CI_JOB_NAME, arg)) {
                ciJobName = FlakyReporterUtils.parseStringArgument(CI_JOB_NAME, arg);
            }
            if (!FlakyReporterUtils.isArgument(NEW_SUMMARY_REPORT_PATH, arg)) continue;
            newSummaryReportPath = Path.of(FlakyReporterUtils.parseStringArgument(NEW_SUMMARY_REPORT_PATH, arg), new String[0]);
        }
        this.dayRetention = dayRetention;
        this.maxFlakesPerTest = maxFlakesPerTest;
        this.newBuildReportPath = newBuildReportPath;
        this.previousSummaryReportPath = previousSummaryReportPath;
        this.ciJobName = ciJobName;
        this.ciJobBuildNumber = ciJobBuildNumber;
        this.newSummaryReportPath = newSummaryReportPath;
    }

    public void createReport() {
        List<FlakyTest> flakyTests = FlakyRunReporter.parseFlakyTestsReport(this.newBuildReportPath);
        if (!flakyTests.isEmpty()) {
            List<FlakyRunSummary.FlakyRunProjectSummary> previousSummaries = FlakyRunSummaryReporter.toProjectSummaries(FlakyRunSummaryReporter.parsePreviousSummary(this.previousSummaryReportPath));
            FlakyRunSummary newSummary = this.createNewSummary(previousSummaries, flakyTests);
            this.saveSummaryToFileSystem(newSummary);
        }
    }

    private FlakyRunSummary createNewSummary(List<FlakyRunSummary.FlakyRunProjectSummary> existingProjects, List<FlakyTest> newFlakyTests) {
        List<FlakyRunSummary.FlakyRunProjectSummary> projectSummaries = new ArrayList<FlakyRunSummary.FlakyRunProjectSummary>(this.flakyTestsToSummaries(newFlakyTests));
        if (!existingProjects.isEmpty()) {
            projectSummaries.addAll(existingProjects);
        }
        projectSummaries = this.mergeProjectSummaries(projectSummaries);
        return new FlakyRunSummary(List.copyOf(projectSummaries));
    }

    private List<FlakyRunSummary.FlakyRunProjectSummary> flakyTestsToSummaries(List<FlakyTest> flakyTests) {
        return flakyTests.stream().map(this::createProjectSummaryFromFlakyTest).toList();
    }

    private FlakyRunSummary.FlakyRunProjectSummary createProjectSummaryFromFlakyTest(FlakyTest flakyTest) {
        return new FlakyRunSummary.FlakyRunProjectSummary(flakyTest.projectName(), flakyTest.projectBaseDir(), this.createFlakyTestSummaryFromTest(flakyTest));
    }

    private List<FlakyRunSummary.FlakyRunTestSummary> createFlakyTestSummaryFromTest(FlakyTest flakyTest) {
        return List.of(new FlakyRunSummary.FlakyRunTestSummary(flakyTest.fullTestName(), this.createFlakyRunFromTest(flakyTest)));
    }

    private List<FlakyRunSummary.FlakyRunFlake> createFlakyRunFromTest(FlakyTest flakyTest) {
        return List.of(new FlakyRunSummary.FlakyRunFlake(flakyTest.failureMessage(), flakyTest.failureType(), flakyTest.failureStackTrace(), flakyTest.dateTime(), this.ciJobName, Integer.toString(this.ciJobBuildNumber)));
    }

    private List<FlakyRunSummary.FlakyRunProjectSummary> mergeProjectSummaries(List<FlakyRunSummary.FlakyRunProjectSummary> projectSummaries) {
        record FlakyRunProjectInfo(String projectName, String baseDir) {
        }
        return projectSummaries.stream().collect(Collectors.groupingBy(s -> new FlakyRunProjectInfo(s.projectName(), s.projectBaseDir()), Collectors.toList())).entrySet().stream().map(entry -> new FlakyRunSummary.FlakyRunProjectSummary(((FlakyRunProjectInfo)entry.getKey()).projectName(), ((FlakyRunProjectInfo)entry.getKey()).baseDir(), this.mergeTestSummaries((List)entry.getValue()))).toList();
    }

    private List<FlakyRunSummary.FlakyRunTestSummary> mergeTestSummaries(List<FlakyRunSummary.FlakyRunProjectSummary> projectSummaries) {
        return projectSummaries.stream().map(FlakyRunSummary.FlakyRunProjectSummary::flakeTests).flatMap(Collection::stream).collect(Collectors.groupingBy(FlakyRunSummary.FlakyRunTestSummary::fullTestName, Collectors.toList())).entrySet().stream().map(s -> new FlakyRunSummary.FlakyRunTestSummary((String)s.getKey(), this.filterTestFlakes((List)s.getValue()))).toList();
    }

    private List<FlakyRunSummary.FlakyRunFlake> filterTestFlakes(List<FlakyRunSummary.FlakyRunTestSummary> testSummaries) {
        ZonedDateTime dayRetentionDateTime = ZonedDateTime.now().minusDays(this.dayRetention);
        return testSummaries.stream().map(FlakyRunSummary.FlakyRunTestSummary::flakes).flatMap(Collection::stream).map(s -> new FlakyRunSummary.FlakyRunFlake(s.failureMessage(), s.failureType(), s.failureStackTrace(), s.dateTime(), s.ciJobName(), s.ciBuildNumber())).sorted(new Comparator<FlakyRunSummary.FlakyRunFlake>(){

            @Override
            public int compare(FlakyRunSummary.FlakyRunFlake o1, FlakyRunSummary.FlakyRunFlake o2) {
                return o1.compareTo(o2);
            }
        }.reversed()).limit(this.maxFlakesPerTest).filter(flake -> ZonedDateTime.parse(flake.dateTime()).isAfter(dayRetentionDateTime)).toList();
    }

    private void saveSummaryToFileSystem(FlakyRunSummary summary) {
        if (Files.exists(this.newSummaryReportPath, new LinkOption[0])) {
            try {
                Files.delete(this.newSummaryReportPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (FileOutputStream file = new FileOutputStream(this.newSummaryReportPath.toFile());){
            OBJECT_MAPPER.writeValue((OutputStream)file, (Object)summary);
        }
        catch (Exception e) {
            System.err.println("Unable to create the %s file: %s" + e);
        }
    }

    private static List<FlakyRunSummary.FlakyRunProjectSummary> toProjectSummaries(FlakyRunSummary previousSummary) {
        List<FlakyRunSummary.FlakyRunProjectSummary> flakyProjects = previousSummary != null && previousSummary.flakyProjects() != null ? List.copyOf(previousSummary.flakyProjects()) : List.of();
        return flakyProjects;
    }

    private static FlakyRunSummary parsePreviousSummary(Path summaryPath) {
        if (Files.exists(summaryPath, new LinkOption[0]) && Files.isRegularFile(summaryPath, new LinkOption[0])) {
            try {
                return (FlakyRunSummary)OBJECT_MAPPER.readValue(summaryPath.toFile(), FlakyRunSummary.class);
            }
            catch (IOException e) {
                System.err.printf("Detected previous summary report on path '%s',\nhowever the file is not deserializable and will be ignored: %s\n%n", summaryPath, e.getMessage());
            }
        }
        return null;
    }
}

