/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qson.generator;

import io.quarkus.qson.GenericType;
import io.quarkus.qson.QsonDate;
import io.quarkus.qson.generator.ClassMapping;
import io.quarkus.qson.generator.ParserGenerator;
import io.quarkus.qson.generator.QsonGenerator;
import io.quarkus.qson.generator.WriterGenerator;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class Generator
implements QsonGenerator {
    QsonDate.Format dateFormat = QsonDate.Format.ISO_8601_OFFSET_DATE_TIME;
    Map<Class, ClassMapping> classGenerators = new HashMap<Class, ClassMapping>();

    public ClassMapping mappingFor(Class type) {
        ClassMapping mapping = this.classGenerators.get(type);
        if (mapping == null) {
            mapping = new ClassMapping((QsonGenerator)this, type);
            mapping.scan();
            this.classGenerators.put(type, mapping);
        }
        return mapping;
    }

    public ClassMapping overrideMappingFor(Class type) {
        ClassMapping mapping = this.classGenerators.get(type);
        if (mapping == null) {
            mapping = new ClassMapping((QsonGenerator)this, type);
            this.classGenerators.put(type, mapping);
        }
        return mapping;
    }

    public ClassMapping valueMappingFor(Class type, Member reader, Method writer) {
        return this.overrideMappingFor(type).valueReader(reader).valueWriter(writer);
    }

    public boolean hasMappingFor(Class type) {
        return this.classGenerators.containsKey(type);
    }

    public QsonGenerator dateFormat(QsonDate.Format format) {
        this.dateFormat = format;
        return this;
    }

    public QsonDate.Format getDateFormat() {
        return this.dateFormat;
    }

    public ParserGenerator.Builder parser(Type generic) {
        return new ParserGenerator.Builder(this).type(generic);
    }

    public ParserGenerator.Builder parser(GenericType generic) {
        return new ParserGenerator.Builder(this).type(generic.getType());
    }

    public WriterGenerator.Builder writer(Type genericType) {
        return new WriterGenerator.Builder(this).type(genericType);
    }

    public WriterGenerator.Builder writer(GenericType genericType) {
        return new WriterGenerator.Builder(this).type(genericType.getType());
    }
}

