/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qson.generator;

import io.quarkus.gizmo.ClassOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

class GizmoClassLoader
extends ClassLoader
implements ClassOutput {
    private final Map<String, byte[]> appClasses = new HashMap<String, byte[]>();
    private final boolean dump;

    public GizmoClassLoader(ClassLoader parent) {
        super(parent);
        this.dump = false;
    }

    public GizmoClassLoader(ClassLoader parent, boolean dump) {
        super(parent);
        this.dump = dump;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> ex = this.findLoadedClass(name);
        if (ex != null) {
            return ex;
        }
        return this.appClasses.containsKey(name) ? this.findClass(name) : super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.appClasses.get(name);
        if (bytes == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    public void write(String name, byte[] data) {
        this.appClasses.put(name.replace('/', '.'), data);
    }

    public Writer getSourceWriter(String className) {
        return new Writer(){

            @Override
            public void write(char[] chars, int i, int i1) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

