/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qson.generator;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.qson.QsonDate;
import io.quarkus.qson.QsonException;
import io.quarkus.qson.generator.ClassMapping;
import io.quarkus.qson.generator.Generator;
import io.quarkus.qson.generator.PropertyMapping;
import io.quarkus.qson.generator.QsonGenerator;
import io.quarkus.qson.generator.Util;
import io.quarkus.qson.parser.AnySetter;
import io.quarkus.qson.parser.BaseParser;
import io.quarkus.qson.parser.BooleanParser;
import io.quarkus.qson.parser.ByteParser;
import io.quarkus.qson.parser.ContextValue;
import io.quarkus.qson.parser.DateTimeNumberParser;
import io.quarkus.qson.parser.DateUtilNumberParser;
import io.quarkus.qson.parser.DateUtilStringParser;
import io.quarkus.qson.parser.DoubleParser;
import io.quarkus.qson.parser.EnumParser;
import io.quarkus.qson.parser.FloatParser;
import io.quarkus.qson.parser.GenericParser;
import io.quarkus.qson.parser.GenericSetParser;
import io.quarkus.qson.parser.IntegerParser;
import io.quarkus.qson.parser.ListParser;
import io.quarkus.qson.parser.LongParser;
import io.quarkus.qson.parser.MapParser;
import io.quarkus.qson.parser.ObjectParser;
import io.quarkus.qson.parser.OffsetDateTimeNumberParser;
import io.quarkus.qson.parser.OffsetDateTimeStringParser;
import io.quarkus.qson.parser.ParserContext;
import io.quarkus.qson.parser.ParserState;
import io.quarkus.qson.parser.QsonParser;
import io.quarkus.qson.parser.SetParser;
import io.quarkus.qson.parser.ShortParser;
import io.quarkus.qson.parser.StringParser;
import io.quarkus.qson.parser.ValueParser;
import io.quarkus.qson.util.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParserGenerator {
    public static final String INIT = "<init>";
    public static final String CLINIT = "<clinit>";
    public static final String QSON_ANY_SETTER = "_qson_any_setter";
    public static final String DEFAULT_DATE_UTIL = "_defaultDateUtil";
    public static final String DEFAULT_OFFSET_DATE_TIME = "_defaultOffsetDateTime";
    ClassCreator creator;
    final Class targetType;
    final Type targetGenericType;
    List<PropertyMapping> properties;
    final ClassOutput classOutput;
    final String className;
    Method anyMethod;
    ClassMapping mapping;
    QsonGenerator generator;

    private static String fqn(Class clz) {
        String prefix = "";
        if (clz.getName().startsWith("java")) {
            prefix = "io.quarkus.qson.";
        }
        return prefix + clz.getName() + "__Parser";
    }

    ParserGenerator(ClassOutput classOutput, Class targetType, Type targetGenericType) {
        this(classOutput, ParserGenerator.fqn(targetType), targetType, targetGenericType);
    }

    ParserGenerator(ClassOutput classOutput, String className, Class targetType, Type targetGenericType) {
        this.targetType = targetType;
        this.targetGenericType = targetGenericType;
        this.classOutput = classOutput;
        this.className = className;
    }

    ResultHandle parseValueClass(ClassMapping mapper, BytecodeCreator scope, _ParserContext ctx) {
        if (mapper.getValueReader() == null) {
            throw new QsonException("There is no value setter for value class: " + mapper.getType().getName());
        }
        if (mapper.getValueReader() instanceof Method) {
            Method setter = (Method)mapper.getValueReader();
            if (Modifier.isStatic(setter.getModifiers())) {
                return scope.invokeStaticMethod(MethodDescriptor.ofMethod((Method)setter), new ResultHandle[]{this.popValue(ctx, scope, setter.getParameterTypes()[0])});
            }
            ResultHandle instance = scope.newInstance(MethodDescriptor.ofConstructor((Class)mapper.getType(), (Class[])new Class[0]), new ResultHandle[0]);
            scope.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)setter), instance, new ResultHandle[]{this.popValue(ctx, scope, setter.getParameterTypes()[0])});
            return instance;
        }
        Constructor setter = (Constructor)mapper.getValueReader();
        return scope.newInstance(MethodDescriptor.ofConstructor((Class)mapper.getType(), (Class[])new Class[]{setter.getParameterTypes()[0]}), new ResultHandle[]{this.popValue(ctx, scope, setter.getParameterTypes()[0])});
    }

    ResultHandle callValueClassStartState(_ParserContext ctx, BytecodeCreator scope, ClassMapping mapper) {
        Class type = mapper.getValueReaderType();
        if (type.equals(String.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            MethodDescriptor descriptor = MethodDescriptor.ofMethod(ObjectParser.class, (String)"startStringValue", (Object)Boolean.TYPE.getName(), (Object[])new Object[]{ParserContext.class.getName()});
            return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Byte.TYPE) || type.equals(Byte.class) || type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Long.TYPE) || type.equals(Long.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            MethodDescriptor descriptor = MethodDescriptor.ofMethod(ObjectParser.class, (String)"startIntegerValue", (Object)Boolean.TYPE.getName(), (Object[])new Object[]{ParserContext.class.getName()});
            return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class) || type.equals(Double.TYPE) || type.equals(Double.class) || type.equals(BigDecimal.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            MethodDescriptor descriptor = MethodDescriptor.ofMethod(ObjectParser.class, (String)"startNumberValue", (Object)Boolean.TYPE.getName(), (Object[])new Object[]{ParserContext.class.getName()});
            return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            MethodDescriptor descriptor = MethodDescriptor.ofMethod(ObjectParser.class, (String)"startBooleanValue", (Object)Boolean.TYPE.getName(), (Object[])new Object[]{ParserContext.class.getName()});
            return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
        }
        throw new QsonException("Invalid value type for class: " + mapper.getType().getName());
    }

    void generateValueClass() {
        this.creator = ClassCreator.builder().classOutput(this.classOutput).className(this.className).superClass(ValueParser.class).build();
        FieldCreator PARSER = (FieldCreator)this.creator.getFieldCreator("PARSER", this.fqn()).setModifiers(9);
        MethodCreator staticConstructor = this.creator.getMethodCreator(CLINIT, Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor((String)this.fqn(), (String[])new String[0]), new ResultHandle[0]);
        staticConstructor.writeStaticField(PARSER.getFieldDescriptor(), instance);
        staticConstructor.returnValue(null);
        MethodCreator method = this.creator.getMethodCreator("value", Object.class, new Class[]{ParserContext.class});
        _ParserContext ctx = new _ParserContext(method.getMethodParam(0));
        method.returnValue(this.parseValueClass(this.mapping, (BytecodeCreator)method, ctx));
        method = this.creator.getMethodCreator("start", Boolean.TYPE, new Class[]{ParserContext.class});
        ctx = new _ParserContext(method.getMethodParam(0));
        ResultHandle stateIndex = ctx.stateIndex((BytecodeCreator)method);
        BytecodeCreator ifScope = method.createScope();
        ResultHandle passed = this.callValueClassStartState(ctx, ifScope, this.mapping);
        ifScope = ifScope.ifZero(passed).trueBranch();
        ctx.pushState(ifScope, ifScope.readInstanceField(FieldDescriptor.of((String)this.fqn(), (String)"continueEndValue", ParserState.class), ifScope.getThis()), stateIndex);
        ifScope.returnValue(ifScope.load(false));
        method.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.fqn(), (String)"endValue", Void.TYPE, (Object[])new Object[]{ParserContext.class}), method.getThis(), new ResultHandle[]{ctx.ctx});
        method.returnValue(method.load(true));
        this.creator.close();
    }

    void generateTransformedClass() {
        this.creator = ClassCreator.builder().classOutput(this.classOutput).className(this.className).superClass(ValueParser.class).build();
        FieldCreator PARSER = (FieldCreator)this.creator.getFieldCreator("PARSER", this.fqn()).setModifiers(9);
        MethodCreator staticConstructor = this.creator.getMethodCreator(CLINIT, Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor((String)this.fqn(), (String[])new String[0]), new ResultHandle[0]);
        staticConstructor.writeStaticField(PARSER.getFieldDescriptor(), instance);
        staticConstructor.returnValue(null);
        MethodCreator method = this.creator.getMethodCreator("value", Object.class, new Class[]{ParserContext.class});
        _ParserContext ctx = new _ParserContext(method.getMethodParam(0));
        ResultHandle transformer = ctx.popTarget((BytecodeCreator)method);
        method.returnValue(method.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)this.mapping.getTransformer()), transformer, new ResultHandle[0]));
        method = this.creator.getMethodCreator("start", Boolean.TYPE, new Class[]{ParserContext.class});
        ctx = new _ParserContext(method.getMethodParam(0));
        ResultHandle stateIndex = ctx.stateIndex((BytecodeCreator)method);
        BytecodeCreator ifScope = method.createScope();
        FieldDescriptor parserField = FieldDescriptor.of((String)ParserGenerator.fqn(this.mapping.getTransformerClass()), (String)"PARSER", (String)ParserGenerator.fqn(this.mapping.getTransformerClass()));
        ResultHandle tPARSER = ifScope.readStaticField(parserField);
        MethodDescriptor descriptor = MethodDescriptor.ofMethod((String)ParserGenerator.fqn(this.mapping.getTransformerClass()), (String)"start", (String)Boolean.TYPE.getName(), (String[])new String[]{ParserContext.class.getName()});
        ResultHandle passed = ifScope.invokeVirtualMethod(descriptor, tPARSER, new ResultHandle[]{ctx.ctx});
        ifScope = ifScope.ifZero(passed).trueBranch();
        ctx.pushState(ifScope, ifScope.readInstanceField(FieldDescriptor.of((String)this.fqn(), (String)"continueEndValue", ParserState.class), ifScope.getThis()), stateIndex);
        ifScope.returnValue(ifScope.load(false));
        method.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)this.fqn(), (String)"endValue", Void.TYPE, (Object[])new Object[]{ParserContext.class}), method.getThis(), new ResultHandle[]{ctx.ctx});
        method.returnValue(method.load(true));
        this.creator.close();
    }

    void generateCollection() {
        Class<MapParser> collectionParser;
        this.creator = ClassCreator.builder().classOutput(this.classOutput).className(this.className).interfaces(new Class[]{QsonParser.class}).build();
        MethodCreator staticConstructor = this.creator.getMethodCreator(CLINIT, Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        this.collectionField(staticConstructor, null, this.targetType, this.targetGenericType, "collection");
        staticConstructor.returnValue(null);
        MethodCreator startState = this.creator.getMethodCreator("startState", ParserState.class, new Class[0]);
        if (Map.class.isAssignableFrom(this.targetType)) {
            collectionParser = MapParser.class;
        } else if (List.class.isAssignableFrom(this.targetType)) {
            collectionParser = ListParser.class;
        } else if (Set.class.isAssignableFrom(this.targetType)) {
            collectionParser = SetParser.class;
        } else {
            throw new QsonException("Unsupported collection type: " + this.targetType.getName());
        }
        ResultHandle collection = startState.readStaticField(FieldDescriptor.of((String)this.className, (String)"collection", collectionParser));
        ResultHandle result = startState.invokeVirtualMethod(MethodDescriptor.ofMethod(collectionParser, (String)"startState", ParserState.class, (Class[])new Class[0]), collection, new ResultHandle[0]);
        startState.returnValue(result);
        this.creator.close();
    }

    void generateEnum() {
        this.creator = ClassCreator.builder().classOutput(this.classOutput).className(this.className).superClass(EnumParser.class).build();
        FieldCreator PARSER = (FieldCreator)this.creator.getFieldCreator("PARSER", this.fqn()).setModifiers(9);
        MethodCreator staticConstructor = this.creator.getMethodCreator(CLINIT, Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor((String)this.fqn(), (String[])new String[0]), new ResultHandle[0]);
        staticConstructor.writeStaticField(PARSER.getFieldDescriptor(), instance);
        staticConstructor.returnValue(null);
        MethodCreator method = this.creator.getMethodCreator("endStringValue", Void.TYPE, new Class[]{ParserContext.class});
        _ParserContext ctx = new _ParserContext(method.getMethodParam(0));
        ResultHandle str = ctx.popToken((BytecodeCreator)method);
        ResultHandle e = method.invokeStaticMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)"valueOf", (Class)this.targetType, (Class[])new Class[]{String.class}), new ResultHandle[]{str});
        ctx.pushTarget((BytecodeCreator)method, e);
        method.returnValue(null);
        this.creator.close();
    }

    void generate() {
        this.creator = ClassCreator.builder().classOutput(this.classOutput).className(this.className).superClass(ObjectParser.class).build();
        this.staticInitializer();
        this.beginObject();
        this.key();
        this.creator.close();
    }

    private void beginObject() {
        MethodCreator method = this.creator.getMethodCreator("beginObject", Void.TYPE, new Class[]{ParserContext.class});
        _ParserContext ctx = new _ParserContext(method.getMethodParam(0));
        ResultHandle instance = method.newInstance(MethodDescriptor.ofConstructor((Class)this.targetType, (Class[])new Class[0]), new ResultHandle[0]);
        ctx.pushTarget((BytecodeCreator)method, instance);
        method.returnValue(null);
    }

    private void staticInitializer() {
        FieldCreator PARSER = (FieldCreator)this.creator.getFieldCreator("PARSER", this.fqn()).setModifiers(9);
        MethodCreator staticConstructor = this.creator.getMethodCreator(CLINIT, Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor((String)this.fqn(), (String[])new String[0]), new ResultHandle[0]);
        staticConstructor.writeStaticField(PARSER.getFieldDescriptor(), instance);
        this.processDateProperties(staticConstructor);
        for (PropertyMapping ref : this.properties) {
            this.collectionField(staticConstructor, ref);
            MethodCreator method = this.propertyEndMethod(ref);
            this.propertyEndFunction(ref, staticConstructor, method);
        }
        if (this.anyMethod != null) {
            this.anySetterFunction(staticConstructor);
        }
        staticConstructor.returnValue(null);
    }

    private ResultHandle allocateDateUtilParser(BytecodeCreator scope, QsonDate.Format format, String pattern) {
        if (pattern != null) {
            return scope.newInstance(MethodDescriptor.ofConstructor(DateUtilStringParser.class, (Class[])new Class[]{String.class}), new ResultHandle[]{scope.load(pattern)});
        }
        if (format == QsonDate.Format.MILLISECONDS) {
            return scope.readStaticField(FieldDescriptor.of(DateUtilNumberParser.class, (String)"MILLIS_UTC", DateTimeNumberParser.class));
        }
        if (format == QsonDate.Format.SECONDS) {
            return scope.readStaticField(FieldDescriptor.of(DateUtilNumberParser.class, (String)"SECONDS_UTC", DateTimeNumberParser.class));
        }
        if (format == QsonDate.Format.ISO_8601_OFFSET_DATE_TIME) {
            return scope.readStaticField(FieldDescriptor.of(DateUtilStringParser.class, (String)"ISO_8601_OFFSET_DATE_TIME", DateUtilStringParser.class));
        }
        if (format == QsonDate.Format.RFC_1123_DATE_TIME) {
            return scope.readStaticField(FieldDescriptor.of(DateUtilStringParser.class, (String)"RFC_1123_DATE_TIME", DateUtilStringParser.class));
        }
        throw new QsonException("Unsupported");
    }

    private ResultHandle allocateOffsetDateTimeParser(BytecodeCreator scope, QsonDate.Format format, String pattern) {
        if (pattern != null) {
            return scope.newInstance(MethodDescriptor.ofConstructor(OffsetDateTimeStringParser.class, (Class[])new Class[]{String.class}), new ResultHandle[]{scope.load(pattern)});
        }
        if (format == QsonDate.Format.MILLISECONDS) {
            return scope.readStaticField(FieldDescriptor.of(OffsetDateTimeNumberParser.class, (String)"MILLIS_UTC", DateTimeNumberParser.class));
        }
        if (format == QsonDate.Format.SECONDS) {
            return scope.readStaticField(FieldDescriptor.of(OffsetDateTimeNumberParser.class, (String)"SECONDS_UTC", DateTimeNumberParser.class));
        }
        if (format == QsonDate.Format.ISO_8601_OFFSET_DATE_TIME) {
            return scope.readStaticField(FieldDescriptor.of(OffsetDateTimeStringParser.class, (String)"ISO_8601_OFFSET_DATE_TIME", OffsetDateTimeStringParser.class));
        }
        if (format == QsonDate.Format.RFC_1123_DATE_TIME) {
            return scope.readStaticField(FieldDescriptor.of(OffsetDateTimeStringParser.class, (String)"RFC_1123_DATE_TIME", OffsetDateTimeStringParser.class));
        }
        throw new QsonException("Unsupported");
    }

    private void processDateProperties(MethodCreator staticConstructor) {
        FieldCreator defaultDateUtil = null;
        FieldCreator defaultOffsetDateTime = null;
        for (PropertyMapping ref : this.properties) {
            FieldCreator dateProperty;
            if (Types.typeContainsType((Type)ref.genericType, Date.class)) {
                if (ref.dateFormat == null) {
                    if (defaultDateUtil != null || this.generator.hasMappingFor(Date.class)) continue;
                    defaultDateUtil = (FieldCreator)this.creator.getFieldCreator(DEFAULT_DATE_UTIL, ValueParser.class).setModifiers(26);
                    staticConstructor.writeStaticField(defaultDateUtil.getFieldDescriptor(), this.allocateDateUtilParser((BytecodeCreator)staticConstructor, this.generator.getDateFormat(), null));
                    continue;
                }
                dateProperty = (FieldCreator)this.creator.getFieldCreator(this.getPropertyDateParser(ref), ValueParser.class).setModifiers(26);
                staticConstructor.writeStaticField(dateProperty.getFieldDescriptor(), this.allocateDateUtilParser((BytecodeCreator)staticConstructor, ref.getDateFormat(), ref.getDatePattern()));
                continue;
            }
            if (!Types.typeContainsType((Type)ref.genericType, OffsetDateTime.class)) continue;
            if (ref.dateFormat == null) {
                if (defaultOffsetDateTime != null || this.generator.hasMappingFor(OffsetDateTime.class)) continue;
                defaultOffsetDateTime = (FieldCreator)this.creator.getFieldCreator(DEFAULT_OFFSET_DATE_TIME, ValueParser.class).setModifiers(26);
                staticConstructor.writeStaticField(defaultOffsetDateTime.getFieldDescriptor(), this.allocateOffsetDateTimeParser((BytecodeCreator)staticConstructor, this.generator.getDateFormat(), null));
                continue;
            }
            dateProperty = (FieldCreator)this.creator.getFieldCreator(this.getPropertyDateParser(ref), ValueParser.class).setModifiers(26);
            staticConstructor.writeStaticField(dateProperty.getFieldDescriptor(), this.allocateOffsetDateTimeParser((BytecodeCreator)staticConstructor, ref.getDateFormat(), ref.getDatePattern()));
        }
    }

    private String getPropertyDateParser(PropertyMapping ref) {
        return ref.getPropertyName() + "_dateParser";
    }

    private void collectionField(MethodCreator staticConstructor, PropertyMapping ref) {
        Type genericType = ref.genericType;
        Class type = ref.type;
        String property = ref.propertyName;
        this.collectionField(staticConstructor, ref, type, genericType, property);
    }

    private void collectionField(MethodCreator staticConstructor, PropertyMapping ref, Class type, Type genericType, String property) {
        if (genericType instanceof ParameterizedType) {
            if (Map.class.isAssignableFrom(type)) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type keyType = pt.getActualTypeArguments()[0];
                Class keyClass = Types.getRawType((Type)keyType);
                Type valueType = pt.getActualTypeArguments()[1];
                Class valueClass = Types.getRawType((Type)valueType);
                if (Map.class.isAssignableFrom(valueClass) && !valueClass.equals(Map.class)) {
                    throw new QsonException("Must use java.util.Map for: " + property);
                }
                if (List.class.isAssignableFrom(valueClass) && !valueClass.equals(List.class)) {
                    throw new QsonException("Must use java.util.List for: " + property);
                }
                if (Set.class.isAssignableFrom(valueClass) && !valueClass.equals(Set.class)) {
                    throw new QsonException("Must use java.util.Set for: " + property);
                }
                if (valueClass.equals(Map.class) || valueClass.equals(List.class) || valueClass.equals(Set.class)) {
                    this.collectionField(staticConstructor, ref, valueClass, valueType, property + "_n");
                }
                ResultHandle keyContextValue = this.contextValue(keyClass, keyType, (BytecodeCreator)staticConstructor);
                ResultHandle valueContextValue = this.contextValue(valueClass, valueType, (BytecodeCreator)staticConstructor);
                ResultHandle valueState = this.collectionValueState(ref, valueClass, valueType, (BytecodeCreator)staticConstructor, property);
                ResultHandle continueValueState = this.continueValueState(ref, valueClass, valueType, (BytecodeCreator)staticConstructor, property);
                FieldCreator mapParser = (FieldCreator)this.creator.getFieldCreator(property, MapParser.class).setModifiers(26);
                ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor(MapParser.class, (Class[])new Class[]{ContextValue.class, ContextValue.class, ParserState.class, ParserState.class}), new ResultHandle[]{keyContextValue, valueContextValue, valueState, continueValueState});
                staticConstructor.writeStaticField(mapParser.getFieldDescriptor(), instance);
            } else if (List.class.isAssignableFrom(type)) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type valueType = pt.getActualTypeArguments()[0];
                Class valueClass = Types.getRawType((Type)valueType);
                if (Map.class.isAssignableFrom(valueClass) && !valueClass.equals(Map.class)) {
                    throw new QsonException("Must use java.util.Map for property: " + property);
                }
                if (List.class.isAssignableFrom(valueClass) && !valueClass.equals(List.class)) {
                    throw new QsonException("Must use java.util.List for property: " + property);
                }
                if (Set.class.isAssignableFrom(valueClass) && !valueClass.equals(Set.class)) {
                    throw new QsonException("Must use java.util.Set for property: " + property);
                }
                if (valueClass.equals(Map.class) || valueClass.equals(List.class) || valueClass.equals(Set.class)) {
                    this.collectionField(staticConstructor, ref, valueClass, valueType, property + "_n");
                }
                ResultHandle valueContextValue = this.contextValue(valueClass, valueType, (BytecodeCreator)staticConstructor);
                ResultHandle valueState = this.collectionValueState(ref, valueClass, valueType, (BytecodeCreator)staticConstructor, property);
                FieldCreator collectionParser = (FieldCreator)this.creator.getFieldCreator(property, ListParser.class).setModifiers(26);
                ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor(ListParser.class, (Class[])new Class[]{ContextValue.class, ParserState.class}), new ResultHandle[]{valueContextValue, valueState});
                staticConstructor.writeStaticField(collectionParser.getFieldDescriptor(), instance);
            } else if (Set.class.isAssignableFrom(type)) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type valueType = pt.getActualTypeArguments()[0];
                Class valueClass = Types.getRawType((Type)valueType);
                if (Map.class.isAssignableFrom(valueClass) && !valueClass.equals(Map.class)) {
                    throw new QsonException("Must use java.util.Map for property: " + property);
                }
                if (List.class.isAssignableFrom(valueClass) && !valueClass.equals(List.class)) {
                    throw new QsonException("Must use java.util.List for property: " + property);
                }
                if (Set.class.isAssignableFrom(valueClass) && !valueClass.equals(Set.class)) {
                    throw new QsonException("Must use java.util.Set for property: " + property);
                }
                if (valueClass.equals(Map.class) || valueClass.equals(List.class) || valueClass.equals(Set.class)) {
                    this.collectionField(staticConstructor, ref, valueClass, valueType, property + "_n");
                }
                ResultHandle valueContextValue = this.contextValue(valueClass, valueType, (BytecodeCreator)staticConstructor);
                ResultHandle valueState = this.collectionValueState(ref, valueClass, valueType, (BytecodeCreator)staticConstructor, property);
                FieldCreator collectionParser = (FieldCreator)this.creator.getFieldCreator(property, SetParser.class).setModifiers(26);
                ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor(SetParser.class, (Class[])new Class[]{ContextValue.class, ParserState.class}), new ResultHandle[]{valueContextValue, valueState});
                staticConstructor.writeStaticField(collectionParser.getFieldDescriptor(), instance);
            }
        }
    }

    private ResultHandle contextValue(Class type, Type genericType, BytecodeCreator scope) {
        if (type.equals(String.class)) {
            return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"STRING_VALUE", ContextValue.class));
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"SHORT_VALUE", ContextValue.class));
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"BYTE_VALUE", ContextValue.class));
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"INT_VALUE", ContextValue.class));
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"LONG_VALUE", ContextValue.class));
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"FLOAT_VALUE", ContextValue.class));
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"DOUBLE_VALUE", ContextValue.class));
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"BOOLEAN_VALUE", ContextValue.class));
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"CHAR_VALUE", ContextValue.class));
        }
        if (type.equals(BigDecimal.class)) {
            return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"BIGDECIMAL_VALUE", ContextValue.class));
        }
        return scope.readStaticField(FieldDescriptor.of(ContextValue.class, (String)"OBJECT_VALUE", ContextValue.class));
    }

    private ResultHandle collectionValueState(PropertyMapping ref, Class type, Type genericType, BytecodeCreator scope, String property) {
        if (type.equals(String.class) || type.equals(Character.TYPE) || type.equals(Character.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"startStringValue", ParserState.class), PARSER);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Byte.TYPE) || type.equals(Byte.class) || type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Long.TYPE) || type.equals(Long.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"startIntegerValue", ParserState.class), PARSER);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class) || type.equals(Double.TYPE) || type.equals(Double.class) || type.equals(BigDecimal.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"startNumberValue", ParserState.class), PARSER);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"startBooleanValue", ParserState.class), PARSER);
        }
        if (type.equals(Map.class)) {
            if (genericType instanceof ParameterizedType) {
                FieldDescriptor parserField = FieldDescriptor.of((String)this.fqn(), (String)(property + "_n"), MapParser.class);
                ResultHandle PARSER = scope.readStaticField(parserField);
                return scope.readInstanceField(FieldDescriptor.of(MapParser.class, (String)"start", ParserState.class), PARSER);
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(GenericParser.class, (String)"startObject", ParserState.class), PARSER);
        }
        if (type.equals(List.class)) {
            if (genericType instanceof ParameterizedType) {
                FieldDescriptor parserField = FieldDescriptor.of((String)this.fqn(), (String)(property + "_n"), ListParser.class);
                ResultHandle PARSER = scope.readStaticField(parserField);
                return scope.readInstanceField(FieldDescriptor.of(ListParser.class, (String)"start", ParserState.class), PARSER);
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(GenericParser.class, (String)"startList", ParserState.class), PARSER);
        }
        if (type.equals(Set.class)) {
            if (genericType instanceof ParameterizedType) {
                FieldDescriptor parserField = FieldDescriptor.of((String)this.fqn(), (String)(property + "_n"), SetParser.class);
                ResultHandle PARSER = scope.readStaticField(parserField);
                return scope.readInstanceField(FieldDescriptor.of(SetParser.class, (String)"start", ParserState.class), PARSER);
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericSetParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(GenericSetParser.class, (String)"startList", ParserState.class), PARSER);
        }
        if (type.equals(OffsetDateTime.class) && !this.generator.hasMappingFor(type)) {
            ResultHandle PARSER = this.getOffsetDateTimeParser(ref, scope);
            return scope.readInstanceField(FieldDescriptor.of(ValueParser.class, (String)"start", ParserState.class), PARSER);
        }
        if (type.equals(Date.class) && !this.generator.hasMappingFor(type)) {
            ResultHandle PARSER = this.getDateUtilParser(ref, scope);
            return scope.readInstanceField(FieldDescriptor.of(ValueParser.class, (String)"start", ParserState.class), PARSER);
        }
        FieldDescriptor parserField = FieldDescriptor.of((String)ParserGenerator.fqn(type), (String)"PARSER", (String)ParserGenerator.fqn(type));
        ResultHandle PARSER = scope.readStaticField(parserField);
        ClassMapping mapping = this.generator.mappingFor(type);
        if (mapping.isValue()) {
            return scope.readInstanceField(FieldDescriptor.of(ValueParser.class, (String)"start", ParserState.class), PARSER);
        }
        return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"start", ParserState.class), PARSER);
    }

    private ResultHandle getDateUtilParser(PropertyMapping ref, BytecodeCreator scope) {
        String field = DEFAULT_DATE_UTIL;
        if (ref != null && ref.getDateFormat() != null) {
            field = this.getPropertyDateParser(ref);
        }
        FieldDescriptor parserField = FieldDescriptor.of((String)this.fqn(), (String)field, ValueParser.class);
        return scope.readStaticField(parserField);
    }

    private ResultHandle continueValueState(PropertyMapping ref, Class type, Type genericType, BytecodeCreator scope, String property) {
        if (type.equals(String.class) || type.equals(Character.TYPE) || type.equals(Character.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"continueStartStringValue", ParserState.class), PARSER);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Byte.TYPE) || type.equals(Byte.class) || type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Long.TYPE) || type.equals(Long.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"continueStartIntegerValue", ParserState.class), PARSER);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class) || type.equals(Double.TYPE) || type.equals(Double.class) || type.equals(BigDecimal.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"continueStartNumberValue", ParserState.class), PARSER);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"continueStartBooleanValue", ParserState.class), PARSER);
        }
        if (type.equals(Map.class)) {
            if (genericType instanceof ParameterizedType) {
                FieldDescriptor parserField = FieldDescriptor.of((String)this.fqn(), (String)(property + "_n"), MapParser.class);
                ResultHandle PARSER = scope.readStaticField(parserField);
                return scope.readInstanceField(FieldDescriptor.of(MapParser.class, (String)"continueStart", ParserState.class), PARSER);
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(GenericParser.class, (String)"continueStartObject", ParserState.class), PARSER);
        }
        if (type.equals(List.class)) {
            if (genericType instanceof ParameterizedType) {
                FieldDescriptor parserField = FieldDescriptor.of((String)this.fqn(), (String)(property + "_n"), ListParser.class);
                ResultHandle PARSER = scope.readStaticField(parserField);
                return scope.readInstanceField(FieldDescriptor.of(ListParser.class, (String)"continueStart", ParserState.class), PARSER);
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(GenericParser.class, (String)"continueStartList", ParserState.class), PARSER);
        }
        if (type.equals(Set.class)) {
            if (genericType instanceof ParameterizedType) {
                FieldDescriptor parserField = FieldDescriptor.of((String)this.fqn(), (String)(property + "_n"), SetParser.class);
                ResultHandle PARSER = scope.readStaticField(parserField);
                return scope.readInstanceField(FieldDescriptor.of(SetParser.class, (String)"continueStart", ParserState.class), PARSER);
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericSetParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(GenericSetParser.class, (String)"continueStartList", ParserState.class), PARSER);
        }
        if (type.equals(OffsetDateTime.class) && !this.generator.hasMappingFor(type)) {
            ResultHandle PARSER = this.getOffsetDateTimeParser(ref, scope);
            return scope.readInstanceField(FieldDescriptor.of(ValueParser.class, (String)"continueStart", ParserState.class), PARSER);
        }
        if (type.equals(Date.class) && !this.generator.hasMappingFor(type)) {
            ResultHandle PARSER = this.getDateUtilParser(ref, scope);
            return scope.readInstanceField(FieldDescriptor.of(ValueParser.class, (String)"continueStart", ParserState.class), PARSER);
        }
        FieldDescriptor parserField = FieldDescriptor.of((String)ParserGenerator.fqn(type), (String)"PARSER", (String)ParserGenerator.fqn(type));
        ResultHandle PARSER = scope.readStaticField(parserField);
        ClassMapping mapping = this.generator.mappingFor(type);
        if (mapping.isValue()) {
            return scope.readInstanceField(FieldDescriptor.of(ValueParser.class, (String)"continueStart", ParserState.class), PARSER);
        }
        return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"continueStart", ParserState.class), PARSER);
    }

    private ResultHandle getOffsetDateTimeParser(PropertyMapping ref, BytecodeCreator scope) {
        String field = DEFAULT_OFFSET_DATE_TIME;
        if (ref != null && ref.getDateFormat() != null) {
            field = this.getPropertyDateParser(ref);
        }
        FieldDescriptor parserField = FieldDescriptor.of((String)this.fqn(), (String)field, ValueParser.class);
        return scope.readStaticField(parserField);
    }

    private void anySetterFunction(MethodCreator staticConstructor) {
        String endName = QSON_ANY_SETTER;
        FieldCreator endField = (FieldCreator)this.creator.getFieldCreator(endName, AnySetter.class).setModifiers(10);
        FunctionCreator endFunction = staticConstructor.createFunction(AnySetter.class);
        BytecodeCreator ebc = endFunction.getBytecode();
        AssignableResultHandle target = ebc.createVariable(this.targetType);
        ebc.assign(target, ebc.getMethodParam(0));
        ebc.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)this.anyMethod), (ResultHandle)target, new ResultHandle[]{ebc.getMethodParam(1), ebc.getMethodParam(2)});
        ebc.returnValue(null);
        staticConstructor.writeStaticField(endField.getFieldDescriptor(), endFunction.getInstance());
    }

    private void propertyEndFunction(PropertyMapping setter, MethodCreator staticConstructor, MethodCreator method) {
        String endName = this.endProperty(setter);
        FieldCreator endField = (FieldCreator)this.creator.getFieldCreator(endName, ParserState.class).setModifiers(10);
        FunctionCreator endFunction = staticConstructor.createFunction(ParserState.class);
        BytecodeCreator ebc = endFunction.getBytecode();
        _ParserContext ctx = new _ParserContext(ebc.getMethodParam(0));
        ctx.popState(ebc);
        ebc.invokeStaticMethod(method.getMethodDescriptor(), new ResultHandle[]{ctx.ctx});
        ebc.returnValue(ebc.load(true));
        staticConstructor.writeStaticField(endField.getFieldDescriptor(), endFunction.getInstance());
    }

    private MethodCreator propertyEndMethod(PropertyMapping setter) {
        String endName = this.endProperty(setter);
        MethodCreator method = this.creator.getMethodCreator(endName, Void.TYPE, new Class[]{ParserContext.class});
        method.setModifiers(25);
        _ParserContext ctx = new _ParserContext(method.getMethodParam(0));
        ResultHandle popSetter = this.popSetterValue(ctx, setter, (BytecodeCreator)method);
        AssignableResultHandle target = method.createVariable(this.targetType);
        method.assign(target, ctx.target((BytecodeCreator)method));
        MethodDescriptor set = MethodDescriptor.ofMethod((Method)setter.setter);
        method.invokeVirtualMethod(set, (ResultHandle)target, new ResultHandle[]{popSetter});
        method.returnValue(null);
        return method;
    }

    private ResultHandle popSetterValue(_ParserContext ctx, PropertyMapping setter, BytecodeCreator scope) {
        Class type = setter.type;
        return this.popValue(ctx, scope, type);
    }

    private ResultHandle popValue(_ParserContext ctx, BytecodeCreator scope, Class type) {
        if (type.equals(String.class)) {
            return ctx.popToken(scope);
        }
        if (type.equals(Short.TYPE)) {
            return ctx.popShortToken(scope);
        }
        if (type.equals(Short.class)) {
            return ctx.popShortObjectToken(scope);
        }
        if (type.equals(Byte.TYPE)) {
            return ctx.popByteToken(scope);
        }
        if (type.equals(Byte.class)) {
            return ctx.popByteObjectToken(scope);
        }
        if (type.equals(Integer.TYPE)) {
            return ctx.popIntToken(scope);
        }
        if (type.equals(Integer.class)) {
            return ctx.popIntObjectToken(scope);
        }
        if (type.equals(Long.TYPE)) {
            return ctx.popLongToken(scope);
        }
        if (type.equals(Long.class)) {
            return ctx.popLongObjectToken(scope);
        }
        if (type.equals(Float.TYPE)) {
            return ctx.popFloatToken(scope);
        }
        if (type.equals(Float.class)) {
            return ctx.popFloatObjectToken(scope);
        }
        if (type.equals(Double.TYPE)) {
            return ctx.popDoubleToken(scope);
        }
        if (type.equals(Double.class)) {
            return ctx.popDoubleObjectToken(scope);
        }
        if (type.equals(Boolean.TYPE)) {
            return ctx.popBooleanToken(scope);
        }
        if (type.equals(Boolean.class)) {
            return ctx.popBooleanObjectToken(scope);
        }
        return ctx.popTarget(scope);
    }

    private String endProperty(PropertyMapping setter) {
        return setter.propertyName + "End";
    }

    private void key() {
        MethodCreator method = this.creator.getMethodCreator("key", Boolean.TYPE, new Class[]{ParserContext.class});
        _ParserContext ctx = new _ParserContext(method.getMethodParam(0));
        BytecodeCreator scope = method.createScope();
        BytecodeCreator ifTrue = scope.ifIntegerEqual(ctx.skipToQuote(scope), scope.load(0)).trueBranch();
        ctx.pushState(ifTrue, ifTrue.readInstanceField(FieldDescriptor.of((String)this.fqn(), (String)"continueKey", ParserState.class), ifTrue.getThis()));
        ifTrue.returnValue(ifTrue.load(false));
        ctx.endToken((BytecodeCreator)method);
        ResultHandle stateIndex = ctx.stateIndex((BytecodeCreator)method);
        this.chooseField((BytecodeCreator)method, ctx, stateIndex, this.properties, 0);
        if (this.anyMethod == null) {
            ResultHandle result = method.invokeVirtualMethod(MethodDescriptor.ofMethod(BaseParser.class, (String)"skipValue", Boolean.TYPE, (Class[])new Class[]{ParserContext.class}), method.readStaticField(FieldDescriptor.of(BaseParser.class, (String)"PARSER", BaseParser.class)), new ResultHandle[]{ctx.ctx});
            method.returnValue(result);
        } else {
            ResultHandle result = ctx.handleAny((BytecodeCreator)method, method.readStaticField(FieldDescriptor.of((String)this.fqn(), (String)QSON_ANY_SETTER, AnySetter.class)));
            method.returnValue(result);
        }
    }

    private void chooseField(BytecodeCreator scope, _ParserContext ctx, ResultHandle stateIndex, List<PropertyMapping> setters, int offset) {
        if (setters.size() == 1) {
            PropertyMapping setter = setters.get(0);
            this.compareToken(scope, ctx, stateIndex, offset, setter);
            return;
        }
        ResultHandle c = ctx.tokenCharAt(scope, offset);
        for (int i = 0; i < setters.size(); ++i) {
            PropertyMapping setter = setters.get(i);
            if (offset >= setter.jsonName.length()) {
                this.compareToken(scope, ctx, stateIndex, offset, setter);
                continue;
            }
            char ch = setter.jsonName.charAt(offset);
            ArrayList<PropertyMapping> sameChars = new ArrayList<PropertyMapping>();
            sameChars.add(setter);
            BytecodeCreator ifScope = scope.createScope();
            BranchResult branchResult = ifScope.ifIntegerEqual(c, ifScope.load(ch));
            ++i;
            while (i < setters.size()) {
                PropertyMapping next = setters.get(i);
                if (offset >= next.jsonName.length() || next.jsonName.charAt(offset) != ch) {
                    --i;
                    break;
                }
                sameChars.add(next);
                ++i;
            }
            this.chooseField(branchResult.trueBranch(), ctx, stateIndex, sameChars, offset + 1);
            scope = branchResult.falseBranch();
        }
    }

    private void compareToken(BytecodeCreator scope, _ParserContext ctx, ResultHandle stateIndex, int offset, PropertyMapping setter) {
        BytecodeCreator ifScope = scope.createScope();
        ResultHandle check = ctx.compareToken(ifScope, ifScope.load(offset), ifScope.load(setter.jsonName.substring(offset)));
        this.matchHandler(ctx, stateIndex, setter, ifScope.ifNonZero(check).trueBranch());
    }

    private void matchHandler(_ParserContext ctx, ResultHandle stateIndex, PropertyMapping setter, BytecodeCreator scope) {
        BytecodeCreator ifScope = scope.createScope();
        MethodDescriptor valueSeparator = this.valueSeparator();
        ResultHandle passed = ifScope.invokeVirtualMethod(valueSeparator, scope.getThis(), new ResultHandle[]{ctx.ctx});
        ifScope = ifScope.ifZero(passed).trueBranch();
        ctx.pushState(ifScope, this.continueState(setter, ifScope), stateIndex);
        ctx.pushState(ifScope, ifScope.readStaticField(FieldDescriptor.of((String)this.fqn(), (String)this.endProperty(setter), ParserState.class)), stateIndex);
        ifScope.returnValue(ifScope.load(false));
        ifScope = scope.createScope();
        passed = this.callStartState(ctx, setter, ifScope);
        ifScope = ifScope.ifZero(passed).trueBranch();
        ctx.pushState(ifScope, ifScope.readStaticField(FieldDescriptor.of((String)this.fqn(), (String)this.endProperty(setter), ParserState.class)), stateIndex);
        ifScope.returnValue(ifScope.load(false));
        scope.invokeStaticMethod(MethodDescriptor.ofMethod((Object)this.fqn(), (String)this.endProperty(setter), Void.TYPE, (Object[])new Object[]{ParserContext.class}), new ResultHandle[]{ctx.ctx});
        scope.returnValue(scope.load(true));
    }

    private ResultHandle continueState(PropertyMapping setter, BytecodeCreator scope) {
        Class type = setter.type;
        Type genericType = setter.genericType;
        if (type.equals(String.class) || type.equals(Character.TYPE) || type.equals(Character.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"continueStartStringValue", ParserState.class), PARSER);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Byte.TYPE) || type.equals(Byte.class) || type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Long.TYPE) || type.equals(Long.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"continueStartIntegerValue", ParserState.class), PARSER);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class) || type.equals(Double.TYPE) || type.equals(Double.class) || type.equals(BigDecimal.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"continueStartNumberValue", ParserState.class), PARSER);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(ObjectParser.class, (String)"PARSER", ObjectParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"continueStartBooleanValue", ParserState.class), PARSER);
        }
        if (List.class.isAssignableFrom(setter.type)) {
            if (!List.class.equals((Object)setter.type)) {
                throw new QsonException("Cannot use concrete list.  Must use java.util.List for property: " + setter.propertyName);
            }
            if (setter.genericType instanceof ParameterizedType) {
                FieldDescriptor mapFieldDesc = FieldDescriptor.of((String)this.fqn(), (String)setter.propertyName, ListParser.class);
                ResultHandle mapField = scope.readStaticField(mapFieldDesc);
                return scope.readInstanceField(FieldDescriptor.of(ListParser.class, (String)"continueStart", ParserState.class), mapField);
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(GenericParser.class, (String)"continueStartObject", ParserState.class), PARSER);
        }
        if (Set.class.isAssignableFrom(setter.type)) {
            if (!Set.class.equals((Object)setter.type)) {
                throw new QsonException("Cannot use concrete set.  Must use java.util.Set for property: " + setter.propertyName);
            }
            if (setter.genericType instanceof ParameterizedType) {
                FieldDescriptor mapFieldDesc = FieldDescriptor.of((String)this.fqn(), (String)setter.propertyName, SetParser.class);
                ResultHandle mapField = scope.readStaticField(mapFieldDesc);
                return scope.readInstanceField(FieldDescriptor.of(SetParser.class, (String)"continueStart", ParserState.class), mapField);
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericSetParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(GenericSetParser.class, (String)"continueStartObject", ParserState.class), PARSER);
        }
        if (Map.class.isAssignableFrom(setter.type)) {
            if (!Map.class.equals((Object)setter.type)) {
                throw new QsonException("Cannot use concrete map.  Must use java.util.Map for property: " + setter.propertyName);
            }
            if (setter.genericType instanceof ParameterizedType) {
                FieldDescriptor mapFieldDesc = FieldDescriptor.of((String)this.fqn(), (String)setter.propertyName, MapParser.class);
                ResultHandle mapField = scope.readStaticField(mapFieldDesc);
                return scope.readInstanceField(FieldDescriptor.of(MapParser.class, (String)"continueStart", ParserState.class), mapField);
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(GenericParser.class, (String)"continueStartObject", ParserState.class), PARSER);
        }
        if (setter.type.equals(Object.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            return scope.readInstanceField(FieldDescriptor.of(GenericParser.class, (String)"continueStart", ParserState.class), PARSER);
        }
        if (type.equals(OffsetDateTime.class) && !this.generator.hasMappingFor(type)) {
            ResultHandle PARSER = this.getOffsetDateTimeParser(setter, scope);
            return scope.readInstanceField(FieldDescriptor.of(ValueParser.class, (String)"continueStart", ParserState.class), PARSER);
        }
        if (type.equals(Date.class) && !this.generator.hasMappingFor(type)) {
            ResultHandle PARSER = this.getDateUtilParser(setter, scope);
            return scope.readInstanceField(FieldDescriptor.of(ValueParser.class, (String)"continueStart", ParserState.class), PARSER);
        }
        FieldDescriptor parserField = FieldDescriptor.of((String)ParserGenerator.fqn(type), (String)"PARSER", (String)ParserGenerator.fqn(type));
        ResultHandle PARSER = scope.readStaticField(parserField);
        ClassMapping mapping = this.generator.mappingFor(type);
        if (mapping.isValue()) {
            return scope.readInstanceField(FieldDescriptor.of(ValueParser.class, (String)"continueStart", ParserState.class), PARSER);
        }
        return scope.readInstanceField(FieldDescriptor.of(ObjectParser.class, (String)"continueStart", ParserState.class), PARSER);
    }

    private ResultHandle callStartState(_ParserContext ctx, PropertyMapping setter, BytecodeCreator scope) {
        Class type = setter.type;
        Type genericType = setter.genericType;
        if (type.equals(String.class) || type.equals(Character.TYPE) || type.equals(Character.class)) {
            MethodDescriptor descriptor = MethodDescriptor.ofMethod((String)this.fqn(), (String)"startStringValue", (String)Boolean.TYPE.getName(), (String[])new String[]{ParserContext.class.getName()});
            return scope.invokeVirtualMethod(descriptor, scope.getThis(), new ResultHandle[]{ctx.ctx});
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Byte.TYPE) || type.equals(Byte.class) || type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Long.TYPE) || type.equals(Long.class)) {
            MethodDescriptor descriptor = MethodDescriptor.ofMethod((String)this.fqn(), (String)"startIntegerValue", (String)Boolean.TYPE.getName(), (String[])new String[]{ParserContext.class.getName()});
            return scope.invokeVirtualMethod(descriptor, scope.getThis(), new ResultHandle[]{ctx.ctx});
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class) || type.equals(Double.TYPE) || type.equals(Double.class) || type.equals(BigDecimal.class)) {
            MethodDescriptor descriptor = MethodDescriptor.ofMethod((String)this.fqn(), (String)"startNumberValue", (String)Boolean.TYPE.getName(), (String[])new String[]{ParserContext.class.getName()});
            return scope.invokeVirtualMethod(descriptor, scope.getThis(), new ResultHandle[]{ctx.ctx});
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            MethodDescriptor descriptor = MethodDescriptor.ofMethod((String)this.fqn(), (String)"startBooleanValue", (String)Boolean.TYPE.getName(), (String[])new String[]{ParserContext.class.getName()});
            return scope.invokeVirtualMethod(descriptor, scope.getThis(), new ResultHandle[]{ctx.ctx});
        }
        if (List.class.isAssignableFrom(setter.type)) {
            if (!List.class.equals((Object)setter.type)) {
                throw new QsonException("Cannot use concrete list.  Must use java.util.List for property: " + setter.propertyName);
            }
            if (setter.genericType instanceof ParameterizedType) {
                MethodDescriptor descriptor = MethodDescriptor.ofMethod(ListParser.class, (String)"start", Boolean.TYPE, (Class[])new Class[]{ParserContext.class});
                return scope.invokeVirtualMethod(descriptor, scope.readStaticField(FieldDescriptor.of((String)this.fqn(), (String)setter.propertyName, ListParser.class)), new ResultHandle[]{ctx.ctx});
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            MethodDescriptor descriptor = MethodDescriptor.ofMethod(GenericParser.class, (String)"startList", Boolean.TYPE, (Class[])new Class[]{ParserContext.class});
            return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
        }
        if (Set.class.isAssignableFrom(setter.type)) {
            if (!Set.class.equals((Object)setter.type)) {
                throw new QsonException("Cannot use concrete set.  Must use java.util.Set for property: " + setter.propertyName);
            }
            if (setter.genericType instanceof ParameterizedType) {
                MethodDescriptor descriptor = MethodDescriptor.ofMethod(SetParser.class, (String)"start", Boolean.TYPE, (Class[])new Class[]{ParserContext.class});
                return scope.invokeVirtualMethod(descriptor, scope.readStaticField(FieldDescriptor.of((String)this.fqn(), (String)setter.propertyName, SetParser.class)), new ResultHandle[]{ctx.ctx});
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericSetParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            MethodDescriptor descriptor = MethodDescriptor.ofMethod(GenericSetParser.class, (String)"startList", Boolean.TYPE, (Class[])new Class[]{ParserContext.class});
            return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
        }
        if (Map.class.isAssignableFrom(setter.type)) {
            if (!Map.class.equals((Object)setter.type)) {
                throw new QsonException("Cannot use concrete map.  Must use java.util.Map for property: " + setter.propertyName);
            }
            if (setter.genericType instanceof ParameterizedType) {
                MethodDescriptor descriptor = MethodDescriptor.ofMethod(MapParser.class, (String)"start", Boolean.TYPE, (Class[])new Class[]{ParserContext.class});
                return scope.invokeVirtualMethod(descriptor, scope.readStaticField(FieldDescriptor.of((String)this.fqn(), (String)setter.propertyName, MapParser.class)), new ResultHandle[]{ctx.ctx});
            }
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            MethodDescriptor descriptor = MethodDescriptor.ofMethod(GenericParser.class, (String)"startObject", Boolean.TYPE, (Class[])new Class[]{ParserContext.class});
            return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
        }
        if (setter.type.equals(Object.class)) {
            FieldDescriptor parserField = FieldDescriptor.of(GenericParser.class, (String)"PARSER", GenericParser.class);
            ResultHandle PARSER = scope.readStaticField(parserField);
            MethodDescriptor descriptor = MethodDescriptor.ofMethod(GenericParser.class, (String)"start", Boolean.TYPE, (Class[])new Class[]{ParserContext.class});
            return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
        }
        if (type.equals(OffsetDateTime.class) && !this.generator.hasMappingFor(type)) {
            ResultHandle PARSER = this.getOffsetDateTimeParser(setter, scope);
            MethodDescriptor descriptor = MethodDescriptor.ofMethod(ValueParser.class, (String)"start", (Object)Boolean.TYPE.getName(), (Object[])new Object[]{ParserContext.class.getName()});
            return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
        }
        if (type.equals(Date.class) && !this.generator.hasMappingFor(type)) {
            ResultHandle PARSER = this.getDateUtilParser(setter, scope);
            MethodDescriptor descriptor = MethodDescriptor.ofMethod(ValueParser.class, (String)"start", (Object)Boolean.TYPE.getName(), (Object[])new Object[]{ParserContext.class.getName()});
            return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
        }
        FieldDescriptor parserField = FieldDescriptor.of((String)ParserGenerator.fqn(type), (String)"PARSER", (String)ParserGenerator.fqn(type));
        ResultHandle PARSER = scope.readStaticField(parserField);
        MethodDescriptor descriptor = MethodDescriptor.ofMethod((String)ParserGenerator.fqn(type), (String)"start", (String)Boolean.TYPE.getName(), (String[])new String[]{ParserContext.class.getName()});
        return scope.invokeVirtualMethod(descriptor, PARSER, new ResultHandle[]{ctx.ctx});
    }

    private MethodDescriptor valueSeparator() {
        return MethodDescriptor.ofMethod((String)this.fqn(), (String)"valueSeparator", (String)Boolean.TYPE.getName(), (String[])new String[]{ParserContext.class.getName()});
    }

    private String fqn() {
        return this.className;
    }

    static class _ParserContext {
        ResultHandle ctx;

        public _ParserContext(ResultHandle ctx) {
            this.ctx = ctx;
        }

        public ResultHandle handleAny(BytecodeCreator scope, ResultHandle setter) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"handleAny", Boolean.TYPE, (Class[])new Class[]{AnySetter.class}), this.ctx, new ResultHandle[]{setter});
        }

        public ResultHandle consume(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"consume", Integer.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public void clearToken(BytecodeCreator scope) {
            scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"clearToken", Void.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public void popState(BytecodeCreator scope) {
            scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popState", Void.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public void endToken(BytecodeCreator scope) {
            scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"endToken", Void.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle compareToken(BytecodeCreator scope, ResultHandle index, ResultHandle str) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"compareToken", Boolean.TYPE, (Class[])new Class[]{Integer.TYPE, String.class}), this.ctx, new ResultHandle[]{index, str});
        }

        public ResultHandle tokenCharAt(BytecodeCreator scope, int index) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"tokenCharAt", Integer.TYPE, (Class[])new Class[]{Integer.TYPE}), this.ctx, new ResultHandle[]{scope.load(index)});
        }

        public ResultHandle popToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popToken", String.class, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popBooleanToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popBooleanToken", Boolean.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popBooleanObjectToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popBooleanObjectToken", Boolean.class, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popIntToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popIntToken", Integer.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popIntObjectToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popIntObjectToken", Integer.class, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popShortToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popShortToken", Short.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popShortObjectToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popShortObjectToken", Short.class, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popByteToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popByteToken", Byte.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popByteObjectToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popByteObjectToken", Byte.class, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popLongToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popLongToken", Long.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popLongObjectToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popLongObjectToken", Long.class, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popFloatToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popFloatToken", Float.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popFloatObjectToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popFloatObjectToken", Float.class, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popDoubleToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popDoubleToken", Double.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle popDoubleObjectToken(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popDoubleObjectToken", Double.class, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle target(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"target", Object.class, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public void pushTarget(BytecodeCreator scope, ResultHandle obj) {
            scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"pushTarget", Void.TYPE, (Class[])new Class[]{Object.class}), this.ctx, new ResultHandle[]{obj});
        }

        public void pushState(BytecodeCreator scope, ResultHandle func, ResultHandle index) {
            scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"pushState", Void.TYPE, (Class[])new Class[]{ParserState.class, Integer.TYPE}), this.ctx, new ResultHandle[]{func, index});
        }

        public void pushState(BytecodeCreator scope, ResultHandle func) {
            scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"pushState", Void.TYPE, (Class[])new Class[]{ParserState.class}), this.ctx, new ResultHandle[]{func});
        }

        public ResultHandle popTarget(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"popTarget", Object.class, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle stateIndex(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"stateIndex", Integer.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }

        public ResultHandle skipToQuote(BytecodeCreator scope) {
            return scope.invokeInterfaceMethod(MethodDescriptor.ofMethod(ParserContext.class, (String)"skipToQuote", Integer.TYPE, (Class[])new Class[0]), this.ctx, new ResultHandle[0]);
        }
    }

    public static class Builder {
        Type type;
        ClassOutput output;
        String className;
        List<PropertyMapping> properties;
        Set<Type> referenced = new HashSet<Type>();
        Generator generator;

        protected Builder(Generator generator) {
            this.generator = generator;
        }

        public Builder type(Type targetType) {
            this.type = targetType;
            return this;
        }

        public Builder output(ClassOutput output) {
            this.output = output;
            return this;
        }

        public String className() {
            return this.className;
        }

        public Set<Type> referenced() {
            return this.referenced;
        }

        public Builder generate() {
            Class rawType;
            if (this.type instanceof Class) {
                if (Integer.TYPE.equals(this.type) || Integer.class.equals((Object)this.type)) {
                    this.className = IntegerParser.class.getName();
                    return this;
                }
                if (Short.TYPE.equals(this.type) || Short.class.equals((Object)this.type)) {
                    this.className = ShortParser.class.getName();
                    return this;
                }
                if (Long.TYPE.equals(this.type) || Long.class.equals((Object)this.type)) {
                    this.className = LongParser.class.getName();
                    return this;
                }
                if (Byte.TYPE.equals(this.type) || Byte.class.equals((Object)this.type)) {
                    this.className = ByteParser.class.getName();
                    return this;
                }
                if (Float.TYPE.equals(this.type) || Float.class.equals((Object)this.type)) {
                    this.className = FloatParser.class.getName();
                    return this;
                }
                if (Double.TYPE.equals(this.type) || Double.class.equals((Object)this.type)) {
                    this.className = DoubleParser.class.getName();
                    return this;
                }
                if (Boolean.TYPE.equals(this.type) || Boolean.class.equals((Object)this.type)) {
                    this.className = BooleanParser.class.getName();
                    return this;
                }
                if (String.class.equals((Object)this.type)) {
                    this.className = StringParser.class.getName();
                    return this;
                }
                if (Map.class.equals((Object)this.type) || List.class.equals((Object)this.type)) {
                    this.className = GenericParser.class.getName();
                    return this;
                }
                if (Set.class.equals((Object)this.type)) {
                    this.className = GenericSetParser.class.getName();
                    return this;
                }
                Class targetType = (Class)this.type;
                if (targetType.isEnum()) {
                    ParserGenerator deserializer = new ParserGenerator(this.output, targetType, this.type);
                    deserializer.generateEnum();
                    this.className = ParserGenerator.fqn(targetType);
                    return this;
                }
                ClassMapping mapping = this.generator.mappingFor(targetType);
                if (mapping != null) {
                    if (mapping.isValue) {
                        ParserGenerator deserializer = new ParserGenerator(this.output, targetType, this.type);
                        deserializer.mapping = mapping;
                        deserializer.generateValueClass();
                        this.className = ParserGenerator.fqn(targetType);
                        return this;
                    }
                    if (mapping.isTransformed()) {
                        ParserGenerator deserializer = new ParserGenerator(this.output, targetType, this.type);
                        deserializer.mapping = mapping;
                        this.referenced.add(mapping.getTransformerClass());
                        deserializer.generateTransformedClass();
                        this.className = ParserGenerator.fqn(targetType);
                        return this;
                    }
                    this.properties = mapping.getProperties();
                }
                ArrayList<PropertyMapping> tmp = new ArrayList<PropertyMapping>();
                Method anySetter = null;
                for (PropertyMapping ref2 : this.properties) {
                    if (ref2.setter == null) continue;
                    if (ref2.isAny) {
                        anySetter = ref2.setter;
                        continue;
                    }
                    tmp.add(ref2);
                    Util.addReference(this.generator, this.referenced, ref2.genericType);
                }
                Collections.sort(tmp, (ref, t1) -> ref.jsonName.compareTo(t1.jsonName));
                ParserGenerator deserializer = new ParserGenerator(this.output, targetType, this.type);
                deserializer.anyMethod = anySetter;
                deserializer.mapping = mapping;
                deserializer.generator = this.generator;
                deserializer.properties = tmp;
                deserializer.generate();
                this.className = ParserGenerator.fqn(targetType);
                return this;
            }
            if (this.type instanceof ParameterizedType && (Map.class.equals((Object)(rawType = Types.getRawType((Type)this.type))) || List.class.equals((Object)rawType) || Set.class.equals((Object)rawType))) {
                if (this.className == null) {
                    this.className = Util.generatedClassName(this.type);
                    this.className = this.className + "__Parser";
                }
                ParserGenerator deserializer = new ParserGenerator(this.output, this.className, Types.getRawType((Type)this.type), this.type);
                deserializer.generator = this.generator;
                deserializer.generateCollection();
                Util.addReference(this.generator, this.referenced, this.type);
                return this;
            }
            throw new QsonException("Deserializer generation unsupported for generic type: " + this.type.getTypeName());
        }
    }
}

