/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qson.generator;

import io.quarkus.qson.GenericType;
import io.quarkus.qson.QsonException;
import io.quarkus.qson.generator.Generator;
import io.quarkus.qson.generator.GizmoClassLoader;
import io.quarkus.qson.generator.ParserGenerator;
import io.quarkus.qson.generator.QsonGenerator;
import io.quarkus.qson.generator.WriterGenerator;
import io.quarkus.qson.parser.QsonParser;
import io.quarkus.qson.util.Types;
import io.quarkus.qson.writer.JsonByteWriter;
import io.quarkus.qson.writer.QsonObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QsonMapper
extends Generator
implements QsonGenerator {
    private ConcurrentHashMap<String, QsonParser> deserializers = new ConcurrentHashMap();
    private Map<String, String> generatedDeserializers = new HashMap<String, String>();
    private ConcurrentHashMap<String, QsonObjectWriter> serializers = new ConcurrentHashMap();
    private Map<String, String> generatedSerializers = new HashMap<String, String>();
    private final GizmoClassLoader cl;

    public QsonMapper() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public QsonMapper(ClassLoader parent) {
        this.cl = new GizmoClassLoader(parent);
    }

    public void parsersFor(Class ... classes) {
        for (Class clz : classes) {
            this.parserFor(clz);
        }
    }

    public QsonParser parserFor(GenericType type) {
        return this.parserFor(type.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QsonParser parserFor(Type genericType) {
        String key = this.key(genericType);
        QsonParser parser = this.deserializers.get(key);
        if (parser != null) {
            return parser;
        }
        ConcurrentHashMap<String, QsonParser> concurrentHashMap = this.deserializers;
        synchronized (concurrentHashMap) {
            parser = this.deserializers.get(key);
            if (parser != null) {
                return parser;
            }
            String className = this.generateDeserializers(genericType);
            try {
                Class<?> deserializer = this.cl.loadClass(className);
                parser = (QsonParser)deserializer.newInstance();
                this.deserializers.put(key, parser);
            }
            catch (Throwable e) {
                throw new QsonException(e);
            }
        }
        return parser;
    }

    public <T> T read(byte[] fullBuffer, Type genericType) {
        QsonParser parser = this.parserFor(genericType);
        return (T)parser.read(fullBuffer);
    }

    public <T> T read(byte[] fullBuffer, GenericType<T> type) {
        return this.read(fullBuffer, type.getType());
    }

    public <T> T read(String json, Type genericType) {
        return this.read(json.getBytes(JsonByteWriter.UTF8), genericType);
    }

    public <T> T read(String json, GenericType<T> type) {
        return this.read(json, type.getType());
    }

    public <T> T read(InputStream is, Type genericType) throws IOException {
        QsonParser parser = this.parserFor(genericType);
        return (T)parser.read(is);
    }

    public <T> T read(InputStream is, GenericType<T> type) throws IOException {
        return this.read(is, type.getType());
    }

    private String generateDeserializers(Type genericType) {
        String key = this.key(genericType);
        if (this.generatedDeserializers.containsKey(key)) {
            return this.generatedDeserializers.get(key);
        }
        ParserGenerator.Builder builder = this.parser(genericType).output(this.cl).generate();
        this.generatedDeserializers.put(key, builder.className());
        for (Type entry : builder.referenced()) {
            String refKey = this.key(entry);
            if (this.generatedDeserializers.containsKey(refKey)) continue;
            this.generateDeserializers(entry);
        }
        return builder.className();
    }

    public void writersFor(Type ... classes) {
        for (Type clz : classes) {
            this.writerFor(clz);
        }
    }

    public void writersFor(GenericType ... types) {
        for (GenericType type : types) {
            this.writerFor(type);
        }
    }

    public QsonObjectWriter writerFor(GenericType type) {
        return this.writerFor(type.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QsonObjectWriter writerFor(Type genericType) {
        String key = this.key(genericType);
        QsonObjectWriter writer = this.serializers.get(key);
        if (writer != null) {
            return writer;
        }
        ConcurrentHashMap<String, QsonObjectWriter> concurrentHashMap = this.serializers;
        synchronized (concurrentHashMap) {
            writer = this.serializers.get(key);
            if (writer != null) {
                return writer;
            }
            String className = this.generateSerializers(genericType);
            try {
                Class<?> serializer = this.cl.loadClass(className);
                writer = (QsonObjectWriter)serializer.newInstance();
                this.serializers.put(key, writer);
            }
            catch (Throwable e) {
                throw new QsonException(e);
            }
        }
        return writer;
    }

    public void writeStream(Type genericType, Object target, OutputStream stream) {
        QsonObjectWriter objectWriter = this.writerFor(genericType);
        objectWriter.writeStream(stream, target);
    }

    public void writeStream(GenericType type, Object target, OutputStream stream) {
        this.writeStream(type.getType(), target, stream);
    }

    public void writeStream(Object target, OutputStream stream) {
        this.writeStream(target.getClass(), target, stream);
    }

    public byte[] writeBytes(Type genericType, Object target) {
        QsonObjectWriter objectWriter = this.writerFor(genericType);
        return objectWriter.writeBytes(target);
    }

    public byte[] writeBytes(GenericType type, Object target) {
        return this.writeBytes(type.getType(), target);
    }

    public byte[] writeBytes(Object target) {
        return this.writeBytes(target.getClass(), target);
    }

    public String writeString(Type genericType, Object target) {
        QsonObjectWriter objectWriter = this.writerFor(genericType);
        return objectWriter.writeString(target);
    }

    public String writeString(GenericType type, Object target) {
        return this.writeString(type.getType(), target);
    }

    public String writeString(Object target) {
        return this.writeString(target.getClass(), target);
    }

    private String generateSerializers(Type genericType) {
        String key = this.key(genericType);
        if (this.generatedSerializers.containsKey(key)) {
            return this.generatedSerializers.get(key);
        }
        WriterGenerator.Builder builder = this.writer(genericType).output(this.cl).generate();
        this.generatedSerializers.put(key, builder.className());
        for (Type entry : builder.referenced()) {
            String refKey = this.key(entry);
            if (this.generatedSerializers.containsKey(refKey)) continue;
            this.generateSerializers(entry);
        }
        return builder.className();
    }

    private String key(Type genericType) {
        return Types.typename((Type)genericType);
    }
}

