/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qson.generator;

import io.quarkus.qson.generator.QsonGenerator;
import io.quarkus.qson.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Util {
    public static String generatedClassName(Type type) {
        return Util.generatedClassName("io.quarkus.qson.generated", type);
    }

    public static String generatedClassName(String packageName, Type type) {
        String name = type.getTypeName().replace(" ", "").replace(',', '$').replace("<", "_").replace(">", "").replace("java.util.", "").replace("java.lang.", "").replace('.', '_');
        return packageName + "." + name;
    }

    public static void addReference(QsonGenerator generator, Set<Type> referenceSet, Type type) {
        if (type instanceof Class) {
            Class clz = (Class)type;
            if (generator.hasMappingFor(clz) || Util.isUserType(generator, clz)) {
                referenceSet.add(type);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            if (Map.class.isAssignableFrom(Types.getRawType((Type)type))) {
                Util.addReference(generator, referenceSet, pt.getActualTypeArguments()[1]);
            } else {
                Util.addReference(generator, referenceSet, pt.getActualTypeArguments()[0]);
            }
        }
    }

    public static boolean isDateType(Class type) {
        return OffsetDateTime.class.equals((Object)type) || Date.class.equals((Object)type);
    }

    public static boolean isUserType(QsonGenerator generator, Class type) {
        if (type.isPrimitive()) {
            return false;
        }
        return !type.equals(String.class) && !type.equals(Integer.class) && !type.equals(Short.class) && !type.equals(Long.class) && !type.equals(Byte.class) && !type.equals(Boolean.class) && !type.equals(Double.class) && !type.equals(Float.class) && !type.equals(Character.class) && (!Util.isDateType(type) || generator.hasMappingFor(type)) && !Map.class.isAssignableFrom(type) && !List.class.isAssignableFrom(type) && !Set.class.isAssignableFrom(type);
    }
}

