/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qson.generator;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.qson.QsonDate;
import io.quarkus.qson.QsonException;
import io.quarkus.qson.generator.ClassMapping;
import io.quarkus.qson.generator.PropertyMapping;
import io.quarkus.qson.generator.QsonGenerator;
import io.quarkus.qson.generator.Util;
import io.quarkus.qson.util.Types;
import io.quarkus.qson.writer.CollectionWriter;
import io.quarkus.qson.writer.DateNumberWriter;
import io.quarkus.qson.writer.DateUtilStringWriter;
import io.quarkus.qson.writer.GenericObjectWriter;
import io.quarkus.qson.writer.JsonWriter;
import io.quarkus.qson.writer.MapWriter;
import io.quarkus.qson.writer.OffsetDateTimeStringWriter;
import io.quarkus.qson.writer.QsonObjectWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WriterGenerator {
    public static final String INIT = "<init>";
    public static final String CLINIT = "<clinit>";
    ClassCreator creator;
    Class targetType;
    Type targetGenericType;
    List<PropertyMapping> properties;
    String className;
    Method anyGetter;
    ClassMapping mapping;
    QsonGenerator generator;
    public static final String DEFAULT_OFFSET_DATE_TIME = "_defaultOffsetDateTime";
    public static final String DEFAULT_DATE_UTIL = "_defaultDateUtil";

    public static String name(Class clz, Type genericType) {
        return clz.getSimpleName() + "__Serializer";
    }

    public static String fqn(Class clz, Type genericType) {
        String prefix = "";
        if (clz.getName().startsWith("java")) {
            prefix = "io.quarkus.qson.";
        }
        return prefix + clz.getName() + "__Serializer";
    }

    WriterGenerator(ClassOutput classOutput, Class targetType, Type targetGenericType) {
        this(classOutput, WriterGenerator.fqn(targetType, targetGenericType), targetType, targetGenericType);
    }

    WriterGenerator(ClassOutput classOutput, String className, Class targetType, Type targetGenericType) {
        this.targetType = targetType;
        this.targetGenericType = targetGenericType;
        this.className = className;
        this.creator = ClassCreator.builder().classOutput(classOutput).className(className).interfaces(new Class[]{QsonObjectWriter.class}).build();
    }

    private String getPropertyDateWriter(PropertyMapping ref) {
        return ref.getPropertyName() + "_dateParser";
    }

    private ResultHandle allocateDateUtilWriter(BytecodeCreator scope, QsonDate.Format format, String pattern) {
        if (pattern != null) {
            return scope.newInstance(MethodDescriptor.ofConstructor(DateUtilStringWriter.class, (Class[])new Class[]{String.class}), new ResultHandle[]{scope.load(pattern)});
        }
        if (format == QsonDate.Format.MILLISECONDS) {
            return scope.readStaticField(FieldDescriptor.of(DateNumberWriter.class, (String)"DATE_UTIL_MILLISECONDS", QsonObjectWriter.class));
        }
        if (format == QsonDate.Format.SECONDS) {
            return scope.readStaticField(FieldDescriptor.of(DateNumberWriter.class, (String)"DATE_UTIL_SECONDS", QsonObjectWriter.class));
        }
        if (format == QsonDate.Format.ISO_8601_OFFSET_DATE_TIME) {
            return scope.readStaticField(FieldDescriptor.of(DateUtilStringWriter.class, (String)"ISO_8601_OFFSET_DATE_TIME", DateUtilStringWriter.class));
        }
        if (format == QsonDate.Format.RFC_1123_DATE_TIME) {
            return scope.readStaticField(FieldDescriptor.of(DateUtilStringWriter.class, (String)"RFC_1123_DATE_TIME", DateUtilStringWriter.class));
        }
        throw new QsonException("Unsupported");
    }

    private ResultHandle allocateOffsetDateTimeWriter(BytecodeCreator scope, QsonDate.Format format, String pattern) {
        if (pattern != null) {
            return scope.newInstance(MethodDescriptor.ofConstructor(OffsetDateTimeStringWriter.class, (Class[])new Class[]{String.class}), new ResultHandle[]{scope.load(pattern)});
        }
        if (format == QsonDate.Format.MILLISECONDS) {
            return scope.readStaticField(FieldDescriptor.of(DateNumberWriter.class, (String)"OFFSET_DATE_TIME_MILLISECONDS", QsonObjectWriter.class));
        }
        if (format == QsonDate.Format.SECONDS) {
            return scope.readStaticField(FieldDescriptor.of(DateNumberWriter.class, (String)"OFFSET_DATE_TIME_SECONDS", QsonObjectWriter.class));
        }
        if (format == QsonDate.Format.ISO_8601_OFFSET_DATE_TIME) {
            return scope.readStaticField(FieldDescriptor.of(OffsetDateTimeStringWriter.class, (String)"ISO_8601_OFFSET_DATE_TIME", OffsetDateTimeStringWriter.class));
        }
        if (format == QsonDate.Format.RFC_1123_DATE_TIME) {
            return scope.readStaticField(FieldDescriptor.of(OffsetDateTimeStringWriter.class, (String)"RFC_1123_DATE_TIME", OffsetDateTimeStringWriter.class));
        }
        throw new QsonException("Unsupported");
    }

    private void processDateProperties(MethodCreator staticConstructor) {
        FieldCreator defaultDateUtil = null;
        FieldCreator defaultOffsetDateTime = null;
        for (PropertyMapping ref : this.properties) {
            FieldCreator dateProperty;
            if (Types.typeContainsType((Type)ref.genericType, Date.class)) {
                if (ref.dateFormat == null) {
                    if (defaultDateUtil != null || this.generator.hasMappingFor(Date.class)) continue;
                    defaultDateUtil = (FieldCreator)this.creator.getFieldCreator(DEFAULT_DATE_UTIL, QsonObjectWriter.class).setModifiers(26);
                    staticConstructor.writeStaticField(defaultDateUtil.getFieldDescriptor(), this.allocateDateUtilWriter((BytecodeCreator)staticConstructor, this.generator.getDateFormat(), null));
                    continue;
                }
                dateProperty = (FieldCreator)this.creator.getFieldCreator(this.getPropertyDateWriter(ref), QsonObjectWriter.class).setModifiers(26);
                staticConstructor.writeStaticField(dateProperty.getFieldDescriptor(), this.allocateDateUtilWriter((BytecodeCreator)staticConstructor, ref.getDateFormat(), ref.getDatePattern()));
                continue;
            }
            if (!Types.typeContainsType((Type)ref.genericType, OffsetDateTime.class)) continue;
            if (ref.dateFormat == null) {
                if (defaultOffsetDateTime != null || this.generator.hasMappingFor(OffsetDateTime.class)) continue;
                defaultOffsetDateTime = (FieldCreator)this.creator.getFieldCreator(DEFAULT_OFFSET_DATE_TIME, QsonObjectWriter.class).setModifiers(26);
                staticConstructor.writeStaticField(defaultOffsetDateTime.getFieldDescriptor(), this.allocateOffsetDateTimeWriter((BytecodeCreator)staticConstructor, this.generator.getDateFormat(), null));
                continue;
            }
            dateProperty = (FieldCreator)this.creator.getFieldCreator(this.getPropertyDateWriter(ref), QsonObjectWriter.class).setModifiers(26);
            staticConstructor.writeStaticField(dateProperty.getFieldDescriptor(), this.allocateOffsetDateTimeWriter((BytecodeCreator)staticConstructor, ref.getDateFormat(), ref.getDatePattern()));
        }
    }

    void generateEnum() {
        FieldCreator SERIALIZER = (FieldCreator)this.creator.getFieldCreator("SERIALIZER", this.fqn()).setModifiers(9);
        MethodCreator staticConstructor = this.creator.getMethodCreator(CLINIT, Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor((String)this.fqn(), (String[])new String[0]), new ResultHandle[0]);
        staticConstructor.writeStaticField(SERIALIZER.getFieldDescriptor(), instance);
        staticConstructor.returnValue(null);
        MethodCreator method = this.creator.getMethodCreator("write", Void.TYPE, new Class[]{JsonWriter.class, Object.class});
        ResultHandle writer = method.getMethodParam(0);
        AssignableResultHandle target = method.createVariable(this.targetType);
        method.assign(target, method.getMethodParam(1));
        method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"write", Void.TYPE, (Class[])new Class[]{Enum.class}), writer, new ResultHandle[]{target});
        method.returnValue(null);
        this.creator.close();
    }

    void generateValueClass() {
        FieldCreator SERIALIZER = (FieldCreator)this.creator.getFieldCreator("SERIALIZER", this.fqn()).setModifiers(9);
        MethodCreator staticConstructor = this.creator.getMethodCreator(CLINIT, Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor((String)this.fqn(), (String[])new String[0]), new ResultHandle[0]);
        staticConstructor.writeStaticField(SERIALIZER.getFieldDescriptor(), instance);
        staticConstructor.returnValue(null);
        MethodCreator method = this.creator.getMethodCreator("write", Void.TYPE, new Class[]{JsonWriter.class, Object.class});
        ResultHandle jsonWriter = method.getMethodParam(0);
        AssignableResultHandle target = method.createVariable(this.targetType);
        method.assign(target, method.getMethodParam(1));
        Method valueGetter = this.mapping.getValueWriter();
        Class<?> type = valueGetter.getReturnType();
        boolean isStatic = Modifier.isStatic(valueGetter.getModifiers());
        ResultHandle val = isStatic ? method.invokeStaticMethod(MethodDescriptor.ofMethod((Method)valueGetter), new ResultHandle[]{target}) : method.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)valueGetter), (ResultHandle)target, new ResultHandle[0]);
        method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"write", Void.TYPE, (Class[])new Class[]{type}), jsonWriter, new ResultHandle[]{val});
        method.returnValue(null);
        this.creator.close();
    }

    void generate() {
        this.singleton();
        this.writeMethod();
        this.creator.close();
    }

    void generateCustom() {
        FieldCreator SERIALIZER = (FieldCreator)this.creator.getFieldCreator("SERIALIZER", this.fqn()).setModifiers(9);
        MethodCreator staticConstructor = this.creator.getMethodCreator(CLINIT, Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor((String)this.fqn(), (String[])new String[0]), new ResultHandle[0]);
        staticConstructor.writeStaticField(SERIALIZER.getFieldDescriptor(), instance);
        staticConstructor.returnValue(null);
        MethodCreator method = this.creator.getMethodCreator("write", Void.TYPE, new Class[]{JsonWriter.class, Object.class});
        ResultHandle jsonWriter = method.getMethodParam(0);
        ResultHandle target = method.getMethodParam(1);
        ResultHandle wrapped = this.mapping.getCustomWriter() != null ? method.newInstance(MethodDescriptor.ofConstructor((Class)this.mapping.getCustomWriter(), (Class[])new Class[0]), new ResultHandle[0]) : method.readStaticField(FieldDescriptor.of((Field)this.mapping.getCustomWriterField()));
        method.invokeInterfaceMethod(MethodDescriptor.ofMethod(QsonObjectWriter.class, (String)"write", Void.TYPE, (Class[])new Class[]{JsonWriter.class, Object.class}), wrapped, new ResultHandle[]{jsonWriter, target});
        method.returnValue(null);
        this.creator.close();
    }

    void generateCollection() {
        MethodCreator staticConstructor = this.creator.getMethodCreator(CLINIT, Void.TYPE, new Class[0]);
        if (Types.typeContainsType((Type)this.targetGenericType, Date.class) && !this.generator.hasMappingFor(Date.class)) {
            FieldCreator defaultDateUtil = (FieldCreator)this.creator.getFieldCreator(DEFAULT_DATE_UTIL, QsonObjectWriter.class).setModifiers(26);
            staticConstructor.writeStaticField(defaultDateUtil.getFieldDescriptor(), this.allocateDateUtilWriter((BytecodeCreator)staticConstructor, this.generator.getDateFormat(), null));
        } else if (Types.typeContainsType((Type)this.targetGenericType, OffsetDateTime.class) && !this.generator.hasMappingFor(OffsetDateTime.class)) {
            FieldCreator defaultOffsetDateTime = (FieldCreator)this.creator.getFieldCreator(DEFAULT_OFFSET_DATE_TIME, QsonObjectWriter.class).setModifiers(26);
            staticConstructor.writeStaticField(defaultOffsetDateTime.getFieldDescriptor(), this.allocateOffsetDateTimeWriter((BytecodeCreator)staticConstructor, this.generator.getDateFormat(), null));
        }
        staticConstructor.setModifiers(8);
        this.collectionProperty(null, staticConstructor, this.targetType, this.targetGenericType, "collection");
        staticConstructor.returnValue(null);
        MethodCreator method = this.creator.getMethodCreator("write", Void.TYPE, new Class[]{JsonWriter.class, Object.class});
        ResultHandle jsonWriter = method.getMethodParam(0);
        AssignableResultHandle target = method.createVariable(this.targetType);
        method.assign(target, method.getMethodParam(1));
        if (Map.class.isAssignableFrom(this.targetType)) {
            if (WriterGenerator.hasCollectionWriter(this.generator, this.targetType, this.targetGenericType)) {
                ResultHandle writer = this.getMapWriter(null, method, "collection", this.targetGenericType);
                method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"write", Void.TYPE, (Class[])new Class[]{Map.class, QsonObjectWriter.class}), jsonWriter, new ResultHandle[]{target, writer});
            } else {
                method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"write", Void.TYPE, (Class[])new Class[]{Map.class}), jsonWriter, new ResultHandle[]{target});
            }
        } else if (WriterGenerator.hasCollectionWriter(this.generator, this.targetType, this.targetGenericType)) {
            ResultHandle writer = this.getCollectionWriter(null, method, "collection", this.targetGenericType);
            method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"write", Void.TYPE, (Class[])new Class[]{Collection.class, QsonObjectWriter.class}), jsonWriter, new ResultHandle[]{target, writer});
        } else {
            method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"write", Void.TYPE, (Class[])new Class[]{Collection.class}), jsonWriter, new ResultHandle[]{target});
        }
        method.returnValue(null);
        this.creator.close();
    }

    private void singleton() {
        FieldCreator SERIALIZER = (FieldCreator)this.creator.getFieldCreator("SERIALIZER", this.fqn()).setModifiers(9);
        MethodCreator staticConstructor = this.creator.getMethodCreator(CLINIT, Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor((String)this.fqn(), (String[])new String[0]), new ResultHandle[0]);
        staticConstructor.writeStaticField(SERIALIZER.getFieldDescriptor(), instance);
        this.processDateProperties(staticConstructor);
        for (PropertyMapping getter : this.properties) {
            this.collectionField(staticConstructor, getter);
        }
        staticConstructor.returnValue(null);
    }

    private void collectionField(MethodCreator staticConstructor, PropertyMapping getter) {
        Type genericType = getter.genericType;
        Class type = getter.type;
        String property = getter.propertyName;
        this.collectionProperty(getter, staticConstructor, type, genericType, property);
    }

    private void collectionProperty(PropertyMapping ref, MethodCreator staticConstructor, Class type, Type genericType, String property) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt;
            Type valueType;
            Class valueClass;
            if (Map.class.isAssignableFrom(type)) {
                ParameterizedType pt2 = (ParameterizedType)genericType;
                Type valueType2 = pt2.getActualTypeArguments()[1];
                Class valueClass2 = Types.getRawType((Type)valueType2);
                if (WriterGenerator.hasNestedWriter(this.generator, valueClass2, valueType2)) {
                    this.collectionField(ref, staticConstructor, valueClass2, valueType2, property + "_n");
                }
            } else if ((List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type)) && WriterGenerator.hasNestedWriter(this.generator, valueClass = Types.getRawType((Type)(valueType = (pt = (ParameterizedType)genericType).getActualTypeArguments()[0])), valueType)) {
                this.collectionField(ref, staticConstructor, valueClass, valueType, property + "_n");
            }
        }
    }

    private ResultHandle getNestedValueWriter(PropertyMapping ref, MethodCreator staticConstructor, Class type, Type genericType, String property) {
        if (Util.isDateType(type) && !this.generator.hasMappingFor(type)) {
            if (type.equals(OffsetDateTime.class)) {
                return this.getOffsetDateTimeWriter(ref, (BytecodeCreator)staticConstructor);
            }
            if (type.equals(Date.class)) {
                return this.getDateUtilWriter(ref, (BytecodeCreator)staticConstructor);
            }
        }
        if (!WriterGenerator.hasNestedWriter(this.generator, type, genericType)) {
            return null;
        }
        if (Util.isUserType(this.generator, type)) {
            return staticConstructor.readStaticField(FieldDescriptor.of((String)WriterGenerator.fqn(type, genericType), (String)"SERIALIZER", (String)WriterGenerator.fqn(type, genericType)));
        }
        this.collectionField(ref, staticConstructor, type, genericType, property);
        return staticConstructor.readStaticField(FieldDescriptor.of((String)this.fqn(), (String)property, QsonObjectWriter.class));
    }

    private void collectionField(PropertyMapping ref, MethodCreator staticConstructor, Class type, Type genericType, String property) {
        if (genericType instanceof ParameterizedType) {
            if (Map.class.isAssignableFrom(type)) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type valueType = pt.getActualTypeArguments()[1];
                Class valueClass = Types.getRawType((Type)valueType);
                ResultHandle nested = this.getNestedValueWriter(ref, staticConstructor, valueClass, valueType, property + "_n");
                if (nested == null) {
                    return;
                }
                FieldCreator mapWriter = (FieldCreator)this.creator.getFieldCreator(property, QsonObjectWriter.class).setModifiers(26);
                ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor(MapWriter.class, (Class[])new Class[]{QsonObjectWriter.class}), new ResultHandle[]{nested});
                staticConstructor.writeStaticField(mapWriter.getFieldDescriptor(), instance);
            } else if (List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type)) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type valueType = pt.getActualTypeArguments()[0];
                Class valueClass = Types.getRawType((Type)valueType);
                ResultHandle nested = this.getNestedValueWriter(ref, staticConstructor, valueClass, valueType, property + "_n");
                if (nested == null) {
                    return;
                }
                FieldCreator mapWriter = (FieldCreator)this.creator.getFieldCreator(property, QsonObjectWriter.class).setModifiers(26);
                ResultHandle instance = staticConstructor.newInstance(MethodDescriptor.ofConstructor(CollectionWriter.class, (Class[])new Class[]{QsonObjectWriter.class}), new ResultHandle[]{nested});
                staticConstructor.writeStaticField(mapWriter.getFieldDescriptor(), instance);
            }
        }
    }

    private ResultHandle getOffsetDateTimeWriter(PropertyMapping ref, BytecodeCreator scope) {
        String field = DEFAULT_OFFSET_DATE_TIME;
        if (ref != null && ref.getDateFormat() != null) {
            field = this.getPropertyDateWriter(ref);
        }
        FieldDescriptor parserField = FieldDescriptor.of((String)this.fqn(), (String)field, QsonObjectWriter.class);
        return scope.readStaticField(parserField);
    }

    private ResultHandle getDateUtilWriter(PropertyMapping ref, BytecodeCreator scope) {
        String field = DEFAULT_DATE_UTIL;
        if (ref != null && ref.getDateFormat() != null) {
            field = this.getPropertyDateWriter(ref);
        }
        FieldDescriptor parserField = FieldDescriptor.of((String)this.fqn(), (String)field, QsonObjectWriter.class);
        return scope.readStaticField(parserField);
    }

    private void writeMethod() {
        MethodCreator method = this.creator.getMethodCreator("write", Void.TYPE, new Class[]{JsonWriter.class, Object.class});
        ResultHandle jsonWriter = method.getMethodParam(0);
        AssignableResultHandle target = method.createVariable(this.targetType);
        method.assign(target, method.getMethodParam(1));
        AssignableResultHandle comma = method.createVariable(Boolean.TYPE);
        method.assign(comma, method.load(false));
        boolean forceComma = false;
        method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeLCurley", Void.TYPE, (Class[])new Class[0]), jsonWriter, new ResultHandle[0]);
        for (PropertyMapping getter : this.properties) {
            ResultHandle result;
            if (getter.type.equals(Integer.TYPE)) {
                method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Void.TYPE, (Class[])new Class[]{String.class, Integer.TYPE, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, method.load(true));
                forceComma = true;
                continue;
            }
            if (getter.type.equals(Integer.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Integer.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(Short.TYPE)) {
                method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Void.TYPE, (Class[])new Class[]{String.class, Short.TYPE, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, method.load(true));
                forceComma = true;
                continue;
            }
            if (getter.type.equals(Short.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Short.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(Long.TYPE)) {
                method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Void.TYPE, (Class[])new Class[]{String.class, Long.TYPE, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, method.load(true));
                forceComma = true;
                continue;
            }
            if (getter.type.equals(Long.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Long.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(Byte.TYPE)) {
                method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Void.TYPE, (Class[])new Class[]{String.class, Byte.TYPE, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, method.load(true));
                forceComma = true;
                continue;
            }
            if (getter.type.equals(Byte.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Byte.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(Boolean.TYPE)) {
                method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Void.TYPE, (Class[])new Class[]{String.class, Boolean.TYPE, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, method.load(true));
                forceComma = true;
                continue;
            }
            if (getter.type.equals(Boolean.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Boolean.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(Float.TYPE)) {
                method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Void.TYPE, (Class[])new Class[]{String.class, Float.TYPE, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, method.load(true));
                forceComma = true;
                continue;
            }
            if (getter.type.equals(Float.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Float.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(Double.TYPE)) {
                method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Void.TYPE, (Class[])new Class[]{String.class, Double.TYPE, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, method.load(true));
                forceComma = true;
                continue;
            }
            if (getter.type.equals(Double.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Double.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(Character.TYPE)) {
                method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Void.TYPE, (Class[])new Class[]{String.class, Character.TYPE, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, method.load(true));
                forceComma = true;
                continue;
            }
            if (getter.type.equals(Character.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Character.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(String.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, String.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (Map.class.isAssignableFrom(getter.type)) {
                if (WriterGenerator.hasCollectionWriter(this.generator, getter)) {
                    result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Map.class, QsonObjectWriter.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), this.getMapWriter(method, getter), comma});
                    if (forceComma) continue;
                    method.assign(comma, result);
                    continue;
                }
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Map.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (Collection.class.isAssignableFrom(getter.type)) {
                if (WriterGenerator.hasCollectionWriter(this.generator, getter)) {
                    result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Collection.class, QsonObjectWriter.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), this.getCollectionWriter(method, getter), comma});
                    if (forceComma) continue;
                    method.assign(comma, result);
                    continue;
                }
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Collection.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(Object.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeObjectProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Object.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(OffsetDateTime.class) && !this.generator.hasMappingFor(OffsetDateTime.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeObjectProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Object.class, QsonObjectWriter.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), this.getOffsetDateTimeWriter(getter, (BytecodeCreator)method), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            if (getter.type.equals(Date.class) && !this.generator.hasMappingFor(Date.class)) {
                result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeObjectProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Object.class, QsonObjectWriter.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), this.getDateUtilWriter(getter, (BytecodeCreator)method), comma});
                if (forceComma) continue;
                method.assign(comma, result);
                continue;
            }
            result = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeObjectProperty", Boolean.TYPE, (Class[])new Class[]{String.class, Object.class, QsonObjectWriter.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.load(getter.jsonName), method.invokeVirtualMethod(MethodDescriptor.ofMethod((Class)this.targetType, (String)getter.getter.getName(), (Class)getter.type, (Class[])new Class[0]), (ResultHandle)target, new ResultHandle[0]), method.readStaticField(FieldDescriptor.of((String)WriterGenerator.fqn(getter.type, getter.genericType), (String)"SERIALIZER", (String)WriterGenerator.fqn(getter.type, getter.genericType))), comma});
            if (forceComma) continue;
            method.assign(comma, result);
        }
        if (this.anyGetter != null) {
            method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeAny", Boolean.TYPE, (Class[])new Class[]{Map.class, Boolean.TYPE}), jsonWriter, new ResultHandle[]{method.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)this.anyGetter), (ResultHandle)target, new ResultHandle[0]), comma});
        }
        method.invokeInterfaceMethod(MethodDescriptor.ofMethod(JsonWriter.class, (String)"writeRCurley", Void.TYPE, (Class[])new Class[0]), jsonWriter, new ResultHandle[0]);
        method.returnValue(null);
    }

    private ResultHandle getCollectionWriter(MethodCreator method, PropertyMapping getter) {
        String property = getter.propertyName;
        Type genericType = getter.genericType;
        return this.getCollectionWriter(getter, method, property, (ParameterizedType)genericType);
    }

    private ResultHandle getCollectionWriter(PropertyMapping ref, MethodCreator method, String property, Type genericType) {
        ParameterizedType pt = (ParameterizedType)genericType;
        Class valueClass = Types.getRawType((Type)pt.getActualTypeArguments()[0]);
        Type valueType = pt.getActualTypeArguments()[0];
        return this.getWriter(ref, method, property, valueClass, valueType);
    }

    private ResultHandle getWriter(PropertyMapping ref, MethodCreator method, String property, Class valueClass, Type valueType) {
        if (Util.isDateType(valueClass) && !this.generator.hasMappingFor(valueClass)) {
            if (valueClass.equals(OffsetDateTime.class)) {
                return this.getOffsetDateTimeWriter(ref, (BytecodeCreator)method);
            }
            if (valueClass.equals(Date.class)) {
                return this.getDateUtilWriter(ref, (BytecodeCreator)method);
            }
            throw new QsonException("Should be unreachable");
        }
        if (Util.isUserType(this.generator, valueClass)) {
            return method.readStaticField(FieldDescriptor.of((String)WriterGenerator.fqn(valueClass, valueType), (String)"SERIALIZER", (String)WriterGenerator.fqn(valueClass, valueType)));
        }
        return method.readStaticField(FieldDescriptor.of((String)this.fqn(), (String)(property + "_n"), QsonObjectWriter.class));
    }

    private ResultHandle getMapWriter(MethodCreator method, PropertyMapping getter) {
        String property = getter.propertyName;
        Type genericType = getter.genericType;
        return this.getMapWriter(getter, method, property, (ParameterizedType)genericType);
    }

    private ResultHandle getMapWriter(PropertyMapping ref, MethodCreator method, String property, Type genericType) {
        ParameterizedType pt = (ParameterizedType)genericType;
        Class valueClass = Types.getRawType((Type)pt.getActualTypeArguments()[1]);
        Type valueType = pt.getActualTypeArguments()[1];
        return this.getWriter(ref, method, property, valueClass, valueType);
    }

    private static boolean isGeneric(QsonGenerator generator, Class type, Type generic) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.equals(String.class) || type.equals(Integer.class) || type.equals(Short.class) || type.equals(Long.class) || type.equals(Byte.class) || type.equals(Boolean.class) || type.equals(Double.class) || type.equals(Float.class) || type.equals(Character.class)) {
            return true;
        }
        if (Map.class.isAssignableFrom(type) || List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type)) {
            return !WriterGenerator.hasCollectionWriter(generator, type, generic);
        }
        return false;
    }

    private static boolean hasCollectionWriter(QsonGenerator generator, PropertyMapping getter) {
        Class type = getter.type;
        Type genericType = getter.genericType;
        return WriterGenerator.hasCollectionWriter(generator, type, genericType);
    }

    private static boolean hasCollectionWriter(QsonGenerator generator, Class type, Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        if (Map.class.isAssignableFrom(type)) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Type valueType = pt.getActualTypeArguments()[1];
            Class valueClass = Types.getRawType((Type)valueType);
            return WriterGenerator.hasNestedWriter(generator, valueClass, valueType);
        }
        if (Collection.class.isAssignableFrom(type)) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Class valueClass = Types.getRawType((Type)pt.getActualTypeArguments()[0]);
            Type valueGenericType = pt.getActualTypeArguments()[0];
            return WriterGenerator.hasNestedWriter(generator, valueClass, valueGenericType);
        }
        return false;
    }

    private static boolean hasNestedWriter(QsonGenerator generator, Class type, Type genericType) {
        if (Util.isDateType(type)) {
            return true;
        }
        if (Util.isUserType(generator, type)) {
            return true;
        }
        if (!(Map.class.isAssignableFrom(type) || List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type))) {
            return false;
        }
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        if (Map.class.isAssignableFrom(type)) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Class valueClass = Types.getRawType((Type)pt.getActualTypeArguments()[1]);
            Type valueGenericType = pt.getActualTypeArguments()[1];
            return WriterGenerator.hasNestedWriter(generator, valueClass, valueGenericType);
        }
        if (Collection.class.isAssignableFrom(type)) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Class valueClass = Types.getRawType((Type)pt.getActualTypeArguments()[0]);
            Type valueGenericType = pt.getActualTypeArguments()[0];
            return WriterGenerator.hasNestedWriter(generator, valueClass, valueGenericType);
        }
        return false;
    }

    private String fqn() {
        return this.className;
    }

    public static class Builder {
        Type type;
        ClassOutput output;
        String className;
        Set<Type> referenced = new HashSet<Type>();
        List<PropertyMapping> properties;
        QsonGenerator generator;
        ClassMapping classGen;

        Builder(QsonGenerator generator) {
            this.generator = generator;
        }

        public Builder type(Type targetType) {
            this.type = targetType;
            return this;
        }

        public Builder output(ClassOutput output) {
            this.output = output;
            return this;
        }

        public String className() {
            return this.className;
        }

        public Set<Type> referenced() {
            return this.referenced;
        }

        public Builder properties(List<PropertyMapping> properties) {
            this.properties = properties;
            return this;
        }

        public List<PropertyMapping> properties() {
            return this.properties;
        }

        public Builder generate() {
            Class targetType;
            if (this.type instanceof Class) {
                Class targetType2 = (Class)this.type;
                if (WriterGenerator.isGeneric(this.generator, targetType2, this.type)) {
                    this.className = GenericObjectWriter.class.getName();
                    return this;
                }
                if (targetType2.isEnum()) {
                    WriterGenerator s = new WriterGenerator(this.output, targetType2, this.type);
                    s.generateEnum();
                    this.className = WriterGenerator.fqn(targetType2, this.type);
                    return this;
                }
                WriterGenerator s = new WriterGenerator(this.output, targetType2, this.type);
                s.mapping = this.classGen = this.generator.mappingFor(targetType2);
                s.generator = this.generator;
                if (this.classGen != null) {
                    if (this.classGen.isValue()) {
                        s.generateValueClass();
                        this.className = WriterGenerator.fqn(targetType2, this.type);
                        return this;
                    }
                    if (this.classGen.hasCustomWriter()) {
                        s.generateCustom();
                        this.className = WriterGenerator.fqn(targetType2, this.type);
                        return this;
                    }
                    this.properties = this.classGen.getProperties();
                }
                ArrayList<PropertyMapping> tmp = new ArrayList<PropertyMapping>();
                Method anyGetter = null;
                for (PropertyMapping ref : this.properties) {
                    if (ref.getter == null) continue;
                    if (ref.isAny) {
                        anyGetter = ref.getter;
                        continue;
                    }
                    tmp.add(ref);
                    Util.addReference(this.generator, this.referenced, ref.genericType);
                }
                s.properties = tmp;
                s.anyGetter = anyGetter;
                s.generate();
                this.className = WriterGenerator.fqn(targetType2, this.type);
                return this;
            }
            if (this.type instanceof ParameterizedType && (Map.class.isAssignableFrom(targetType = Types.getRawType((Type)this.type)) || List.class.isAssignableFrom(targetType) || Set.class.isAssignableFrom(targetType))) {
                if (WriterGenerator.hasCollectionWriter(this.generator, targetType, this.type)) {
                    if (this.className == null) {
                        this.className = Util.generatedClassName(this.type);
                        this.className = this.className + "__Serializer";
                    }
                    WriterGenerator s = new WriterGenerator(this.output, this.className, targetType, this.type);
                    s.generateCollection();
                    Util.addReference(this.generator, this.referenced, this.type);
                    return this;
                }
                this.className = GenericObjectWriter.class.getName();
                return this;
            }
            throw new QsonException("Unsupported generic type for serializer generation: " + this.type.getTypeName());
        }
    }
}

