/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.deployment;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.security.AgroalDefaultSecurityProvider;
import io.agroal.api.security.AgroalKerberosSecurityProvider;
import io.agroal.api.security.AgroalSecurityProvider;
import io.agroal.pool.ConnectionHandler;
import io.quarkus.agroal.DataSource;
import io.quarkus.agroal.deployment.DataSourceDriverBuildItem;
import io.quarkus.agroal.deployment.DataSourceInitializedBuildItem;
import io.quarkus.agroal.runtime.AbstractDataSourceProducer;
import io.quarkus.agroal.runtime.AgroalBuildTimeConfig;
import io.quarkus.agroal.runtime.AgroalRecorder;
import io.quarkus.agroal.runtime.AgroalRuntimeConfig;
import io.quarkus.agroal.runtime.DataSourceBuildTimeConfig;
import io.quarkus.agroal.runtime.TransactionIntegration;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.sql.XADataSource;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class AgroalProcessor {
    private static final Logger log = Logger.getLogger(AgroalProcessor.class);
    private static final Set<DotName> UNREMOVABLE_BEANS = new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)AbstractDataSourceProducer.class.getName()), DotName.createSimple((String)javax.sql.DataSource.class.getName())));
    AgroalBuildTimeConfig agroalBuildTimeConfig;

    AgroalProcessor() {
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    BeanContainerListenerBuildItem build(RecorderContext recorderContext, AgroalRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<DataSourceDriverBuildItem> dataSourceDriver, SslNativeConfigBuildItem sslNativeConfig, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<GeneratedBeanBuildItem> generatedBean) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("agroal"));
        if (!this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent() && this.agroalBuildTimeConfig.namedDataSources.isEmpty()) {
            log.warn((Object)"Agroal dependency is present but no driver has been defined for the default datasource");
            return null;
        }
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/" + AgroalSecurityProvider.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ConnectionHandler[].class.getName(), ConnectionHandler.class.getName(), AgroalDefaultSecurityProvider.class.getName(), AgroalKerberosSecurityProvider.class.getName(), Statement[].class.getName(), Statement.class.getName(), ResultSet.class.getName(), ResultSet[].class.getName()}));
        AgroalProcessor.validateBuildTimeConfig(null, this.agroalBuildTimeConfig.defaultDataSource);
        this.agroalBuildTimeConfig.namedDataSources.forEach(AgroalProcessor::validateBuildTimeConfig);
        if (this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{(String)this.agroalBuildTimeConfig.defaultDataSource.driver.get()}));
            dataSourceDriver.produce((BuildItem)new DataSourceDriverBuildItem((String)this.agroalBuildTimeConfig.defaultDataSource.driver.get()));
        }
        for (Map.Entry namedDataSourceEntry : this.agroalBuildTimeConfig.namedDataSources.entrySet()) {
            if (!((DataSourceBuildTimeConfig)namedDataSourceEntry.getValue()).driver.isPresent()) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{(String)((DataSourceBuildTimeConfig)namedDataSourceEntry.getValue()).driver.get()}));
        }
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem("agroal"));
        String dataSourceProducerClassName = AbstractDataSourceProducer.class.getPackage().getName() + ".DataSourceProducer";
        this.createDataSourceProducerBean(generatedBean, dataSourceProducerClassName);
        return new BeanContainerListenerBuildItem(recorder.addDataSource(recorderContext.classProxy(dataSourceProducerClassName), this.agroalBuildTimeConfig, sslNativeConfig.isExplicitlyDisabled()));
    }

    private static void validateBuildTimeConfig(String datasourceName, DataSourceBuildTimeConfig ds) {
        Class<?> driver;
        if (!ds.driver.isPresent()) {
            if (datasourceName != null) {
                throw new DeploymentException("Named datasource '" + datasourceName + "' doesn't have a driver defined.");
            }
            return;
        }
        String driverName = (String)ds.driver.get();
        try {
            driver = Class.forName(driverName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (datasourceName == null) {
                throw new DeploymentException("Unable to load the datasource driver for the default datasource", (Throwable)e);
            }
            throw new DeploymentException("Unable to load the datasource driver for datasource named '" + datasourceName + "'", (Throwable)e);
        }
        if (ds.transactions == TransactionIntegration.XA) {
            if (!XADataSource.class.isAssignableFrom(driver)) {
                if (datasourceName == null) {
                    throw new DeploymentException("Driver is not an XA dataSource, while XA has been enabled in the configuration of the default datasource: either disable XA or switch the driver to an XADataSource");
                }
                throw new DeploymentException("Driver is not an XA dataSource, while XA has been enabled in the configuration of the datasource named '" + datasourceName + "': either disable XA or switch the driver to an XADataSource");
            }
        } else if (driver != null && !javax.sql.DataSource.class.isAssignableFrom(driver) && !Driver.class.isAssignableFrom(driver)) {
            if (datasourceName == null) {
                throw new DeploymentException("Driver is an XA dataSource, but XA transactions have not been enabled on the default datasource; please either set 'quarkus.datasource.xa=true' or switch to a standard non-XA JDBC driver implementation");
            }
            throw new DeploymentException("Driver is an XA dataSource, but XA transactions have not been enabled on the datasource named '" + datasourceName + "'; please either set 'quarkus.datasource." + datasourceName + ".xa=true' or switch to a standard non-XA JDBC driver implementation");
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configureRuntimeProperties(AgroalRecorder recorder, BuildProducer<DataSourceInitializedBuildItem> dataSourceInitialized, AgroalRuntimeConfig agroalRuntimeConfig) {
        if (!this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent() && this.agroalBuildTimeConfig.namedDataSources.isEmpty()) {
            return;
        }
        recorder.configureRuntimeProperties(agroalRuntimeConfig);
        dataSourceInitialized.produce((BuildItem)new DataSourceInitializedBuildItem());
    }

    @BuildStep
    UnremovableBeanBuildItem markBeansAsUnremovable() {
        return new UnremovableBeanBuildItem(beanInfo -> {
            Set types = beanInfo.getTypes();
            for (Type t : types) {
                if (!UNREMOVABLE_BEANS.contains(t.name())) continue;
                return true;
            }
            return false;
        });
    }

    private void createDataSourceProducerBean(final BuildProducer<GeneratedBeanBuildItem> generatedBean, String dataSourceProducerClassName) {
        ClassOutput classOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                generatedBean.produce((BuildItem)new GeneratedBeanBuildItem(name, data));
            }
        };
        ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(dataSourceProducerClassName).superClass(AbstractDataSourceProducer.class).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        if (this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent()) {
            MethodCreator defaultDataSourceMethodCreator = classCreator.getMethodCreator("createDefaultDataSource", AgroalDataSource.class, new Class[0]);
            defaultDataSourceMethodCreator.addAnnotation(ApplicationScoped.class);
            defaultDataSourceMethodCreator.addAnnotation(Produces.class);
            defaultDataSourceMethodCreator.addAnnotation(Default.class);
            ResultHandle dataSourceName = defaultDataSourceMethodCreator.load("<default>");
            ResultHandle dataSourceBuildTimeConfig = defaultDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getDefaultBuildTimeConfig", DataSourceBuildTimeConfig.class, (Class[])new Class[0]), defaultDataSourceMethodCreator.getThis(), new ResultHandle[0]);
            ResultHandle dataSourceRuntimeConfig = defaultDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getDefaultRuntimeConfig", Optional.class, (Class[])new Class[0]), defaultDataSourceMethodCreator.getThis(), new ResultHandle[0]);
            defaultDataSourceMethodCreator.returnValue(defaultDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"createDataSource", AgroalDataSource.class, (Class[])new Class[]{String.class, DataSourceBuildTimeConfig.class, Optional.class}), defaultDataSourceMethodCreator.getThis(), new ResultHandle[]{dataSourceName, dataSourceBuildTimeConfig, dataSourceRuntimeConfig}));
        }
        for (Map.Entry namedDataSourceEntry : this.agroalBuildTimeConfig.namedDataSources.entrySet()) {
            String namedDataSourceName = (String)namedDataSourceEntry.getKey();
            if (!((DataSourceBuildTimeConfig)namedDataSourceEntry.getValue()).driver.isPresent()) {
                log.warn((Object)("No driver defined for named datasource " + namedDataSourceName + ". Ignoring."));
                continue;
            }
            MethodCreator namedDataSourceMethodCreator = classCreator.getMethodCreator("createNamedDataSource_" + HashUtil.sha1((String)namedDataSourceName), AgroalDataSource.class, new Class[0]);
            namedDataSourceMethodCreator.addAnnotation(ApplicationScoped.class);
            namedDataSourceMethodCreator.addAnnotation(Produces.class);
            namedDataSourceMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)namedDataSourceName)}));
            namedDataSourceMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DotName.createSimple((String)DataSource.class.getName()), null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)namedDataSourceName)}));
            ResultHandle namedDataSourceNameRH = namedDataSourceMethodCreator.load(namedDataSourceName);
            ResultHandle namedDataSourceBuildTimeConfig = namedDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getBuildTimeConfig", DataSourceBuildTimeConfig.class, (Class[])new Class[]{String.class}), namedDataSourceMethodCreator.getThis(), new ResultHandle[]{namedDataSourceNameRH});
            ResultHandle namedDataSourceRuntimeConfig = namedDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getRuntimeConfig", Optional.class, (Class[])new Class[]{String.class}), namedDataSourceMethodCreator.getThis(), new ResultHandle[]{namedDataSourceNameRH});
            namedDataSourceMethodCreator.returnValue(namedDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"createDataSource", AgroalDataSource.class, (Class[])new Class[]{String.class, DataSourceBuildTimeConfig.class, Optional.class}), namedDataSourceMethodCreator.getThis(), new ResultHandle[]{namedDataSourceNameRH, namedDataSourceBuildTimeConfig, namedDataSourceRuntimeConfig}));
        }
        classCreator.close();
    }

    @BuildStep
    HealthBuildItem addHealthCheck(AgroalBuildTimeConfig agroalBuildTimeConfig) {
        return new HealthBuildItem("io.quarkus.agroal.runtime.health.DataSourceHealthCheck", agroalBuildTimeConfig.healthEnabled, "datasource");
    }
}

