/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.deployment;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.api.security.AgroalDefaultSecurityProvider;
import io.agroal.api.security.AgroalKerberosSecurityProvider;
import io.agroal.api.security.AgroalSecurityProvider;
import io.agroal.pool.ConnectionHandler;
import io.quarkus.agroal.DataSource;
import io.quarkus.agroal.deployment.AggregatedDataSourceBuildTimeConfigBuildItem;
import io.quarkus.agroal.runtime.AgroalRecorder;
import io.quarkus.agroal.runtime.DataSourceJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.DataSourceSupport;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.runtime.DataSourcesJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.TransactionIntegration;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import javax.sql.XADataSource;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

class AgroalProcessor {
    private static final Logger log = Logger.getLogger(AgroalProcessor.class);
    private static final DotName DATA_SOURCE = DotName.createSimple((String)javax.sql.DataSource.class.getName());

    AgroalProcessor() {
    }

    @BuildStep
    void agroal(BuildProducer<FeatureBuildItem> feature, BuildProducer<CapabilityBuildItem> capability) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.AGROAL));
        capability.produce((BuildItem)new CapabilityBuildItem(Capability.AGROAL));
    }

    @BuildStep
    void build(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDbKinds, List<JdbcDriverBuildItem> jdbcDriverBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedConfig, CurateOutcomeBuildItem curateOutcomeBuildItem) throws Exception {
        if (dataSourcesBuildTimeConfig.driver.isPresent() || dataSourcesBuildTimeConfig.url.isPresent()) {
            throw new ConfigurationException("quarkus.datasource.url and quarkus.datasource.driver have been deprecated in Quarkus 1.3 and removed in 1.9. Please use the new datasource configuration as explained in https://quarkus.io/guides/datasource.");
        }
        List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedDataSourceBuildTimeConfigs = this.getAggregatedConfigBuildItems(dataSourcesBuildTimeConfig, dataSourcesJdbcBuildTimeConfig, curateOutcomeBuildItem, jdbcDriverBuildItems, defaultDbKinds);
        if (aggregatedDataSourceBuildTimeConfigs.isEmpty()) {
            log.warn((Object)"The Agroal dependency is present but no JDBC datasources have been defined.");
            return;
        }
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedDataSourceBuildTimeConfig : aggregatedDataSourceBuildTimeConfigs) {
            AgroalProcessor.validateBuildTimeConfig(aggregatedDataSourceBuildTimeConfig);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{aggregatedDataSourceBuildTimeConfig.getResolvedDriverClass()}));
            aggregatedConfig.produce((BuildItem)aggregatedDataSourceBuildTimeConfig);
        }
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/" + AgroalSecurityProvider.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ConnectionHandler[].class.getName(), ConnectionHandler.class.getName(), AgroalDefaultSecurityProvider.class.getName(), AgroalKerberosSecurityProvider.class.getName(), Statement[].class.getName(), Statement.class.getName(), ResultSet.class.getName(), ResultSet[].class.getName()}));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.AGROAL.getName()));
    }

    private static void validateBuildTimeConfig(AggregatedDataSourceBuildTimeConfigBuildItem aggregatedConfig) {
        Class<?> driver;
        DataSourceJdbcBuildTimeConfig jdbcBuildTimeConfig = aggregatedConfig.getJdbcConfig();
        String fullDataSourceName = aggregatedConfig.isDefault() ? "default datasource" : "datasource named '" + aggregatedConfig.getName() + "'";
        String driverName = aggregatedConfig.getResolvedDriverClass();
        try {
            driver = Class.forName(driverName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Unable to load the datasource driver " + driverName + " for the " + fullDataSourceName, (Throwable)e);
        }
        if (jdbcBuildTimeConfig.transactions == TransactionIntegration.XA) {
            if (!XADataSource.class.isAssignableFrom(driver)) {
                throw new ConfigurationException("Driver is not an XA dataSource, while XA has been enabled in the configuration of the " + fullDataSourceName + ": either disable XA or switch the driver to an XADataSource");
            }
        } else if (driver != null && !javax.sql.DataSource.class.isAssignableFrom(driver) && !Driver.class.isAssignableFrom(driver)) {
            if (aggregatedConfig.isDefault()) {
                throw new ConfigurationException("Driver " + driverName + " is an XA datasource, but XA transactions have not been enabled on the default datasource; please either set 'quarkus.datasource.jdbc.transactions=xa' or switch to a standard non-XA JDBC driver implementation");
            }
            throw new ConfigurationException("Driver " + driverName + " is an XA datasource, but XA transactions have not been enabled on the datasource named '" + fullDataSourceName + "'; please either set 'quarkus.datasource." + fullDataSourceName + ".jdbc.transactions=xa' or switch to a standard non-XA JDBC driver implementation");
        }
    }

    private DataSourceSupport getDataSourceSupport(List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, Capabilities capabilities) {
        HashMap<String, DataSourceSupport.Entry> dataSourceSupportEntries = new HashMap<String, DataSourceSupport.Entry>();
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedDataSourceBuildTimeConfig : aggregatedBuildTimeConfigBuildItems) {
            String dataSourceName = aggregatedDataSourceBuildTimeConfig.getName();
            dataSourceSupportEntries.put(dataSourceName, new DataSourceSupport.Entry(dataSourceName, aggregatedDataSourceBuildTimeConfig.getDbKind(), aggregatedDataSourceBuildTimeConfig.getResolvedDriverClass(), aggregatedDataSourceBuildTimeConfig.isDefault()));
        }
        return new DataSourceSupport(sslNativeConfig.isExplicitlyDisabled(), capabilities.isPresent(Capability.METRICS), dataSourceSupportEntries);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void generateDataSourceSupportBean(AgroalRecorder recorder, List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (aggregatedBuildTimeConfigBuildItems.isEmpty()) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{DataSources.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(DataSource.class).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(AgroalPoolInterceptor.class));
        DataSourceSupport dataSourceSupport = this.getDataSourceSupport(aggregatedBuildTimeConfigBuildItems, sslNativeConfig, capabilities);
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DataSourceSupport.class).supplier(recorder.dataSourceSupportSupplier(dataSourceSupport)).unremovable()).done());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateDataSourceBeans(AgroalRecorder recorder, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, Capabilities capabilities, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<JdbcDataSourceBuildItem> jdbcDataSource) {
        if (aggregatedBuildTimeConfigBuildItems.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.getDataSourceSupport(aggregatedBuildTimeConfigBuildItems, (SslNativeConfigBuildItem)sslNativeConfig, (Capabilities)capabilities).entries.entrySet()) {
            String dataSourceName = (String)entry.getKey();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(AgroalDataSource.class).addType(DATA_SOURCE)).scope(Singleton.class)).setRuntimeInit().unremovable()).supplier(recorder.agroalDataSourceSupplier(dataSourceName, dataSourcesRuntimeConfig));
            if (((DataSourceSupport.Entry)entry.getValue()).isDefault) {
                configurator.addQualifier(Default.class);
            } else {
                configurator.name(dataSourceName);
                configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)dataSourceName).done();
                configurator.addQualifier().annotation(DataSource.class).addValue("value", (Object)dataSourceName).done();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
            jdbcDataSource.produce((BuildItem)new JdbcDataSourceBuildItem(dataSourceName, ((DataSourceSupport.Entry)entry.getValue()).resolvedDbKind, ((DataSourceSupport.Entry)entry.getValue()).isDefault));
        }
    }

    private List<AggregatedDataSourceBuildTimeConfigBuildItem> getAggregatedConfigBuildItems(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, List<JdbcDriverBuildItem> jdbcDriverBuildItems, List<DefaultDataSourceDbKindBuildItem> defaultDbKinds) {
        ArrayList<AggregatedDataSourceBuildTimeConfigBuildItem> dataSources = new ArrayList<AggregatedDataSourceBuildTimeConfigBuildItem>();
        Optional effectiveDbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)dataSourcesBuildTimeConfig.defaultDataSource.dbKind, defaultDbKinds, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
        if (effectiveDbKind.isPresent() && dataSourcesJdbcBuildTimeConfig.jdbc.enabled) {
            dataSources.add(new AggregatedDataSourceBuildTimeConfigBuildItem("<default>", dataSourcesBuildTimeConfig.defaultDataSource, dataSourcesJdbcBuildTimeConfig.jdbc, (String)effectiveDbKind.get(), this.resolveDriver("<default>", (String)effectiveDbKind.get(), dataSourcesJdbcBuildTimeConfig.jdbc, jdbcDriverBuildItems)));
        }
        for (Map.Entry entry : dataSourcesBuildTimeConfig.namedDataSources.entrySet()) {
            Optional dbKind;
            DataSourceJdbcBuildTimeConfig jdbcBuildTimeConfig;
            DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig = jdbcBuildTimeConfig = dataSourcesJdbcBuildTimeConfig.namedDataSources.containsKey(entry.getKey()) ? ((DataSourcesJdbcBuildTimeConfig.DataSourceJdbcOuterNamedBuildTimeConfig)dataSourcesJdbcBuildTimeConfig.namedDataSources.get(entry.getKey())).jdbc : new DataSourceJdbcBuildTimeConfig();
            if (!jdbcBuildTimeConfig.enabled || !(dbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)((DataSourceBuildTimeConfig)entry.getValue()).dbKind, defaultDbKinds, (CurateOutcomeBuildItem)curateOutcomeBuildItem)).isPresent()) continue;
            dataSources.add(new AggregatedDataSourceBuildTimeConfigBuildItem((String)entry.getKey(), (DataSourceBuildTimeConfig)entry.getValue(), jdbcBuildTimeConfig, (String)dbKind.get(), this.resolveDriver((String)entry.getKey(), (String)dbKind.get(), jdbcBuildTimeConfig, jdbcDriverBuildItems)));
        }
        return dataSources;
    }

    private String resolveDriver(String dataSourceName, String dbKind, DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig, List<JdbcDriverBuildItem> jdbcDriverBuildItems) {
        if (dataSourceJdbcBuildTimeConfig.driver.isPresent()) {
            return (String)dataSourceJdbcBuildTimeConfig.driver.get();
        }
        Optional<JdbcDriverBuildItem> matchingJdbcDriver = jdbcDriverBuildItems.stream().filter(i -> dbKind.equals(i.getDbKind())).findFirst();
        if (matchingJdbcDriver.isPresent()) {
            if (TransactionIntegration.XA == dataSourceJdbcBuildTimeConfig.transactions) {
                if (matchingJdbcDriver.get().getDriverXAClass().isPresent()) {
                    return (String)matchingJdbcDriver.get().getDriverXAClass().get();
                }
            } else {
                return matchingJdbcDriver.get().getDriverClass();
            }
        }
        throw new ConfigurationException("Unable to find a JDBC driver corresponding to the database kind '" + dbKind + "' for the " + (DataSourceUtil.isDefault((String)dataSourceName) ? "default datasource" : "datasource '" + dataSourceName + "'") + ". Either provide a suitable JDBC driver extension, define the driver manually, or disable the JDBC datasource by adding " + (DataSourceUtil.isDefault((String)dataSourceName) ? "'quarkus.datasource.jdbc=false'" : "'quarkus.datasource." + dataSourceName + ".jdbc=false'") + " to your configuration if you don't need it.");
    }

    @BuildStep
    HealthBuildItem addHealthCheck(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig) {
        return new HealthBuildItem("io.quarkus.agroal.runtime.health.DataSourceHealthCheck", dataSourcesBuildTimeConfig.healthEnabled);
    }
}

