/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.deployment;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.security.AgroalDefaultSecurityProvider;
import io.agroal.api.security.AgroalKerberosSecurityProvider;
import io.agroal.api.security.AgroalSecurityProvider;
import io.agroal.pool.ConnectionHandler;
import io.quarkus.agroal.DataSource;
import io.quarkus.agroal.deployment.DataSourceDriverBuildItem;
import io.quarkus.agroal.deployment.DataSourceInitializedBuildItem;
import io.quarkus.agroal.metrics.AgroalCounter;
import io.quarkus.agroal.metrics.AgroalGauge;
import io.quarkus.agroal.runtime.AbstractDataSourceProducer;
import io.quarkus.agroal.runtime.AgroalBuildTimeConfig;
import io.quarkus.agroal.runtime.AgroalRecorder;
import io.quarkus.agroal.runtime.AgroalRuntimeConfig;
import io.quarkus.agroal.runtime.DataSourceBuildTimeConfig;
import io.quarkus.agroal.runtime.TransactionIntegration;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.smallrye.metrics.deployment.spi.MetricBuildItem;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.sql.XADataSource;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class AgroalProcessor {
    private static final Logger log = Logger.getLogger(AgroalProcessor.class);
    private static final Set<DotName> UNREMOVABLE_BEANS = new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)AbstractDataSourceProducer.class.getName()), DotName.createSimple((String)javax.sql.DataSource.class.getName())));
    AgroalBuildTimeConfig agroalBuildTimeConfig;

    AgroalProcessor() {
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(loadsApplicationClasses=true)
    BeanContainerListenerBuildItem build(RecorderContext recorderContext, AgroalRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<DataSourceDriverBuildItem> dataSourceDriver, SslNativeConfigBuildItem sslNativeConfig, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<GeneratedBeanBuildItem> generatedBean, Capabilities capabilities) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("agroal"));
        if (!this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent() && this.agroalBuildTimeConfig.namedDataSources.isEmpty()) {
            log.warn((Object)"Agroal dependency is present but no driver has been defined for the default datasource");
            return null;
        }
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/" + AgroalSecurityProvider.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ConnectionHandler[].class.getName(), ConnectionHandler.class.getName(), AgroalDefaultSecurityProvider.class.getName(), AgroalKerberosSecurityProvider.class.getName(), Statement[].class.getName(), Statement.class.getName(), ResultSet.class.getName(), ResultSet[].class.getName()}));
        AgroalProcessor.validateBuildTimeConfig(null, this.agroalBuildTimeConfig.defaultDataSource);
        this.agroalBuildTimeConfig.namedDataSources.forEach(AgroalProcessor::validateBuildTimeConfig);
        if (this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{(String)this.agroalBuildTimeConfig.defaultDataSource.driver.get()}));
            dataSourceDriver.produce((BuildItem)new DataSourceDriverBuildItem((String)this.agroalBuildTimeConfig.defaultDataSource.driver.get()));
        }
        for (Map.Entry namedDataSourceEntry : this.agroalBuildTimeConfig.namedDataSources.entrySet()) {
            if (!((DataSourceBuildTimeConfig)namedDataSourceEntry.getValue()).driver.isPresent()) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{(String)((DataSourceBuildTimeConfig)namedDataSourceEntry.getValue()).driver.get()}));
        }
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem("agroal"));
        String dataSourceProducerClassName = AbstractDataSourceProducer.class.getPackage().getName() + ".DataSourceProducer";
        this.createDataSourceProducerBean(generatedBean, dataSourceProducerClassName, capabilities.isCapabilityPresent("io.quarkus.metrics"));
        return new BeanContainerListenerBuildItem(recorder.addDataSource(recorderContext.classProxy(dataSourceProducerClassName), this.agroalBuildTimeConfig, sslNativeConfig.isExplicitlyDisabled()));
    }

    private static void validateBuildTimeConfig(String datasourceName, DataSourceBuildTimeConfig ds) {
        Class<?> driver;
        if (!ds.driver.isPresent()) {
            if (datasourceName != null) {
                throw new DeploymentException("Named datasource '" + datasourceName + "' doesn't have a driver defined.");
            }
            return;
        }
        String driverName = (String)ds.driver.get();
        try {
            driver = Class.forName(driverName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (datasourceName == null) {
                throw new DeploymentException("Unable to load the datasource driver for the default datasource", (Throwable)e);
            }
            throw new DeploymentException("Unable to load the datasource driver for datasource named '" + datasourceName + "'", (Throwable)e);
        }
        if (ds.transactions == TransactionIntegration.XA) {
            if (!XADataSource.class.isAssignableFrom(driver)) {
                if (datasourceName == null) {
                    throw new DeploymentException("Driver is not an XA dataSource, while XA has been enabled in the configuration of the default datasource: either disable XA or switch the driver to an XADataSource");
                }
                throw new DeploymentException("Driver is not an XA dataSource, while XA has been enabled in the configuration of the datasource named '" + datasourceName + "': either disable XA or switch the driver to an XADataSource");
            }
        } else if (driver != null && !javax.sql.DataSource.class.isAssignableFrom(driver) && !Driver.class.isAssignableFrom(driver)) {
            if (datasourceName == null) {
                throw new DeploymentException("Driver is an XA dataSource, but XA transactions have not been enabled on the default datasource; please either set 'quarkus.datasource.xa=true' or switch to a standard non-XA JDBC driver implementation");
            }
            throw new DeploymentException("Driver is an XA dataSource, but XA transactions have not been enabled on the datasource named '" + datasourceName + "'; please either set 'quarkus.datasource." + datasourceName + ".xa=true' or switch to a standard non-XA JDBC driver implementation");
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configureRuntimeProperties(AgroalRecorder recorder, BuildProducer<DataSourceInitializedBuildItem> dataSourceInitialized, AgroalRuntimeConfig agroalRuntimeConfig) {
        Optional defaultDataSourceDriver = this.agroalBuildTimeConfig.defaultDataSource.driver;
        if (!defaultDataSourceDriver.isPresent() && this.agroalBuildTimeConfig.namedDataSources.isEmpty()) {
            return;
        }
        recorder.configureRuntimeProperties(agroalRuntimeConfig);
        Set dataSourceNames = this.agroalBuildTimeConfig.namedDataSources.keySet();
        DataSourceInitializedBuildItem buildItem = defaultDataSourceDriver.isPresent() ? DataSourceInitializedBuildItem.ofDefaultDataSourceAnd(dataSourceNames) : DataSourceInitializedBuildItem.ofDataSources(dataSourceNames);
        dataSourceInitialized.produce((BuildItem)buildItem);
    }

    @BuildStep
    UnremovableBeanBuildItem markBeansAsUnremovable() {
        return new UnremovableBeanBuildItem(beanInfo -> {
            Set types = beanInfo.getTypes();
            for (Type t : types) {
                if (!UNREMOVABLE_BEANS.contains(t.name())) continue;
                return true;
            }
            return false;
        });
    }

    private void createDataSourceProducerBean(BuildProducer<GeneratedBeanBuildItem> generatedBean, String dataSourceProducerClassName, boolean metricsCapabilityPresent) {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBean);
        ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(dataSourceProducerClassName).superClass(AbstractDataSourceProducer.class).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        if (this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent()) {
            MethodCreator defaultDataSourceMethodCreator = classCreator.getMethodCreator("createDefaultDataSource", AgroalDataSource.class, new Class[0]);
            defaultDataSourceMethodCreator.addAnnotation(ApplicationScoped.class);
            defaultDataSourceMethodCreator.addAnnotation(Produces.class);
            defaultDataSourceMethodCreator.addAnnotation(Default.class);
            ResultHandle dataSourceName = defaultDataSourceMethodCreator.load("<default>");
            ResultHandle dataSourceBuildTimeConfig = defaultDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getDefaultBuildTimeConfig", DataSourceBuildTimeConfig.class, (Class[])new Class[0]), defaultDataSourceMethodCreator.getThis(), new ResultHandle[0]);
            ResultHandle dataSourceRuntimeConfig = defaultDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getDefaultRuntimeConfig", Optional.class, (Class[])new Class[0]), defaultDataSourceMethodCreator.getThis(), new ResultHandle[0]);
            ResultHandle mpMetricsEnabled = defaultDataSourceMethodCreator.load(metricsCapabilityPresent);
            defaultDataSourceMethodCreator.returnValue(defaultDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"createDataSource", AgroalDataSource.class, (Class[])new Class[]{String.class, DataSourceBuildTimeConfig.class, Optional.class, Boolean.TYPE}), defaultDataSourceMethodCreator.getThis(), new ResultHandle[]{dataSourceName, dataSourceBuildTimeConfig, dataSourceRuntimeConfig, mpMetricsEnabled}));
        }
        for (Map.Entry namedDataSourceEntry : this.agroalBuildTimeConfig.namedDataSources.entrySet()) {
            String namedDataSourceName = (String)namedDataSourceEntry.getKey();
            if (!((DataSourceBuildTimeConfig)namedDataSourceEntry.getValue()).driver.isPresent()) {
                log.warn((Object)("No driver defined for named datasource " + namedDataSourceName + ". Ignoring."));
                continue;
            }
            MethodCreator namedDataSourceMethodCreator = classCreator.getMethodCreator("createNamedDataSource_" + HashUtil.sha1((String)namedDataSourceName), AgroalDataSource.class, new Class[0]);
            namedDataSourceMethodCreator.addAnnotation(ApplicationScoped.class);
            namedDataSourceMethodCreator.addAnnotation(Produces.class);
            namedDataSourceMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)namedDataSourceName)}));
            namedDataSourceMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DotName.createSimple((String)DataSource.class.getName()), null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)namedDataSourceName)}));
            ResultHandle namedDataSourceNameRH = namedDataSourceMethodCreator.load(namedDataSourceName);
            ResultHandle namedDataSourceBuildTimeConfig = namedDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getBuildTimeConfig", DataSourceBuildTimeConfig.class, (Class[])new Class[]{String.class}), namedDataSourceMethodCreator.getThis(), new ResultHandle[]{namedDataSourceNameRH});
            ResultHandle namedDataSourceRuntimeConfig = namedDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getRuntimeConfig", Optional.class, (Class[])new Class[]{String.class}), namedDataSourceMethodCreator.getThis(), new ResultHandle[]{namedDataSourceNameRH});
            ResultHandle mpMetricsEnabled = namedDataSourceMethodCreator.load(metricsCapabilityPresent);
            namedDataSourceMethodCreator.returnValue(namedDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"createDataSource", AgroalDataSource.class, (Class[])new Class[]{String.class, DataSourceBuildTimeConfig.class, Optional.class, Boolean.TYPE}), namedDataSourceMethodCreator.getThis(), new ResultHandle[]{namedDataSourceNameRH, namedDataSourceBuildTimeConfig, namedDataSourceRuntimeConfig, mpMetricsEnabled}));
        }
        classCreator.close();
    }

    @BuildStep
    HealthBuildItem addHealthCheck(AgroalBuildTimeConfig agroalBuildTimeConfig) {
        return new HealthBuildItem("io.quarkus.agroal.runtime.health.DataSourceHealthCheck", agroalBuildTimeConfig.healthEnabled, "datasource");
    }

    @BuildStep
    void registerMetrics(AgroalBuildTimeConfig agroalBuildTimeConfig, BuildProducer<MetricBuildItem> metrics) {
        Metadata activeCountMetadata = Metadata.builder().withName("agroal.active.count").withDescription("Number of active connections. These connections are in use and not available to be acquired.").withType(MetricType.GAUGE).build();
        Metadata availableCountMetadata = Metadata.builder().withName("agroal.available.count").withDescription("Number of idle connections in the pool, available to be acquired.").withType(MetricType.GAUGE).build();
        Metadata maxUsedCountMetadata = Metadata.builder().withName("agroal.max.used.count").withDescription("Maximum number of connections active simultaneously.").withType(MetricType.GAUGE).build();
        Metadata awaitingCountMetadata = Metadata.builder().withName("agroal.awaiting.count").withDescription("Approximate number of threads blocked, waiting to acquire a connection.").withType(MetricType.GAUGE).build();
        Metadata blockingTimeAverageMetadata = Metadata.builder().withName("agroal.blocking.time.average").withDescription("Average time an application waited to acquire a connection.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata blockingTimeMaxMetadata = Metadata.builder().withName("agroal.blocking.time.max").withDescription("Maximum time an application waited to acquire a connection.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata blockingTimeTotalMetadata = Metadata.builder().withName("agroal.blocking.time.total").withDescription("Total time applications waited to acquire a connection.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata creationTimeAverageMetadata = Metadata.builder().withName("agroal.creation.time.average").withDescription("Average time for a connection to be created.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata creationTimeMaxMetadata = Metadata.builder().withName("agroal.creation.time.max").withDescription("Maximum time for a connection to be created.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata creationTimeTotalMetadata = Metadata.builder().withName("agroal.creation.time.total").withDescription("Total time waiting for connections to be created.").withUnit("milliseconds").withType(MetricType.GAUGE).build();
        Metadata acquireCountMetadata = Metadata.builder().withName("agroal.acquire.count").withDescription("Number of times an acquire operation succeeded.").withType(MetricType.COUNTER).build();
        Metadata creationCountMetadata = Metadata.builder().withName("agroal.creation.count").withDescription("Number of created connections.").withType(MetricType.COUNTER).build();
        Metadata leakDetectionCountMetadata = Metadata.builder().withName("agroal.leak.detection.count").withDescription("Number of times a leak was detected. A single connection can be detected multiple times.").withType(MetricType.COUNTER).build();
        Metadata destroyCountMetadata = Metadata.builder().withName("agroal.destroy.count").withDescription("Number of destroyed connections.").withType(MetricType.COUNTER).build();
        Metadata flushCountMetadata = Metadata.builder().withName("agroal.flush.count").withDescription("Number of connections removed from the pool, not counting invalid / idle.").withType(MetricType.COUNTER).build();
        Metadata invalidCountMetadata = Metadata.builder().withName("agroal.invalid.count").withDescription("Number of connections removed from the pool for being invalid.").withType(MetricType.COUNTER).build();
        Metadata reapCountMetadata = Metadata.builder().withName("agroal.reap.count").withDescription("Number of connections removed from the pool for being idle.").withType(MetricType.COUNTER).build();
        HashMap datasources = new HashMap(agroalBuildTimeConfig.namedDataSources);
        if (agroalBuildTimeConfig.defaultDataSource != null) {
            datasources.put(null, agroalBuildTimeConfig.defaultDataSource);
        }
        for (Map.Entry dataSourceEntry : datasources.entrySet()) {
            String dataSourceName = (String)dataSourceEntry.getKey();
            boolean metricsEnabledForThisDatasource = agroalBuildTimeConfig.metricsEnabled && ((DataSourceBuildTimeConfig)dataSourceEntry.getValue()).enableMetrics.orElse(true) != false;
            Tag tag = new Tag("datasource", dataSourceName != null ? dataSourceName : "default");
            String configRootName = "datasource";
            metrics.produce((BuildItem)new MetricBuildItem(activeCountMetadata, (Object)new AgroalGauge(dataSourceName, "activeCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(maxUsedCountMetadata, (Object)new AgroalGauge(dataSourceName, "maxUsedCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(awaitingCountMetadata, (Object)new AgroalGauge(dataSourceName, "awaitingCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(availableCountMetadata, (Object)new AgroalGauge(dataSourceName, "availableCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(blockingTimeAverageMetadata, (Object)new AgroalGauge(dataSourceName, "blockingTimeAverage"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(blockingTimeMaxMetadata, (Object)new AgroalGauge(dataSourceName, "blockingTimeMax"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(blockingTimeTotalMetadata, (Object)new AgroalGauge(dataSourceName, "blockingTimeTotal"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(creationTimeAverageMetadata, (Object)new AgroalGauge(dataSourceName, "creationTimeAverage"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(creationTimeMaxMetadata, (Object)new AgroalGauge(dataSourceName, "creationTimeMax"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(creationTimeTotalMetadata, (Object)new AgroalGauge(dataSourceName, "creationTimeTotal"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(acquireCountMetadata, (Object)new AgroalCounter(dataSourceName, "acquireCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(creationCountMetadata, (Object)new AgroalCounter(dataSourceName, "creationCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(leakDetectionCountMetadata, (Object)new AgroalCounter(dataSourceName, "leakDetectionCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(destroyCountMetadata, (Object)new AgroalCounter(dataSourceName, "destroyCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(flushCountMetadata, (Object)new AgroalCounter(dataSourceName, "flushCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(invalidCountMetadata, (Object)new AgroalCounter(dataSourceName, "invalidCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
            metrics.produce((BuildItem)new MetricBuildItem(reapCountMetadata, (Object)new AgroalCounter(dataSourceName, "reapCount"), metricsEnabledForThisDatasource, configRootName, new Tag[]{tag}));
        }
    }
}

