/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class DataSourceInitializedBuildItem
extends SimpleBuildItem {
    private static final String DEFAULT_DATASOURCE_NAME = "<default>";
    private final String defaultDataSourceName;
    private final Collection<String> dataSourceNames = new ArrayList<String>();

    public static final Collection<String> dataSourceNamesOf(DataSourceInitializedBuildItem buildItem) {
        return buildItem != null ? buildItem.getDataSourceNames() : Collections.emptyList();
    }

    public static final boolean isDefaultDataSourcePresent(DataSourceInitializedBuildItem buildItem) {
        return buildItem != null ? buildItem.isDefaultDataSourcePresent() : false;
    }

    public static final DataSourceInitializedBuildItem ofDefaultDataSourceAnd(Collection<String> dataSourceNames) {
        return new DataSourceInitializedBuildItem(dataSourceNames, DEFAULT_DATASOURCE_NAME);
    }

    public static final DataSourceInitializedBuildItem ofDataSources(Collection<String> dataSourceNames) {
        ArrayList<String> allDataSourceNames = new ArrayList<String>(dataSourceNames);
        return new DataSourceInitializedBuildItem(allDataSourceNames, null);
    }

    DataSourceInitializedBuildItem(Collection<String> dataSourceNames, String defaultDataSourceName) {
        this.dataSourceNames.addAll(dataSourceNames);
        this.defaultDataSourceName = defaultDataSourceName;
    }

    public Collection<String> getDataSourceNames() {
        return new ArrayList<String>(this.dataSourceNames);
    }

    public boolean isDefaultDataSourcePresent() {
        return this.defaultDataSourceName != null;
    }

    public String toString() {
        return "DataSourceInitializedBuildItem [defaultDataSourceName=" + this.defaultDataSourceName + ", dataSourceNames=" + this.dataSourceNames + "]";
    }
}

