/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import io.agroal.narayana.NarayanaTransactionIntegration;
import io.agroal.pool.DataSource;
import io.quarkus.agroal.runtime.AgroalConnectionConfigurer;
import io.quarkus.agroal.runtime.AgroalEventLoggingListener;
import io.quarkus.agroal.runtime.AgroalVaultCredentialsProviderPassword;
import io.quarkus.agroal.runtime.DataSourceJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.DataSourceJdbcRuntimeConfig;
import io.quarkus.agroal.runtime.DataSourcesJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.DataSourcesJdbcRuntimeConfig;
import io.quarkus.agroal.runtime.JdbcDriver;
import io.quarkus.agroal.runtime.LegacyDataSourceJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.LegacyDataSourceJdbcRuntimeConfig;
import io.quarkus.agroal.runtime.LegacyDataSourcesJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.LegacyDataSourcesJdbcRuntimeConfig;
import io.quarkus.agroal.runtime.TransactionIntegration;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.datasource.runtime.LegacyDataSourceRuntimeConfig;
import io.quarkus.datasource.runtime.LegacyDataSourcesRuntimeConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vault.CredentialsProvider;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.logging.Logger;

public abstract class AbstractDataSourceProducer {
    private static final Logger log = Logger.getLogger((String)AbstractDataSourceProducer.class.getName());
    private DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig;
    private DataSourcesRuntimeConfig dataSourcesRuntimeConfig;
    private DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig;
    private DataSourcesJdbcRuntimeConfig dataSourcesJdbcRuntimeConfig;
    private LegacyDataSourcesJdbcBuildTimeConfig legacyDataSourcesJdbcBuildTimeConfig;
    private LegacyDataSourcesRuntimeConfig legacyDataSourcesRuntimeConfig;
    private LegacyDataSourcesJdbcRuntimeConfig legacyDataSourcesJdbcRuntimeConfig;
    private boolean disableSslSupport = false;
    private List<AgroalDataSource> dataSources = new ArrayList<AgroalDataSource>();
    @Inject
    public TransactionManager transactionManager;
    @Inject
    public TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    public void configureDataSources(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesJdbcBuildTimeConfig dataSourcesJdbcBuildTimeConfig, DataSourcesRuntimeConfig dataSourcesRuntimeConfig, DataSourcesJdbcRuntimeConfig dataSourcesJdbcRuntimeConfig, LegacyDataSourcesJdbcBuildTimeConfig legacyDataSourcesJdbcBuildTimeConfig, LegacyDataSourcesRuntimeConfig legacyDataSourcesRuntimeConfig, LegacyDataSourcesJdbcRuntimeConfig legacyDataSourcesJdbcRuntimeConfig, boolean disableSslSupport) {
        this.dataSourcesBuildTimeConfig = dataSourcesBuildTimeConfig;
        this.dataSourcesJdbcBuildTimeConfig = dataSourcesJdbcBuildTimeConfig;
        this.dataSourcesRuntimeConfig = dataSourcesRuntimeConfig;
        this.dataSourcesJdbcRuntimeConfig = dataSourcesJdbcRuntimeConfig;
        this.legacyDataSourcesJdbcBuildTimeConfig = legacyDataSourcesJdbcBuildTimeConfig;
        this.legacyDataSourcesRuntimeConfig = legacyDataSourcesRuntimeConfig;
        this.legacyDataSourcesJdbcRuntimeConfig = legacyDataSourcesJdbcRuntimeConfig;
        this.disableSslSupport = disableSslSupport;
    }

    public AgroalDataSource createDataSource(String dataSourceName, DataSourceBuildTimeConfig dataSourceBuildTimeConfig, DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceJdbcRuntimeConfig dataSourceJdbcRuntimeConfig, LegacyDataSourceJdbcBuildTimeConfig legacyDataSourceJdbcBuildTimeConfig, LegacyDataSourceRuntimeConfig legacyDataSourceRuntimeConfig, LegacyDataSourceJdbcRuntimeConfig legacyDataSourceJdbcRuntimeConfig, String resolvedDbKind, String resolvedDriverClass, boolean mpMetricsPresent, boolean isLegacy) {
        Class<?> driver;
        this.checkConfigInjection();
        if (!isLegacy ? !dataSourceJdbcRuntimeConfig.url.isPresent() : !legacyDataSourceRuntimeConfig.url.isPresent()) {
            throw new ConfigurationException("URL is not defined for datasource " + dataSourceName);
        }
        AbstractDataSourceProducer.loadDriversInTCCL();
        try {
            driver = Class.forName(resolvedDriverClass, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load the datasource driver " + resolvedDriverClass + " for datasource " + dataSourceName, e);
        }
        InstanceHandle agroalConnectionConfigurerHandle = Arc.container().instance(AgroalConnectionConfigurer.class, new Annotation[]{new JdbcDriver.JdbcDriverLiteral(resolvedDbKind)});
        AgroalDataSourceConfigurationSupplier dataSourceConfiguration = new AgroalDataSourceConfigurationSupplier();
        AgroalConnectionPoolConfigurationSupplier poolConfiguration = dataSourceConfiguration.connectionPoolConfiguration();
        AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration = poolConfiguration.connectionFactoryConfiguration();
        if (!isLegacy) {
            this.applyNewConfiguration(dataSourceConfiguration, poolConfiguration, connectionFactoryConfiguration, driver, dataSourceJdbcBuildTimeConfig, dataSourceRuntimeConfig, dataSourceJdbcRuntimeConfig, mpMetricsPresent);
        } else {
            this.applyLegacyConfiguration(dataSourceConfiguration, poolConfiguration, connectionFactoryConfiguration, driver, dataSourceRuntimeConfig, legacyDataSourceJdbcBuildTimeConfig, legacyDataSourceRuntimeConfig, legacyDataSourceJdbcRuntimeConfig, mpMetricsPresent);
        }
        if (this.disableSslSupport) {
            if (agroalConnectionConfigurerHandle.isAvailable()) {
                ((AgroalConnectionConfigurer)agroalConnectionConfigurerHandle.get()).disableSslSupport(resolvedDbKind, dataSourceConfiguration);
            } else {
                log.warnv("Agroal does not support disabling SSL for database kind: {0}", (Object)resolvedDbKind);
            }
        }
        AgroalDataSourceConfiguration agroalConfiguration = dataSourceConfiguration.get();
        DataSource dataSource = new DataSource(agroalConfiguration, new AgroalDataSourceListener[]{new AgroalEventLoggingListener(dataSourceName)});
        log.debugv("Started datasource {0} connected to {1}", (Object)dataSourceName, (Object)agroalConfiguration.connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl());
        this.dataSources.add((AgroalDataSource)dataSource);
        return dataSource;
    }

    private void applyNewConfiguration(AgroalDataSourceConfigurationSupplier dataSourceConfiguration, AgroalConnectionPoolConfigurationSupplier poolConfiguration, AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration, Class<?> driver, DataSourceJdbcBuildTimeConfig dataSourceJdbcBuildTimeConfig, DataSourceRuntimeConfig dataSourceRuntimeConfig, DataSourceJdbcRuntimeConfig dataSourceJdbcRuntimeConfig, boolean mpMetricsPresent) {
        connectionFactoryConfiguration.jdbcUrl(dataSourceJdbcRuntimeConfig.url.get());
        connectionFactoryConfiguration.connectionProviderClass(driver);
        connectionFactoryConfiguration.trackJdbcResources(dataSourceJdbcRuntimeConfig.detectStatementLeaks);
        if (dataSourceJdbcRuntimeConfig.transactionIsolationLevel.isPresent()) {
            connectionFactoryConfiguration.jdbcTransactionIsolation(dataSourceJdbcRuntimeConfig.transactionIsolationLevel.get());
        }
        if (dataSourceJdbcBuildTimeConfig.transactions != TransactionIntegration.DISABLED) {
            NarayanaTransactionIntegration txIntegration = new NarayanaTransactionIntegration(this.transactionManager, this.transactionSynchronizationRegistry);
            poolConfiguration.transactionIntegration((io.agroal.api.transaction.TransactionIntegration)txIntegration);
        }
        if (dataSourceJdbcRuntimeConfig.newConnectionSql.isPresent()) {
            connectionFactoryConfiguration.initialSql(dataSourceJdbcRuntimeConfig.newConnectionSql.get());
        }
        if (dataSourceJdbcBuildTimeConfig.enableMetrics.isPresent()) {
            dataSourceConfiguration.metricsEnabled(dataSourceJdbcBuildTimeConfig.enableMetrics.get().booleanValue());
        } else {
            dataSourceConfiguration.metricsEnabled(this.dataSourcesBuildTimeConfig.metricsEnabled && mpMetricsPresent);
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            connectionFactoryConfiguration.principal((Principal)new NamePrincipal((String)dataSourceRuntimeConfig.username.get()));
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            connectionFactoryConfiguration.credential((Object)new SimplePassword((String)dataSourceRuntimeConfig.password.get()));
        }
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            CredentialsProvider credentialsProvider;
            ArcContainer container = Arc.container();
            String type = dataSourceRuntimeConfig.credentialsProviderType.orElse(null);
            CredentialsProvider credentialsProvider2 = credentialsProvider = type != null ? (CredentialsProvider)container.instance(type).get() : (CredentialsProvider)container.instance(CredentialsProvider.class, new Annotation[0]).get();
            if (credentialsProvider == null) {
                throw new RuntimeException("unable to find credentials provider of type " + (type == null ? "default" : type));
            }
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            connectionFactoryConfiguration.credential((Object)new AgroalVaultCredentialsProviderPassword(name, credentialsProvider));
        }
        poolConfiguration.minSize(dataSourceJdbcRuntimeConfig.minSize);
        poolConfiguration.maxSize(dataSourceJdbcRuntimeConfig.maxSize);
        if (dataSourceJdbcRuntimeConfig.initialSize.isPresent() && dataSourceJdbcRuntimeConfig.initialSize.getAsInt() > 0) {
            poolConfiguration.initialSize(dataSourceJdbcRuntimeConfig.initialSize.getAsInt());
        }
        poolConfiguration.connectionValidator(AgroalConnectionPoolConfiguration.ConnectionValidator.defaultValidator());
        if (dataSourceJdbcRuntimeConfig.acquisitionTimeout.isPresent()) {
            poolConfiguration.acquisitionTimeout(dataSourceJdbcRuntimeConfig.acquisitionTimeout.get());
        }
        if (dataSourceJdbcRuntimeConfig.backgroundValidationInterval.isPresent()) {
            poolConfiguration.validationTimeout(dataSourceJdbcRuntimeConfig.backgroundValidationInterval.get());
        }
        if (dataSourceJdbcRuntimeConfig.validationQuerySql.isPresent()) {
            final String validationQuery = dataSourceJdbcRuntimeConfig.validationQuerySql.get();
            poolConfiguration.connectionValidator(new AgroalConnectionPoolConfiguration.ConnectionValidator(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean isValid(Connection connection) {
                    try (Statement stmt = connection.createStatement();){
                        stmt.execute(validationQuery);
                        boolean bl = true;
                        return bl;
                    }
                    catch (Exception e) {
                        log.warn((Object)"Connection validation failed", (Throwable)e);
                        return false;
                    }
                }
            });
        }
        if (dataSourceJdbcRuntimeConfig.idleRemovalInterval.isPresent()) {
            poolConfiguration.reapTimeout(dataSourceJdbcRuntimeConfig.idleRemovalInterval.get());
        }
        if (dataSourceJdbcRuntimeConfig.leakDetectionInterval.isPresent()) {
            poolConfiguration.leakTimeout(dataSourceJdbcRuntimeConfig.leakDetectionInterval.get());
        }
        if (dataSourceJdbcRuntimeConfig.maxLifetime.isPresent()) {
            poolConfiguration.maxLifetime(dataSourceJdbcRuntimeConfig.maxLifetime.get());
        }
    }

    private void applyLegacyConfiguration(AgroalDataSourceConfigurationSupplier dataSourceConfiguration, AgroalConnectionPoolConfigurationSupplier poolConfiguration, AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration, Class<?> driver, DataSourceRuntimeConfig dataSourceRuntimeConfig, LegacyDataSourceJdbcBuildTimeConfig legacyDataSourceJdbcBuildTimeConfig, LegacyDataSourceRuntimeConfig legacyDataSourceRuntimeConfig, LegacyDataSourceJdbcRuntimeConfig legacyDataSourceJdbcRuntimeConfig, boolean mpMetricsPresent) {
        connectionFactoryConfiguration.jdbcUrl((String)legacyDataSourceRuntimeConfig.url.get());
        connectionFactoryConfiguration.connectionProviderClass(driver);
        connectionFactoryConfiguration.trackJdbcResources(legacyDataSourceJdbcRuntimeConfig.detectStatementLeaks);
        if (legacyDataSourceJdbcRuntimeConfig.transactionIsolationLevel.isPresent()) {
            connectionFactoryConfiguration.jdbcTransactionIsolation(legacyDataSourceJdbcRuntimeConfig.transactionIsolationLevel.get());
        }
        if (legacyDataSourceJdbcBuildTimeConfig.transactions != TransactionIntegration.DISABLED) {
            NarayanaTransactionIntegration txIntegration = new NarayanaTransactionIntegration(this.transactionManager, this.transactionSynchronizationRegistry);
            poolConfiguration.transactionIntegration((io.agroal.api.transaction.TransactionIntegration)txIntegration);
        }
        if (legacyDataSourceJdbcRuntimeConfig.newConnectionSql.isPresent()) {
            connectionFactoryConfiguration.initialSql(legacyDataSourceJdbcRuntimeConfig.newConnectionSql.get());
        }
        if (legacyDataSourceJdbcBuildTimeConfig.enableMetrics.isPresent()) {
            dataSourceConfiguration.metricsEnabled(legacyDataSourceJdbcBuildTimeConfig.enableMetrics.get().booleanValue());
        } else {
            dataSourceConfiguration.metricsEnabled(this.dataSourcesBuildTimeConfig.metricsEnabled && mpMetricsPresent);
        }
        if (dataSourceRuntimeConfig.username.isPresent()) {
            connectionFactoryConfiguration.principal((Principal)new NamePrincipal((String)dataSourceRuntimeConfig.username.get()));
        }
        if (dataSourceRuntimeConfig.password.isPresent()) {
            connectionFactoryConfiguration.credential((Object)new SimplePassword((String)dataSourceRuntimeConfig.password.get()));
        }
        if (dataSourceRuntimeConfig.credentialsProvider.isPresent()) {
            CredentialsProvider credentialsProvider;
            ArcContainer container = Arc.container();
            String type = dataSourceRuntimeConfig.credentialsProviderType.orElse(null);
            CredentialsProvider credentialsProvider2 = credentialsProvider = type != null ? (CredentialsProvider)container.instance(type).get() : (CredentialsProvider)container.instance(CredentialsProvider.class, new Annotation[0]).get();
            if (credentialsProvider == null) {
                throw new RuntimeException("unable to find credentials provider of type " + (type == null ? "default" : type));
            }
            String name = (String)dataSourceRuntimeConfig.credentialsProvider.get();
            connectionFactoryConfiguration.credential((Object)new AgroalVaultCredentialsProviderPassword(name, credentialsProvider));
        }
        poolConfiguration.minSize(legacyDataSourceJdbcRuntimeConfig.minSize);
        poolConfiguration.maxSize(legacyDataSourceRuntimeConfig.maxSize);
        if (legacyDataSourceJdbcRuntimeConfig.initialSize.isPresent() && legacyDataSourceJdbcRuntimeConfig.initialSize.get() > 0) {
            poolConfiguration.initialSize(legacyDataSourceJdbcRuntimeConfig.initialSize.get().intValue());
        }
        poolConfiguration.connectionValidator(AgroalConnectionPoolConfiguration.ConnectionValidator.defaultValidator());
        if (legacyDataSourceJdbcRuntimeConfig.acquisitionTimeout.isPresent()) {
            poolConfiguration.acquisitionTimeout(legacyDataSourceJdbcRuntimeConfig.acquisitionTimeout.get());
        }
        if (legacyDataSourceJdbcRuntimeConfig.backgroundValidationInterval.isPresent()) {
            poolConfiguration.validationTimeout(legacyDataSourceJdbcRuntimeConfig.backgroundValidationInterval.get());
        }
        if (legacyDataSourceJdbcRuntimeConfig.validationQuerySql.isPresent()) {
            final String validationQuery = legacyDataSourceJdbcRuntimeConfig.validationQuerySql.get();
            poolConfiguration.connectionValidator(new AgroalConnectionPoolConfiguration.ConnectionValidator(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean isValid(Connection connection) {
                    try (Statement stmt = connection.createStatement();){
                        stmt.execute(validationQuery);
                        boolean bl = true;
                        return bl;
                    }
                    catch (Exception e) {
                        log.warn((Object)"Connection validation failed", (Throwable)e);
                        return false;
                    }
                }
            });
        }
        if (legacyDataSourceJdbcRuntimeConfig.idleRemovalInterval.isPresent()) {
            poolConfiguration.reapTimeout(legacyDataSourceJdbcRuntimeConfig.idleRemovalInterval.get());
        }
        if (legacyDataSourceJdbcRuntimeConfig.leakDetectionInterval.isPresent()) {
            poolConfiguration.leakTimeout(legacyDataSourceJdbcRuntimeConfig.leakDetectionInterval.get());
        }
        if (legacyDataSourceJdbcRuntimeConfig.maxLifetime.isPresent()) {
            poolConfiguration.maxLifetime(legacyDataSourceJdbcRuntimeConfig.maxLifetime.get());
        }
    }

    public DataSourceBuildTimeConfig getDataSourceBuildTimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.dataSourcesBuildTimeConfig.defaultDataSource;
        }
        DataSourceBuildTimeConfig namedConfig = (DataSourceBuildTimeConfig)this.dataSourcesBuildTimeConfig.namedDataSources.get(dataSourceName);
        return namedConfig != null ? namedConfig : new DataSourceBuildTimeConfig();
    }

    public DataSourceJdbcBuildTimeConfig getDataSourceJdbcBuildTimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.dataSourcesJdbcBuildTimeConfig.jdbc;
        }
        DataSourcesJdbcBuildTimeConfig.DataSourceJdbcOuterNamedBuildTimeConfig namedOuterConfig = this.dataSourcesJdbcBuildTimeConfig.namedDataSources.get(dataSourceName);
        return namedOuterConfig != null ? namedOuterConfig.jdbc : new DataSourceJdbcBuildTimeConfig();
    }

    public DataSourceRuntimeConfig getDataSourceRuntimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.dataSourcesRuntimeConfig.defaultDataSource;
        }
        DataSourceRuntimeConfig namedConfig = (DataSourceRuntimeConfig)this.dataSourcesRuntimeConfig.namedDataSources.get(dataSourceName);
        return namedConfig != null ? namedConfig : new DataSourceRuntimeConfig();
    }

    public DataSourceJdbcRuntimeConfig getDataSourceJdbcRuntimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.dataSourcesJdbcRuntimeConfig.jdbc;
        }
        DataSourcesJdbcRuntimeConfig.DataSourceJdbcOuterNamedRuntimeConfig namedOuterConfig = this.dataSourcesJdbcRuntimeConfig.namedDataSources.get(dataSourceName);
        return namedOuterConfig != null ? namedOuterConfig.jdbc : new DataSourceJdbcRuntimeConfig();
    }

    public LegacyDataSourceJdbcBuildTimeConfig getLegacyDataSourceJdbcBuildTimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.legacyDataSourcesJdbcBuildTimeConfig.defaultDataSource;
        }
        LegacyDataSourceJdbcBuildTimeConfig namedConfig = this.legacyDataSourcesJdbcBuildTimeConfig.namedDataSources.get(dataSourceName);
        return namedConfig != null ? namedConfig : new LegacyDataSourceJdbcBuildTimeConfig();
    }

    public LegacyDataSourceRuntimeConfig getLegacyDataSourceRuntimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.legacyDataSourcesRuntimeConfig.defaultDataSource;
        }
        LegacyDataSourceRuntimeConfig namedConfig = (LegacyDataSourceRuntimeConfig)this.legacyDataSourcesRuntimeConfig.namedDataSources.get(dataSourceName);
        return namedConfig != null ? namedConfig : new LegacyDataSourceRuntimeConfig();
    }

    public LegacyDataSourceJdbcRuntimeConfig getLegacyDataSourceJdbcRuntimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.legacyDataSourcesJdbcRuntimeConfig.defaultDataSource;
        }
        LegacyDataSourceJdbcRuntimeConfig namedConfig = this.legacyDataSourcesJdbcRuntimeConfig.namedDataSources.get(dataSourceName);
        return namedConfig != null ? namedConfig : new LegacyDataSourceJdbcRuntimeConfig();
    }

    private void checkConfigInjection() {
        if (this.dataSourcesBuildTimeConfig == null || this.dataSourcesJdbcBuildTimeConfig == null || this.dataSourcesRuntimeConfig == null || this.dataSourcesJdbcRuntimeConfig == null) {
            throw new IllegalStateException("The datasources are not ready to be consumed: the configuration has not been injected yet");
        }
    }

    private static void loadDriversInTCCL() {
        ServiceLoader<Driver> drivers = ServiceLoader.load(Driver.class);
        Iterator<Driver> iterator = drivers.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next();
            }
            catch (Throwable throwable) {}
        }
    }

    @PreDestroy
    public void stop() {
        for (AgroalDataSource dataSource : this.dataSources) {
            if (dataSource == null) continue;
            dataSource.close();
        }
    }
}

