/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime.metrics;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceMetrics;
import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.metrics.Counter;

public class AgroalCounter
implements Counter {
    private String dataSourceName;
    private volatile AgroalDataSource dataSource;
    private String metric;

    public AgroalCounter() {
    }

    public AgroalCounter(String dataSourceName, String metricName) {
        this.dataSourceName = dataSourceName;
        this.metric = metricName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgroalDataSource getDataSource() {
        AgroalDataSource dsLocal = this.dataSource;
        if (dsLocal == null) {
            AgroalCounter agroalCounter = this;
            synchronized (agroalCounter) {
                dsLocal = this.dataSource;
                if (dsLocal == null) {
                    this.dataSource = this.dataSourceName == null || DataSourceUtil.isDefault((String)this.dataSourceName) ? (dsLocal = (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[0]).get()) : (dsLocal = (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(this.dataSourceName)}).get());
                }
            }
        }
        return dsLocal;
    }

    public void setDataSource(AgroalDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void inc() {
    }

    public void inc(long n) {
    }

    public long getCount() {
        AgroalDataSourceMetrics metrics = this.getDataSource().getMetrics();
        switch (this.metric) {
            case "acquireCount": {
                return metrics.acquireCount();
            }
            case "creationCount": {
                return metrics.creationCount();
            }
            case "leakDetectionCount": {
                return metrics.leakDetectionCount();
            }
            case "destroyCount": {
                return metrics.destroyCount();
            }
            case "flushCount": {
                return metrics.flushCount();
            }
            case "invalidCount": {
                return metrics.invalidCount();
            }
            case "reapCount": {
                return metrics.reapCount();
            }
        }
        throw new IllegalArgumentException("Unknown datasource metric");
    }
}

