/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime;

import io.agroal.api.cache.Acquirable;
import io.agroal.api.cache.ConnectionCache;
import org.jboss.threads.JBossThread;

class QuarkusSimpleConnectionCache
implements ConnectionCache {
    volatile ThreadLocal<Acquirable> connectionCache = new ThreadLocal();

    QuarkusSimpleConnectionCache() {
    }

    public Acquirable get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof JBossThread) {
            Acquirable acquirable = this.connectionCache.get();
            return acquirable != null && acquirable.acquire() ? acquirable : null;
        }
        return null;
    }

    public void put(Acquirable acquirable) {
        Thread thread = Thread.currentThread();
        if (thread instanceof JBossThread) {
            this.connectionCache.set(acquirable);
        }
    }

    public void reset() {
        this.connectionCache = new ThreadLocal();
    }
}

