/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.deployment;

import io.quarkus.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuilderBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuilderConfiguredBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkus.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientNettyTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientUrlConnectionTransportRecorder;
import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.NettyHttpClientConfig;
import io.quarkus.amazon.common.runtime.SdkBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.runtime.RuntimeValue;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;

public abstract class AbstractAmazonServiceProcessor {
    protected abstract Feature amazonServiceClientName();

    protected abstract String configName();

    protected abstract DotName syncClientName();

    protected abstract DotName asyncClientName();

    protected abstract String builtinInterceptorsPath();

    protected void setupExtension(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors, BuildProducer<AmazonClientBuildItem> clientProducer, SdkBuildTimeConfig buildTimeSdkConfig, SyncHttpClientBuildTimeConfig buildTimeSyncConfig) {
        feature.produce((BuildItem)new FeatureBuildItem(this.amazonServiceClientName()));
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(this.amazonServiceClientName()));
        interceptors.produce((BuildItem)new AmazonClientInterceptorsPathBuildItem(this.builtinInterceptorsPath()));
        Optional<DotName> syncClassName = Optional.empty();
        Optional<DotName> asyncClassName = Optional.empty();
        for (InjectionPointInfo injectionPoint : (Collection)beanRegistrationPhase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            Type requiredType = injectionPoint.getRequiredType();
            if (this.syncClientName().equals((Object)requiredType.name())) {
                syncClassName = Optional.of(this.syncClientName());
            }
            if (!this.asyncClientName().equals((Object)requiredType.name())) continue;
            asyncClassName = Optional.of(this.asyncClientName());
        }
        if (syncClassName.isPresent() || asyncClassName.isPresent()) {
            clientProducer.produce((BuildItem)new AmazonClientBuildItem(syncClassName, asyncClassName, this.configName(), buildTimeSdkConfig, buildTimeSyncConfig));
        }
    }

    protected void createApacheSyncTransportBuilder(List<AmazonClientBuildItem> amazonClients, AmazonClientApacheTransportRecorder recorder, SyncHttpClientBuildTimeConfig buildSyncConfig, RuntimeValue<SyncHttpClientConfig> syncConfig, BuildProducer<AmazonClientSyncTransportBuildItem> clientSyncTransports) {
        Optional<AmazonClientBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getSyncClassName().isPresent()) {
                return;
            }
            if (buildSyncConfig.type != SyncHttpClientBuildTimeConfig.SyncClientType.APACHE) {
                return;
            }
            clientSyncTransports.produce((BuildItem)new AmazonClientSyncTransportBuildItem(client.getAwsClientName(), client.getSyncClassName().get(), (RuntimeValue<SdkHttpClient.Builder>)recorder.configureSync(this.configName(), syncConfig)));
        });
    }

    protected void createUrlConnectionSyncTransportBuilder(List<AmazonClientBuildItem> amazonClients, AmazonClientUrlConnectionTransportRecorder recorder, SyncHttpClientBuildTimeConfig buildSyncConfig, RuntimeValue<SyncHttpClientConfig> syncConfig, BuildProducer<AmazonClientSyncTransportBuildItem> clientSyncTransports) {
        Optional<AmazonClientBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getSyncClassName().isPresent()) {
                return;
            }
            if (buildSyncConfig.type != SyncHttpClientBuildTimeConfig.SyncClientType.URL) {
                return;
            }
            clientSyncTransports.produce((BuildItem)new AmazonClientSyncTransportBuildItem(client.getAwsClientName(), client.getSyncClassName().get(), (RuntimeValue<SdkHttpClient.Builder>)recorder.configureSync(this.configName(), syncConfig)));
        });
    }

    protected void createNettyAsyncTransportBuilder(List<AmazonClientBuildItem> amazonClients, AmazonClientNettyTransportRecorder recorder, RuntimeValue<NettyHttpClientConfig> asyncConfig, BuildProducer<AmazonClientAsyncTransportBuildItem> clientAsyncTransports) {
        Optional<AmazonClientBuildItem> matchingClientBuildItem = amazonClients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuildItem.ifPresent(client -> {
            if (!client.getAsyncClassName().isPresent()) {
                return;
            }
            clientAsyncTransports.produce((BuildItem)new AmazonClientAsyncTransportBuildItem(client.getAwsClientName(), client.getAsyncClassName().get(), (RuntimeValue<SdkAsyncHttpClient.Builder>)recorder.configureAsync(this.configName(), asyncConfig)));
        });
    }

    protected void createClientBuilders(List<AmazonClientSyncTransportBuildItem> syncClientBuilders, List<AmazonClientAsyncTransportBuildItem> asyncClientBuilders, BuildProducer<AmazonClientBuilderBuildItem> builderProducer, Function<RuntimeValue<SdkHttpClient.Builder>, RuntimeValue<AwsClientBuilder>> syncFunc, Function<RuntimeValue<SdkAsyncHttpClient.Builder>, RuntimeValue<AwsClientBuilder>> asyncFunc) {
        String configName = this.configName();
        Optional<RuntimeValue> syncClientBuilder = syncClientBuilders.stream().filter(c -> configName.equals(c.getAwsClientName())).map(c -> c.getClientBuilder()).findFirst();
        Optional<RuntimeValue> asyncClientBuilder = asyncClientBuilders.stream().filter(c -> configName.equals(c.getAwsClientName())).map(c -> c.getClientBuilder()).findFirst();
        if (!syncClientBuilder.isPresent() && !asyncClientBuilder.isPresent()) {
            return;
        }
        builderProducer.produce((BuildItem)new AmazonClientBuilderBuildItem(configName, syncClientBuilder.isPresent() ? syncFunc.apply((RuntimeValue<SdkHttpClient.Builder>)syncClientBuilder.get()) : null, asyncClientBuilder.isPresent() ? asyncFunc.apply((RuntimeValue<SdkAsyncHttpClient.Builder>)asyncClientBuilder.get()) : null));
    }

    protected void buildClients(List<AmazonClientBuilderConfiguredBuildItem> configuredClients, Function<RuntimeValue<? extends AwsClientBuilder>, RuntimeValue<? extends SdkClient>> syncClient, Function<RuntimeValue<? extends AwsClientBuilder>, RuntimeValue<? extends SdkClient>> asyncClient) {
        for (AmazonClientBuilderConfiguredBuildItem client : configuredClients) {
            if (!this.configName().equals(client.getAwsClientName())) continue;
            if (client.getSyncBuilder() != null) {
                syncClient.apply(client.getSyncBuilder());
            }
            if (client.getAsyncBuilder() == null) continue;
            asyncClient.apply(client.getAsyncBuilder());
        }
    }

    protected void initClientBuilders(List<AmazonClientBuilderBuildItem> clients, AmazonClientRecorder recorder, RuntimeValue<AwsConfig> awsConfigRuntime, RuntimeValue<SdkConfig> sdkConfigRuntime, SdkBuildTimeConfig sdkBuildConfig, BuildProducer<AmazonClientBuilderConfiguredBuildItem> producer) {
        Optional<AmazonClientBuilderBuildItem> matchingClientBuilderBuildItem = clients.stream().filter(c -> c.getAwsClientName().equals(this.configName())).findAny();
        matchingClientBuilderBuildItem.ifPresent(client -> {
            RuntimeValue syncBuilder = null;
            RuntimeValue asyncBuilder = null;
            if (client.getSyncBuilder() != null) {
                syncBuilder = recorder.configure(client.getSyncBuilder(), awsConfigRuntime, sdkConfigRuntime, sdkBuildConfig, this.configName());
            }
            if (client.getAsyncBuilder() != null) {
                asyncBuilder = recorder.configure(client.getAsyncBuilder(), awsConfigRuntime, sdkConfigRuntime, sdkBuildConfig, this.configName());
            }
            producer.produce((BuildItem)new AmazonClientBuilderConfiguredBuildItem(this.configName(), (RuntimeValue<? extends AwsClientBuilder>)syncBuilder, asyncBuilder));
        });
    }
}

