/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.deployment;

import com.google.common.base.Predicate;
import io.quarkus.amazon.common.deployment.AmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.runtime.SdkBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientBuildTimeConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.DeploymentException;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpService;
import software.amazon.awssdk.http.async.SdkAsyncHttpService;

public class AmazonServicesClientsProcessor {
    public static final String AWS_SDK_APPLICATION_ARCHIVE_MARKERS = "software/amazon/awssdk";
    private static final String APACHE_HTTP_SERVICE = "software.amazon.awssdk.http.apache.ApacheSdkHttpService";
    private static final String NETTY_HTTP_SERVICE = "software.amazon.awssdk.http.nio.netty.NettySdkAsyncHttpService";
    private static final String URL_HTTP_SERVICE = "software.amazon.awssdk.http.urlconnection.UrlConnectionSdkHttpService";
    private static final DotName EXECUTION_INTERCEPTOR_NAME = DotName.createSimple((String)ExecutionInterceptor.class.getName());

    @BuildStep
    void globalInterceptors(BuildProducer<AmazonClientInterceptorsPathBuildItem> producer) {
        producer.produce((BuildItem)new AmazonClientInterceptorsPathBuildItem("software/amazon/awssdk/global/handlers/execution.interceptors"));
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem awsAppArchiveMarkers() {
        return new AdditionalApplicationArchiveMarkerBuildItem(AWS_SDK_APPLICATION_ARCHIVE_MARKERS);
    }

    @BuildStep
    void setup(CombinedIndexBuildItem combinedIndexBuildItem, List<AmazonClientBuildItem> amazonClients, List<AmazonClientInterceptorsPathBuildItem> interceptors, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition, BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        interceptors.stream().map(AmazonClientInterceptorsPathBuildItem::getInterceptorsPath).forEach(path -> resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path})));
        List<String> knownInterceptorImpls = combinedIndexBuildItem.getIndex().getAllKnownImplementors(EXECUTION_INTERCEPTOR_NAME).stream().map(c -> c.name().toString()).collect(Collectors.toList());
        for (AmazonClientBuildItem client2 : amazonClients) {
            SdkBuildTimeConfig clientSdkConfig = client2.getBuildTimeSdkConfig();
            if (clientSdkConfig == null) continue;
            clientSdkConfig.interceptors.orElse(Collections.emptyList()).forEach(interceptorClass -> {
                if (!knownInterceptorImpls.contains(interceptorClass.getName())) {
                    throw new ConfigurationError(String.format("quarkus.%s.interceptors (%s) - must list only existing implementations of software.amazon.awssdk.core.interceptor.ExecutionInterceptor", client2.getAwsClientName(), clientSdkConfig.interceptors.toString()));
                }
            });
        }
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, knownInterceptorImpls.toArray(new String[knownInterceptorImpls.size()])));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"com.sun.xml.internal.stream.XMLInputFactoryImpl"}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"com.sun.xml.internal.stream.XMLOutputFactoryImpl"}));
        boolean syncTransportNeeded = amazonClients.stream().anyMatch(item -> item.getSyncClassName().isPresent());
        boolean asyncTransportNeeded = amazonClients.stream().anyMatch(item -> item.getAsyncClassName().isPresent());
        Predicate isSyncApache = client -> client.getBuildTimeSyncConfig().type == SyncHttpClientBuildTimeConfig.SyncClientType.APACHE;
        if (syncTransportNeeded) {
            if (amazonClients.stream().filter(isSyncApache).findAny().isPresent()) {
                this.checkClasspath(APACHE_HTTP_SERVICE, "apache-client");
                proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"org.apache.http.conn.HttpClientConnectionManager", "org.apache.http.pool.ConnPoolControl", "software.amazon.awssdk.http.apache.internal.conn.Wrapped"}));
                serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(SdkHttpService.class.getName(), new String[]{APACHE_HTTP_SERVICE}));
            } else {
                this.checkClasspath(URL_HTTP_SERVICE, "url-connection-client");
                serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(SdkHttpService.class.getName(), new String[]{URL_HTTP_SERVICE}));
            }
        }
        if (asyncTransportNeeded) {
            this.checkClasspath(NETTY_HTTP_SERVICE, "netty-nio-client");
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(SdkAsyncHttpService.class.getName(), new String[]{NETTY_HTTP_SERVICE}));
        }
    }

    private void checkClasspath(String className, String dependencyName) {
        try {
            Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Missing 'software.amazon.awssdk:" + dependencyName + "' dependency on the classpath");
        }
    }
}

