/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.runtime;

import io.quarkus.amazon.common.runtime.FileStoreTlsManagersProviderConfig;
import io.quarkus.amazon.common.runtime.NettyHttpClientConfig;
import io.quarkus.amazon.common.runtime.RuntimeConfigurationError;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.TlsKeyManagersProviderConfig;
import io.quarkus.amazon.common.runtime.TlsKeyManagersProviderType;
import io.quarkus.amazon.common.runtime.TlsTrustManagersProviderConfig;
import io.quarkus.amazon.common.runtime.TlsTrustManagersProviderType;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.Http2Configuration;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;
import software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@Recorder
public class AmazonClientTransportRecorder {
    public RuntimeValue<SdkAsyncHttpClient.Builder> configureAsync(String clientName, RuntimeValue<NettyHttpClientConfig> asyncConfigRuntime) {
        NettyNioAsyncHttpClient.Builder builder = NettyNioAsyncHttpClient.builder();
        NettyHttpClientConfig asyncConfig = (NettyHttpClientConfig)asyncConfigRuntime.getValue();
        this.validateNettyClientConfig(clientName, asyncConfig);
        builder.connectionAcquisitionTimeout(asyncConfig.connectionAcquisitionTimeout);
        builder.connectionMaxIdleTime(asyncConfig.connectionMaxIdleTime);
        builder.connectionTimeout(asyncConfig.connectionTimeout);
        asyncConfig.connectionTimeToLive.ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)builder).connectionTimeToLive(arg_0));
        builder.maxConcurrency(Integer.valueOf(asyncConfig.maxConcurrency));
        builder.maxPendingConnectionAcquires(Integer.valueOf(asyncConfig.maxPendingConnectionAcquires));
        builder.protocol(asyncConfig.protocol);
        builder.readTimeout(asyncConfig.readTimeout);
        builder.writeTimeout(asyncConfig.writeTimeout);
        asyncConfig.sslProvider.ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)builder).sslProvider(arg_0));
        builder.useIdleConnectionReaper(Boolean.valueOf(asyncConfig.useIdleConnectionReaper));
        if (asyncConfig.http2.initialWindowSize.isPresent() || asyncConfig.http2.maxStreams.isPresent()) {
            Http2Configuration.Builder http2Builder = Http2Configuration.builder();
            asyncConfig.http2.initialWindowSize.ifPresent(arg_0 -> ((Http2Configuration.Builder)http2Builder).initialWindowSize(arg_0));
            asyncConfig.http2.maxStreams.ifPresent(arg_0 -> ((Http2Configuration.Builder)http2Builder).maxStreams(arg_0));
            asyncConfig.http2.healthCheckPingPeriod.ifPresent(arg_0 -> ((Http2Configuration.Builder)http2Builder).healthCheckPingPeriod(arg_0));
            builder.http2Configuration((Http2Configuration)http2Builder.build());
        }
        if (asyncConfig.proxy.enabled && asyncConfig.proxy.endpoint.isPresent()) {
            ProxyConfiguration.Builder proxyBuilder = software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder().scheme(asyncConfig.proxy.endpoint.get().getScheme()).host(asyncConfig.proxy.endpoint.get().getHost()).nonProxyHosts(new HashSet(asyncConfig.proxy.nonProxyHosts.orElse(Collections.emptyList())));
            if (asyncConfig.proxy.endpoint.get().getPort() != -1) {
                proxyBuilder.port(asyncConfig.proxy.endpoint.get().getPort());
            }
            builder.proxyConfiguration((software.amazon.awssdk.http.nio.netty.ProxyConfiguration)proxyBuilder.build());
        }
        this.getTlsKeyManagersProvider(asyncConfig.tlsKeyManagersProvider).ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)builder).tlsKeyManagersProvider(arg_0));
        this.getTlsTrustManagersProvider(asyncConfig.tlsTrustManagersProvider).ifPresent(arg_0 -> ((NettyNioAsyncHttpClient.Builder)builder).tlsTrustManagersProvider(arg_0));
        if (asyncConfig.eventLoop.override) {
            SdkEventLoopGroup.Builder eventLoopBuilder = SdkEventLoopGroup.builder();
            asyncConfig.eventLoop.numberOfThreads.ifPresent(arg_0 -> ((SdkEventLoopGroup.Builder)eventLoopBuilder).numberOfThreads(arg_0));
            if (asyncConfig.eventLoop.threadNamePrefix.isPresent()) {
                eventLoopBuilder.threadFactory(new ThreadFactoryBuilder().threadNamePrefix(asyncConfig.eventLoop.threadNamePrefix.get()).build());
            }
            builder.eventLoopGroupBuilder(eventLoopBuilder);
        }
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<SdkHttpClient.Builder> configureSyncUrlConnectionHttpClient(String clientName, RuntimeValue<SyncHttpClientConfig> syncConfigRuntime) {
        SyncHttpClientConfig syncConfig = (SyncHttpClientConfig)syncConfigRuntime.getValue();
        this.validateTlsKeyManagersProvider(clientName, syncConfig.tlsKeyManagersProvider, "sync");
        this.validateTlsTrustManagersProvider(clientName, syncConfig.tlsTrustManagersProvider, "sync");
        UrlConnectionHttpClient.Builder builder = UrlConnectionHttpClient.builder();
        builder.connectionTimeout(syncConfig.connectionTimeout);
        builder.socketTimeout(syncConfig.socketTimeout);
        this.getTlsKeyManagersProvider(syncConfig.tlsKeyManagersProvider).ifPresent(arg_0 -> ((UrlConnectionHttpClient.Builder)builder).tlsKeyManagersProvider(arg_0));
        this.getTlsTrustManagersProvider(syncConfig.tlsTrustManagersProvider).ifPresent(arg_0 -> ((UrlConnectionHttpClient.Builder)builder).tlsTrustManagersProvider(arg_0));
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<SdkHttpClient.Builder> configureSyncApacheHttpClient(String clientName, RuntimeValue<SyncHttpClientConfig> syncConfigRuntime) {
        SyncHttpClientConfig syncConfig = (SyncHttpClientConfig)syncConfigRuntime.getValue();
        this.validateTlsKeyManagersProvider(clientName, syncConfig.tlsKeyManagersProvider, "sync");
        this.validateTlsTrustManagersProvider(clientName, syncConfig.tlsTrustManagersProvider, "sync");
        ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        this.validateApacheClientConfig(clientName, syncConfig);
        builder.connectionTimeout(syncConfig.connectionTimeout);
        builder.connectionAcquisitionTimeout(syncConfig.apache.connectionAcquisitionTimeout);
        builder.connectionMaxIdleTime(syncConfig.apache.connectionMaxIdleTime);
        syncConfig.apache.connectionTimeToLive.ifPresent(arg_0 -> ((ApacheHttpClient.Builder)builder).connectionTimeToLive(arg_0));
        builder.expectContinueEnabled(Boolean.valueOf(syncConfig.apache.expectContinueEnabled));
        builder.maxConnections(Integer.valueOf(syncConfig.apache.maxConnections));
        builder.socketTimeout(syncConfig.socketTimeout);
        builder.useIdleConnectionReaper(Boolean.valueOf(syncConfig.apache.useIdleConnectionReaper));
        if (syncConfig.apache.proxy.enabled && syncConfig.apache.proxy.endpoint.isPresent()) {
            ProxyConfiguration.Builder proxyBuilder = ProxyConfiguration.builder().endpoint(syncConfig.apache.proxy.endpoint.get());
            syncConfig.apache.proxy.username.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).username(arg_0));
            syncConfig.apache.proxy.password.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).password(arg_0));
            syncConfig.apache.proxy.nonProxyHosts.ifPresent(c -> c.forEach(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).addNonProxyHost(arg_0)));
            syncConfig.apache.proxy.ntlmDomain.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).ntlmDomain(arg_0));
            syncConfig.apache.proxy.ntlmWorkstation.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).ntlmWorkstation(arg_0));
            syncConfig.apache.proxy.preemptiveBasicAuthenticationEnabled.ifPresent(arg_0 -> ((ProxyConfiguration.Builder)proxyBuilder).preemptiveBasicAuthenticationEnabled(arg_0));
            builder.proxyConfiguration((ProxyConfiguration)proxyBuilder.build());
        }
        this.getTlsKeyManagersProvider(syncConfig.tlsKeyManagersProvider).ifPresent(arg_0 -> ((ApacheHttpClient.Builder)builder).tlsKeyManagersProvider(arg_0));
        this.getTlsTrustManagersProvider(syncConfig.tlsTrustManagersProvider).ifPresent(arg_0 -> ((ApacheHttpClient.Builder)builder).tlsTrustManagersProvider(arg_0));
        return new RuntimeValue((Object)builder);
    }

    private Optional<TlsKeyManagersProvider> getTlsKeyManagersProvider(TlsKeyManagersProviderConfig config) {
        if (config.fileStore != null && config.fileStore.path.isPresent() && config.fileStore.type.isPresent()) {
            return Optional.of(config.type.create(config));
        }
        return Optional.empty();
    }

    private Optional<TlsTrustManagersProvider> getTlsTrustManagersProvider(TlsTrustManagersProviderConfig config) {
        if (config.fileStore != null && config.fileStore.path.isPresent() && config.fileStore.type.isPresent()) {
            return Optional.of(config.type.create(config));
        }
        return Optional.empty();
    }

    private void validateApacheClientConfig(String extension, SyncHttpClientConfig config) {
        if (config.apache.maxConnections <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.sync-client.max-connections may not be negative or zero.", extension));
        }
        if (config.apache.proxy.enabled) {
            config.apache.proxy.endpoint.ifPresent(uri -> this.validateProxyEndpoint(extension, (URI)uri, "sync"));
        }
    }

    private void validateNettyClientConfig(String extension, NettyHttpClientConfig config) {
        if (config.maxConcurrency <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.max-concurrency may not be negative or zero.", extension));
        }
        if (config.http2.maxStreams.isPresent() && config.http2.maxStreams.get() <= 0L) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.http2.max-streams may not be negative.", extension));
        }
        if (config.http2.initialWindowSize.isPresent() && config.http2.initialWindowSize.getAsInt() <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.http2.initial-window-size may not be negative.", extension));
        }
        if (config.maxPendingConnectionAcquires <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.max-pending-connection-acquires may not be negative or zero.", extension));
        }
        if (config.eventLoop.override && config.eventLoop.numberOfThreads.isPresent() && config.eventLoop.numberOfThreads.getAsInt() <= 0) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.async-client.event-loop.number-of-threads may not be negative or zero.", extension));
        }
        if (config.proxy.enabled) {
            config.proxy.endpoint.ifPresent(uri -> this.validateProxyEndpoint(extension, (URI)uri, "async"));
        }
        this.validateTlsKeyManagersProvider(extension, config.tlsKeyManagersProvider, "async");
        this.validateTlsTrustManagersProvider(extension, config.tlsTrustManagersProvider, "async");
    }

    private void validateProxyEndpoint(String extension, URI endpoint, String clientType) {
        if (StringUtils.isBlank((CharSequence)endpoint.getScheme())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - scheme must be specified", extension, clientType, endpoint.toString()));
        }
        if (StringUtils.isBlank((CharSequence)endpoint.getHost())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - host must be specified", extension, clientType, endpoint.toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getUserInfo())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - user info is not supported.", extension, clientType, endpoint.toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getPath())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - path is not supported.", extension, clientType, endpoint.toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getQuery())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - query is not supported.", extension, clientType, endpoint.toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getFragment())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.proxy.endpoint (%s) - fragment is not supported.", extension, clientType, endpoint.toString()));
        }
    }

    private void validateTlsKeyManagersProvider(String extension, TlsKeyManagersProviderConfig config, String clientType) {
        if (config != null && config.type == TlsKeyManagersProviderType.FILE_STORE) {
            this.validateFileStore(extension, clientType, "key", config.fileStore);
        }
    }

    private void validateTlsTrustManagersProvider(String extension, TlsTrustManagersProviderConfig config, String clientType) {
        if (config != null && config.type == TlsTrustManagersProviderType.FILE_STORE) {
            this.validateFileStore(extension, clientType, "trust", config.fileStore);
        }
    }

    private void validateFileStore(String extension, String clientType, String storeType, FileStoreTlsManagersProviderConfig fileStore) {
        if (fileStore == null) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.tls-%s-managers-provider.file-store must be specified if 'FILE_STORE' provider type is used", extension, clientType, storeType));
        }
        if (!fileStore.password.isPresent()) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.tls-%s-managers-provider.file-store.path should not be empty if 'FILE_STORE' provider is used.", extension, clientType, storeType));
        }
        if (!fileStore.type.isPresent()) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.tls-%s-managers-provider.file-store.type should not be empty if 'FILE_STORE' provider is used.", extension, clientType, storeType));
        }
        if (!fileStore.password.isPresent()) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.%s-client.tls-%s-managers-provider.file-store.password should not be empty if 'FILE_STORE' provider is used.", extension, clientType, storeType));
        }
    }
}

