/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.common.runtime;

import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.AwsCredentialsProviderType;
import io.quarkus.amazon.common.runtime.RuntimeConfigurationError;
import io.quarkus.amazon.common.runtime.SdkBuildTimeConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.utils.StringUtils;

@Recorder
public class AmazonClientRecorder {
    private static final Log LOG = LogFactory.getLog(AmazonClientRecorder.class);

    public RuntimeValue<AwsClientBuilder> configure(RuntimeValue<? extends AwsClientBuilder> clientBuilder, RuntimeValue<AwsConfig> awsConfig, RuntimeValue<SdkConfig> sdkConfig, SdkBuildTimeConfig sdkBuildTimeConfig, String awsServiceName) {
        AwsClientBuilder builder = (AwsClientBuilder)clientBuilder.getValue();
        this.initAwsClient(builder, awsServiceName, (AwsConfig)awsConfig.getValue());
        this.initSdkClient((SdkClientBuilder)builder, awsServiceName, (SdkConfig)sdkConfig.getValue(), sdkBuildTimeConfig);
        return new RuntimeValue((Object)builder);
    }

    public void initAwsClient(AwsClientBuilder builder, String extension, AwsConfig config) {
        config.region.ifPresent(arg_0 -> ((AwsClientBuilder)builder).region(arg_0));
        if (!(config.credentials.type != AwsCredentialsProviderType.STATIC || config.credentials.staticProvider.accessKeyId.isPresent() && config.credentials.staticProvider.secretAccessKey.isPresent())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.aws.credentials.static-provider.access-key-id and quarkus.%s.aws.credentials.static-provider.secret-access-key cannot be empty if STATIC credentials provider used.", extension, extension));
        }
        if (config.credentials.type == AwsCredentialsProviderType.PROCESS && !config.credentials.processProvider.command.isPresent()) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.aws.credentials.process-provider.command cannot be empty if PROCESS credentials provider used.", extension));
        }
        builder.credentialsProvider(config.credentials.type.create(config.credentials));
    }

    public void initSdkClient(SdkClientBuilder builder, String extension, SdkConfig config, SdkBuildTimeConfig buildConfig) {
        URI endpointOverride;
        if (config.endpointOverride.isPresent() && StringUtils.isBlank((CharSequence)(endpointOverride = config.endpointOverride.get()).getScheme())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.endpoint-override (%s) - scheme must be specified", extension, endpointOverride.toString()));
        }
        config.endpointOverride.filter(URI::isAbsolute).ifPresent(arg_0 -> ((SdkClientBuilder)builder).endpointOverride(arg_0));
        ClientOverrideConfiguration.Builder overrides = ClientOverrideConfiguration.builder();
        config.apiCallTimeout.ifPresent(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).apiCallTimeout(arg_0));
        config.apiCallAttemptTimeout.ifPresent(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).apiCallAttemptTimeout(arg_0));
        buildConfig.interceptors.orElse(Collections.emptyList()).stream().map(this::createInterceptor).filter(Objects::nonNull).forEach(arg_0 -> ((ClientOverrideConfiguration.Builder)overrides).addExecutionInterceptor(arg_0));
        builder.overrideConfiguration((ClientOverrideConfiguration)overrides.build());
    }

    private ExecutionInterceptor createInterceptor(Class<?> interceptorClass) {
        try {
            return (ExecutionInterceptor)Class.forName(interceptorClass.getName()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error((Object)"Unable to create interceptor", (Throwable)e);
            return null;
        }
    }
}

