/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.kms.runtime;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.KmsAsyncClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;

@ApplicationScoped
public class KmsClientProducer {
    private volatile KmsClientBuilder syncConfiguredBuilder;
    private volatile KmsAsyncClientBuilder asyncConfiguredBuilder;
    private KmsClient client;
    private KmsAsyncClient asyncClient;

    @Produces
    @ApplicationScoped
    public KmsClient client() {
        this.client = (KmsClient)this.syncConfiguredBuilder.build();
        return this.client;
    }

    @Produces
    @ApplicationScoped
    public KmsAsyncClient asyncClient() {
        this.asyncClient = (KmsAsyncClient)this.asyncConfiguredBuilder.build();
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }

    public void setSyncConfiguredBuilder(KmsClientBuilder syncConfiguredBuilder) {
        this.syncConfiguredBuilder = syncConfiguredBuilder;
    }

    public void setAsyncConfiguredBuilder(KmsAsyncClientBuilder asyncConfiguredBuilder) {
        this.asyncConfiguredBuilder = asyncConfiguredBuilder;
    }
}

