/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.kms.runtime;

import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.NettyHttpClientConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.kms.runtime.KmsClientProducer;
import io.quarkus.amazon.kms.runtime.KmsConfig;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.KmsAsyncClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;

@Recorder
public class KmsRecorder {
    public RuntimeValue<SyncHttpClientConfig> getSyncConfig(KmsConfig config) {
        return new RuntimeValue((Object)config.syncClient);
    }

    public RuntimeValue<NettyHttpClientConfig> getAsyncConfig(KmsConfig config) {
        return new RuntimeValue((Object)config.asyncClient);
    }

    public RuntimeValue<AwsConfig> getAwsConfig(KmsConfig config) {
        return new RuntimeValue((Object)config.aws);
    }

    public RuntimeValue<SdkConfig> getSdkConfig(KmsConfig config) {
        return new RuntimeValue((Object)config.sdk);
    }

    public RuntimeValue<AwsClientBuilder> createSyncBuilder(KmsConfig config, RuntimeValue<SdkHttpClient.Builder> transport) {
        KmsClientBuilder builder = KmsClient.builder();
        if (transport != null) {
            builder.httpClientBuilder((SdkHttpClient.Builder)transport.getValue());
        }
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<AwsClientBuilder> createAsyncBuilder(KmsConfig config, RuntimeValue<SdkAsyncHttpClient.Builder> transport) {
        KmsAsyncClientBuilder builder = KmsAsyncClient.builder();
        if (transport != null) {
            builder.httpClientBuilder((SdkAsyncHttpClient.Builder)transport.getValue());
        }
        return new RuntimeValue((Object)builder);
    }

    public RuntimeValue<KmsClient> buildClient(RuntimeValue<? extends AwsClientBuilder> builder, BeanContainer beanContainer, ShutdownContext shutdown) {
        KmsClientProducer producer = (KmsClientProducer)beanContainer.instance(KmsClientProducer.class, new Annotation[0]);
        producer.setSyncConfiguredBuilder((KmsClientBuilder)builder.getValue());
        shutdown.addShutdownTask(producer::destroy);
        return new RuntimeValue((Object)producer.client());
    }

    public RuntimeValue<KmsAsyncClient> buildAsyncClient(RuntimeValue<? extends AwsClientBuilder> builder, BeanContainer beanContainer, ShutdownContext shutdown) {
        KmsClientProducer producer = (KmsClientProducer)beanContainer.instance(KmsClientProducer.class, new Annotation[0]);
        producer.setAsyncConfiguredBuilder((KmsAsyncClientBuilder)builder.getValue());
        shutdown.addShutdownTask(producer::destroy);
        return new RuntimeValue((Object)producer.asyncClient());
    }
}

