/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.LegacyJarRequiredBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UpxCompressedBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.jboss.logging.Logger;

public class FunctionZipProcessor {
    private static final Logger log = Logger.getLogger(FunctionZipProcessor.class);

    @BuildStep(onlyIf={IsNormal.class}, onlyIfNot={NativeBuild.class})
    public void requireLegacy(BuildProducer<LegacyJarRequiredBuildItem> required) {
        required.produce((BuildItem)new LegacyJarRequiredBuildItem());
    }

    @BuildStep(onlyIf={IsNormal.class}, onlyIfNot={NativeBuild.class})
    public void jvmZip(OutputTargetBuildItem target, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, JarBuildItem jar) throws Exception {
        block27: {
            Path zipPath = target.getOutputDirectory().resolve("function.zip");
            Path zipDir = FunctionZipProcessor.findJvmZipDir(target.getOutputDirectory());
            try (ZipArchiveOutputStream zip = new ZipArchiveOutputStream(zipPath.toFile());){
                Stream<Path> paths;
                try (ZipArchiveInputStream zinput = new ZipArchiveInputStream((InputStream)new FileInputStream(jar.getPath().toFile()));){
                    ZipArchiveEntry entry;
                    while ((entry = zinput.getNextZipEntry()) != null) {
                        this.copyZipEntry(zip, (InputStream)zinput, entry);
                    }
                }
                if (zipDir != null) {
                    paths = Files.walk(zipDir, new FileVisitOption[0]);
                    try {
                        paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                            try {
                                int mode = Files.isExecutable(path) ? 493 : 420;
                                this.addZipEntry(zip, (Path)path, zipDir.relativize((Path)path).toString().replace('\\', '/'), mode);
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex);
                            }
                        });
                    }
                    finally {
                        if (paths != null) {
                            paths.close();
                        }
                    }
                }
                if (jar.isUberJar()) break block27;
                paths = Files.walk(jar.getLibraryDir(), new FileVisitOption[0]);
                try {
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        try {
                            int mode = Files.isExecutable(path) ? 493 : 420;
                            this.addZipEntry(zip, (Path)path, "lib/" + jar.getLibraryDir().relativize((Path)path).toString().replace('\\', '/'), mode);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    });
                }
                finally {
                    if (paths != null) {
                        paths.close();
                    }
                }
            }
        }
    }

    @BuildStep(onlyIf={IsNormal.class, NativeBuild.class})
    public void nativeZip(OutputTargetBuildItem target, Optional<UpxCompressedBuildItem> upxCompressed, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, NativeImageBuildItem nativeImage) throws Exception {
        Path zipDir = FunctionZipProcessor.findNativeZipDir(target.getOutputDirectory());
        Path zipPath = target.getOutputDirectory().resolve("function.zip");
        Files.deleteIfExists(zipPath);
        try (ZipArchiveOutputStream zip = new ZipArchiveOutputStream(zipPath.toFile());){
            String executableName = "bootstrap";
            if (zipDir != null) {
                File bootstrap = zipDir.resolve("bootstrap").toFile();
                if (bootstrap.exists()) {
                    executableName = "runner";
                }
                try (Stream<Path> paths = Files.walk(zipDir, new FileVisitOption[0]);){
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        try {
                            if (bootstrap.equals(path.toFile())) {
                                this.addZipEntry(zip, (Path)path, "bootstrap", 493);
                            } else {
                                int mode = Files.isExecutable(path) ? 493 : 420;
                                this.addZipEntry(zip, (Path)path, zipDir.relativize((Path)path).toString().replace('\\', '/'), mode);
                            }
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    });
                }
            }
            this.addZipEntry(zip, nativeImage.getPath(), executableName, 493);
        }
    }

    private void copyZipEntry(ZipArchiveOutputStream zip, InputStream zinput, ZipArchiveEntry from) throws Exception {
        ZipArchiveEntry entry = new ZipArchiveEntry(from);
        zip.putArchiveEntry((ArchiveEntry)entry);
        zinput.transferTo((OutputStream)zip);
        zip.closeArchiveEntry();
    }

    private void addZipEntry(ZipArchiveOutputStream zip, Path path, String name, int mode) throws Exception {
        ZipArchiveEntry entry = (ZipArchiveEntry)zip.createArchiveEntry(path.toFile(), name);
        entry.setUnixMode(mode);
        zip.putArchiveEntry((ArchiveEntry)entry);
        try (InputStream i = Files.newInputStream(path, new OpenOption[0]);){
            i.transferTo((OutputStream)zip);
        }
        zip.closeArchiveEntry();
    }

    private static Path findNativeZipDir(Path outputDirectory) {
        Path mainSrc = FunctionZipProcessor.findMainSourcesRoot(outputDirectory);
        if (mainSrc == null) {
            return null;
        }
        Path zipDir = mainSrc.resolve("zip.native");
        return Files.exists(zipDir, new LinkOption[0]) && Files.isDirectory(zipDir, new LinkOption[0]) ? zipDir : null;
    }

    private static Path findJvmZipDir(Path outputDirectory) {
        Path mainSrc = FunctionZipProcessor.findMainSourcesRoot(outputDirectory);
        if (mainSrc == null) {
            return null;
        }
        Path zipDir = mainSrc.resolve("zip.jvm");
        return Files.exists(zipDir, new LinkOption[0]) && Files.isDirectory(zipDir, new LinkOption[0]) ? zipDir : null;
    }

    private static Path findMainSourcesRoot(Path outputDirectory) {
        Path currentPath = outputDirectory;
        while (true) {
            Path toCheck;
            if ((toCheck = currentPath.resolve(Paths.get("src", "main"))).toFile().exists()) {
                return toCheck;
            }
            Path parent = currentPath.getParent();
            if (parent == null || !Files.exists(parent, new LinkOption[0])) break;
            currentPath = parent;
        }
        return null;
    }
}

