/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import io.quarkus.amazon.lambda.deployment.EventServerOverrideBuildItem;
import io.quarkus.amazon.lambda.deployment.LambdaConfig;
import io.quarkus.amazon.lambda.deployment.LambdaObjectMapperInitializedBuildItem;
import io.quarkus.amazon.lambda.runtime.LambdaHotReplacementRecorder;
import io.quarkus.amazon.lambda.runtime.MockEventServer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.runtime.LaunchMode;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class DevServicesLambdaProcessor {
    private static final Logger log = Logger.getLogger(DevServicesLambdaProcessor.class);
    static MockEventServer server;
    static LaunchMode startMode;

    @BuildStep(onlyIfNot={IsNormal.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public void enableHotReplacementChecker(LaunchModeBuildItem launchMode, LambdaHotReplacementRecorder recorder, LambdaObjectMapperInitializedBuildItem dependency) {
        if (launchMode.getLaunchMode().isDevOrTest() && !this.legacyTestingEnabled()) {
            recorder.enable();
        }
    }

    private boolean legacyTestingEnabled() {
        try {
            Class.forName("io.quarkus.amazon.lambda.test.LambdaClient");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Produce(value=ServiceStartBuildItem.class)
    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public void startEventServer(LaunchModeBuildItem launchMode, LambdaConfig config, Optional<EventServerOverrideBuildItem> override, BuildProducer<DevServicesResultBuildItem> devServicePropertiesProducer, CuratedApplicationShutdownBuildItem closeBuildItem) throws Exception {
        if (!launchMode.getLaunchMode().isDevOrTest()) {
            return;
        }
        if (this.legacyTestingEnabled()) {
            return;
        }
        if (server != null) {
            return;
        }
        Supplier<MockEventServer> supplier = null;
        supplier = override.isPresent() ? override.get().getServer() : () -> new MockEventServer();
        server = supplier.get();
        int port = launchMode.getLaunchMode() == LaunchMode.TEST ? config.mockEventServer.testPort : config.mockEventServer.devPort;
        startMode = launchMode.getLaunchMode();
        server.start(port);
        int actualPort = server.getPort();
        String baseUrl = "localhost:" + actualPort + "/_lambda_";
        HashMap<String, CallSite> properties = new HashMap<String, CallSite>();
        properties.put("quarkus-internal.aws-lambda.test-api", (CallSite)((Object)baseUrl));
        if (actualPort != port) {
            String portPropertyValue = String.valueOf(actualPort);
            String portPropertySuffix = launchMode.getLaunchMode() == LaunchMode.TEST ? "test-port" : "dev-port";
            String propName = "quarkus.lambda.mock-event-server." + portPropertySuffix;
            System.setProperty(propName, portPropertyValue);
        }
        devServicePropertiesProducer.produce((BuildItem)new DevServicesResultBuildItem(Feature.AMAZON_LAMBDA.getName(), null, properties));
        Runnable closeTask = () -> {
            if (server != null) {
                try {
                    server.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop the Lambda Mock Event Server", e);
                }
                finally {
                    server = null;
                }
            }
            startMode = null;
            server = null;
        };
        closeBuildItem.addCloseTask(closeTask, true);
    }
}

