/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaApi;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaContext;
import io.quarkus.amazon.lambda.runtime.FunctionError;
import io.quarkus.amazon.lambda.runtime.TraceId;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.ShutdownContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;

public abstract class AbstractLambdaPollLoop {
    private static final Logger log = Logger.getLogger(AbstractLambdaPollLoop.class);
    private ObjectMapper objectMapper;
    private ObjectReader cognitoIdReader;
    private ObjectReader clientCtxReader;

    public AbstractLambdaPollLoop(ObjectMapper objectMapper, ObjectReader cognitoIdReader, ObjectReader clientCtxReader) {
        this.objectMapper = objectMapper;
        this.cognitoIdReader = cognitoIdReader;
        this.clientCtxReader = clientCtxReader;
    }

    protected abstract boolean isStream();

    public void startPollLoop(ShutdownContext context) {
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread pollingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractLambdaPollLoop.this.checkQuarkusBootstrapped();
                    URL requestUrl = AmazonLambdaApi.invocationNext();
                    while (running.get()) {
                        HttpURLConnection requestConnection = (HttpURLConnection)requestUrl.openConnection();
                        try {
                            String requestId = requestConnection.getHeaderField("Lambda-Runtime-Aws-Request-Id");
                            try {
                                String traceId = requestConnection.getHeaderField("Lambda-Runtime-Trace-Id");
                                TraceId.setTraceId(traceId);
                                URL url = AmazonLambdaApi.invocationResponse(requestId);
                                if (AbstractLambdaPollLoop.this.isStream()) {
                                    HttpURLConnection responseConnection = AbstractLambdaPollLoop.this.responseStream(url);
                                    AbstractLambdaPollLoop.this.processRequest(requestConnection.getInputStream(), responseConnection.getOutputStream(), AbstractLambdaPollLoop.this.createContext(requestConnection));
                                    while (responseConnection.getInputStream().read() != -1) {
                                    }
                                    continue;
                                }
                                Object input = null;
                                if (AbstractLambdaPollLoop.this.getInputReader() != null) {
                                    input = AbstractLambdaPollLoop.this.getInputReader().readValue(requestConnection.getInputStream());
                                }
                                Object output = AbstractLambdaPollLoop.this.processRequest(input, AbstractLambdaPollLoop.this.createContext(requestConnection));
                                AbstractLambdaPollLoop.this.postResponse(url, output);
                            }
                            catch (Exception e) {
                                log.error((Object)"Failed to run lambda", (Throwable)e);
                                AbstractLambdaPollLoop.this.postError(AmazonLambdaApi.invocationError(requestId), new FunctionError(e.getClass().getName(), e.getMessage()));
                                requestConnection.getInputStream().close();
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"Error running lambda", (Throwable)e);
                            Application app = Application.currentApplication();
                            if (app != null) {
                                app.stop();
                            }
                            return;
                        }
                        finally {
                            requestConnection.getInputStream().close();
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        log.error((Object)"Lambda init error", (Throwable)e);
                        AbstractLambdaPollLoop.this.postError(AmazonLambdaApi.initError(), new FunctionError(e.getClass().getName(), e.getMessage()));
                    }
                    catch (Exception ex) {
                        log.error((Object)"Failed to report init error", (Throwable)ex);
                    }
                    finally {
                        Application app = Application.currentApplication();
                        if (app != null) {
                            app.stop();
                        }
                    }
                }
            }
        }, "Lambda Thread");
        context.addShutdownTask(() -> {
            running.set(false);
            pollingThread.interrupt();
        });
        pollingThread.start();
    }

    protected abstract Object processRequest(Object var1, AmazonLambdaContext var2) throws Exception;

    protected abstract void processRequest(InputStream var1, OutputStream var2, AmazonLambdaContext var3) throws Exception;

    protected abstract ObjectReader getInputReader();

    protected abstract ObjectWriter getOutputWriter();

    protected AmazonLambdaContext createContext(HttpURLConnection requestConnection) throws IOException {
        return new AmazonLambdaContext(requestConnection, this.cognitoIdReader, this.clientCtxReader);
    }

    private void checkQuarkusBootstrapped() {
        if (Application.currentApplication() == null) {
            throw new RuntimeException("Quarkus initialization error");
        }
        String[] args = new String[]{};
        Application.currentApplication().start(args);
    }

    protected void postResponse(URL url, Object response) throws IOException {
        HttpURLConnection responseConnection = (HttpURLConnection)url.openConnection();
        responseConnection.setDoOutput(true);
        responseConnection.setRequestMethod("POST");
        if (response != null) {
            this.getOutputWriter().writeValue(responseConnection.getOutputStream(), response);
        }
        while (responseConnection.getInputStream().read() != -1) {
        }
    }

    protected void postError(URL url, Object response) throws IOException {
        HttpURLConnection responseConnection = (HttpURLConnection)url.openConnection();
        responseConnection.setDoOutput(true);
        responseConnection.setRequestMethod("POST");
        this.objectMapper.writeValue(responseConnection.getOutputStream(), response);
        while (responseConnection.getInputStream().read() != -1) {
        }
    }

    protected HttpURLConnection responseStream(URL url) throws IOException {
        HttpURLConnection responseConnection = (HttpURLConnection)url.openConnection();
        responseConnection.setDoOutput(true);
        responseConnection.setRequestMethod("POST");
        return responseConnection;
    }
}

