/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaApi;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaContext;
import io.quarkus.amazon.lambda.runtime.FunctionError;
import io.quarkus.amazon.lambda.runtime.LambdaInputReader;
import io.quarkus.amazon.lambda.runtime.LambdaOutputWriter;
import io.quarkus.amazon.lambda.runtime.TraceId;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.ShutdownContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;

public abstract class AbstractLambdaPollLoop {
    private static final Logger log = Logger.getLogger(AbstractLambdaPollLoop.class);
    private ObjectMapper objectMapper;
    private ObjectReader cognitoIdReader;
    private ObjectReader clientCtxReader;

    public AbstractLambdaPollLoop(ObjectMapper objectMapper, ObjectReader cognitoIdReader, ObjectReader clientCtxReader) {
        this.objectMapper = objectMapper;
        this.cognitoIdReader = cognitoIdReader;
        this.clientCtxReader = clientCtxReader;
    }

    protected abstract boolean isStream();

    public void startPollLoop(ShutdownContext context) {
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread pollingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                try {
                    AbstractLambdaPollLoop.this.checkQuarkusBootstrapped();
                    URL requestUrl = AmazonLambdaApi.invocationNext();
                    while (running.get()) {
                        HttpURLConnection requestConnection = null;
                        try {
                            requestConnection = (HttpURLConnection)requestUrl.openConnection();
                        }
                        catch (IOException e) {
                            if (AbstractLambdaPollLoop.this.abortGracefully(e)) {
                                return;
                            }
                            throw e;
                        }
                        try {
                            String requestId = requestConnection.getHeaderField("Lambda-Runtime-Aws-Request-Id");
                            try {
                                String traceId = requestConnection.getHeaderField("Lambda-Runtime-Trace-Id");
                                TraceId.setTraceId(traceId);
                                URL url = AmazonLambdaApi.invocationResponse(requestId);
                                if (AbstractLambdaPollLoop.this.isStream()) {
                                    HttpURLConnection responseConnection = AbstractLambdaPollLoop.this.responseStream(url);
                                    if (!running.get()) continue;
                                    AbstractLambdaPollLoop.this.processRequest(requestConnection.getInputStream(), responseConnection.getOutputStream(), AbstractLambdaPollLoop.this.createContext(requestConnection));
                                    while (responseConnection.getInputStream().read() != -1) {
                                    }
                                    continue;
                                }
                                Object input = null;
                                if (!running.get()) continue;
                                LambdaInputReader inputReader = AbstractLambdaPollLoop.this.getInputReader();
                                if (inputReader != null) {
                                    input = inputReader.readValue(requestConnection.getInputStream());
                                }
                                Object output = AbstractLambdaPollLoop.this.processRequest(input, AbstractLambdaPollLoop.this.createContext(requestConnection));
                                AbstractLambdaPollLoop.this.postResponse(url, output);
                            }
                            catch (Exception e) {
                                if (AbstractLambdaPollLoop.this.abortGracefully(e)) {
                                    try {
                                        requestConnection.getInputStream().close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                log.error((Object)"Failed to run lambda", (Throwable)e);
                                AbstractLambdaPollLoop.this.postError(AmazonLambdaApi.invocationError(requestId), new FunctionError(e.getClass().getName(), e.getMessage()));
                                try {
                                    requestConnection.getInputStream().close();
                                }
                                catch (IOException iOException) {}
                                continue;
                                catch (Exception e2) {
                                    Application app;
                                    if (!AbstractLambdaPollLoop.this.abortGracefully(e2)) {
                                        log.error((Object)"Error running lambda", (Throwable)e2);
                                    }
                                    if ((app = Application.currentApplication()) != null) {
                                        app.stop();
                                    }
                                    return;
                                }
                            }
                        }
                        finally {
                            try {
                                requestConnection.getInputStream().close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        log.error((Object)"Lambda init error", (Throwable)e);
                        AbstractLambdaPollLoop.this.postError(AmazonLambdaApi.initError(), new FunctionError(e.getClass().getName(), e.getMessage()));
                    }
                    catch (Exception ex) {
                        log.error((Object)"Failed to report init error", (Throwable)ex);
                    }
                    finally {
                        Application app = Application.currentApplication();
                        if (app != null) {
                            app.stop();
                        }
                    }
                }
            }
        }, "Lambda Thread");
        pollingThread.setDaemon(true);
        context.addShutdownTask(() -> {
            running.set(false);
            pollingThread.interrupt();
        });
        pollingThread.start();
    }

    protected abstract Object processRequest(Object var1, AmazonLambdaContext var2) throws Exception;

    protected abstract void processRequest(InputStream var1, OutputStream var2, AmazonLambdaContext var3) throws Exception;

    protected abstract LambdaInputReader getInputReader();

    protected abstract LambdaOutputWriter getOutputWriter();

    protected AmazonLambdaContext createContext(HttpURLConnection requestConnection) throws IOException {
        return new AmazonLambdaContext(requestConnection, this.cognitoIdReader, this.clientCtxReader);
    }

    private void checkQuarkusBootstrapped() {
        if (Application.currentApplication() == null) {
            throw new RuntimeException("Quarkus initialization error");
        }
        String[] args = new String[]{};
        Application.currentApplication().start(args);
    }

    protected void postResponse(URL url, Object response) throws IOException {
        HttpURLConnection responseConnection = (HttpURLConnection)url.openConnection();
        responseConnection.setDoOutput(true);
        responseConnection.setRequestMethod("POST");
        if (response != null) {
            this.getOutputWriter().writeValue(responseConnection.getOutputStream(), response);
        }
        while (responseConnection.getInputStream().read() != -1) {
        }
    }

    protected void postError(URL url, Object response) throws IOException {
        HttpURLConnection responseConnection = (HttpURLConnection)url.openConnection();
        responseConnection.setDoOutput(true);
        responseConnection.setRequestMethod("POST");
        this.objectMapper.writeValue(responseConnection.getOutputStream(), response);
        while (responseConnection.getInputStream().read() != -1) {
        }
    }

    protected HttpURLConnection responseStream(URL url) throws IOException {
        HttpURLConnection responseConnection = (HttpURLConnection)url.openConnection();
        responseConnection.setDoOutput(true);
        responseConnection.setRequestMethod("POST");
        return responseConnection;
    }

    boolean abortGracefully(Exception ex) {
        boolean graceful;
        boolean lambdaEnv = System.getenv("AWS_LAMBDA_RUNTIME_API") != null;
        boolean testEnv = System.getProperty("quarkus-internal.aws-lambda.test-api") != null;
        boolean bl = graceful = (ex instanceof SocketException || ex instanceof ConnectException) && testEnv || ex instanceof UnknownHostException && !lambdaEnv;
        if (graceful) {
            log.warn((Object)("Aborting lambda poll loop: " + (!lambdaEnv ? "no lambda container found" : "test mode")));
        }
        return graceful;
    }
}

