/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import io.quarkus.amazon.lambda.deployment.AmazonLambdaBuildItem;
import io.quarkus.amazon.lambda.deployment.ProvidedAmazonLambdaHandlerBuildItem;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaRecorder;
import io.quarkus.amazon.lambda.runtime.FunctionError;
import io.quarkus.amazon.lambda.runtime.LambdaBuildTimeConfig;
import io.quarkus.amazon.lambda.runtime.LambdaConfig;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.joda.time.DateTime;

public final class AmazonLambdaProcessor {
    public static final String AWS_LAMBDA_EVENTS_ARCHIVE_MARKERS = "com/amazonaws/services/lambda/runtime/events";
    private static final DotName REQUEST_HANDLER = DotName.createSimple((String)RequestHandler.class.getName());
    private static final DotName REQUEST_STREAM_HANDLER = DotName.createSimple((String)RequestStreamHandler.class.getName());
    private static final DotName SKILL_STREAM_HANDLER = DotName.createSimple((String)"com.amazon.ask.SkillStreamHandler");
    private static final DotName NAMED = DotName.createSimple((String)Named.class.getName());
    private static final Logger log = Logger.getLogger(AmazonLambdaProcessor.class);

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.AMAZON_LAMBDA);
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem marker() {
        return new AdditionalApplicationArchiveMarkerBuildItem(AWS_LAMBDA_EVENTS_ARCHIVE_MARKERS);
    }

    @BuildStep
    List<AmazonLambdaBuildItem> discover(CombinedIndexBuildItem combinedIndexBuildItem, Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer) throws BuildException {
        Collection allKnownImplementors = combinedIndexBuildItem.getIndex().getAllKnownImplementors(REQUEST_HANDLER);
        allKnownImplementors.addAll(combinedIndexBuildItem.getIndex().getAllKnownImplementors(REQUEST_STREAM_HANDLER));
        allKnownImplementors.addAll(combinedIndexBuildItem.getIndex().getAllKnownSubclasses(SKILL_STREAM_HANDLER));
        if (allKnownImplementors.size() > 0 && providedLambda.isPresent()) {
            throw new BuildException("Multiple handler classes.  You have a custom handler class and the " + providedLambda.get().getProvider() + " extension.  Please remove one of them from your deployment.", Collections.emptyList());
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        ArrayList<AmazonLambdaBuildItem> ret = new ArrayList<AmazonLambdaBuildItem>();
        for (ClassInfo info : allKnownImplementors) {
            boolean streamHandler;
            if (Modifier.isAbstract(info.flags())) continue;
            DotName name = info.name();
            String lambda = name.toString();
            builder.addBeanClass(lambda);
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{lambda}));
            String cdiName = null;
            AnnotationInstance named = info.classAnnotation(NAMED);
            if (named != null) {
                cdiName = named.value().asString();
            }
            ClassInfo current = info;
            boolean done = false;
            boolean bl = streamHandler = info.superName().equals((Object)SKILL_STREAM_HANDLER);
            while (current != null && !done) {
                for (MethodInfo method : current.methods()) {
                    if (!method.name().equals("handleRequest")) continue;
                    if (method.parameters().size() == 3) {
                        streamHandler = true;
                        done = true;
                        break;
                    }
                    if (method.parameters().size() != 2 || ((Type)method.parameters().get(0)).name().equals((Object)DotName.createSimple((String)Object.class.getName()))) continue;
                    String source = this.getClass().getSimpleName() + " > " + method.declaringClass() + "[" + method + "]";
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type((Type)method.parameters().get(0)).source(source).build());
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(method.returnType()).source(source).build());
                    done = true;
                    break;
                }
                current = combinedIndexBuildItem.getIndex().getClassByName(current.superName());
            }
            ret.add(new AmazonLambdaBuildItem(lambda, cdiName, streamHandler));
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)builder.build());
        reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new Class[]{FunctionError.class}));
        return ret;
    }

    @BuildStep
    void processProvidedLambda(Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer) {
        if (!providedLambda.isPresent()) {
            return;
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        Class handlerClass = providedLambda.get().getHandlerClass();
        builder.addBeanClass(handlerClass);
        additionalBeanBuildItemBuildProducer.produce((BuildItem)builder.build());
        reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new Class[]{handlerClass}));
        for (Method method : handlerClass.getMethods()) {
            if (!method.getName().equals("handleRequest") || method.getParameterTypes().length != 2 || method.getParameterTypes()[0].equals(Object.class)) continue;
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{method.getParameterTypes()[0].getName()}));
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{method.getReturnType().getName()}));
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new Class[]{DateTime.class}));
            break;
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void recordHandlerClass(List<AmazonLambdaBuildItem> lambdas, Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BeanContainerBuildItem beanContainerBuildItem, AmazonLambdaRecorder recorder, LambdaConfig config, List<ServiceStartBuildItem> orderServicesFirst, RecorderContext context) {
        if (providedLambda.isPresent()) {
            Class handlerClass;
            boolean useStreamHandler = false;
            for (Class<?> handleInterface : providedLambda.get().getHandlerClass().getInterfaces()) {
                if (!handleInterface.getName().equals(RequestStreamHandler.class.getName())) continue;
                useStreamHandler = true;
            }
            if (useStreamHandler) {
                handlerClass = context.classProxy(providedLambda.get().getHandlerClass().getName());
                recorder.setStreamHandlerClass(handlerClass, beanContainerBuildItem.getValue());
            } else {
                handlerClass = context.classProxy(providedLambda.get().getHandlerClass().getName());
                recorder.setHandlerClass(handlerClass, beanContainerBuildItem.getValue());
            }
        } else if (lambdas != null) {
            ArrayList<Class> unnamed = new ArrayList<Class>();
            HashMap<String, Class> named = new HashMap<String, Class>();
            ArrayList<Class> unnamedStreamHandler = new ArrayList<Class>();
            HashMap<String, Class> namedStreamHandler = new HashMap<String, Class>();
            for (AmazonLambdaBuildItem i : lambdas) {
                if (i.isStreamHandler()) {
                    if (i.getName() == null) {
                        unnamedStreamHandler.add(context.classProxy(i.getHandlerClass()));
                        continue;
                    }
                    namedStreamHandler.put(i.getName(), context.classProxy(i.getHandlerClass()));
                    continue;
                }
                if (i.getName() == null) {
                    unnamed.add(context.classProxy(i.getHandlerClass()));
                    continue;
                }
                named.put(i.getName(), context.classProxy(i.getHandlerClass()));
            }
            recorder.chooseHandlerClass(unnamed, named, unnamedStreamHandler, namedStreamHandler, beanContainerBuildItem.getValue(), config);
        }
    }

    @BuildStep(onlyIf={NativeBuild.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void startPoolLoop(AmazonLambdaRecorder recorder, ShutdownContextBuildItem shutdownContextBuildItem, List<ServiceStartBuildItem> orderServicesFirst) {
        recorder.startPollLoop((ShutdownContext)shutdownContextBuildItem);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void enableNativeEventLoop(LambdaBuildTimeConfig config, AmazonLambdaRecorder recorder, List<ServiceStartBuildItem> orderServicesFirst, ShutdownContextBuildItem shutdownContextBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        LaunchMode mode = launchModeBuildItem.getLaunchMode();
        if (config.enablePollingJvmMode && mode.isDevOrTest()) {
            recorder.startPollLoop((ShutdownContext)shutdownContextBuildItem);
        }
    }
}

