/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import com.amazonaws.services.lambda.runtime.RequestHandler;
import io.quarkus.amazon.lambda.deployment.AmazonLambdaBuildItem;
import io.quarkus.amazon.lambda.deployment.ProvidedAmazonLambdaHandlerBuildItem;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaRecorder;
import io.quarkus.amazon.lambda.runtime.FunctionError;
import io.quarkus.amazon.lambda.runtime.LambdaBuildTimeConfig;
import io.quarkus.amazon.lambda.runtime.LambdaConfig;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.joda.time.DateTime;

public final class AmazonLambdaProcessor {
    public static final String AWS_LAMBDA_EVENTS_ARCHIVE_MARKERS = "com/amazonaws/services/lambda/runtime/events";
    private static final DotName REQUEST_HANDLER = DotName.createSimple((String)RequestHandler.class.getName());
    private static final DotName NAMED = DotName.createSimple((String)Named.class.getName());
    private static final Logger log = Logger.getLogger(AmazonLambdaProcessor.class);

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("amazon-lambda");
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem marker() {
        return new AdditionalApplicationArchiveMarkerBuildItem(AWS_LAMBDA_EVENTS_ARCHIVE_MARKERS);
    }

    @BuildStep
    List<AmazonLambdaBuildItem> discover(CombinedIndexBuildItem combinedIndexBuildItem, Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer) throws BuildException {
        Collection allKnownImplementors = combinedIndexBuildItem.getIndex().getAllKnownImplementors(REQUEST_HANDLER);
        if (allKnownImplementors.size() > 0 && providedLambda.isPresent()) {
            throw new BuildException("Multiple handler classes.  You have a custom handler class and the " + providedLambda.get().getProvider() + " extension.  Please remove one of them from your deployment.", Collections.emptyList());
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        ArrayList<AmazonLambdaBuildItem> ret = new ArrayList<AmazonLambdaBuildItem>();
        for (ClassInfo info : allKnownImplementors) {
            DotName name = info.name();
            builder.addBeanClass(name.toString());
            String cdiName = null;
            List named = (List)info.annotations().get(NAMED);
            if (named != null && !named.isEmpty()) {
                cdiName = ((AnnotationInstance)named.get(0)).value().asString();
            }
            String lambda = name.toString();
            ret.add(new AmazonLambdaBuildItem(lambda, cdiName));
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{lambda}));
            ClassInfo current = info;
            boolean done = false;
            while (current != null && !done) {
                for (MethodInfo method : current.methods()) {
                    if (!method.name().equals("handleRequest") || method.parameters().size() != 2 || ((Type)method.parameters().get(0)).name().equals((Object)DotName.createSimple((String)Object.class.getName()))) continue;
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem((Type)method.parameters().get(0)));
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(method.returnType()));
                    done = true;
                    break;
                }
                current = combinedIndexBuildItem.getIndex().getClassByName(current.superName());
            }
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)builder.build());
        reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new Class[]{FunctionError.class}));
        return ret;
    }

    @BuildStep
    void processProvidedLambda(Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer) {
        if (!providedLambda.isPresent()) {
            return;
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        Class handlerClass = providedLambda.get().getHandlerClass();
        builder.addBeanClass(handlerClass);
        additionalBeanBuildItemBuildProducer.produce((BuildItem)builder.build());
        reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new Class[]{handlerClass}));
        for (Method method : handlerClass.getMethods()) {
            if (!method.getName().equals("handleRequest") || method.getParameterTypes().length != 2 || method.getParameterTypes()[0].equals(Object.class)) continue;
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{method.getParameterTypes()[0].getName()}));
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{method.getReturnType().getName()}));
            reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new Class[]{DateTime.class}));
            break;
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void recordHandlerClass(List<AmazonLambdaBuildItem> lambdas, Optional<ProvidedAmazonLambdaHandlerBuildItem> providedLambda, BeanContainerBuildItem beanContainerBuildItem, AmazonLambdaRecorder recorder, LambdaConfig config, List<ServiceStartBuildItem> orderServicesFirst, RecorderContext context) {
        if (providedLambda.isPresent()) {
            Class handlerClass = context.classProxy(providedLambda.get().getHandlerClass().getName());
            recorder.setHandlerClass(handlerClass, beanContainerBuildItem.getValue());
        } else if (lambdas != null) {
            ArrayList<Class> unnamed = new ArrayList<Class>();
            HashMap<String, Class> named = new HashMap<String, Class>();
            for (AmazonLambdaBuildItem i : lambdas) {
                if (i.getName() == null) {
                    unnamed.add(context.classProxy(i.getHandlerClass()));
                    continue;
                }
                named.put(i.getName(), context.classProxy(i.getHandlerClass()));
            }
            recorder.chooseHandlerClass(unnamed, named, beanContainerBuildItem.getValue(), config);
        }
    }

    @BuildStep(onlyIf={NativeBuild.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void startPoolLoop(AmazonLambdaRecorder recorder, ShutdownContextBuildItem shutdownContextBuildItem, List<ServiceStartBuildItem> orderServicesFirst) {
        recorder.startPollLoop((ShutdownContext)shutdownContextBuildItem);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void ipv4Only(BuildProducer<SystemPropertyBuildItem> systemProperty) {
        systemProperty.produce((BuildItem)new SystemPropertyBuildItem("java.net.preferIPv4Stack", "true"));
    }

    @BuildStep
    void tmpdirs(BuildProducer<SystemPropertyBuildItem> systemProperty, LaunchModeBuildItem launchModeBuildItem) {
        LaunchMode mode = launchModeBuildItem.getLaunchMode();
        if (mode.isDevOrTest()) {
            return;
        }
        systemProperty.produce((BuildItem)new SystemPropertyBuildItem("java.io.tmpdir", "/tmp"));
        systemProperty.produce((BuildItem)new SystemPropertyBuildItem("vertx.cacheDirBase", "/tmp/vertx"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void enableNativeEventLoop(LambdaBuildTimeConfig config, AmazonLambdaRecorder recorder, List<ServiceStartBuildItem> orderServicesFirst, ShutdownContextBuildItem shutdownContextBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        LaunchMode mode = launchModeBuildItem.getLaunchMode();
        if (config.enablePollingJvmMode && mode.isDevOrTest()) {
            recorder.startPollLoop((ShutdownContext)shutdownContextBuildItem);
        }
    }
}

