/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.amazon.lambda.runtime.MockBodyHandler;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;

public class MockEventServer
implements Closeable {
    protected static final Logger log = Logger.getLogger(MockEventServer.class);
    public static final int DEFAULT_PORT = 8081;
    private Vertx vertx;
    protected HttpServer httpServer;
    protected Router router;
    protected BlockingQueue<RoutingContext> queue;
    protected ConcurrentHashMap<String, RoutingContext> responsePending = new ConcurrentHashMap();
    protected ExecutorService blockingPool = Executors.newCachedThreadPool();
    public static final String BASE_PATH = "/_lambda_";
    public static final String INVOCATION = "/_lambda_/2018-06-01/runtime/invocation/";
    public static final String NEXT_INVOCATION = "/_lambda_/2018-06-01/runtime/invocation/next";
    public static final String POST_EVENT = "/_lambda_";
    public static final String CONTINUE = "100-continue";
    final AtomicBoolean closed = new AtomicBoolean();

    public MockEventServer() {
        this.queue = new LinkedBlockingQueue<RoutingContext>();
    }

    public void start() {
        this.start(8081);
    }

    public void start(int port) {
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMaxWorkerExecuteTime(60L).setMaxWorkerExecuteTimeUnit(TimeUnit.MINUTES));
        this.httpServer = this.vertx.createHttpServer();
        this.router = Router.router((Vertx)this.vertx);
        this.setupRoutes();
        try {
            this.httpServer.requestHandler((Handler)this.router).listen(port).toCompletionStage().toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        log.info((Object)"Mock Lambda Event Server Started");
    }

    public void setupRoutes() {
        this.router.route().handler(context -> {
            String expect;
            if (context.get("continue-sent") == null && (expect = context.request().getHeader((CharSequence)HttpHeaderNames.EXPECT)) != null && expect.equalsIgnoreCase(CONTINUE)) {
                context.put("continue-sent", (Object)true);
                context.response().writeContinue();
            }
            context.next();
        });
        this.router.route().handler((Handler)new MockBodyHandler());
        this.router.post("/_lambda_").handler(this::postEvent);
        this.router.route(NEXT_INVOCATION).blockingHandler(this::nextEvent);
        this.router.route("/_lambda_/2018-06-01/runtime/invocation/:requestId/requeue").handler(this::handleRequeue);
        this.router.route("/_lambda_/2018-06-01/runtime/invocation/:requestId/response").handler(this::handleResponse);
        this.router.route("/_lambda_/2018-06-01/runtime/invocation/:requestId/error").handler(this::handleError);
        this.defaultHanderSetup();
    }

    protected void defaultHanderSetup() {
        this.router.post().handler(this::postEvent);
    }

    public void postEvent(RoutingContext ctx) {
        String requestId = ctx.request().getHeader("Lambda-Runtime-Aws-Request-Id");
        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
        }
        ctx.put("Lambda-Runtime-Aws-Request-Id", (Object)requestId);
        String traceId = ctx.request().getHeader("Lambda-Runtime-Aws-Request-Id");
        if (traceId == null) {
            traceId = UUID.randomUUID().toString();
        }
        ctx.put("Lambda-Runtime-Trace-Id", (Object)traceId);
        try {
            log.debugf("Putting message %s into the queue", (Object)requestId);
            this.queue.put(ctx);
        }
        catch (InterruptedException e) {
            log.error((Object)"Publish interrupted");
            ctx.fail(500);
        }
    }

    public void nextEvent(final RoutingContext ctx) {
        this.vertx.executeBlocking((Handler)new Handler<Promise<Object>>(){

            public void handle(Promise<Object> event) {
                String traceId;
                RoutingContext request;
                block8: {
                    AtomicBoolean closed = new AtomicBoolean(false);
                    ctx.response().closeHandler(v -> closed.set(true));
                    ctx.response().exceptionHandler(v -> closed.set(true));
                    ctx.request().connection().closeHandler(v -> closed.set(true));
                    ctx.request().connection().exceptionHandler(v -> closed.set(true));
                    request = null;
                    try {
                        do {
                            if ((request = MockEventServer.this.queue.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                            if (closed.get()) {
                                log.debugf("Polled message %s but connection was closed, returning to queue", (Object[])request.get("Lambda-Runtime-Aws-Request-Id"));
                                MockEventServer.this.queue.put(request);
                                return;
                            }
                            break block8;
                        } while (!closed.get());
                        return;
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"nextEvent interrupted");
                        ctx.fail(500);
                    }
                }
                String contentType = MockEventServer.this.getEventContentType(request);
                if (contentType != null) {
                    ctx.response().putHeader("content-type", contentType);
                }
                if ((traceId = (String)request.get("Lambda-Runtime-Trace-Id")) != null) {
                    ctx.response().putHeader("Lambda-Runtime-Trace-Id", traceId);
                }
                String requestId = (String)request.get("Lambda-Runtime-Aws-Request-Id");
                log.debugf("Starting processing %s, added to pending request map", (Object)requestId);
                MockEventServer.this.responsePending.put(requestId, request);
                ctx.response().putHeader("Lambda-Runtime-Aws-Request-Id", requestId);
                Buffer body = MockEventServer.this.processEventBody(request);
                if (body != null) {
                    ctx.response().setStatusCode(200).end(body);
                } else {
                    ctx.response().setStatusCode(200).end();
                }
            }
        }, false, null);
    }

    protected String getEventContentType(RoutingContext request) {
        return request.request().getHeader("content-type");
    }

    protected Buffer processEventBody(RoutingContext request) {
        return request.getBody();
    }

    public void handleResponse(RoutingContext ctx) {
        String requestId = ctx.pathParam("requestId");
        RoutingContext pending = this.responsePending.remove(requestId);
        if (pending == null) {
            log.error((Object)("Unknown lambda request: " + requestId));
            ctx.fail(404);
            return;
        }
        log.debugf("Sending response %s", (Object)requestId);
        Buffer buffer = ctx.getBody();
        this.processResponse(ctx, pending, buffer);
        ctx.response().setStatusCode(204);
        ctx.end();
    }

    public void handleRequeue(RoutingContext ctx) {
        String requestId = ctx.pathParam("requestId");
        RoutingContext pending = this.responsePending.remove(requestId);
        if (pending == null) {
            log.error((Object)("Unknown lambda request: " + requestId));
            ctx.fail(404);
            return;
        }
        log.debugf("Requeue %s", (Object)requestId);
        try {
            this.queue.put(pending);
        }
        catch (InterruptedException e) {
            log.error((Object)"Publish interrupted");
            ctx.fail(500);
        }
        ctx.response().setStatusCode(204);
        ctx.end();
    }

    public void processResponse(RoutingContext ctx, RoutingContext pending, Buffer buffer) {
        if (buffer != null) {
            if (ctx.request().getHeader("Content-Type") != null) {
                pending.response().putHeader("Content-Type", ctx.request().getHeader("Content-Type"));
            }
            pending.response().setStatusCode(200).end(buffer);
        } else {
            pending.response().setStatusCode(204).end();
        }
    }

    public void handleError(RoutingContext ctx) {
        String requestId = ctx.pathParam("requestId");
        RoutingContext pending = this.responsePending.remove(requestId);
        if (pending == null) {
            log.error((Object)("Unknown lambda request: " + requestId));
            ctx.fail(404);
            return;
        }
        log.debugf("Sending response %s", (Object)requestId);
        Buffer buffer = ctx.getBody();
        this.processError(ctx, pending, buffer);
        ctx.response().setStatusCode(204);
        ctx.end();
    }

    public void processError(RoutingContext ctx, RoutingContext pending, Buffer buffer) {
        if (buffer != null) {
            if (ctx.request().getHeader("Content-Type") != null) {
                pending.response().putHeader("Content-Type", ctx.request().getHeader("Content-Type"));
            }
            pending.response().setStatusCode(500).end(buffer);
        } else {
            pending.response().setStatusCode(500).end();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        log.info((Object)"Stopping Mock Lambda Event Server");
        for (Map.Entry<String, RoutingContext> entry : this.responsePending.entrySet()) {
            entry.getValue().response().setStatusCode(503).end();
        }
        for (RoutingContext routingContext : this.queue) {
            routingContext.response().setStatusCode(503).end();
        }
        try {
            this.httpServer.close().toCompletionStage().toCompletableFuture().get();
            return;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.vertx.close().toCompletionStage().toCompletableFuture().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.blockingPool.shutdown();
            }
        }
    }
}

