/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.quarkus.amazon.lambda.http.model.AwsProxyRequest;
import io.quarkus.amazon.lambda.http.model.AwsProxyResponse;
import io.quarkus.amazon.lambda.http.model.Headers;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualClientConnection;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import java.io.ByteArrayOutputStream;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LambdaHttpHandler
implements RequestHandler<AwsProxyRequest, AwsProxyResponse> {
    private static Headers errorHeaders = new Headers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AwsProxyResponse handleRequest(AwsProxyRequest request, Context context) {
        InetSocketAddress clientAddress = null;
        if (request.getRequestContext() != null && request.getRequestContext().getIdentity() != null && request.getRequestContext().getIdentity().getSourceIp() != null) {
            clientAddress = new InetSocketAddress(request.getRequestContext().getIdentity().getSourceIp(), 443);
        }
        try (VirtualClientConnection connection = VirtualClientConnection.connect((VirtualAddress)VertxHttpRecorder.VIRTUAL_HTTP, clientAddress);){
            AwsProxyResponse awsProxyResponse = this.nettyDispatch(connection, request);
            return awsProxyResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AwsProxyResponse nettyDispatch(VirtualClientConnection connection, AwsProxyRequest request) throws Exception {
        String path = request.getPath();
        if (request.getMultiValueQueryStringParameters() != null && !request.getMultiValueQueryStringParameters().isEmpty()) {
            StringBuilder sb = new StringBuilder(path);
            sb.append("?");
            boolean first = true;
            for (Map.Entry<String, List<String>> e : request.getMultiValueQueryStringParameters().entrySet()) {
                for (String v : e.getValue()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append("&");
                    }
                    if (request.getRequestSource() == AwsProxyRequest.RequestSource.ALB) {
                        sb.append(e.getKey());
                        sb.append("=");
                        sb.append(v);
                        continue;
                    }
                    sb.append(URLEncoder.encode(e.getKey(), StandardCharsets.UTF_8.name()));
                    sb.append("=");
                    sb.append(URLEncoder.encode(v, StandardCharsets.UTF_8.name()));
                }
            }
            path = sb.toString();
        }
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)request.getHttpMethod()), path);
        if (request.getMultiValueHeaders() != null) {
            for (Map.Entry header : request.getMultiValueHeaders().entrySet()) {
                nettyRequest.headers().add((String)header.getKey(), (Iterable)header.getValue());
            }
        }
        if (!nettyRequest.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
            nettyRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
        }
        LastHttpContent requestContent = LastHttpContent.EMPTY_LAST_CONTENT;
        if (request.getBody() != null) {
            ByteBuf body;
            if (request.isBase64Encoded()) {
                body = Unpooled.wrappedBuffer((byte[])Base64.getMimeDecoder().decode(request.getBody()));
                requestContent = new DefaultLastHttpContent(body);
            } else {
                body = Unpooled.copiedBuffer((CharSequence)request.getBody(), (Charset)StandardCharsets.UTF_8);
                requestContent = new DefaultLastHttpContent(body);
            }
        }
        connection.sendMessage((Object)nettyRequest);
        connection.sendMessage((Object)requestContent);
        AwsProxyResponse responseBuilder = new AwsProxyResponse();
        try (ByteArrayOutputStream baos = null;){
            while (true) {
                Object msg = connection.queue().poll(100L, TimeUnit.MILLISECONDS);
                try {
                    if (msg == null) continue;
                    if (msg instanceof HttpResponse) {
                        HttpResponse res = (HttpResponse)msg;
                        responseBuilder.setStatusCode(res.status().code());
                        if (request.getRequestSource() == AwsProxyRequest.RequestSource.ALB) {
                            responseBuilder.setStatusDescription(res.status().reasonPhrase());
                        }
                        responseBuilder.setMultiValueHeaders(new Headers());
                        for (String name : res.headers().names()) {
                            for (String v : res.headers().getAll(name)) {
                                responseBuilder.getMultiValueHeaders().add(name, v);
                            }
                        }
                    }
                    if (msg instanceof HttpContent) {
                        HttpContent content = (HttpContent)msg;
                        int readable = content.content().readableBytes();
                        if (baos == null && readable > 0) {
                            baos = new ByteArrayOutputStream(500);
                        }
                        for (int i = 0; i < readable; ++i) {
                            baos.write(content.content().readByte());
                        }
                    }
                    if (!(msg instanceof LastHttpContent)) continue;
                    if (baos != null) {
                        if (this.isBinary((String)responseBuilder.getMultiValueHeaders().getFirst("Content-Type"))) {
                            responseBuilder.setBase64Encoded(true);
                            responseBuilder.setBody(Base64.getMimeEncoder().encodeToString(baos.toByteArray()));
                        } else {
                            responseBuilder.setBody(new String(baos.toByteArray(), "UTF-8"));
                        }
                    }
                    AwsProxyResponse awsProxyResponse = responseBuilder;
                    return awsProxyResponse;
                }
                finally {
                    if (msg == null) continue;
                    ReferenceCountUtil.release(msg);
                    continue;
                }
                break;
            }
        }
    }

    private boolean isBinary(String contentType) {
        if (contentType != null) {
            int index = contentType.indexOf(59);
            if (index >= 0) {
                return LambdaContainerHandler.getContainerConfig().isBinaryContentType(contentType.substring(0, index));
            }
            return LambdaContainerHandler.getContainerConfig().isBinaryContentType(contentType);
        }
        return false;
    }

    static {
        errorHeaders.putSingle("Content-Type", "application/json");
    }
}

