/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualClientConnection;
import io.quarkus.netty.runtime.virtual.VirtualResponseHandler;
import io.quarkus.vertx.http.runtime.QuarkusHttpHeaders;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import java.io.ByteArrayOutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jboss.logging.Logger;

public class LambdaHttpHandler
implements RequestHandler<APIGatewayV2HTTPEvent, APIGatewayV2HTTPResponse> {
    private static final Logger log = Logger.getLogger((String)"quarkus.amazon.lambda.http");
    private static final int BUFFER_SIZE = 8096;
    private static final Map<String, List<String>> ERROR_HEADERS = Map.of("Content-Type", List.of("application/json"));
    private static final String COOKIE_HEADER = "Cookie";
    private static final Set<String> COMMA_HEADERS = Set.of("access-control-request-headers");

    public APIGatewayV2HTTPResponse handleRequest(APIGatewayV2HTTPEvent request, Context context) {
        InetSocketAddress clientAddress = null;
        if (request.getRequestContext() != null && request.getRequestContext().getHttp() != null && request.getRequestContext().getHttp().getSourceIp() != null) {
            clientAddress = new InetSocketAddress(request.getRequestContext().getHttp().getSourceIp(), 443);
        }
        try {
            return this.nettyDispatch(clientAddress, request, context);
        }
        catch (Exception e) {
            log.error((Object)"Request Failure", (Throwable)e);
            APIGatewayV2HTTPResponse res = new APIGatewayV2HTTPResponse();
            res.setStatusCode(500);
            res.setBody("{ \"message\": \"Internal Server Error\" }");
            res.setMultiValueHeaders(ERROR_HEADERS);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIGatewayV2HTTPResponse nettyDispatch(InetSocketAddress clientAddress, APIGatewayV2HTTPEvent request, Context context) throws Exception {
        QuarkusHttpHeaders quarkusHeaders = new QuarkusHttpHeaders();
        quarkusHeaders.setContextObject(Context.class, (Object)context);
        quarkusHeaders.setContextObject(APIGatewayV2HTTPEvent.class, (Object)request);
        quarkusHeaders.setContextObject(APIGatewayV2HTTPEvent.RequestContext.class, (Object)request.getRequestContext());
        HttpMethod httpMethod = null;
        if (request.getRequestContext() != null && request.getRequestContext().getHttp() != null && request.getRequestContext().getHttp().getMethod() != null) {
            httpMethod = HttpMethod.valueOf((String)request.getRequestContext().getHttp().getMethod());
        }
        if (httpMethod == null) {
            throw new IllegalStateException("Missing HTTP method in request event");
        }
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, Optional.ofNullable(request.getRawQueryString()).filter(q -> !q.isEmpty()).map(q -> request.getRawPath() + "?" + q).orElse(request.getRawPath()), (HttpHeaders)quarkusHeaders);
        if (request.getHeaders() != null) {
            for (Map.Entry header : request.getHeaders().entrySet()) {
                if (header.getValue() == null) continue;
                if (COMMA_HEADERS.contains(((String)header.getKey()).toLowerCase(Locale.ROOT))) {
                    nettyRequest.headers().add((String)header.getKey(), header.getValue());
                    continue;
                }
                for (String val : ((String)header.getValue()).split(",")) {
                    nettyRequest.headers().add((String)header.getKey(), (Object)val);
                }
            }
        }
        if (request.getCookies() != null) {
            nettyRequest.headers().add(COOKIE_HEADER, (Object)String.join((CharSequence)"; ", request.getCookies()));
        }
        if (!nettyRequest.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
            nettyRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
        }
        LastHttpContent requestContent = LastHttpContent.EMPTY_LAST_CONTENT;
        if (request.getBody() != null) {
            ByteBuf body;
            nettyRequest.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
            if (request.getIsBase64Encoded()) {
                body = Unpooled.wrappedBuffer((byte[])Base64.getDecoder().decode(request.getBody()));
                requestContent = new DefaultLastHttpContent(body);
            } else {
                body = Unpooled.copiedBuffer((CharSequence)request.getBody(), (Charset)StandardCharsets.UTF_8);
                requestContent = new DefaultLastHttpContent(body);
            }
        }
        NettyResponseHandler handler = new NettyResponseHandler(request);
        VirtualClientConnection connection = VirtualClientConnection.connect((VirtualResponseHandler)handler, (VirtualAddress)VertxHttpRecorder.VIRTUAL_HTTP, (java.net.SocketAddress)clientAddress);
        if (request.getRequestContext() != null && request.getRequestContext().getHttp() != null && request.getRequestContext().getHttp().getSourceIp() != null && request.getRequestContext().getHttp().getSourceIp().length() > 0) {
            int port = 443;
            if (request.getHeaders() != null && request.getHeaders().get("X-Forwarded-Port") != null) {
                port = Integer.parseInt((String)request.getHeaders().get("X-Forwarded-Port"));
            }
            connection.peer().attr(ConnectionBase.REMOTE_ADDRESS_OVERRIDE).set((Object)SocketAddress.inetSocketAddress((int)port, (String)request.getRequestContext().getHttp().getSourceIp()));
        }
        connection.sendMessage((Object)nettyRequest);
        connection.sendMessage((Object)requestContent);
        try {
            APIGatewayV2HTTPResponse aPIGatewayV2HTTPResponse = handler.getFuture().get();
            return aPIGatewayV2HTTPResponse;
        }
        finally {
            connection.close();
        }
    }

    private ByteArrayOutputStream createByteStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8096);
        return baos;
    }

    private boolean isBinary(String contentType) {
        if (contentType != null) {
            String ct = contentType.toLowerCase(Locale.ROOT);
            return !ct.startsWith("text") && !ct.contains("json") && !ct.contains("xml") && !ct.contains("yaml");
        }
        return false;
    }

    private class NettyResponseHandler
    implements VirtualResponseHandler {
        APIGatewayV2HTTPResponse responseBuilder = new APIGatewayV2HTTPResponse();
        ByteArrayOutputStream baos;
        WritableByteChannel byteChannel;
        final APIGatewayV2HTTPEvent request;
        CompletableFuture<APIGatewayV2HTTPResponse> future = new CompletableFuture();

        public NettyResponseHandler(APIGatewayV2HTTPEvent request) {
            this.request = request;
        }

        public CompletableFuture<APIGatewayV2HTTPResponse> getFuture() {
            return this.future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Object msg) {
            try {
                FileRegion file;
                if (msg instanceof HttpResponse) {
                    HttpResponse res = (HttpResponse)msg;
                    this.responseBuilder.setStatusCode(res.status().code());
                    HashMap<String, String> headers = new HashMap<String, String>();
                    this.responseBuilder.setHeaders(headers);
                    for (String name : res.headers().names()) {
                        List allForName = res.headers().getAll(name);
                        if (allForName == null || allForName.isEmpty()) continue;
                        if ("set-cookie".equals(name)) {
                            this.responseBuilder.setCookies(allForName);
                            continue;
                        }
                        StringBuilder sb = new StringBuilder();
                        Iterator valueIterator = allForName.iterator();
                        while (valueIterator.hasNext()) {
                            sb.append((String)valueIterator.next());
                            if (!valueIterator.hasNext()) continue;
                            sb.append(",");
                        }
                        headers.put(name, sb.toString());
                    }
                }
                if (msg instanceof HttpContent) {
                    HttpContent content = (HttpContent)msg;
                    int readable = content.content().readableBytes();
                    if (this.baos == null && readable > 0) {
                        this.baos = LambdaHttpHandler.this.createByteStream();
                    }
                    for (int i = 0; i < readable; ++i) {
                        this.baos.write(content.content().readByte());
                    }
                }
                if (msg instanceof FileRegion && (file = (FileRegion)msg).count() > 0L && file.transferred() < file.count()) {
                    if (this.baos == null) {
                        this.baos = LambdaHttpHandler.this.createByteStream();
                    }
                    if (this.byteChannel == null) {
                        this.byteChannel = Channels.newChannel(this.baos);
                    }
                    file.transferTo(this.byteChannel, file.transferred());
                }
                if (msg instanceof LastHttpContent) {
                    if (this.baos != null) {
                        if (LambdaHttpHandler.this.isBinary((String)this.responseBuilder.getHeaders().get("Content-Type"))) {
                            this.responseBuilder.setIsBase64Encoded(true);
                            this.responseBuilder.setBody(Base64.getEncoder().encodeToString(this.baos.toByteArray()));
                        } else {
                            this.responseBuilder.setBody(this.baos.toString(StandardCharsets.UTF_8));
                        }
                    }
                    this.future.complete(this.responseBuilder);
                }
            }
            catch (Throwable ex) {
                this.future.completeExceptionally(ex);
            }
            finally {
                if (msg != null) {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        }

        public void close() {
            if (!this.future.isDone()) {
                this.future.completeExceptionally(new RuntimeException("Connection closed"));
            }
        }
    }
}

