/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.amazon.lambda.http.model.AwsProxyRequest;
import io.quarkus.amazon.lambda.http.model.AwsProxyRequestContext;
import io.quarkus.amazon.lambda.http.model.AwsProxyResponse;
import io.quarkus.amazon.lambda.http.model.Headers;
import io.quarkus.amazon.lambda.http.model.MultiValuedTreeMap;
import io.quarkus.amazon.lambda.runtime.MockEventServer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class MockRestEventServer
extends MockEventServer {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ObjectWriter eventWriter;
    private final ObjectReader responseReader;

    public MockRestEventServer() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        this.eventWriter = this.objectMapper.writerFor(AwsProxyRequest.class);
        this.responseReader = this.objectMapper.readerFor(AwsProxyResponse.class);
    }

    protected void defaultHanderSetup() {
        this.router.route().handler(this::handleHttpRequests);
    }

    public void handleHttpRequests(RoutingContext ctx) {
        String requestId = ctx.request().getHeader("Lambda-Runtime-Aws-Request-Id");
        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
        }
        ctx.put("Lambda-Runtime-Aws-Request-Id", (Object)requestId);
        String traceId = ctx.request().getHeader("Lambda-Runtime-Aws-Request-Id");
        if (traceId == null) {
            traceId = UUID.randomUUID().toString();
        }
        ctx.put("Lambda-Runtime-Trace-Id", (Object)traceId);
        Buffer body = ctx.getBody();
        AwsProxyRequest event = new AwsProxyRequest();
        event.setRequestContext(new AwsProxyRequestContext());
        event.getRequestContext().setRequestId(requestId);
        event.getRequestContext().setHttpMethod(ctx.request().method().name());
        event.setHttpMethod(ctx.request().method().name());
        event.setPath(ctx.request().path());
        if (ctx.request().query() != null) {
            event.setMultiValueQueryStringParameters(new MultiValuedTreeMap());
            String[] params = ctx.request().query().split("&");
            for (String param : params) {
                if (!param.contains("=")) continue;
                String[] keyval = param.split("=");
                try {
                    event.getMultiValueQueryStringParameters().add((Object)URLDecoder.decode(keyval[0], StandardCharsets.UTF_8.name()), (Object)URLDecoder.decode(keyval[1], StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"Failed to parse query string", (Throwable)e);
                    ctx.response().setStatusCode(400).end();
                    return;
                }
            }
        }
        if (ctx.request().headers() != null) {
            event.setMultiValueHeaders(new Headers());
            for (String header : ctx.request().headers().names()) {
                List values = ctx.request().headers().getAll(header);
                for (String val : values) {
                    event.getMultiValueHeaders().add((Object)header, (Object)val);
                }
            }
        }
        if (body != null) {
            String ct = ctx.request().getHeader("content-type");
            if (ct == null || this.isBinary(ct)) {
                String encoded = Base64.getMimeEncoder().encodeToString(body.getBytes());
                event.setBody(encoded);
                event.setIsBase64Encoded(true);
            } else {
                event.setBody(new String(body.getBytes(), StandardCharsets.UTF_8));
            }
        }
        try {
            byte[] mEvent = this.eventWriter.writeValueAsBytes((Object)event);
            ctx.put(AwsProxyRequest.class.getName(), (Object)mEvent);
            log.debugf("Putting message %s into the queue", (Object)requestId);
            this.queue.put(ctx);
        }
        catch (Exception e) {
            log.error((Object)"Publish failure", (Throwable)e);
            ctx.fail(500);
        }
    }

    protected String getEventContentType(RoutingContext request) {
        if (request.get(AwsProxyRequest.class.getName()) != null) {
            return "application/json";
        }
        return super.getEventContentType(request);
    }

    protected Buffer processEventBody(RoutingContext request) {
        byte[] buf = (byte[])request.get(AwsProxyRequest.class.getName());
        if (buf != null) {
            return Buffer.buffer((byte[])buf);
        }
        return super.processEventBody(request);
    }

    public void processResponse(RoutingContext ctx, RoutingContext pending, Buffer buffer) {
        block10: {
            if (pending.get(AwsProxyRequest.class.getName()) != null) {
                try {
                    AwsProxyResponse res = (AwsProxyResponse)this.responseReader.readValue(buffer.getBytes());
                    HttpServerResponse response = pending.response();
                    if (res.getMultiValueHeaders() != null) {
                        for (Map.Entry header : res.getMultiValueHeaders().entrySet()) {
                            for (String val : (List)header.getValue()) {
                                response.headers().add((String)header.getKey(), val);
                            }
                        }
                    }
                    response.setStatusCode(res.getStatusCode());
                    String body = res.getBody();
                    if (body != null) {
                        if (res.isBase64Encoded()) {
                            byte[] bytes = Base64.getDecoder().decode(body);
                            response.end(Buffer.buffer((byte[])bytes));
                        } else {
                            response.end(body);
                        }
                        break block10;
                    }
                    response.end();
                }
                catch (IOException e) {
                    log.error((Object)"Publish failure", (Throwable)e);
                    pending.fail(500);
                }
            } else {
                super.processResponse(ctx, pending, buffer);
            }
        }
    }

    private boolean isBinary(String contentType) {
        if (contentType != null) {
            String ct = contentType.toLowerCase(Locale.ROOT);
            return !ct.startsWith("text") && !ct.contains("json") && !ct.contains("xml") && !ct.contains("yaml");
        }
        return false;
    }
}

