/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http;

import com.amazonaws.services.lambda.runtime.Context;
import io.quarkus.amazon.lambda.http.model.AwsProxyRequest;
import io.quarkus.amazon.lambda.http.model.AwsProxyRequestContext;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.QuarkusHttpHeaders;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AwsHttpContextProducers {
    @Inject
    Instance<CurrentVertxRequest> current;

    @RequestScoped
    @Produces
    public Context getAwsContext() {
        return (Context)this.getContextObjects().get(Context.class);
    }

    @RequestScoped
    @Produces
    public AwsProxyRequestContext getHttpEvent() {
        return (AwsProxyRequestContext)this.getContextObjects().get(AwsProxyRequestContext.class);
    }

    @RequestScoped
    @Produces
    public AwsProxyRequest getHttpRequestContext() {
        return (AwsProxyRequest)this.getContextObjects().get(AwsProxyRequest.class);
    }

    private Map<Class<?>, Object> getContextObjects() {
        if (this.current == null) {
            return Collections.EMPTY_MAP;
        }
        CurrentVertxRequest currentVertxRequest = (CurrentVertxRequest)this.current.get();
        if (currentVertxRequest == null) {
            return Collections.EMPTY_MAP;
        }
        RoutingContext routingContext = currentVertxRequest.getCurrent();
        if (routingContext == null) {
            return Collections.EMPTY_MAP;
        }
        MultiMap qheaders = routingContext.request().headers();
        if (qheaders == null) {
            return Collections.EMPTY_MAP;
        }
        if (qheaders instanceof QuarkusHttpHeaders) {
            return ((QuarkusHttpHeaders)qheaders).getContextObjects();
        }
        return Collections.EMPTY_MAP;
    }
}

